/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.jcache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.jcache.Cache;
import com.ibm.ws.naming.jcache.CacheInvalidPropertyValueException;
import com.ibm.ws.naming.jcache.CacheKey;
import com.ibm.ws.naming.jcache.JavaNameSpaceCacheContainer;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.omg.CosNaming.NameComponent;

public class CacheManager {
    private static final TraceComponent _tc = Tr.register(CacheManager.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME = CacheManager.class.getName();
    private static HashMap _caches;
    private static HashMap _javaNameSpaceCaches;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getCache(Hashtable env) throws CacheInvalidPropertyValueException {
        String cacheOption = Cache.cacheObjectPropertyValue(env);
        boolean newCache = false;
        if (cacheOption.equals("none")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCache: caching disabled");
            }
            return null;
        }
        String cacheName = Cache.cacheNameFromPropertyValue(env);
        CacheKey cacheKey = new CacheKey(cacheName);
        Cache cache = null;
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            cache = (Cache)_caches.get(cacheKey);
            if (cache == null) {
                cache = new Cache(cacheName, cacheKey.getClassLoader(), env);
                _caches.put(cacheKey, cache);
                newCache = true;
            }
        }
        if (!newCache) {
            cache.setLifetimeProperties(env);
            if (cacheOption.equals("cleared")) {
                cache.clear();
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCache: returning cache", cacheKey.toString());
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getCacheUsingName(String cacheName, Hashtable env) throws CacheInvalidPropertyValueException {
        String cacheOption = Cache.cacheObjectPropertyValue(env);
        boolean newCache = false;
        if (cacheOption.equals("none")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCacheUsingName: caching disabled");
            }
            return null;
        }
        Cache cache = null;
        CacheKey cacheKey = new CacheKey(cacheName);
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            cache = (Cache)_caches.get(cacheKey);
            if (cache == null) {
                cache = new Cache(cacheName, cacheKey.getClassLoader(), env);
                _caches.put(cacheKey, cache);
                newCache = true;
            }
        }
        if (!newCache) {
            cache.setLifetimeProperties(env);
            if (cacheOption.equals("cleared")) {
                cache.clear();
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCacheUsingName: returning cache", cacheKey.toString());
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getJavaNameSpaceCache(Integer cacheKey, Hashtable env, boolean createIfNecessary) throws CacheInvalidPropertyValueException {
        String cacheOption;
        if (_tc.isDebugEnabled()) {
            Tr.entry(_tc, "getJavaNameSpaceCache(cacheKey=" + cacheKey + ", env=" + env + ", createIfNecessary=" + createIfNecessary);
        }
        if ((cacheOption = Cache.cacheObjectPropertyValue(env)).equals("none")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getJavaNameSpaceCache: caching disabled");
            }
            return null;
        }
        Hashtable jnsCache = null;
        JavaNameSpaceCacheContainer jnsCacheContainer = null;
        boolean cacheAlreadyExists = false;
        HashMap hashMap = _javaNameSpaceCaches;
        synchronized (hashMap) {
            jnsCacheContainer = (JavaNameSpaceCacheContainer)_javaNameSpaceCaches.get(cacheKey);
            if (jnsCacheContainer == null) {
                if (createIfNecessary) {
                    jnsCache = new Hashtable();
                    ClassLoader contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    jnsCacheContainer = new JavaNameSpaceCacheContainer(jnsCache, cacheKey, contextClassLoader);
                    _javaNameSpaceCaches.put(cacheKey, jnsCacheContainer);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getJavaNameSpaceCache: created new cache", "associatedClassLoader=" + contextClassLoader);
                    }
                }
            } else {
                cacheAlreadyExists = true;
                jnsCache = jnsCacheContainer.getCache();
            }
        }
        if (cacheAlreadyExists) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getJavaNameSpaceCache: cache already exists and returning java name space cache " + cacheKey.toString());
            }
            if (cacheOption.equals("cleared")) {
                jnsCache.clear();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getJavaNameSpaceCache: cache cleared");
                }
            }
        } else if (_tc.isDebugEnabled() && jnsCache == null) {
            Tr.debug(_tc, "getJavaNameSpaceCache: cache not created, returning null. ");
        }
        return jnsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllCaches() {
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            for (Cache cache : _caches.values()) {
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unbindFromAllCaches(UuidContext ctx, NameComponent[] name) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbindFromAllCaches", name);
        }
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            try {
                WsnName jndiName = new WsnName(name, Helpers.getJNDIEnvironment());
                WsnName insName = new WsnName(name, Helpers.getINSEnvironment());
                for (Cache cache : _caches.values()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Cache name: " + cache.getCacheName());
                    }
                    try {
                        Hashtable env = cache.getEnv();
                        String nameSyntax = (String)env.get("com.ibm.websphere.naming.name.syntax");
                        if (nameSyntax == null) {
                            nameSyntax = "jndi";
                        }
                        if (nameSyntax.equals("jndi")) {
                            cache.unbind(ctx, jndiName, null);
                            continue;
                        }
                        cache.unbind(ctx, insName, null);
                    }
                    catch (Exception e) {
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "Unbind from cache failed", e);
                    }
                }
            }
            catch (Exception e) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "unbindFromAllCaches: Unexpected exception.", e);
                }
                RasUtil.logException(e, _tc, CLASS_NAME, "unbindFromAllCaches", "368");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "unbindFromAllCaches");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJavaNameSpaceCaches(ClassLoader associatedClassLoader) {
        HashMap hashMap = _javaNameSpaceCaches;
        synchronized (hashMap) {
            for (JavaNameSpaceCacheContainer cacheContainer : _javaNameSpaceCaches.values()) {
                if (!cacheContainer.getAssociatedClassLoader().equals(associatedClassLoader)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Clearing java name space cache.", "cacheKey=" + cacheContainer.getCacheKey().toString());
                }
                cacheContainer.getCache().clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCaches(ClassLoader classLoader) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeCaches", "searchClassLoader=" + classLoader);
        }
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Number of JNDI / CosNaming caches: " + _caches.size());
            }
            Iterator keys = _caches.keySet().iterator();
            while (keys.hasNext()) {
                CacheKey cacheKey = (CacheKey)keys.next();
                ClassLoader keyClassLoader = cacheKey.getClassLoader();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "cacheClassLoader=" + keyClassLoader);
                }
                if (!keyClassLoader.equals(classLoader)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Removing cache.", "cacheKey=" + cacheKey.toString());
                }
                keys.remove();
            }
        }
        hashMap = _javaNameSpaceCaches;
        synchronized (hashMap) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Number of Java name space caches: " + _javaNameSpaceCaches.size());
            }
            Iterator caches = _javaNameSpaceCaches.values().iterator();
            while (caches.hasNext()) {
                JavaNameSpaceCacheContainer cacheContainer = (JavaNameSpaceCacheContainer)caches.next();
                ClassLoader cacheClassLoader = cacheContainer.getAssociatedClassLoader();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "cacheClassLoader=" + cacheClassLoader);
                }
                if (!cacheClassLoader.equals(classLoader)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Removing java name space cache.", "cacheKey=" + cacheContainer.getCacheKey().toString());
                }
                caches.remove();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeCaches");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/jcache/CacheManager.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.17");
        }
        _caches = new HashMap();
        _javaNameSpaceCaches = new HashMap();
    }
}

