/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.java;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ipbase.NameSpace;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.StringContextID;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.java.javaNameSpaceImpl;
import com.ibm.ws.naming.java.javaURLContextImpl;
import com.ibm.ws.naming.jcache.CacheInvalidPropertyValueException;
import com.ibm.ws.naming.urlbase.UrlContextHelper;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.RasUtil;
import java.net.URL;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class javaURLContextRoot
extends javaURLContextImpl {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent _tc = Tr.register(javaURLContextRoot.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    protected static final String COMP_ENV_PREFIX = "comp/env/";
    private static final StringContextID ROOT_CONTEXT_ID;
    protected boolean _attemptedToCreateRootCache = false;
    protected Hashtable<String, Object> _rootCache = null;

    public javaURLContextRoot(javaNameSpaceImpl jns, NameSpace ns, String contextName, Hashtable<?, ?> env) throws NamingException {
        super(jns, ns, contextName, env, ROOT_CONTEXT_ID, null);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>", new String[]{"jns=" + jns, "ns=" + ns, "contextName=" + contextName, "env=" + env});
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookup", "name=" + name);
        }
        Object retObj = null;
        try {
            retObj = this.lookup(name != null ? this._parser.parse(name) : null);
        }
        catch (NamingException ne) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookup", ne.toString());
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookup", retObj);
        }
        return retObj;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookup", "name=" + name);
        }
        Object retObj = null;
        try {
            if (name != null) {
                name = this.stripSchemeIdForUrlRootContext(name);
                String nameString = name.toString();
                Hashtable<String, Object> rootCache = this.getRootCache(false);
                if (rootCache != null) {
                    retObj = rootCache.get(nameString);
                    if (retObj != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "lookup", "Cache hit for " + nameString);
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "lookup", "Cache miss for " + nameString);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "lookup", "Caching disabled or nothing cached yet");
                }
            }
            if (retObj == null) {
                retObj = super.lookup(name);
            }
        }
        catch (NamingException ne) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookup", ne.toString());
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookup", retObj);
        }
        return retObj;
    }

    @Override
    public UuidContext cloneContext() throws NamingException {
        return new javaURLContextRoot(this._jns, this._ns, this._context_name, this._env);
    }

    @Override
    public UuidContext copyContext(UuidContext ctx) throws IllegalArgumentException, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "copyContext", "ctx=" + ctx);
        }
        Hashtable<?, ?> env = null;
        env = ctx instanceof javaURLContextRoot ? ((javaURLContextRoot)ctx)._env : ((Context)((Object)ctx)).getEnvironment();
        javaURLContextRoot copy = new javaURLContextRoot(this._jns, this._ns, this._context_name, env);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "copyContext", copy);
        }
        return copy;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "composeName", new String[]{"name=" + name, "prefix=" + prefix});
        }
        Helpers.throwIfNull(name, "composeName", (Context)this);
        Helpers.throwIfNull(prefix, "composeName", (Context)this);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "composeName", name);
        }
        return name;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "composeName", new String[]{"name=" + name, "prefix=" + prefix});
        }
        Helpers.throwIfNull(name, "composeName", (Context)this);
        Helpers.throwIfNull(prefix, "composeName", (Context)this);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "composeName", name);
        }
        return name;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        String nins = this._schemeId + ":";
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNameInNamespace", "nins=" + nins);
        }
        return nins;
    }

    @Override
    protected Name stripSchemeIdForUrlRootContext(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stripSchemeIdForUrlRootContext", "name=" + name);
        }
        Name retName = UrlContextHelper.stripSchemeIdForUrlRootContext(name, this._schemeId, this._parser);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stripSchemeIdForUrlRootContext", retName);
        }
        return retName;
    }

    @Override
    protected Name[] stripSchemeIdForUrlRootContextForRename(Name oldName, Name newName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stripSchemeIdForUrlRootContextForRename", new String[]{"oldName=" + oldName, "newName=" + newName});
        }
        Object[] retName = UrlContextHelper.stripSchemeIdForUrlRootContextForRename(oldName, newName, this._schemeId, this._parser);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stripSchemeIdForUrlRootContextForRename", Arrays.toString(retName));
        }
        return retName;
    }

    @Override
    protected Object processBoundObjectForLookup(NameSpaceBindingData bindingData, Object boundObj, Name name, Hashtable env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processBoundObjectForLookup", new String[]{"bindingData=" + bindingData, "boundObj=" + boundObj, "name=" + name, "env=" + env});
        }
        Object retObj = null;
        BooleanWrapper isCacheableReference = new BooleanWrapper(false);
        JavaObjectHolder unprocessedJavaObject = new JavaObjectHolder();
        BooleanWrapper haveUnprocessedIndirectJavaObject = new BooleanWrapper(false);
        JavaObjectHolder unprocessedIndirectJavaObject = new JavaObjectHolder();
        try {
            retObj = UrlContextHelper.processBoundObjectForLookup(bindingData, boundObj, this, env, isCacheableReference, unprocessedJavaObject, haveUnprocessedIndirectJavaObject, unprocessedIndirectJavaObject);
        }
        catch (NamingException ne) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "processBoundObjectForLookup", ne.toString());
            }
            throw ne;
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "processBoundObjectForLookup", "414", this);
            NamingException ne = new NamingException("Error thrown from IndirectJndiLookup object factory");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "processBoundObjectForLookup", ne);
            }
            throw ne;
        }
        Hashtable<String, Object> rootCache = this.getRootCache(false);
        if (rootCache != null || !this._attemptedToCreateRootCache) {
            boolean retObjCacheable = false;
            String nameString = name.toString();
            if (nameString.startsWith(COMP_ENV_PREFIX)) {
                if (isCacheableReference.value || haveUnprocessedIndirectJavaObject.value && (unprocessedIndirectJavaObject.value == null || unprocessedIndirectJavaObject.value instanceof CacheableReference)) {
                    retObjCacheable = true;
                } else if (Helpers.isIndirectLookupReference(unprocessedJavaObject)) {
                    if (haveUnprocessedIndirectJavaObject.value) {
                        retObjCacheable = this.isObjectCacheable(unprocessedIndirectJavaObject.value);
                    }
                } else {
                    retObjCacheable = this.isObjectCacheable(boundObj);
                }
            }
            if (retObjCacheable) {
                rootCache = this.getRootCache(true);
                if (rootCache != null) {
                    if (retObj != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "processBoundObjectForLookup", new Object[]{"Caching " + nameString, retObj});
                        }
                        rootCache.put(nameString, retObj);
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "processBoundObjectForLookup", "Not caching null object for " + nameString);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processBoundObjectForLookup", "Caching disabled");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "processBoundObjectForLookup", "Not caching " + nameString);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "processBoundObjectForLookup", "Caching disabled");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processBoundObjectForLookup", retObj);
        }
        return retObj;
    }

    protected boolean isObjectCacheable(Object obj) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isObjectCacheable", "obj=" + obj + (obj != null ? " (class=" + obj.getClass().getName() + ")" : ""));
        }
        boolean cacheable = false;
        if (obj instanceof String || obj instanceof Number || obj instanceof EJBLocalHome || obj instanceof URL || obj instanceof Boolean || obj instanceof Character || obj instanceof Remote || obj instanceof Stub || obj instanceof EJBHome) {
            cacheable = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isObjectCacheable", Boolean.toString(cacheable));
        }
        return cacheable;
    }

    protected Hashtable<String, Object> getRootCache(boolean createIfNecessary) {
        block6: {
            if (_tc.isDebugEnabled()) {
                Tr.entry(_tc, "getRootCache(createIfNecessary=" + createIfNecessary + ")");
                Tr.debug(_tc, "_attemptedToCreateRootCache=" + this._attemptedToCreateRootCache);
            }
            if (!this._attemptedToCreateRootCache) {
                if (createIfNecessary) {
                    this._attemptedToCreateRootCache = true;
                }
                try {
                    this._rootCache = this._jns.getRootCache(this._env, createIfNecessary);
                }
                catch (CacheInvalidPropertyValueException e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getRootCache", "617", this);
                    if (!_tc.isEventEnabled()) break block6;
                    Tr.event(_tc, "getRootCache", new Object[]{"Could not create root cache", e});
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRootCache", this._rootCache);
        }
        return this._rootCache;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", _attemptedToCreateRootCache=");
        stringBuilder.append(this._attemptedToCreateRootCache);
        stringBuilder.append(", _rootCache=");
        stringBuilder.append(this._rootCache);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/java/javaURLContextRoot.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.32");
        }
        CLASS_NAME = javaURLContextRoot.class.getName();
        ROOT_CONTEXT_ID = new StringContextID("ROOT CONTEXT");
    }
}

