/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ipbase;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ipbase.BindingsTableData;
import com.ibm.ws.naming.ipbase.BindingsTableKey;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceBindingDataImpl;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.util.DestroyedContext;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.RasUtil;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameSpaceEnumeration
implements Enumeration<NameSpaceBindingData> {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final TraceComponent _tc = Tr.register(NameSpaceEnumeration.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static boolean _debug;
    private final Object _lock;
    private final Map<BindingsTableKey, BindingsTableData> _bindingsTable;
    private final Map<String, UuidContext> _contextsTable;
    private final UuidContext _baseContext;
    private final String _baseContextIDString;
    private Iterator<Map.Entry<BindingsTableKey, BindingsTableData>> _bindingKeyIterator = null;
    private final int _batchSize;
    private final Queue<NameSpaceBindingData> _batch = new LinkedList<NameSpaceBindingData>();
    private Boolean _more = null;

    public NameSpaceEnumeration(Object lock, Map<BindingsTableKey, BindingsTableData> bindingsTable, Map<String, UuidContext> contextsTable, UuidContext baseContext) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"lock=" + lock, "bindingsTable=" + Helpers.mapToTerseString(bindingsTable), "contextsTable=" + Helpers.mapToTerseString(contextsTable), "baseContext=" + baseContext});
        }
        this._lock = lock;
        this._bindingsTable = bindingsTable;
        this._contextsTable = contextsTable;
        this._baseContext = baseContext;
        this._baseContextIDString = ((Object)baseContext.getContextID()).toString();
        this._batchSize = 100;
        this.nextBatch();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    @Override
    public boolean hasMoreElements() {
        boolean more;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "hasMoreElements");
        }
        if (this._batch.peek() == null && (this._more == null || this._more.booleanValue())) {
            this.nextBatch();
        }
        boolean bl = more = this._batch.peek() != null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "hasMoreElements", Boolean.toString(more));
        }
        return more;
    }

    @Override
    public NameSpaceBindingData nextElement() throws NoSuchElementException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "nextElement");
        }
        NameSpaceBindingData nextElement = null;
        if (!this.hasMoreElements()) {
            NoSuchElementException nsee = new NoSuchElementException();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "nextElement", nsee.toString());
            }
            throw nsee;
        }
        nextElement = this._batch.poll();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "nextElement", nextElement);
        }
        return nextElement;
    }

    public String toString() {
        return this.toString(_debug);
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_lock=");
        stringBuilder.append(this._lock);
        stringBuilder.append(", _bindingsTable=");
        stringBuilder.append(Helpers.mapToTerseString(this._bindingsTable));
        stringBuilder.append(", _contextsTable=");
        stringBuilder.append(Helpers.mapToTerseString(this._contextsTable));
        stringBuilder.append(", _baseContext=");
        stringBuilder.append(this._baseContext);
        stringBuilder.append(", _baseContextIDString=");
        stringBuilder.append(this._baseContextIDString);
        stringBuilder.append(", _bindingKeyIterator=");
        stringBuilder.append(this._bindingKeyIterator);
        stringBuilder.append(", _batchSize=");
        stringBuilder.append(this._batchSize);
        stringBuilder.append(", _batch=");
        if (verbose) {
            stringBuilder.append(this._batch);
        } else {
            stringBuilder.append(Helpers.collectionToTerseString(this._batch));
        }
        stringBuilder.append(", _more=");
        stringBuilder.append(this._more);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextBatch() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "nextBatch");
        }
        this._batch.clear();
        Object object = this._lock;
        synchronized (object) {
            if (this._bindingKeyIterator == null) {
                Set<Map.Entry<BindingsTableKey, BindingsTableData>> _bindingKeys = this._bindingsTable.entrySet();
                this._bindingKeyIterator = _bindingKeys.iterator();
            }
            int elements = 0;
            while (elements < this._batchSize && this._bindingKeyIterator.hasNext()) {
                BindingsTableData bindingData;
                Map.Entry<BindingsTableKey, BindingsTableData> entry = this._bindingKeyIterator.next();
                BindingsTableKey bindingKey = entry.getKey();
                if (!bindingKey.isPartialKeyMatch(this._baseContextIDString) || (bindingData = entry.getValue()) == null) continue;
                Object boundObject = bindingData.getObject();
                if (boundObject instanceof ContextID) {
                    ContextID ctxID = (ContextID)boundObject;
                    if ((boundObject = this._contextsTable.get(((Object)ctxID).toString())) != null) {
                        try {
                            boundObject = ((UuidContext)boundObject).copyContext(this._baseContext);
                        }
                        catch (NamingException e) {
                            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "nextBatch", "264", this);
                        }
                    } else {
                        boundObject = new DestroyedContext(((Object)ctxID).toString());
                    }
                }
                if (bindingData == null) continue;
                NameSpaceBindingDataImpl nsData = new NameSpaceBindingDataImpl(bindingKey.getKeyPart2(), boundObject, bindingData.getAdditionalData(), bindingData.getBindingType());
                this._batch.offer(nsData);
                ++elements;
            }
            if (!this._bindingKeyIterator.hasNext()) {
                this._more = Boolean.FALSE;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "nextBatch", "batch size=" + this._batch.size());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "nextBatch");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ipbase/NameSpaceEnumeration.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.16");
        }
        CLASS_NAME = NameSpaceEnumeration.class.getName();
        _debug = Boolean.getBoolean("com.ibm.ws.naming.debug");
    }
}

