/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ipbase;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ipbase.BindingsTableData;
import com.ibm.ws.naming.ipbase.BindingsTableKey;
import com.ibm.ws.naming.ipbase.ContextCloner;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.DuplicateContextIDException;
import com.ibm.ws.naming.ipbase.NameNotAtomicException;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceBindingDataImpl;
import com.ibm.ws.naming.ipbase.NameSpaceEnumeration;
import com.ibm.ws.naming.ipbase.NameSpaceException;
import com.ibm.ws.naming.ipbase.NameSpaceInconsistentException;
import com.ibm.ws.naming.ipbase.StringContextID;
import com.ibm.ws.naming.ipbase.UnresolvedContext;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.util.CannotDestroySubcontextException;
import com.ibm.ws.naming.util.CannotUnbindSubcontextException;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.InvalidObjectException;
import com.ibm.ws.naming.util.RasUtil;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSpace
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent _tc = Tr.register(NameSpace.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    public static final int NAME_SPACE_TYPE_PRIMARY = 1;
    public static final int NAME_SPACE_TYPE_CACHE = 2;
    public static final int BINDING_TYPE_CREATE = 1;
    public static final int BINDING_TYPE_BIND = 2;
    public static final int BINDING_TYPE_DONT_CARE = 99;
    public static final String ROOT_CONTEXT_ID = "ROOT CONTEXT";
    private static final String ROOT_PARENT_CONTEXT_ID = "";
    private static final String NAME_COMPONENT_SEPARATOR = "/";
    private static boolean _debug;
    private static int _nameSpaceCount;
    private final int _nameSpaceID;
    private final int _nameSpaceType;
    private final Map<BindingsTableKey, BindingsTableData> _bindingsTable = new HashMap<BindingsTableKey, BindingsTableData>();
    private final Map<String, UuidContext> _contextsTable = new HashMap<String, UuidContext>();

    private static synchronized int getNextNameSpaceID() {
        return ++_nameSpaceCount;
    }

    private static String bindObjectToString(Object objectToBind) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("objectToBind=");
        if (objectToBind instanceof UuidContext) {
            stringBuilder.append(NameSpace.uuidContextToString((UuidContext)objectToBind));
        } else {
            stringBuilder.append(objectToBind);
            if (objectToBind != null && !(objectToBind instanceof byte[])) {
                stringBuilder.append(" (");
                stringBuilder.append(objectToBind.getClass().getName());
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    private static String uuidContextToString(UuidContext context) {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (context != null) {
            stringBuilder.append(context.getClass().getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(context.hashCode()));
            ContextID contextID = context.getContextID();
            stringBuilder.append("[contextID=");
            if (contextID != null) {
                stringBuilder.append(contextID);
            } else {
                stringBuilder.append("null");
            }
            String nameInNamespace = "null";
            try {
                nameInNamespace = context.getNameInNamespace();
            }
            catch (NamingException e) {
                RasUtil.logException(e, _tc, CLASS_NAME, "uuidContextToString", "248");
            }
            stringBuilder.append(", nameInNamespace=");
            stringBuilder.append(nameInNamespace);
            stringBuilder.append(']');
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    public NameSpace(int nameSpaceType) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", "nameSpaceType=" + nameSpaceType);
        }
        if (nameSpaceType != 1 && nameSpaceType != 2) {
            IllegalArgumentException e = new IllegalArgumentException("Illegal nameSpaceType value: " + nameSpaceType);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "<init>", e);
            }
            throw e;
        }
        this._nameSpaceID = NameSpace.getNextNameSpaceID();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "nsID=" + this._nameSpaceID);
        }
        this._nameSpaceType = nameSpaceType;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>", this);
        }
    }

    private NameSpace(NameSpace nameSpace, ContextCloner ctxCloner) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"nameSpace=" + nameSpace, "ctxCloner=" + ctxCloner});
        }
        this._nameSpaceID = NameSpace.getNextNameSpaceID();
        this._nameSpaceType = nameSpace._nameSpaceType;
        this._bindingsTable.putAll(nameSpace._bindingsTable);
        for (Map.Entry<String, UuidContext> entry : nameSpace._contextsTable.entrySet()) {
            String ctxID = entry.getKey();
            UuidContext ctx = entry.getValue();
            UuidContext clonedCtx = ctxCloner.cloneContextToDifferentNameSpace(ctx, this);
            this._contextsTable.put(ctxID, clonedCtx);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>", this);
        }
    }

    public NameSpace cloneNameSpace(ContextCloner ctxCloner) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cloneNameSpace", "ctxCloner=" + ctxCloner);
        }
        NameSpace nsClone = new NameSpace(this, ctxCloner);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cloneNameSpace", nsClone);
        }
        return nsClone;
    }

    public int getNameSpaceID() {
        return this._nameSpaceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinkedContextBinding(UuidContext currContext, Name name, String linkedCtxIDString, Object additionalData) throws NamingException, NameSpaceException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addLinkedContextBinding", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name, "linkedCtxIDString=" + linkedCtxIDString, "additionalData=" + additionalData});
        }
        StringContextID linkedCtxID = new StringContextID(linkedCtxIDString);
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("addLinkedContextBinding", currContext, name, "linkedCtxID=" + linkedCtxID);
        }
        UuidContext baseContext = currContext;
        this.validateName(name);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (currContext == null && name.size() > 1) {
                currContext = this.lookUpRootContext(name.get(0), null);
                name = name.getSuffix(1);
            }
            String relNameString = name.get(name.size() - 1);
            if (name.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException e = new NameNotAtomicException("Name " + name + " is not atomic.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "addLinkedContextBinding", new Object[]{"Throwing NameNotAtomicException", e});
                    }
                    throw e;
                }
                currContext = this.getParentCtxInternal(currContext, name, null);
            }
            String currCtxIDString = null;
            currCtxIDString = currContext != null ? ((Object)currContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            BindingsTableKey bindingKey = new BindingsTableKey(currCtxIDString, relNameString);
            BindingsTableData bindingData = null;
            int bindingType = 2;
            if (this._nameSpaceType == 1) {
                bindingData = this._bindingsTable.get(bindingKey);
                if (bindingData != null) {
                    NameAlreadyBoundException e = new NameAlreadyBoundException("Name \"" + name + "\" is already bound to the context \"" + baseContext.getNameInNamespace() + "\".");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "addLinkedContextBinding", e);
                    }
                    throw e;
                }
                bindingType = 2;
            }
            bindingData = new BindingsTableData(relNameString, linkedCtxID, bindingType, additionalData);
            this._bindingsTable.put(bindingKey, bindingData);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addLinkedContextBinding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(UuidContext currContext, Name name, Object objectToBind, Object additionalData) throws NamingException, NameSpaceException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "bind", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name, "objectToBind=" + objectToBind, "additionalData=" + additionalData});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("bind", currContext, name, NameSpace.bindObjectToString(objectToBind));
        }
        UuidContext baseContext = currContext;
        this.validateName(name);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (currContext == null && name.size() > 1) {
                currContext = this.lookUpRootContext(name.get(0), null);
                name = name.getSuffix(1);
            }
            String relNameString = name.get(name.size() - 1);
            if (name.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException e = new NameNotAtomicException("Name " + name + " is not atomic.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "bind", e);
                    }
                    throw e;
                }
                currContext = this.getParentCtxInternal(currContext, name, null);
            }
            String currCtxIDString = null;
            currCtxIDString = currContext != null ? ((Object)currContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            BindingsTableKey bindingKey = new BindingsTableKey(currCtxIDString, relNameString);
            BindingsTableData bindingData = null;
            int bindingType = 99;
            if (this._nameSpaceType == 1) {
                bindingData = this._bindingsTable.get(bindingKey);
                if (bindingData != null) {
                    NameAlreadyBoundException e = new NameAlreadyBoundException("Name \"" + name + "\" is already bound to the context \"" + baseContext.getNameInNamespace() + "\".");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "bind", e);
                    }
                    throw e;
                }
                bindingType = 2;
            }
            if (objectToBind instanceof UuidContext) {
                objectToBind = this.getUuidContextReference((UuidContext)objectToBind);
            }
            bindingData = new BindingsTableData(relNameString, objectToBind, bindingType, additionalData);
            this._bindingsTable.put(bindingKey, bindingData);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "bind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubcontext(UuidContext currContext, Name name, UuidContext newContext, Object additionalData) throws NamingException, NameSpaceException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontext", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name, "newContext=" + NameSpace.uuidContextToString(newContext), "additionalData=" + additionalData});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("createSubcontext", currContext, name, "newContext=" + NameSpace.uuidContextToString(newContext));
        }
        this.validateName(name);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (currContext == null && name.size() > 1) {
                currContext = this.lookUpRootContext(name.get(0), null);
                name = name.getSuffix(1);
            }
            String relNameString = name.get(name.size() - 1);
            if (name.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException e = new NameNotAtomicException("Name " + name + " is not atomic.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createSubcontext", e);
                    }
                    throw e;
                }
                currContext = this.getParentCtxInternal(currContext, name, null);
            }
            String currCtxIDString = null;
            currCtxIDString = currContext != null ? ((Object)currContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            ContextID newCtxID = newContext.getContextID();
            String newCtxIDString = ((Object)newCtxID).toString();
            BindingsTableKey bindingKey = new BindingsTableKey(currCtxIDString, relNameString);
            BindingsTableData bindingData = null;
            int bindingType = 99;
            if (this._nameSpaceType == 1) {
                bindingData = this._bindingsTable.get(bindingKey);
                if (bindingData != null) {
                    NameAlreadyBoundException e = new NameAlreadyBoundException("Name " + name + " is already bound.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createSubcontext", e);
                    }
                    throw e;
                }
                bindingType = 1;
                UuidContext ctxData = this._contextsTable.get(newCtxIDString);
                if (ctxData != null) {
                    DuplicateContextIDException e = new DuplicateContextIDException("Context ID " + newCtxIDString + " already exists.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createSubcontext", e);
                    }
                    throw e;
                }
            }
            bindingData = new BindingsTableData(relNameString, newCtxID, bindingType, additionalData);
            newContext = newContext.cloneContext();
            this._bindingsTable.put(bindingKey, bindingData);
            this._contextsTable.put(newCtxIDString, newContext);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(UuidContext currContext, Name name) throws NamingException, NameSpaceException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroySubcontext", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("destroySubcontext", currContext, name, new String[0]);
        }
        UuidContext baseContext = currContext;
        this.validateName(name);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (currContext == null && name.size() > 1) {
                currContext = this.lookUpRootContext(name.get(0), null);
                name = name.getSuffix(1);
            }
            String relNameString = name.get(name.size() - 1);
            if (name.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException e = new NameNotAtomicException("Name " + name + " is not atomic.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "destroySubcontext", e);
                    }
                    throw e;
                }
                currContext = this.getParentCtxInternal(currContext, name, null);
            }
            String currCtxIDString = null;
            currCtxIDString = currContext != null ? ((Object)currContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            BindingsTableKey bindingKey = new BindingsTableKey(currCtxIDString, relNameString);
            BindingsTableData bindingData = this._bindingsTable.get(bindingKey);
            if (bindingData != null) {
                Object boundObj = bindingData.getObject();
                String targetContextIDString = null;
                if (this._nameSpaceType == 1) {
                    if (!(boundObj instanceof ContextID) && !(boundObj instanceof Context)) {
                        NotContextException e = new NotContextException("Object bound under under the name \"" + name + "\" is not a context.");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "destroySubcontext", e);
                        }
                        throw e;
                    }
                    if (bindingData.getBindingType() == 2) {
                        CannotDestroySubcontextException e = new CannotDestroySubcontextException("Cannot destroy context \"" + name + "\" in the context \"" + baseContext.getNameInNamespace() + "\".  A context can " + "be destroyed only from a context from which it was created.");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "destroySubcontext", e);
                        }
                        throw e;
                    }
                    if (!(boundObj instanceof ContextID)) {
                        NameSpaceInconsistentException e = new NameSpaceInconsistentException("Internal error:  The context \"" + name + "\" has " + "a binding type of \"create\" but is not a UuidContext");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "destroySubcontext", e);
                        }
                        throw e;
                    }
                    targetContextIDString = ((Object)((ContextID)boundObj)).toString();
                    Set<BindingsTableKey> scanKeys = this._bindingsTable.keySet();
                    for (BindingsTableKey scanKey : scanKeys) {
                        if (!scanKey.isPartialKeyMatch(targetContextIDString)) continue;
                        ContextNotEmptyException e = new ContextNotEmptyException("The context \"" + name + "\" is not empty.");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "destroySubcontext", e);
                        }
                        throw e;
                    }
                }
                this._bindingsTable.remove(bindingKey);
                if (boundObj instanceof ContextID) {
                    ContextID destroyedCtxID = (ContextID)boundObj;
                    this._contextsTable.remove(((Object)destroyedCtxID).toString());
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroySubcontext");
        }
    }

    public Enumeration<NameSpaceBindingData> list(UuidContext currContext, Name name) throws NamingException, NameSpaceException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "list", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("list", currContext, name, new String[0]);
        }
        if (name == null) {
            InvalidNameException e = new InvalidNameException("A null name is not allowed.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "list", e);
            }
            throw e;
        }
        if (this._nameSpaceType == 2) {
            OperationNotSupportedException e = new OperationNotSupportedException("This method is not supported for caching.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "list", e);
            }
            throw e;
        }
        UuidContext targetCtx = currContext;
        if (name.size() > 0) {
            NameSpaceBindingData targetData = this.lookup(currContext, name);
            Object obj = targetData.getBoundObject();
            if (obj instanceof UuidContext) {
                targetCtx = (UuidContext)obj;
            } else {
                NotContextException e = new NotContextException("The object bound under the name \"" + name + "\" is not a context.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "list", e);
                }
                throw e;
            }
        }
        NameSpaceEnumeration nsEnum = new NameSpaceEnumeration(this, this._bindingsTable, this._contextsTable, targetCtx);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "list", nsEnum);
        }
        return nsEnum;
    }

    public NameSpaceBindingData lookup(UuidContext currContext, Name name) throws NamingException, NameSpaceException {
        return this.lookupInternal(currContext, name, false);
    }

    public NameSpaceBindingData intermediateCacheLookup(UuidContext currContext, Name name) throws NamingException, NameSpaceException {
        return this.lookupInternal(currContext, name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameSpaceBindingData lookupInternal(UuidContext currContext, Name name, boolean intermediateCacheLookup) throws NamingException, NameSpaceException {
        NameNotFoundException e;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookupInternal", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name, "intermediateCacheLookup=" + intermediateCacheLookup});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("lookupInternal", currContext, name, new String[0]);
        }
        this.validateName(name);
        UuidContext baseContext = null;
        BindingsTableKey bindingKey = null;
        BindingsTableData bindingData = null;
        Object retObject = null;
        String relNameString = null;
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (currContext == null) {
                bindingData = new BindingsTableData();
                currContext = this.lookUpRootContext(name.get(0), bindingData);
                if ((name = name.getSuffix(1)).size() == 0) {
                    if (currContext instanceof UnresolvedContext) {
                        NameNotFoundException e2 = new NameNotFoundException("Root context not found.");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "lookupInternal", this.namingExceptionForTrace(e2));
                        }
                        throw e2;
                    }
                    NameSpaceBindingDataImpl retData = new NameSpaceBindingDataImpl(name.toString(), currContext, bindingData.getAdditionalData(), bindingData.getBindingType());
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "lookupInternal", new Object[]{"root context", retData});
                    }
                    return retData;
                }
            }
            relNameString = name.get(name.size() - 1);
            baseContext = currContext;
            if (name.size() > 1) {
                currContext = this.getParentCtxInternal(currContext, name, null);
            }
            ContextID currCtxID = currContext.getContextID();
            String currCtxIDString = ((Object)currCtxID).toString();
            bindingKey = new BindingsTableKey(currCtxIDString, relNameString);
            bindingData = this._bindingsTable.get(bindingKey);
        }
        if (bindingData == null) {
            e = new NameNotFoundException("Name \"" + name + "\" not found in context \"" + baseContext.getNameInNamespace() + "\".");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookupInternal", this.namingExceptionForTrace(e));
            }
            throw e;
        }
        retObject = bindingData.getObject();
        if (retObject instanceof ContextID) {
            if ((retObject = this._contextsTable.get(((Object)((ContextID)retObject)).toString())) == null) {
                Exception e3;
                int bindingType = bindingData.getBindingType();
                if (bindingType == 2) {
                    e3 = new InvalidObjectException("The context binding \"" + name + "\", relative to context \"" + baseContext.getNameInNamespace() + "\", exists, but the context " + "itself does not exist.  A \"destroySubcontext\" operation may have " + "already been performed on the name under which it was created.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "lookupInternal", e3);
                    }
                    throw e3;
                }
                if (bindingType == 1) {
                    e3 = new NameSpaceInconsistentException("Internal Error:  Context \"" + name + "\" relative to " + "the context \"" + baseContext.getNameInNamespace() + "\" was not found in the Contexts table.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "lookupInternal", e3);
                    }
                    throw e3;
                }
                e3 = new NameNotFoundException("The context binding \"" + name + "\", relative to context \"" + baseContext.getNameInNamespace() + "\", exists, but the context " + "itself does not exist.  A \"destroySubcontext\" operation may have " + "already been performed on the name under which it was created.  Since " + "this is a cache lookup, NameNotFoundException is being thrown.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookupInternal", e3);
                }
                throw e3;
            }
            if (retObject instanceof UnresolvedContext && !intermediateCacheLookup) {
                e = new NameNotFoundException("Name \"" + name + "\" not found in context \"" + baseContext.getNameInNamespace() + "\".");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookupInternal", e);
                }
                throw e;
            }
            if (!intermediateCacheLookup) {
                retObject = ((UuidContext)retObject).copyContext(baseContext);
            }
        }
        NameSpaceBindingDataImpl retData = new NameSpaceBindingDataImpl(name.toString(), retObject, bindingData.getAdditionalData(), bindingData.getBindingType());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookupInternal", retData);
        }
        return retData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(UuidContext currContext, Name name, Object objectToBind, Object additionalData) throws NamingException, NameSpaceException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rebind", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name, "objectToBind=" + objectToBind, "additionalData=" + additionalData});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("rebind", currContext, name, NameSpace.bindObjectToString(objectToBind));
        }
        UuidContext baseContext = currContext;
        this.validateName(name);
        String relNameString = name.get(name.size() - 1);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (name.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException e = new NameNotAtomicException("Name " + name + " is not atomic.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "rebind", e);
                    }
                    throw e;
                }
                currContext = this.getParentCtxInternal(currContext, name, null);
            }
            ContextID currCtxID = currContext.getContextID();
            String currCtxIDString = ((Object)currCtxID).toString();
            BindingsTableKey bindingKey = new BindingsTableKey(currCtxIDString, relNameString);
            BindingsTableData bindingData = this._bindingsTable.get(bindingKey);
            if (this._nameSpaceType == 1 && bindingData != null && bindingData.getBindingType() == 1) {
                CannotUnbindSubcontextException e = new CannotUnbindSubcontextException("Cannot unbind context \"" + name + "\" from the context \"" + baseContext.getNameInNamespace() + "\".  A context can " + "be unbound only from a context from which it was bound.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "rebind", e);
                }
                throw e;
            }
            if (objectToBind instanceof UuidContext) {
                objectToBind = this.getUuidContextReference((UuidContext)objectToBind);
            }
            if (bindingData == null) {
                int bindingType = 99;
                if (this._nameSpaceType == 1) {
                    bindingType = 2;
                }
                bindingData = new BindingsTableData(relNameString, objectToBind, bindingType, additionalData);
            } else {
                bindingData = new BindingsTableData(bindingData.getName(), objectToBind, bindingData.getBindingType(), additionalData);
            }
            this._bindingsTable.put(bindingKey, bindingData);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rebind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(UuidContext currContext, Name name) throws NamingException, NameSpaceException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbind", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("unbind", currContext, name, new String[0]);
        }
        UuidContext baseContext = currContext;
        this.validateName(name);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (currContext == null && name.size() > 1) {
                currContext = this.lookUpRootContext(name.get(0), null);
                name = name.getSuffix(1);
            }
            String relNameString = name.get(name.size() - 1);
            if (name.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException e = new NameNotAtomicException("Name " + name + " is not atomic.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "unbind", e);
                    }
                    throw e;
                }
                currContext = this.getParentCtxInternal(currContext, name, null);
            }
            String currCtxIDString = null;
            currCtxIDString = currContext != null ? ((Object)currContext.getContextID()).toString() : ROOT_PARENT_CONTEXT_ID;
            BindingsTableKey bindingKey = new BindingsTableKey(currCtxIDString, relNameString);
            BindingsTableData bindingData = this._bindingsTable.get(bindingKey);
            if (this._nameSpaceType == 1 && bindingData != null && bindingData.getBindingType() == 1) {
                CannotUnbindSubcontextException e = new CannotUnbindSubcontextException("Cannot unbind context \"" + name + "\" from the context \"" + baseContext.getNameInNamespace() + "\".  A context can " + "be unbound only from a context from which it was bound.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "unbind", e);
                }
                throw e;
            }
            if (bindingData != null) {
                this._bindingsTable.remove(bindingKey);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "unbind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdditionalData(UuidContext currContext, Name name, Object additionalData) throws NamingException, NameSpaceException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateAdditionalData", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name, "additionalData=" + additionalData});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("updateAdditionalData", currContext, name, new String[0]);
        }
        UuidContext baseContext = currContext;
        this.validateName(name);
        String relNameString = name.get(name.size() - 1);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            String currCtxIDString;
            BindingsTableKey bindingKey;
            BindingsTableData bindingData;
            if (name.size() > 1) {
                if (this._nameSpaceType == 1) {
                    NameNotAtomicException e = new NameNotAtomicException("Name " + name + " is not atomic.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "updateAdditionalData", e);
                    }
                    throw e;
                }
                currContext = this.getParentCtxInternal(currContext, name, null);
            }
            if ((bindingData = this._bindingsTable.get(bindingKey = new BindingsTableKey(currCtxIDString = ((Object)currContext.getContextID()).toString(), relNameString))) == null) {
                NameNotFoundException e = new NameNotFoundException("Name " + name + " not found in context \"" + baseContext.getNameInNamespace() + "\".");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateAdditionalData", e);
                }
                throw e;
            }
            bindingData.setAdditionalData(additionalData);
            this._bindingsTable.put(bindingKey, bindingData);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateAdditionalData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "clear");
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("clear", null, null, new String[0]);
        }
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            this._bindingsTable.clear();
            this._contextsTable.clear();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "clear");
        }
    }

    public void validateName(Name name) throws InvalidNameException {
        if (name == null || name.size() == 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "validateName", "Name is null or empty.");
            }
            throw new InvalidNameException("A null or empty name is not allowed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContext(String ctxID) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContext", "ctxID=" + ctxID);
        }
        UuidContext ctx = null;
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            ctx = this._contextsTable.get(ctxID);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContext", ctx);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameSpaceBindingData getParentContext(UuidContext currContext, Name name) throws NameNotFoundException, NotContextException, CannotProceedException, NamingException, NameSpaceInconsistentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getParentContext", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("getParentContext", currContext, name, new String[0]);
        }
        if (name.size() == 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getParentContext", "Empty name specified");
            }
            return null;
        }
        UuidContext baseCtx = currContext;
        UuidContext retCtx = null;
        BindingsTableData parentData = new BindingsTableData();
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            if (currContext == null) {
                currContext = this.lookUpRootContext(name.get(0), parentData);
                name = name.getSuffix(1);
            }
            if (name.size() > 1) {
                retCtx = this.getParentCtxInternal(currContext, name, parentData);
            } else if (baseCtx == null) {
                retCtx = currContext;
            } else {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getParentContext", "Non-null current context with atomic name specified");
                }
                return null;
            }
        }
        if (baseCtx != null && retCtx != null) {
            retCtx = retCtx.copyContext(baseCtx);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getParentContext", "parentCtx=" + retCtx.getNameInNamespace());
            }
        }
        NameSpaceBindingDataImpl retData = new NameSpaceBindingDataImpl(name.toString(), retCtx, parentData.getAdditionalData(), parentData.getBindingType());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getParentContext", retData);
        }
        return retData;
    }

    private UuidContext getParentCtxInternal(UuidContext currContext, Name name, BindingsTableData parentBindingData) throws NameNotFoundException, NotContextException, CannotProceedException, NamingException, NameSpaceInconsistentException {
        int i;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getParentCtxInternal", new String[]{"currContext=" + NameSpace.uuidContextToString(currContext), "name=" + name, "parentBindingData=" + parentBindingData});
        }
        if (_tc.isDebugEnabled()) {
            this.traceDebugInfo("getParentCtxInternal", currContext, name, new String[0]);
        }
        if (name.size() < 2) {
            NameNotFoundException e = new NameNotFoundException("Name \"" + name + "\" not found in context \"" + currContext.getNameInNamespace() + "\".");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getParentCtxInternal", this.namingExceptionForTrace(e));
            }
            throw e;
        }
        UuidContext baseContext = currContext;
        BindingsTableData data = null;
        boolean foreignContext = false;
        StringBuilder nameBuff = new StringBuilder(64);
        int nameSize = name.size();
        for (i = 0; i < nameSize - 1; ++i) {
            String nameComp = name.get(i);
            if (i != 0) {
                nameBuff.append(NAME_COMPONENT_SEPARATOR);
            }
            nameBuff.append(nameComp);
            BindingsTableKey key = new BindingsTableKey(((Object)currContext.getContextID()).toString(), name.get(i));
            data = this._bindingsTable.get(key);
            if (data == null) {
                NameNotFoundException e = new NameNotFoundException("Name " + nameBuff + " not found in context \"" + baseContext.getNameInNamespace() + "\".");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getParentCtxInternal", this.namingExceptionForTrace(e));
                }
                throw e;
            }
            Object boundObject = data.getObject();
            if (boundObject instanceof ContextID) {
                currContext = this._contextsTable.get(((Object)((ContextID)boundObject)).toString());
                if (currContext != null) continue;
                int bindingType = data.getBindingType();
                if (bindingType == 1) {
                    NameSpaceInconsistentException e = new NameSpaceInconsistentException("Internal Error:  Context \"" + nameBuff + "\" bound in the context \"" + baseContext.getNameInNamespace() + "\" not found in contexts table.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getParentCtxInternal", e);
                    }
                    throw e;
                }
                if (bindingType == 2) {
                    InvalidObjectException e = new InvalidObjectException("The context binding \"" + nameBuff + "\", relative " + "to context \"" + baseContext.getNameInNamespace() + "\", exists, " + "but the context itself does not exist.  A \"destroySubcontext\" " + "operation may have already been performed on the name under which " + "it was created.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getParentCtxInternal", e);
                    }
                    throw e;
                }
                NameNotFoundException e = new NameNotFoundException("Name \"" + nameBuff + "\" not found in context \"" + baseContext.getNameInNamespace() + "\".");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getParentCtxInternal", this.namingExceptionForTrace(e));
                }
                throw e;
            }
            if (boundObject instanceof Context) {
                foreignContext = true;
                break;
            }
            NotContextException e = new NotContextException("The object bound to " + nameBuff + " in the context \"" + baseContext.getNameInNamespace() + "\" is not a context.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getParentCtxInternal", e);
            }
            throw e;
        }
        if (foreignContext) {
            Name remName;
            Name altName = name.getPrefix(i + 1);
            Name tmpremName = remName = name.getSuffix(i);
            Name tmpaltName = altName;
            CannotProceedException x = new CannotProceedException();
            x.setAltName(tmpaltName);
            x.setRemainingNewName(tmpremName);
            if (currContext instanceof Context) {
                x.setAltNameCtx((Context)((Object)currContext));
                x.setEnvironment(((Context)((Object)currContext)).getEnvironment());
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getParentCtxInternal", "Cannot proceed. Alt name=" + altName + ", Rem name=" + remName + ", Base ctx=" + baseContext.getNameInNamespace());
            }
            throw x;
        }
        if (parentBindingData != null) {
            parentBindingData.copyBindingData(data);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getParentCtxInternal", currContext.getNameInNamespace());
        }
        return currContext;
    }

    private Object getUuidContextReference(UuidContext bindCtx) throws NamingException {
        Object objRef = null;
        ContextID bindCtxID = bindCtx.getContextID();
        String bindCtxIDString = ((Object)bindCtxID).toString();
        UuidContext ctxData = this._contextsTable.get(bindCtxIDString);
        objRef = ctxData != null ? bindCtx.getContextID() : bindCtx.cloneContext();
        return objRef;
    }

    private UuidContext lookUpRootContext(String bindingName, BindingsTableData rootBindingData) throws NameNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookUpRootContext", new String[]{"bindingName=" + bindingName, "rootBindingData=" + rootBindingData});
        }
        UuidContext rootContext = null;
        BindingsTableKey bindingKey = new BindingsTableKey(ROOT_PARENT_CONTEXT_ID, bindingName);
        BindingsTableData bindingData = this._bindingsTable.get(bindingKey);
        if (bindingData != null) {
            Object boundObject = bindingData.getObject();
            if (boundObject instanceof ContextID) {
                rootContext = this._contextsTable.get(((Object)((ContextID)boundObject)).toString());
            }
            if (rootBindingData != null) {
                rootBindingData.copyBindingData(bindingData);
            }
        }
        if (rootContext == null) {
            NameNotFoundException e = new NameNotFoundException("Root context not found.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookUpRootContext", this.namingExceptionForTrace(e));
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookUpRootContext", NameSpace.uuidContextToString(rootContext));
        }
        return rootContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recursivelyRemoveBindings(String ctxID) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "recursivelyRemoveBindings", "ctxID=" + ctxID);
        }
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            Set<BindingsTableKey> keys = this._bindingsTable.keySet();
            BindingsTableKey[] keyArray = keys.toArray(new BindingsTableKey[keys.size()]);
            this.doRecursivelyRemoveBindings(keyArray, ctxID);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "recursivelyRemoveBindings");
        }
    }

    private void doRecursivelyRemoveBindings(BindingsTableKey[] keyArray, String ctxID) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doRecursivelyRemoveBindings", new String[]{"keyArray=" + Arrays.toString(keyArray), "ctxID=" + ctxID});
        }
        for (BindingsTableKey bindingKey : keyArray) {
            BindingsTableData bindingData = this._bindingsTable.get(bindingKey);
            if (!bindingKey.isPartialKeyMatch(ctxID)) continue;
            if (bindingData.getBindingType() == 1) {
                String currCtxIDString = bindingData.getObject().toString();
                this.doRecursivelyRemoveBindings(keyArray, currCtxIDString);
                this._contextsTable.remove(currCtxIDString);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doRecursivelyRemoveBindings", "Context " + currCtxIDString + " is removed from the context table");
                }
            }
            this._bindingsTable.remove(bindingKey);
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "doRecursivelyRemoveBindings", "Binding =" + bindingKey + " is removed from the binding table");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doRecursivelyRemoveBindings");
        }
    }

    public String toString() {
        return this.toString(_debug);
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_nameSpaceID=");
        stringBuilder.append(this._nameSpaceID);
        stringBuilder.append(", _nameSpaceType=");
        stringBuilder.append(this._nameSpaceType);
        stringBuilder.append(", _contextsTable=");
        stringBuilder.append(Helpers.mapToTerseString(this._contextsTable));
        stringBuilder.append(", _bindingsTable=");
        stringBuilder.append(Helpers.mapToTerseString(this._bindingsTable));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private Object namingExceptionForTrace(NamingException e) {
        Object object = null;
        object = this._nameSpaceType != 2 ? e : e.toString();
        return object;
    }

    private void traceDebugInfo(String methodName, UuidContext currContext, Name name, String ... more) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(methodName);
        stringBuilder.append(", nsID=");
        stringBuilder.append(this._nameSpaceID);
        if (name != null) {
            stringBuilder.append(", name=");
            stringBuilder.append(name.toString());
        }
        for (String s : more) {
            stringBuilder.append(", ");
            stringBuilder.append(s);
        }
        stringBuilder.append(": this=");
        stringBuilder.append(this);
        if (currContext != null) {
            stringBuilder.append(", currContext=");
            stringBuilder.append(NameSpace.uuidContextToString(currContext));
        }
        Tr.debug(_tc, methodName, stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpNameSpace(PrintStream outputStream) {
        PrintStream out = outputStream;
        if (outputStream == null) {
            out = System.out;
        }
        out.println(ROOT_PARENT_CONTEXT_ID);
        out.println("DUMP OF NAME SPACE");
        out.println("==================");
        out.println(ROOT_PARENT_CONTEXT_ID);
        if (this._nameSpaceType == 1) {
            out.println("Name space type: PRIMARY");
        } else {
            out.println("Name space type: CACHE");
        }
        out.println(ROOT_PARENT_CONTEXT_ID);
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            Set<BindingsTableKey> bindingKeys = this._bindingsTable.keySet();
            Object[] bindingKeyArray = bindingKeys.toArray(new BindingsTableKey[bindingKeys.size()]);
            Arrays.sort(bindingKeyArray);
            out.println("BINDINGS TABLE (size: " + bindingKeyArray.length + "):");
            for (Object bindingKey : bindingKeyArray) {
                StringBuilder lineOut = new StringBuilder(128);
                lineOut.append("BINDING: ");
                lineOut.append("Key=");
                lineOut.append(((BindingsTableKey)bindingKey).toString());
                out.println(lineOut.toString());
                lineOut = new StringBuilder(128);
                BindingsTableData data = this._bindingsTable.get(bindingKey);
                int bindingType = data.getBindingType();
                String bindingTypeString = null;
                switch (bindingType) {
                    case 1: {
                        bindingTypeString = "CREATE";
                        break;
                    }
                    case 2: {
                        bindingTypeString = "BIND";
                        break;
                    }
                    case 99: {
                        bindingTypeString = "DON'T CARE";
                        break;
                    }
                    default: {
                        bindingTypeString = "<INVALID BINDING TYPE (" + bindingType + ")!!!>";
                    }
                }
                lineOut.append("   Binding type=");
                lineOut.append(bindingTypeString);
                out.println(lineOut.toString());
                lineOut = new StringBuilder(128);
                Object boundObj = data.getObject();
                lineOut.append("   Bound object type=");
                if (boundObj instanceof ContextID) {
                    lineOut.append("LOCAL CONTEXT,");
                    lineOut.append(" ID=" + ((Object)((ContextID)boundObj)).toString());
                } else if (boundObj instanceof Context) {
                    lineOut.append("REMOTE CONTEXT,");
                    lineOut.append(" Class name=" + boundObj.getClass().getName());
                    try {
                        lineOut.append(" Context name=" + ((Context)boundObj).getNameInNamespace());
                    }
                    catch (NamingException e) {
                        RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "dumpNameSpace", "2274", this);
                    }
                } else {
                    lineOut.append("OBJECT, ");
                    if (boundObj != null) {
                        if (boundObj instanceof byte[]) {
                            lineOut.append("Class name=<serialized object>, ");
                        } else {
                            lineOut.append("Class name=" + boundObj.getClass().getName() + ", ");
                        }
                        lineOut.append("Data=" + boundObj.toString());
                    } else {
                        lineOut.append("null object");
                    }
                }
                out.println(lineOut.toString());
                lineOut = new StringBuilder(128);
                Object addData = data.getAdditionalData();
                lineOut.append("   Additional data: ");
                if (addData == null) {
                    lineOut.append("<NULL>");
                } else {
                    lineOut.append("Class name=");
                    lineOut.append(addData.getClass().getName() + ", ");
                    lineOut.append("Data=");
                    lineOut.append(addData.toString());
                }
                out.println(lineOut.toString());
            }
            Set<String> contextKeys = this._contextsTable.keySet();
            Object[] contextKeyArray = contextKeys.toArray(new String[contextKeys.size()]);
            Arrays.sort(contextKeyArray);
            out.println(ROOT_PARENT_CONTEXT_ID);
            out.println("CONTEXTS TABLE (size: " + contextKeyArray.length + "):");
            for (Object contextKey : contextKeyArray) {
                StringBuilder lineOut = new StringBuilder(128);
                lineOut.append("CONTEXT: ");
                lineOut.append("Key=");
                lineOut.append((String)contextKey);
                lineOut.append(", ");
                UuidContext ctxObj = this._contextsTable.get(contextKey);
                out.println(lineOut.toString());
                lineOut = new StringBuilder(128);
                lineOut.append("   Type=");
                if (ctxObj instanceof UnresolvedContext) {
                    lineOut.append("UNRESOLVED, ID=");
                    lineOut.append(((Object)((UnresolvedContext)ctxObj).getContextID()).toString());
                    lineOut.append(", name=");
                    try {
                        lineOut.append(ctxObj.getNameInNamespace());
                    }
                    catch (NamingException e) {
                        RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "dumpNameSpace", "2340", this);
                    }
                } else if (ctxObj instanceof UuidContext) {
                    lineOut.append("RESOLVED, ID=");
                    lineOut.append(((Object)ctxObj.getContextID()).toString());
                    lineOut.append(", name=");
                    try {
                        lineOut.append(ctxObj.getNameInNamespace());
                    }
                    catch (NamingException e) {
                        RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "dumpNameSpace", "2354", this);
                    }
                } else {
                    lineOut.append("unknown. class name=");
                    lineOut.append(ctxObj.getClass().getName());
                }
                out.println(lineOut.toString());
            }
        }
        out.println("\nEND OF NAME SPACE DUMP");
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ipbase/NameSpace.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.43");
        }
        CLASS_NAME = NameSpace.class.getName();
        _debug = Boolean.getBoolean("com.ibm.ws.naming.debug");
        _nameSpaceCount = 0;
    }
}

