/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.corbaname;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.CorbaURLContext;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.URLNameHelpers;
import com.ibm.ws.naming.util.WsnName;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.omg.CORBA.BAD_PARAM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class corbanameURLContext
extends CorbaURLContext {
    private static final TraceComponent _tc = Tr.register(corbanameURLContext.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;

    public corbanameURLContext(Hashtable<?, ?> env) throws NamingException {
        super(env);
    }

    @Override
    protected String setErrMsgForEmptyStrName(String method2) {
        String errMsg = "The corbaname: URL string with an empty stringfied  name is not a valid name parameter for the method " + method2 + ": ";
        return errMsg;
    }

    protected String convertINSNameToCurrentSyntax(String name) throws NamingException {
        WsnName insName = new WsnName(name, _insEnv);
        WsnName targetName = new WsnName(insName.toCosName(), this._env);
        return targetName.toString();
    }

    @Override
    protected String[] getProviderURLAndName(String urlName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getProviderURLAndName", "urlName=" + urlName);
        }
        String encodedCorbaURLName = null;
        try {
            encodedCorbaURLName = URLNameHelpers.encodeCorbaURL(urlName);
        }
        catch (IllegalArgumentException iae) {
            RasUtil.logException((Throwable)iae, _tc, CLASS_NAME, "getProviderURLAndName", "117", this);
            String message = "Unexpected error occurred while escaping characters per RFC 2396 in corbaname URL \"" + urlName + "\"";
            InvalidNameException ine = new InvalidNameException(message);
            ine.initCause(iae);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getProviderURLAndName", ine);
            }
            throw ine;
        }
        ObjectURL objectUrl = null;
        try {
            objectUrl = ORB.createObjectURL((String)encodedCorbaURLName);
        }
        catch (BAD_PARAM e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getProviderURLAndName", "133", this);
            InvalidNameException ne = new InvalidNameException("Invalid corbaname URL \"" + urlName + "\"");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getProviderURLAndName", ne);
            }
            throw ne;
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "getProviderURLAndName", "140", this);
            ConfigurationException ne = new ConfigurationException("Unexpected error occurred while attempting to parse corbaname URL \"" + urlName + "\"");
            ne.initCause(t);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getProviderURLAndName", ne);
            }
            throw ne;
        }
        String providerUrl = "";
        String stringifiedName = objectUrl.getStringName();
        if (stringifiedName.length() == 0) {
            providerUrl = encodedCorbaURLName;
        } else {
            int index = encodedCorbaURLName.length() - stringifiedName.length();
            providerUrl = encodedCorbaURLName.substring(0, index - 1);
            stringifiedName = URLNameHelpers.decodeString(stringifiedName);
            stringifiedName = this.convertINSNameToCurrentSyntax(stringifiedName);
        }
        Object[] result = new String[]{providerUrl, stringifiedName};
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getProviderURLAndName", Arrays.toString(result));
        }
        return result;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/corbaname/corbanameURLContext.java, WAS.naming.client, WAS70.SERV1, cf050925.09, ver. 1.11");
        }
        CLASS_NAME = corbanameURLContext.class.getName();
    }
}

