/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ComponentDataObject;
import com.ibm.ws.metadata.MDOFields;
import com.ibm.ws.metadata.MetaDataException;
import com.ibm.ws.security.util.AccessController;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDataObject {
    private static final String CLASS_NAME = ModuleDataObject.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    public J2EEName iv_Key;
    protected EnumMap<MDOFields, Object> iv_MDOMap;
    protected HashMap<J2EEName, ComponentDataObject> iv_ComponentDataObjectHashMap;
    protected HashMap<String, ClassDataObject> iv_ClassDataObjectHashMap;
    public HashSet<String> ivScannedClasses;

    public ModuleDataObject(J2EEName j2eeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ModuleDataObject CTOR entry/exit");
        }
        this.iv_Key = j2eeName;
        this.iv_MDOMap = new EnumMap(MDOFields.class);
        this.iv_ComponentDataObjectHashMap = new HashMap();
        this.iv_ClassDataObjectHashMap = new HashMap();
    }

    public final void putEntry(MDOFields keyName, Object value) {
        this.iv_MDOMap.put(keyName, value);
    }

    public final Object getEntry(String key) {
        MDOFields keyName = Enum.valueOf(MDOFields.class, key);
        return this.iv_MDOMap.get((Object)keyName);
    }

    public final Object getEntry(MDOFields key) {
        return this.iv_MDOMap.get((Object)key);
    }

    public final ComponentDataObject getComponentDataObject(J2EEName key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getComponentDataObject", key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getComponentDataObject");
        }
        return this.iv_ComponentDataObjectHashMap.get(key);
    }

    public final ClassDataObject getClassDataObject(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassDataObject", key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassDataObject");
        }
        return this.iv_ClassDataObjectHashMap.get(key);
    }

    public final ComponentDataObject putComponentDataObject(ComponentDataObject newCDO) {
        ComponentDataObject cdo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putComponentDataObject", ((Object)newCDO.iv_Key).toString());
        }
        if ((cdo = this.iv_ComponentDataObjectHashMap.get(newCDO.iv_Key)) != null) {
            MetaDataException ex = new MetaDataException("Component already exists:  J2EEName = " + ((Object)newCDO.iv_Key).toString());
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "putComponentDataObject", "243", this);
            Tr.error(tc, "DUPLICATE_COMPONENT_CWMDF0001E", ((Object)newCDO.iv_Key).toString());
            throw ex;
        }
        this.iv_ComponentDataObjectHashMap.put(newCDO.iv_Key, newCDO);
        cdo = this.iv_ComponentDataObjectHashMap.get(newCDO.iv_Key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "putComponentDataObject");
        }
        return cdo;
    }

    public final ClassDataObject putClassDataObject(ClassDataObject newCDO) {
        ClassDataObject cdo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putClassDataObject", newCDO);
        }
        if ((cdo = this.iv_ClassDataObjectHashMap.get(newCDO.iv_Key)) == null) {
            this.iv_ClassDataObjectHashMap.put(newCDO.iv_Key, newCDO);
            cdo = newCDO;
        }
        Tr.exit(tc, "putClassDataObject");
        return cdo;
    }

    public final ComponentDataObject createComponentDataObject(J2EEName key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createComponentDataObject", key);
        }
        ComponentDataObject cdo = null;
        cdo = key == null ? new ComponentDataObject(this) : new ComponentDataObject(key, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createComponentDataObject");
        }
        return cdo;
    }

    public final ClassDataObject createClassDataObject(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createClassDataObject", key);
        }
        ClassDataObject cdo = new ClassDataObject(key, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createClassDataObject");
        }
        return cdo;
    }

    public final ClassDataObject createClassDataObject(String key, String componentName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createClassDataObject:  " + key, componentName);
        }
        ClassDataObject classDO = this.createClassDataObject(key);
        if (classDO.ivComponentNames == null) {
            classDO.ivComponentNames = new HashSet();
        }
        classDO.ivComponentNames.add(componentName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createClassDataObject");
        }
        return classDO;
    }

    public final Collection<ComponentDataObject> getAllComponentDataObjects() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllComponentDataObjects");
        }
        Collection<ComponentDataObject> result = null;
        if (!this.iv_ComponentDataObjectHashMap.isEmpty()) {
            result = this.iv_ComponentDataObjectHashMap.values();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllComponentDataObjects");
        }
        return result;
    }

    public final Collection<ClassDataObject> getAllClassDataObjects() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllClassDataObjects");
        }
        Collection<ClassDataObject> result = null;
        if (!this.iv_ClassDataObjectHashMap.isEmpty()) {
            result = this.iv_ClassDataObjectHashMap.values();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllClassDataObjects");
        }
        return result;
    }

    public String toString() {
        int i;
        String newLine = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("line.separator", "\n"));
        StringBuffer sb = new StringBuffer();
        String indent = "     ";
        sb.append(newLine + indent + "*** START ModuleDataObject fields ***");
        sb.append(newLine + indent + "J2EEName = " + this.iv_Key);
        if (this.iv_MDOMap != null) {
            Set<MDOFields> mdoSet = this.iv_MDOMap.keySet();
            Object[] mdoKeys = null;
            mdoKeys = mdoSet.toArray();
            for (i = 0; i < mdoKeys.length; ++i) {
                Object entry = this.iv_MDOMap.get(mdoKeys[i]);
                if (entry instanceof Map) {
                    sb.append(this.exceptionMapToString(mdoKeys[i], (Map)entry, newLine + indent));
                    continue;
                }
                sb.append(newLine + indent + mdoKeys[i] + " = " + entry);
            }
        }
        Set<J2EEName> keySet = this.iv_ComponentDataObjectHashMap.keySet();
        Object[] cdoKeyArray = keySet.toArray();
        for (i = 0; i < cdoKeyArray.length; ++i) {
            ComponentDataObject cdo = this.iv_ComponentDataObjectHashMap.get(cdoKeyArray[i]);
            sb.append(cdo.toString());
        }
        Set<String> classKeySet = this.iv_ClassDataObjectHashMap.keySet();
        Object[] classKeyArray = classKeySet.toArray();
        for (int i2 = 0; i2 < classKeyArray.length; ++i2) {
            ClassDataObject classDO = this.iv_ClassDataObjectHashMap.get(classKeyArray[i2]);
            sb.append(classDO.toString());
        }
        sb.append(newLine + newLine + indent + "*** END ModuleDataObject fields  ***");
        return sb.toString();
    }

    private StringBuffer exceptionMapToString(Object key, Map theMap, String separator) {
        String indent = "     ";
        StringBuffer sb = new StringBuffer();
        if (theMap != null && !theMap.isEmpty()) {
            sb.append(separator + key + " list: ");
            Object[] mapKeys = theMap.keySet().toArray();
            for (int k = 0; k < mapKeys.length; ++k) {
                Object theValue = theMap.get(mapKeys[k]);
                sb.append(separator + indent + "Exception: " + mapKeys[k] + ", Rollback setting: " + theValue);
            }
        }
        return sb;
    }
}

