/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.product.WASProduct;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.ControlAdminService;
import com.ibm.ws.management.ControllerAdminService;
import com.ibm.ws.management.ServantAdminService;
import com.ibm.ws.management.util.PortConflictResolver;
import com.ibm.ws.management.util.UtilsClient;
import com.ibm.ws.profile.utils.FreePortDetector;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws390.management.ControllerAdminServiceImpl;
import com.ibm.ws390.management.ServantAdminServiceImpl;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.emf.ecore.EPackage;

public class Utils {
    public static final long CLOCK_SYNC_TOLERANCE = 300000L;
    private static TraceComponent tc = Tr.register(Utils.class, "Admin", null);
    private static WASProduct product = null;
    private static ServantAdminService servant = null;
    public static final String INDENT = "           ";
    public static final int MAX_MSG_LEN = 79;

    public static String getNodeAgentName() {
        return "nodeagent";
    }

    public static String getNetmgrName(AdminClient netmgr) {
        ObjectName mbean = null;
        String name = "dmgr";
        try {
            mbean = netmgr.getServerMBean();
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.management.util.Utils.getNetmgrName", "32");
        }
        if (mbean != null) {
            name = ObjectNameHelper.getProcessName(mbean);
        }
        return name;
    }

    public static ThreadPool getThreadPool(ThreadPoolMgr tpMgr, String name, int maxThreads, boolean growable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool", name);
        }
        ThreadPool pool = null;
        ProcessPackage processpkg = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        ProcessFactory processFactory = processpkg.getProcessFactory();
        com.ibm.websphere.models.config.process.ThreadPool tpCfg = processFactory.createThreadPool();
        tpCfg.setMinimumSize(1);
        tpCfg.setMaximumSize(maxThreads);
        tpCfg.setIsGrowable(growable);
        pool = tpMgr.getThreadPool(name, tpCfg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool");
        }
        return pool;
    }

    public static String getProductName() {
        if (product == null) {
            product = new WASProduct();
        }
        return product.getPlatform().getName();
    }

    public static String getProductVersion() {
        return UtilsClient.getProductVersion();
    }

    public static String getRemoteProductVersion(String productName, ObjectName serverMBean, AdminClient ac) throws InstanceNotFoundException, MBeanException, ConnectorException {
        String productVersion = null;
        try {
            if (ac != null) {
                productVersion = (String)ac.invoke(serverMBean, "getProductVersion", new Object[]{productName}, new String[]{"java.lang.String"});
            } else {
                AdminService as = AdminServiceFactory.getAdminService();
                productVersion = (String)as.invoke(serverMBean, "getProductVersion", new Object[]{productName}, new String[]{"java.lang.String"});
            }
        }
        catch (ReflectionException exc) {
            // empty catch block
        }
        if (productVersion != null) {
            int i = productVersion.indexOf("<version>");
            if (i < 0) {
                return null;
            }
            int j = productVersion.indexOf("</version>", i);
            if (j < 0) {
                return null;
            }
            productVersion = productVersion.substring(i + 9, j);
        }
        return productVersion;
    }

    public static int compareVersions(String v1, String v2) {
        StringTokenizer tok1 = new StringTokenizer(v1, ".");
        StringTokenizer tok2 = new StringTokenizer(v2, ".");
        short d1 = 0;
        short d2 = 0;
        while (tok1.hasMoreTokens()) {
            d1 = Short.parseShort(tok1.nextToken());
            if (!tok2.hasMoreTokens()) {
                while (d1 == 0) {
                    if (tok1.hasMoreTokens()) {
                        d1 = Short.parseShort(tok1.nextToken());
                        continue;
                    }
                    return 0;
                }
                return 1;
            }
            d2 = Short.parseShort(tok2.nextToken());
            if (d1 < d2) {
                return -1;
            }
            if (d1 <= d2) continue;
            return 1;
        }
        if (tok2.hasMoreTokens()) {
            d2 = Short.parseShort(tok2.nextToken());
            while (d2 == 0) {
                if (tok2.hasMoreTokens()) {
                    d2 = Short.parseShort(tok2.nextToken());
                    continue;
                }
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public static boolean isClockInSync(AdminClient ac, ObjectName jvmMBean) throws InstanceNotFoundException, MBeanException, ConnectorException {
        long preInvokeTime = System.currentTimeMillis();
        long remoteTime = Utils.getRemoteTime(ac, jvmMBean);
        long localTime = System.currentTimeMillis();
        long timeToInvoke = localTime - preInvokeTime;
        return Math.abs(remoteTime - localTime) <= 300000L + timeToInvoke;
    }

    public static long getRemoteTime(AdminClient ac, ObjectName jvmMBean) throws InstanceNotFoundException, MBeanException, ConnectorException {
        long remoteTime = 0L;
        try {
            if (ac != null) {
                remoteTime = (Long)ac.invoke(jvmMBean, "getCurrentTimeInMillis", null, null);
            } else {
                AdminService as = AdminServiceFactory.getAdminService();
                remoteTime = (Long)as.invoke(jvmMBean, "getCurrentTimeInMillis", null, null);
            }
        }
        catch (ReflectionException exc) {
            // empty catch block
        }
        return remoteTime;
    }

    public static ControllerAdminService getControllerAdminService() throws ConnectorException, RemoteException {
        ControllerAdminServiceImpl controller = null;
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            controller = new ControllerAdminServiceImpl();
        }
        return controller;
    }

    public static ServantAdminService getServantAdminService() {
        ServantAdminServiceImpl servant = null;
        if (AdminHelper.getPlatformHelper().isControlJvm()) {
            servant = new ServantAdminServiceImpl();
        }
        return servant;
    }

    public static void setServantAdminService(ServantAdminService servant) {
        Utils.servant = servant;
    }

    public static ControlAdminService getControlAdminService() {
        ControlAdminService service = null;
        try {
            String serviceName = "ControlAdminService";
            String uuid = AdminContext.peek();
            if (uuid != null) {
                serviceName = serviceName + "_" + uuid;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resolving initial reference for: " + serviceName);
            }
            service = (ControlAdminService)AdminHelper.getPlatformHelper().getGlobalORB().resolve_initial_references(serviceName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return service;
    }

    public static AdminException makeAdminException(Throwable t) {
        if (t instanceof AdminException) {
            return (AdminException)t;
        }
        return new AdminException(t);
    }

    public static int resolvePort(int seedPortValue, PortConflictResolver pcr) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "resolvePort: " + seedPortValue);
        }
        int recommendedPort = pcr.getPort(seedPortValue);
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "recommendedPort: " + recommendedPort + " for seedPortValue: " + seedPortValue);
        }
        if (!FreePortDetector.isPortFree((int)recommendedPort)) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "Port: " + recommendedPort + " is not free or available, we look for next available port");
            }
            while (!FreePortDetector.isPortFree((int)recommendedPort) || !pcr.reservePort(recommendedPort)) {
                ++recommendedPort;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "resolvePort: " + recommendedPort);
        }
        return recommendedPort;
    }

    public static boolean isSyncHotRestartEnabled() {
        boolean result = false;
        result = Boolean.getBoolean("hotRestartSync");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "hotRestartSync: " + result);
        }
        return result;
    }

    public static void issueMessage(String resourceBundle, String key, Object[] args, String inputmsg) {
        String msg = Utils.getFormattedMessage(resourceBundle, key, args, inputmsg);
        if (msg == null) {
            msg = Utils.getFormattedMessage(resourceBundle, "ADMU0123E", new Object[]{key}, null);
        }
        Utils.printMessage(msg, 79, false);
        Tr.audit(tc, key, args);
    }

    public static void printMessage(String msg, int maxLength, boolean indent) {
        int maxLocalLength = maxLength;
        if (indent) {
            System.out.print(INDENT);
            maxLocalLength -= INDENT.length();
        }
        if (msg.length() <= maxLocalLength) {
            System.out.println(msg);
        } else {
            int i = msg.lastIndexOf(32, maxLocalLength);
            if (i == -1 && (i = msg.indexOf(32)) == -1) {
                System.out.println(msg);
                return;
            }
            Utils.printMessage(msg.substring(0, i), maxLength, false);
            Utils.printMessage(msg.substring(i + 1), maxLength, true);
        }
    }

    public static String getFormattedMessage(String resourceBundle, String key, Object[] args, String defaultString) {
        try {
            ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(resourceBundle, Locale.getDefault());
            String result = RESOURCE_BUNDLE.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            return defaultString;
        }
    }
}

