/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.ListenerInfo;
import com.ibm.ws.management.event.ReceiverPermanentlyUnavailableException;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.management.event.WsStickyListener;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.util.ThreadPool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.security.auth.Subject;

public class NotificationDispatcher
implements WsNotifListener {
    private static TraceComponent tc = Tr.register(NotificationDispatcher.class, "Admin", "com.ibm.ws.management.resources.event");
    public static final String[] ASYNC_NOTIFS = new String[]{"websphere.ras"};
    private final ThreadPool dispatchPool;
    private final WsNotifListenerContainer container;
    private final WsNotifListener[] listeners;
    private final boolean removeNonresponsiveListeners;
    private static int _nextNotifDispatcherID = 1;
    private final String _ndIDString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationDispatcher(WsNotifListenerContainer container, WsNotifListener[] listeners, boolean removeNonresponsiveListeners, ThreadPool dispatchPool) {
        this.container = container;
        this.listeners = listeners;
        this.removeNonresponsiveListeners = removeNonresponsiveListeners;
        this.dispatchPool = dispatchPool;
        NotificationDispatcher notificationDispatcher = this;
        synchronized (notificationDispatcher) {
            this._ndIDString = "(ndID=" + _nextNotifDispatcherID++ + ")";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NotificationDispatcher: " + this._ndIDString);
        }
    }

    public boolean isNotificationEnabled(Notification n) {
        return true;
    }

    public void handleNotification(Notification notif) {
        if (this.listeners.length > 0) {
            new DispatchANotificationToAllListeners(notif).dispatch();
        }
    }

    void sendWarningInSeparateThread(String key, Object[] args) {
        this.sendTrInSeparateThread(false, key, args);
    }

    void sendErrorInSeparateThread(String key, Object[] args) {
        this.sendTrInSeparateThread(true, key, args);
    }

    private void sendTrInSeparateThread(final boolean sendError, final String key, final Object[] args) {
        try {
            this.dispatchPool.execute(new Runnable(){

                public void run() {
                    if (sendError) {
                        Tr.error(tc, key, args);
                    } else {
                        Tr.warning(tc, key, args);
                    }
                }
            });
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
    }

    class DispatchANotificationToAListener
    implements Runnable {
        private int listenerId;
        private Notification notif;
        private DispatchANotificationToAllListeners dispatcher;
        private Subject subject;
        private String profileKey;

        public DispatchANotificationToAListener(int listenerId, Notification notif, DispatchANotificationToAllListeners dispatcher, String profileKey) {
            this.listenerId = listenerId;
            this.notif = notif;
            this.dispatcher = dispatcher;
            this.profileKey = profileKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean tmpProfileKey = false;
            try {
                if (this.profileKey != null) {
                    tmpProfileKey = AdminContext.push(this.profileKey);
                }
                this.setServerCredentials();
                WsNotifListener listener = NotificationDispatcher.this.listeners[this.listenerId];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Dispatching to listener #" + this.listenerId + " notification " + this.notif + " AdminContext:" + tmpProfileKey, listener);
                }
                try {
                    listener.handleNotification(this.notif);
                }
                catch (ReceiverPermanentlyUnavailableException exc) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, NotificationDispatcher.this._ndIDString + ": Removing listener #" + this.listenerId + " because of ReceiverPermanentlyUnavailableException.", exc);
                    }
                    FFDCFilter.processException((Throwable)exc, "com.ibm.ws.management.event.NotificationDispatcher.run", "219", this);
                    NotificationDispatcher.this.container.removeListener(listener);
                }
                catch (Throwable exc) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, NotificationDispatcher.this._ndIDString + ": Error occurred notifying listener #" + this.listenerId + ".", exc);
                    }
                    NotificationDispatcher.this.sendWarningInSeparateThread("ADME0006W", new Object[]{this.notif, listener, exc});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Returned from listener #" + this.listenerId);
                }
                this.unsetServerCredentials();
                this.dispatcher.markComplete(this.listenerId);
            }
            finally {
                if (tmpProfileKey) {
                    AdminContext.pop();
                }
            }
        }

        private void setServerCredentials() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DispatchANotificationToAListener.this.subject = SecurityHelper.getServerSubject();
                    if (DispatchANotificationToAListener.this.subject != null) {
                        SecurityHelper.pushInvocationSubject(DispatchANotificationToAListener.this.subject);
                    }
                    return null;
                }
            });
        }

        private void unsetServerCredentials() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (DispatchANotificationToAListener.this.subject != null) {
                        SecurityHelper.popInvocationSubject(DispatchANotificationToAListener.this.subject);
                    }
                    return null;
                }
            });
        }
    }

    class DispatchANotificationToAllListeners {
        private final Notification notif;
        private boolean[] completeRegistry;
        private int numListenersDispatched;
        private int numListenersReturned;
        private final long timeout;

        public DispatchANotificationToAllListeners(Notification notif) {
            this.notif = notif;
            this.completeRegistry = new boolean[NotificationDispatcher.this.listeners.length];
            this.timeout = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Long.getLong("com.ibm.ws.management.event.LocalNotificationService.handleNotificationTimeout", 300000L);
                }
            });
        }

        public void dispatch() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Emitting to " + NotificationDispatcher.this.listeners.length + " listeners: " + this.notif + " AdminContext:" + AdminContext.peek());
                for (int i = 0; i < NotificationDispatcher.this.listeners.length; ++i) {
                    Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": " + i + ": " + NotificationDispatcher.this.listeners[i]);
                }
            }
            this.numListenersDispatched = 0;
            this.numListenersReturned = 0;
            if (this.executeDispatchers() && !this.isAsyncNotif()) {
                this.waitForDispatchers();
                if (!this.isNotificationComplete() && NotificationDispatcher.this.removeNonresponsiveListeners) {
                    this.removeUncompletedListeners();
                }
            }
        }

        private boolean executeDispatchers() {
            for (int i = 0; i < NotificationDispatcher.this.listeners.length; ++i) {
                if (NotificationDispatcher.this.listeners[i].isNotificationEnabled(this.notif)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Listener #" + i + " is enabled");
                    }
                    try {
                        NotificationDispatcher.this.dispatchPool.execute(new DispatchANotificationToAListener(i, this.notif, this, AdminContext.peek()));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++this.numListenersDispatched;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Listener #" + i + " not enabled");
                }
                this.completeRegistry[i] = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Dispatched to " + this.numListenersDispatched + " listeners");
            }
            return this.numListenersDispatched > 0;
        }

        private boolean isAsyncNotif() {
            String type = this.notif.getType();
            for (int i = 0; i < ASYNC_NOTIFS.length; ++i) {
                if (!type.startsWith(ASYNC_NOTIFS[i])) continue;
                return true;
            }
            return false;
        }

        private synchronized void waitForDispatchers() {
            if (this.isNotificationComplete()) {
                return;
            }
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Finished emitting notification");
            }
        }

        private boolean isNotificationComplete() {
            return this.numListenersReturned >= this.numListenersDispatched;
        }

        private void removeUncompletedListeners() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Some listeners not complete -- removing");
            }
            ArrayList<String> removedList = new ArrayList<String>();
            for (int i = 0; i < this.completeRegistry.length; ++i) {
                NotificationListener notifListener;
                if (this.completeRegistry[i]) continue;
                WsNotifListener listnr = NotificationDispatcher.this.listeners[i];
                if (listnr instanceof ListenerInfo && (notifListener = ((ListenerInfo)listnr).getNotificationListener()) instanceof WsStickyListener && ((WsStickyListener)((Object)notifListener)).checkNotification(this.notif)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Listener #" + i + " is sticky listener, not removed");
                    continue;
                }
                NotificationDispatcher.this.container.removeListener(listnr);
                removedList.add(listnr.toString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": " + removedList.size() + " listeners removed");
            }
            if (!removedList.isEmpty()) {
                this.sendListenersRemovedError(removedList);
            }
        }

        private void sendListenersRemovedError(List removedList) {
            String timeoutStr = Long.toString(this.timeout);
            String notifType = this.notif.getType();
            Iterator i = removedList.iterator();
            while (i.hasNext()) {
                NotificationDispatcher.this.sendErrorInSeparateThread("ADME0005E", new Object[]{timeoutStr, i.next()});
            }
        }

        synchronized void markComplete(int listenerId) {
            this.completeRegistry[listenerId] = true;
            ++this.numListenersReturned;
            if (this.isNotificationComplete()) {
                this.notify();
            }
        }
    }
}

