/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deployment.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.deployment.registry.ExtensionProvider;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public class DeploymentExtensionHelper {
    private static TraceComponent tc = Tr.register(DeploymentExtensionHelper.class, "Admin", "com.ibm.ws.management.resources.DeploymentMessages");
    private static final String CLASS_NAME;
    public static final String EXT_POINT = "common-deployment-framework-exensionprovider";
    private static Vector _extProviders;

    public static void getProviders(Vector providersV, Vector handlersH) {
        DeploymentExtensionHelper.getProviders(providersV);
    }

    public static void getProviders(Vector providersV) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProviders");
        }
        if (_extProviders == null) {
            DeploymentExtensionHelper._getProviders(EXT_POINT);
        }
        providersV.addAll(_extProviders);
        try {
            Collections.sort(providersV);
        }
        catch (RuntimeException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid provider type found.  Not a type of ExtensionProvider.");
            }
            RasUtils.logException(e, tc, CLASS_NAME, "getProviders", "74");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProviders");
        }
    }

    private static void _getProviders(String extpoint) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getProviders: processing extpoint - " + extpoint);
        }
        _extProviders = new Vector();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting extension registry ...");
        }
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got extension registry ...");
        }
        if (registry == null) {
            Tr.error(tc, "Unable to get eclipse extension registry");
            return;
        }
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + extpoint;
        IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
        if (extensionPoint == null) {
            Tr.error(tc, "Unable to get eclipse extension point " + extpoint);
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] providerElements;
            IExtension extension2 = extensions[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension - " + extension2.getUniqueIdentifier());
            }
            if ((providerElements = extension2.getConfigurationElements()).length != 1) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid number of taskProviders elements - " + providerElements.length);
                continue;
            }
            IConfigurationElement providerElement = providerElements[0];
            if (!providerElement.getName().equals("action")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Expecting taskProviders action element but got " + providerElement.getName() + " instead");
                continue;
            }
            try {
                Object o = providerElement.createExecutableExtension("class");
                if (o instanceof ExtensionProvider) {
                    _extProviders.addElement(o);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "action class is not an instance of ExtensionProvider for : " + extension2.getUniqueIdentifier());
                continue;
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting CDF extension provider in " + extension2.getUniqueIdentifier() + th);
                }
                RasUtils.logException(th, tc, CLASS_NAME, "_getProviders", "156");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getProviders", new Object[]{_extProviders});
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/deployment/util/DeploymentExtensionHelper.java, WAS.admin.appmgmt, WAS70.SERV1, cf050925.09, ver. 1.13");
        }
        CLASS_NAME = DeploymentExtensionHelper.class.getName();
        _extProviders = null;
    }
}

