/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.jsr160rmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PullRemoteReceiver;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.AdminCertificateHelper;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class JSR160RMIConnectorClient
implements AdminServiceProxy {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(JSR160RMIConnectorClient.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private static String JNDI_PATH = "/jndi/JMXConnector";
    private Properties proxyProps = null;
    private String host = null;
    private String port = null;
    private X509Certificate targetCertificate = null;
    private Subject savedSubject = null;
    private boolean secEnabled = false;
    private boolean isInternal = false;
    private boolean autoAcceptSigner = false;
    private String jndiPath = null;
    private String type = "JSR160RMI";
    private MBeanServerConnection mbsc = null;
    private boolean online = false;
    private ObjectName AdminServiceON = null;

    public JSR160RMIConnectorClient(Properties props) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JSR160RMIConnectorClient<init>");
        }
        this.proxyProps = (Properties)props.clone();
        this.host = this.proxyProps.getProperty("host");
        this.port = this.proxyProps.getProperty("port");
        this.type = this.proxyProps.getProperty("type", "JSR160RMI");
        if (this.host.indexOf(58) > -1 && this.host.indexOf(91) < 0) {
            this.host = "[" + this.host + "]";
        }
        String user = this.proxyProps.getProperty("username");
        String password = this.proxyProps.getProperty("password");
        this.isInternal = new Boolean(this.proxyProps.getProperty("isInternal", "false"));
        this.autoAcceptSigner = new Boolean(this.proxyProps.getProperty("autoAcceptSignerForThisConnectionOnly", "false"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "autoAcceptSigner " + this.autoAcceptSigner);
        }
        this.jndiPath = this.proxyProps.getProperty("JNDI", JNDI_PATH);
        if (user != null && user.length() > 0 && password != null && password.length() > 0) {
            this.reconnect(this.proxyProps);
        } else {
            this.reconnect();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JSR160RMIConnectorClient", this);
        }
    }

    public void reconnect() throws ConnectorNotAvailableException {
        this.reconnect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(Properties props) throws ConnectorNotAvailableException {
        Hashtable<String, Object> h;
        JMXServiceURL url;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "reconnect:" + DebugUtils.createPropertiesMaskPlainTextPassword(props));
            }
            String jndiBindPath = this.jndiPath + this.port;
            url = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Lookup for JSR160RMI stub, using jndiName " + jndiBindPath);
                }
                url = new JMXServiceURL("service:jmx:iiop://" + this.host + ":" + this.port + jndiBindPath);
            }
            catch (MalformedURLException mue) {
                FFDCFilter.processException((Throwable)mue, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.reconnect", "149", this);
                throw new ConnectorNotAvailableException(mue);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JMXServiceURL", url);
            }
            h = new Hashtable<String, Object>();
            if (props != null) {
                String user = props.getProperty("username");
                String password = props.getProperty("password");
                String[] credentials = new String[]{user, password};
                h.put("jmx.remote.credentials", credentials);
            }
            try {
                if (!AdminCertificateHelper.getInstance().isRSAPropagationEnabled() || RSATokenThreadManager.getInstance().isCertificateRetrievalInProcess().booleanValue()) break block27;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "clearing the certificate cache");
                    }
                    String host = this.proxyProps.getProperty("host");
                    String port = this.proxyProps.getProperty("port");
                    if (host != null && port != null) {
                        AdminCertificateHelper.getInstance().clearCertificateFromCache(host, port);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Retrieving the admin target certificate.");
                    }
                    RSATokenThreadManager.getInstance().setCertificateRetrievalInProcess();
                    this.targetCertificate = AdminCertificateHelper.getInstance().retrieveTargetCertificate(this.proxyProps);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Retrieved the following target certificate.", new Object[]{this.targetCertificate});
                    }
                }
                finally {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Finished retrieving the admin target certificate.");
                    }
                    RSATokenThreadManager.getInstance().unsetCertificateRetrievalInProcess();
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception setting up RSA token information.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.<init>", "258", this);
                RSATokenThreadManager.getInstance().setTargetCertificate(null);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jmx.remote.protocol.provider.pkgs", "com.ibm.websphere.management.remote");
        }
        h.put("jmx.remote.protocol.provider.pkgs", "com.ibm.websphere.management.remote");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jmx.remote.protocol.provider.class.loader", ExtClassLoader.getInstance());
        }
        h.put("jmx.remote.protocol.provider.class.loader", ExtClassLoader.getInstance());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Environment", h);
        }
        JMXConnector jmxc = null;
        try {
            jmxc = JMXConnectorFactory.connect(url, h);
        }
        catch (IOException ioe) {
            this.online = false;
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.reconnect", "179", this);
            throw new ConnectorNotAvailableException(ioe);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JMXConnector", jmxc);
        }
        if (!this.isInternal) {
            this.savedSubject = SecurityHelper.getInvocationSubject();
        }
        try {
            this.mbsc = jmxc.getMBeanServerConnection();
            this.online = true;
        }
        catch (IOException ioe) {
            this.online = false;
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.reconnect", "190", this);
            throw new ConnectorNotAvailableException(ioe);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect", this.mbsc);
        }
    }

    private void handleException(Exception exception) throws ConnectorException {
        this.online = false;
        throw new ConnectorException("Exception received", exception);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{name, listener, filter});
        }
        throw new ConnectorException("addNotificationListener(ObjectName, NotificationListener, NotificationFilter, Object) not supported");
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{name, listener, filter});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        try {
            this.mbsc.addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                this.mbsc.addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.addNotificationListener", "243", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void addNotificationListenerExtended(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListenerExtended", new Object[]{name, listener, filter});
        }
        throw new ConnectorException("addNotificationListenerExtended(ObjectName, NotificationListener, NotificationFilter, Object) not supported");
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{name, attribute});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        Object retval = null;
        try {
            retval = this.mbsc.getAttribute(name, attribute);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.getAttribute(name, attribute);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getAttribute", "303", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", retval);
        }
        return retval;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{name, attributes});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        AttributeList retval = null;
        try {
            retval = this.mbsc.getAttributes(name, attributes);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.getAttributes(name, attributes);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getAttributes", "326", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", retval);
        }
        return retval;
    }

    public ClassLoader getClassLoader(ObjectName name) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader", new Object[]{name});
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName adminService = this.getAdminServiceObjectName();
        ClassLoader loader = null;
        try {
            loader = (ClassLoader)this.mbsc.invoke(adminService, "getClassLoader", new Object[]{name}, new String[]{"javax.management.ObjectName"});
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                loader = (ClassLoader)this.mbsc.invoke(adminService, "getClassLoader", new Object[]{name}, new String[]{"javax.management.ObjectName"});
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getClassLoader", "350", this);
                this.handleException(ioe);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getClassLoader", "353", this);
                throw new ConnectorException(ex);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getClassLoader", "357", this);
            throw new ConnectorException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader", loader);
        }
        return loader;
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoaderFor", new Object[]{name});
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName adminService = this.getAdminServiceObjectName();
        ClassLoader retval = null;
        try {
            retval = (ClassLoader)this.mbsc.invoke(adminService, "getClassLoaderFor", new Object[]{name}, new String[]{"javax.management.ObjectName"});
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = (ClassLoader)this.mbsc.invoke(adminService, "getClassLoaderFor", new Object[]{name}, new String[]{"javax.management.ObjectName"});
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getClassLoaderFor", "381", this);
                this.handleException(ioe);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getClassLoaderFor", "384", this);
                throw new ConnectorException(ex);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.addNotificationListener", "379", this);
            throw new ConnectorException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoaderFor", retval);
        }
        return retval;
    }

    public Properties getConnectorProperties() {
        return this.proxyProps;
    }

    public String getDefaultDomain() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDomain");
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        String retval = null;
        try {
            retval = this.mbsc.getDefaultDomain();
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.getDefaultDomain();
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getDefautlDomain", "416", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDomain", retval);
        }
        return retval;
    }

    public String getDomainName() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainName");
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        String retval = null;
        try {
            retval = this.mbsc.getDefaultDomain();
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.getDefaultDomain();
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getDomainName", "440", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainName", retval);
        }
        return retval;
    }

    public Integer getMBeanCount() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanCount");
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        Integer retval = null;
        try {
            retval = this.mbsc.getMBeanCount();
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.getMBeanCount();
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getMBeanCount", "463", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanCount", retval);
        }
        return retval;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanInfo", name);
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        MBeanInfo retval = null;
        try {
            retval = this.mbsc.getMBeanInfo(name);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.getMBeanInfo(name);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getMBeanInfo", "486", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanInfo", retval);
        }
        return retval;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", objectName);
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        ObjectInstance retval = null;
        try {
            retval = this.mbsc.getObjectInstance(objectName);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.getObjectInstance(objectName);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getObjectInstance", "509", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance", retval);
        }
        return retval;
    }

    public ObjectName getServerMBean() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerMBean");
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName adminService = this.getAdminServiceObjectName();
        ObjectName retval = null;
        try {
            retval = (ObjectName)this.mbsc.invoke(adminService, "getServerMBean", new Object[0], new String[0]);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = (ObjectName)this.mbsc.invoke(adminService, "getServerMBean", new Object[0], new String[0]);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getServerMBean", "532", this);
                this.handleException(ioe);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getServerMBean", "535", this);
                throw new ConnectorException(ex);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.getServerMBean", "539", this);
            throw new ConnectorException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerMBean", retval);
        }
        return retval;
    }

    public String getType() {
        return this.type;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{name, operationName, params, signature});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        Object retval = null;
        try {
            retval = this.mbsc.invoke(name, operationName, params, signature);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.invoke(name, operationName, params, signature);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.invoke", "568", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", retval);
        }
        return retval;
    }

    public Session isAlive() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlive");
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName adminService = this.getAdminServiceObjectName();
        Session retval = null;
        try {
            retval = (Session)this.mbsc.invoke(adminService, "isAlive", new Object[0], new String[0]);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = (Session)this.mbsc.invoke(adminService, "isAlive", new Object[0], new String[0]);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.isAlive", "592", this);
                this.handleException(ioe);
            }
            catch (Exception ex) {
                throw new ConnectorException(ex);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.isAlive", "598", this);
            throw new ConnectorException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlive", retval);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session isAlive(int timeout) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlive", new Integer(timeout));
        }
        if (!this.online) {
            this.reconnect();
        }
        Session retval = null;
        ContactThread contact = new ContactThread(this, Thread.currentThread());
        contact.start();
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException ie) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Expected Exception Recieved", ie);
            }
        }
        finally {
            contact.setResponder(null);
            Thread.interrupted();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Returned from nap");
        }
        if (contact.hasReturned()) {
            Throwable th = contact.getException();
            if (th != null) {
                throw new ConnectorException(th);
            }
        } else {
            throw new ConnectorException("Timeout Triggered, isAlive did not return in time");
        }
        retval = contact.getSession();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlive", retval);
        }
        return retval;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInstanceOf", new Object[]{name, className});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        boolean retval = false;
        try {
            retval = this.mbsc.isInstanceOf(name, className);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.isInstanceOf(name, className);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.isInstanceOf", "621", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInstanceOf", new Boolean(retval));
        }
        return retval;
    }

    public boolean isRegistered(ObjectName name) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistered", new Object[]{name});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        boolean retval = false;
        try {
            retval = this.mbsc.isRegistered(name);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.isRegistered(name);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.isRegistered", "642", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistered", new Boolean(retval));
        }
        return retval;
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryMBeans", new Object[]{name});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        Set retval = null;
        try {
            retval = this.mbsc.queryMBeans(name, query);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.queryMBeans(name, query);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.queryMBeans", "665", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBeans", retval);
        }
        return retval;
    }

    public Set queryNames(ObjectName name, QueryExp query) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames", new Object[]{name});
        }
        Set retval = null;
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        try {
            retval = this.mbsc.queryNames(name, query);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.queryNames(name, query);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.queryNames", "688", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryNames", retval);
        }
        return retval;
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{name, listener});
        }
        throw new ConnectorException("removeNotificationListener(ObjectName, NotificationListener) not supported");
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{name, listener});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        try {
            this.mbsc.removeNotificationListener(name, listener);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                this.mbsc.removeNotificationListener(name, listener);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.removeNotificationListener", "731", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{name, listener, filter, handback});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        try {
            this.mbsc.removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                this.mbsc.removeNotificationListener(name, listener, filter, handback);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.removeNotificationListener", "753", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListenerExtended(NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListenerExtended", new Object[]{listener});
        }
        throw new ConnectorException("removeNotificationListenerExtended(NotificationListener) not supported");
    }

    public void removeNotificationListenerExtended(ObjectName name, NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListenerExtended", new Object[]{name, listener});
        }
        throw new ConnectorException("removeNotificationListenerExtended(ObjectName, NotificationListener) not supported");
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttribute", new Object[]{name, attribute});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        try {
            this.mbsc.setAttribute(name, attribute);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                this.mbsc.setAttribute(name, attribute);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.setAttribute", "837", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttribute");
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{name, attributes});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        AttributeList retval = null;
        try {
            retval = this.mbsc.setAttributes(name, attributes);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = this.mbsc.setAttributes(name, attributes);
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.setAttributes", "860", this);
                this.handleException(ioe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes", retval);
        }
        return retval;
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy proxy) {
        return new PullRemoteReceiver(proxy);
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{filter, listener});
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName adminService = this.getAdminServiceObjectName();
        ListenerIdentifier retval = null;
        try {
            retval = (ListenerIdentifier)this.mbsc.invoke(adminService, "addNotificationListener", new Object[]{filter, listener}, new String[]{"com.ibm.ws.management.event.ConsolidatedFilter", "com.ibm.ws.management.event.PushNotificationListener"});
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = (ListenerIdentifier)this.mbsc.invoke(adminService, "addNotificationListener", new Object[]{filter, listener}, new String[]{"com.ibm.ws.management.event.ConsolidatedFilter", "com.ibm.ws.management.event.PushNotificationListener"});
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.addNotificationListener", "857", this);
                this.handleException(ioe);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.addNotificationListener", "897", this);
                throw new ConnectorException(ex);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.addNotificationListener", "901", this);
            throw new ConnectorException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener", retval);
        }
        return retval;
    }

    public Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pullNotifications", new Object[]{id, batchSize});
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        ObjectName adminService = this.getAdminServiceObjectName();
        Notification[] retval = null;
        try {
            retval = (Notification[])this.mbsc.invoke(adminService, "pullNotifications", new Object[]{id, batchSize}, new String[]{"com.ibm.ws.management.event.ListenerIdentifier", "java.lang.Integer"});
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                retval = (Notification[])this.mbsc.invoke(adminService, "pullNotifications", new Object[]{id, batchSize}, new String[]{"com.ibm.ws.management.event.ListenerIdentifier", "java.lang.Integer"});
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.pullNotifications", "924", this);
                this.handleException(ioe);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.pullNotifications", "927", this);
                throw new ConnectorException(ex);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.pullNotifications", "931", this);
            throw new ConnectorException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullNotifications", retval);
        }
        return retval;
    }

    public void removeNotificationListener(ListenerIdentifier listenerId) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{listenerId});
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName adminService = this.getAdminServiceObjectName();
        try {
            this.mbsc.invoke(adminService, "removeNotificationListener", new Object[]{listenerId}, new String[]{"com.ibm.ws.management.event.ListenerIdentifier"});
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                this.mbsc.invoke(adminService, "removeNotificationListener", new Object[]{listenerId}, new String[]{"com.ibm.ws.management.event.ListenerIdentifier"});
            }
            catch (IOException ioe2) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.removeNotificationListener", "954", this);
                this.handleException(ioe);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.removeNotificationListener", "957", this);
                throw new ConnectorException(ex);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.removeNotificationListener", "961", this);
            throw new ConnectorException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filters) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetFilter", new Object[]{listenerId, filters});
        }
        ObjectName adminService = this.getAdminServiceObjectName();
        try {
            this.mbsc.invoke(adminService, "resetFilter", new Object[]{listenerId, filters}, new String[]{"com.ibm.ws.management.event.ListenerIdentifier", "com.ibm.ws.management.event.ConsolidatedFilter"});
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.resetFilter", "978", this);
            throw new ConnectorException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetFilter");
        }
    }

    private ObjectName getAdminServiceObjectName() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminServiceObjectName");
        }
        ObjectName ason = null;
        try {
            ason = new ObjectName("WebSphere:type=AdminService,*");
        }
        catch (MalformedObjectNameException mue) {
            throw new ConnectorException(mue);
        }
        if (!this.online) {
            this.reconnect();
        }
        this.setupPerInvocationSecurityCredentials();
        Set sets = null;
        try {
            sets = this.mbsc.queryNames(ason, null);
        }
        catch (IOException ioe) {
            this.reconnect();
            try {
                sets = this.mbsc.queryNames(ason, null);
            }
            catch (IOException ioe2) {
                this.handleException(ioe);
            }
        }
        ObjectName adminService = (ObjectName)sets.iterator().next();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminServiceObjectName", adminService);
        }
        return adminService;
    }

    private void setupSecurityCredentials(Properties props) {
        this.setupInternalSecurityCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupInternalSecurityCredentials() {
        block12: {
            boolean secEnabled = new Boolean(this.proxyProps.getProperty("securityEnabled", "false"));
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupInternalSecurityCredentials " + secEnabled);
            }
            if (!secEnabled) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupInternalSecurityCredentials exit without setting credential");
                }
                return;
            }
            if (this.targetCertificate == null) {
                this.targetCertificate = SecurityHelper.retrieveRSACertificate(this.proxyProps);
            }
            RSATokenThreadManager.getInstance().setTargetCertificate(this.targetCertificate);
            if (this.autoAcceptSigner) {
                Tr.debug(tc, "autoAcceptSignerForThisConnectionOnly");
                RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
            }
            Subject subject1 = null;
            try {
                subject1 = SecurityHelper.getInvocationSubject();
                Tr.debug(tc, "got Invocation Subject:" + subject1);
                if (subject1 == null) {
                    subject1 = SecurityHelper.getReceivedSubject();
                    Tr.debug(tc, "got Received Subject:" + subject1);
                }
                if (subject1 != null) {
                    Tr.debug(tc, "Setting invocaion Subject" + subject1);
                    SecurityHelper.setInvocationSubject(subject1);
                    SubjectHelper.setClientDefaultSubject(subject1);
                    break block12;
                }
                Tr.service(tc, "ADMC0032W");
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.rmi.JSR160RMIConnectorClient.setupInternalSecurityCredentials", "1323", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception occurred setting invocation credential", ex);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupPerInvocationSecurityCredentials() throws ConnectorAuthenticationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupPerInvocationSecurityCredentials");
        }
        if (!this.isInternal) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "savedSubject is: " + this.savedSubject);
                }
                if (this.savedSubject == null) return;
                SecurityHelper.setInvocationSubject(this.savedSubject);
                SubjectHelper.setClientDefaultSubject(this.savedSubject);
                return;
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to login", ex);
                }
                if (!tc.isEntryEnabled()) throw new ConnectorAuthenticationException(nls.getString("ADMC0039E", "RMI Connector login failed"), ex);
                Tr.exit(tc, "<init> - exception");
                throw new ConnectorAuthenticationException(nls.getString("ADMC0039E", "RMI Connector login failed"), ex);
            }
        } else {
            this.setupInternalSecurityCredentials();
        }
    }

    private static void showDebugInfo(Properties props) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JSR160RMIConnector Client properties: ");
            for (String string : props.keySet()) {
                if (string.equals("password")) {
                    Tr.debug(tc, "> " + string + "=*****");
                    continue;
                }
                Tr.debug(tc, "> " + string + "=" + props.getProperty(string));
            }
        }
    }

    class ContactThread
    extends Thread {
        boolean returned = false;
        Thread respond = null;
        JSR160RMIConnectorClient parent = null;
        Session session = null;
        Throwable except = null;

        ContactThread(JSR160RMIConnectorClient connector2, Thread res) {
            this.respond = res;
            this.parent = connector2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ContactThread.run()");
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " checking whether the process is alive ");
                }
                this.session = this.parent.isAlive();
                this.returned = true;
            }
            catch (ConnectorException ce) {
                FFDCFilter.processException((Throwable)ce, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.ContactThread", "731", this);
                this.returned = true;
                this.except = ce;
            }
            catch (OutOfMemoryError oom) {
                FFDCFilter.processException((Throwable)oom, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.ContactThread", "736", this);
                this.returned = true;
                this.except = oom;
            }
            catch (Throwable th) {
                FFDCFilter.processException(th, "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient.ContactThread", "741", this);
                this.returned = true;
                this.except = null;
            }
            ContactThread contactThread = this;
            synchronized (contactThread) {
                if (this.respond != null) {
                    this.respond.interrupt();
                }
            }
        }

        synchronized void setResponder(Thread th) {
            this.respond = th;
        }

        synchronized Thread getResponder() {
            return this.respond;
        }

        boolean hasReturned() {
            return this.returned;
        }

        Session getSession() {
            return this.session;
        }

        Throwable getException() {
            return this.except;
        }
    }
}

