/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.ipc.ConnectionPool;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class RawConnectionPool
implements ConnectionPool {
    private int timeoutInSec = 300;
    private LinkedList<TimeStampedRawConnection> pool = new LinkedList();
    private static TraceComponent tc = Tr.register(RawConnectionPool.class, "Admin", "com.ibm.ws.management.resources.connector");
    private String targetHost;
    private String targetPort;

    public RawConnectionPool(String host, String port, int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RawConnectionPool", new Object[]{host, port, timeout});
        }
        this.targetHost = host;
        this.targetPort = port;
        this.timeoutInSec = timeout;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RawConnectionPool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection() throws Exception {
        Socket so = null;
        LinkedList<TimeStampedRawConnection> linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting a connection from the pool...");
                }
                so = this.pool.removeFirst().socket;
                return so;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pool is empty; creating a new socket");
        }
        so = new Socket(this.targetHost, Integer.parseInt(this.targetPort));
        so.setSoTimeout(this.timeoutInSec * 1000);
        return so;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnection(Object so) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Putting a connection back to the pool");
        }
        TimeStampedRawConnection tsc = new TimeStampedRawConnection();
        tsc.socket = (Socket)so;
        tsc.timeStamp = System.currentTimeMillis();
        LinkedList<TimeStampedRawConnection> linkedList = this.pool;
        synchronized (linkedList) {
            this.pool.addLast(tsc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        LinkedList<TimeStampedRawConnection> linkedList = this.pool;
        synchronized (linkedList) {
            int sz = this.pool.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Recycling the connections; there are " + sz + " of them in the pool");
            }
            for (int i = 0; i < sz; ++i) {
                try {
                    TimeStampedRawConnection tsc = this.pool.removeFirst();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to close socket " + tsc.socket);
                        }
                        tsc.socket.close();
                    }
                    catch (IOException ioe) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "...and got " + ioe);
                    }
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeExpired(long timeSpan) {
        LinkedList<TimeStampedRawConnection> linkedList = this.pool;
        synchronized (linkedList) {
            int sz = this.pool.size();
            for (int i = 0; i < sz; ++i) {
                try {
                    TimeStampedRawConnection tsc = this.pool.getFirst();
                    long s = System.currentTimeMillis() - tsc.timeStamp;
                    if (s < timeSpan * 1000L) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Purging one connection, which is " + s / 1000L + " secs old");
                    }
                    tsc = this.pool.removeFirst();
                    try {
                        tsc.socket.close();
                    }
                    catch (IOException ioe) {}
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
        }
    }

    class TimeStampedRawConnection {
        long timeStamp;
        Socket socket;

        TimeStampedRawConnection() {
        }
    }
}

