/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.management.connector.ipc.Arrayster;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;

public class IPCProtocol {
    public static final int IPCC_MAGIC = 1229996867;
    public static final short IPCC_VERSION = 256;
    public static final short IPCC_FLAGS = 0;
    public static final int HEADER_PREFIX_LENTGH = 8;
    public static final int HEADER_LENGTH = 12;

    public static WsByteBuffer allocateHeaderBuffer() {
        WsByteBuffer bb = WsByteBufferPoolManagerImpl.getRef().allocate(12);
        IPCProtocol.fillinHeader(bb);
        return bb;
    }

    public static byte[] createHeader(int dataLength) {
        byte[] hdr = new byte[12];
        WsByteBuffer bb = WsByteBufferPoolManagerImpl.getRef().wrap(hdr);
        IPCProtocol.fillinHeader(bb);
        IPCProtocol.setDataLength(bb, dataLength);
        return hdr;
    }

    private static void fillinHeader(WsByteBuffer bb) {
        bb.putInt(1229996867);
        bb.putShort((short)256);
        bb.putShort((short)0);
        bb.putInt(0);
        bb.rewind();
    }

    public static void setDataLength(WsByteBuffer bb, int dataLength) {
        bb.putInt(8, dataLength);
    }

    public static IPCCHeader readMessageHeader(WsByteBuffer bb) throws IOException {
        IPCCHeader header = new IPCCHeader();
        if (bb.remaining() >= 12) {
            header.magic = bb.getInt();
            if (header.magic != 1229996867) {
                throw new IOException("Header not as expected: " + Integer.toHexString(header.magic));
            }
            header.major_ver = bb.get();
            header.minor_ver = bb.get();
            header.flags = bb.getShort();
            header.dataLength = bb.getInt();
            header.headerComplete = true;
        } else {
            header.rawheader = new byte[12];
            header.readOffset = bb.remaining();
            bb.get(header.rawheader, 0, header.readOffset);
        }
        return header;
    }

    public static void readMessageHeader(IPCCHeader header, WsByteBuffer bb) {
        int headerRemaining;
        if (header.rawheader == null) {
            header.rawheader = new byte[12];
            header.readOffset = 0;
        }
        if ((headerRemaining = 12 - header.readOffset) > 0) {
            if (bb.remaining() >= headerRemaining) {
                bb.get(header.rawheader, header.readOffset, headerRemaining);
                header.readOffset += headerRemaining;
            } else {
                int length = bb.remaining();
                bb.get(header.rawheader, header.readOffset, length);
                header.readOffset += length;
            }
        }
        if (header.readOffset >= 12) {
            header.magic = Arrayster.byteArrayToInt(header.rawheader, 0);
            header.major_ver = header.rawheader[4];
            header.minor_ver = header.rawheader[5];
            header.flags = (short)(header.rawheader[6] << 8 | header.rawheader[7]);
            header.dataLength = Arrayster.byteArrayToInt(header.rawheader, 8);
            header.headerComplete = true;
        }
    }

    public static class BAD_MAGIC
    extends IOException {
        public BAD_MAGIC(String msg) {
            super(msg);
        }
    }

    public static class IPCCHeader {
        public int magic;
        public byte major_ver;
        public byte minor_ver;
        public short flags;
        public int dataLength;
        public int readOffset = 0;
        public byte[] rawheader = null;
        public boolean headerComplete = false;

        public String toString() {
            return "IPCCHeader-" + this.major_ver + "." + this.minor_ver + "(flags=" + Integer.toHexString(this.flags) + ",dataLen=" + this.dataLength + ",hash=@" + this.hashCode() + ")";
        }

        public String toDebug() {
            return "IPCCHeader(readOff=" + this.readOffset + ")";
        }
    }
}

