/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.ipc.ClientAccessor;
import com.ibm.ws.management.connector.ipc.ConnectionPool;
import com.ibm.ws.management.connector.ipc.LocalCommUtil;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.utility.JAVAtoCPPUtilities;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContextFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;

public class ChannelConnectionPool
implements ConnectionPool {
    private static TraceComponent tc = Tr.register(ChannelConnectionPool.class, "Admin", "com.ibm.ws.management.resources.connector");
    private int timeoutInSec = 300;
    private LinkedList<TimeStampedChannelConnection> pool = new LinkedList();
    private String targetHost;
    private String targetPort;
    private String zosShortName;
    private String zosGenericName;
    private String zosDaemonName;
    private VirtualConnectionFactory _vcf;
    private VirtualConnectionFactory _lc_vcf;
    private PlatformHelper helper = PlatformHelperFactory.getPlatformHelper();
    private static final int CONNECT_TIMEOUT = 30000;

    public ChannelConnectionPool(String host, String port, String shortName, String genericName, String daemonName, int timeout, VirtualConnectionFactory vcf, VirtualConnectionFactory lc_vcf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ChannelConnectionPool", new Object[]{host, port, shortName, genericName, daemonName, timeout});
        }
        this.targetHost = host;
        this.targetPort = port;
        this.zosShortName = shortName;
        this.zosGenericName = genericName;
        this.zosDaemonName = daemonName;
        this.timeoutInSec = timeout;
        this._vcf = vcf;
        this._lc_vcf = lc_vcf;
        if (this._lc_vcf != null && this.zosShortName == null && !SecurityContext.isServerProcess()) {
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(this.targetHost);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (addr != null && addr.isLoopbackAddress()) {
                Properties p = LocalCommUtil.getMagicNames(null, this.targetPort);
                if (p != null) {
                    this.zosShortName = p.getProperty("zos.targetServer.serverShortName");
                    this.zosGenericName = p.getProperty("zos.targetServer.genericServerName");
                    this.zosDaemonName = p.getProperty("zos.targetServer.daemonName");
                }
            } else {
                this._lc_vcf = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Host " + this.targetHost + " is not a loopback address, hence localcomm will not be available");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ChannelConnectionPool", new Object[]{this.zosShortName, this.zosGenericName, this.zosDaemonName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection() throws Exception {
        boolean localcomm_connected;
        TCPConnectRequestContext addr;
        ClientAccessor accessor;
        OutboundVirtualConnection ovc;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConnection");
            }
            ovc = null;
            accessor = null;
            LinkedList<TimeStampedChannelConnection> linkedList = this.pool;
            synchronized (linkedList) {
                if (this.pool.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting a connection from the pool...");
                    }
                    ovc = this.pool.removeFirst().outboundVC;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getConnection");
                    }
                    return ovc;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pool is empty; creating a new outboundVC");
            }
            addr = TCPConnectRequestContextFactory.getRef().createTCPConnectRequestContext(this.targetHost, Integer.parseInt(this.targetPort), 30000);
            localcomm_connected = false;
            ByteBuffer lsipData = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before calling into JNI, _lc_vcf=" + this._lc_vcf);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...and the names are: \"" + this.zosShortName + "\", \"" + this.zosGenericName + "\", \"" + this.zosDaemonName + "\"");
            }
            if (this._lc_vcf != null && this.zosShortName != null && (lsipData = JAVAtoCPPUtilities.getLSIPByServerShortName((String)this.zosShortName, (String)this.zosGenericName, (String)this.zosDaemonName)) == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "JNI called, but it returned null");
            }
            if (lsipData != null) {
                try {
                    ovc = (OutboundVirtualConnection)this._lc_vcf.createConnection();
                    ovc.getStateMap().put("ZWAS_LOCAL_COMM_DATA", lsipData);
                    ovc.connect((Object)addr);
                    localcomm_connected = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New outbound LC VC connected to " + this.zosShortName + ":" + this.zosGenericName + ":" + this.zosDaemonName);
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to connect LC VC, due to " + e + "; will fall back to TCP");
                    }
                    if (ovc == null) break block18;
                    ovc.close(null);
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Dead outbound LC VC closed");
                }
            }
        }
        if (!localcomm_connected) {
            ovc = this.makeOrdinaryTCPConnection(addr);
        }
        accessor = (ClientAccessor)ovc.getChannelAccessor();
        accessor.setReadTimeout(this.timeoutInSec);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnection");
        }
        return ovc;
    }

    private OutboundVirtualConnection makeOrdinaryTCPConnection(TCPConnectRequestContext addr) throws Exception {
        OutboundVirtualConnection ovc = (OutboundVirtualConnection)this._vcf.createConnection();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New outbound VC=" + ovc);
        }
        try {
            ovc.connect((Object)addr);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New outbound VC connected to " + this.targetHost + ":" + this.targetPort);
            }
        }
        catch (Exception ex) {
            if (ovc != null) {
                ovc.close(null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Dead outbound VC closed");
                }
            }
            throw ex;
        }
        return ovc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnection(Object ovc) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Connection put back to pool: " + ovc);
        }
        TimeStampedChannelConnection tsc = new TimeStampedChannelConnection();
        tsc.outboundVC = (OutboundVirtualConnection)ovc;
        tsc.timeStamp = System.currentTimeMillis();
        LinkedList<TimeStampedChannelConnection> linkedList = this.pool;
        synchronized (linkedList) {
            this.pool.addLast(tsc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        LinkedList<TimeStampedChannelConnection> linkedList = this.pool;
        synchronized (linkedList) {
            int sz = this.pool.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Recycling the connections; there are " + sz + " of them in the pool");
            }
            for (int i = 0; i < sz; ++i) {
                try {
                    TimeStampedChannelConnection tsc = this.pool.removeFirst();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to close outboundVC " + tsc.outboundVC);
                        }
                        tsc.outboundVC.close(null);
                    }
                    catch (Exception ioe) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "...and got " + ioe);
                    }
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeExpired(long timeSpan) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "purgeExpired");
        }
        LinkedList<TimeStampedChannelConnection> linkedList = this.pool;
        synchronized (linkedList) {
            int sz = this.pool.size();
            for (int i = 0; i < sz; ++i) {
                try {
                    TimeStampedChannelConnection tsc = this.pool.getFirst();
                    long s = System.currentTimeMillis() - tsc.timeStamp;
                    if (s < timeSpan * 1000L) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Purging one connection, which is " + s / 1000L + " secs old");
                    }
                    tsc = this.pool.removeFirst();
                    try {
                        tsc.outboundVC.close(null);
                    }
                    catch (Exception ioe) {}
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "purgeExpired");
        }
    }

    class TimeStampedChannelConnection {
        long timeStamp;
        OutboundVirtualConnection outboundVC;

        TimeStampedChannelConnection() {
        }
    }
}

