/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.interop.JMXTransformException;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.soap.GenericSerializer;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JMXObjectOutputStream
extends ObjectOutputStream {
    private static TraceComponent tc = Tr.register(JMXObjectOutputStream.class, "Admin", "com.ibm.ws.management.resources.connector");
    private String remoteJMXVersion = "";
    private static Object transformWriter = GenericSerializer.getJMXTransformWriter();

    public JMXObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.enableReplaceObject(true);
    }

    protected Object replaceObject(Object obj) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceObject, obj=" + obj);
        }
        if (!(obj instanceof Serializable)) {
            Tr.error(tc, "ADMC0001E", obj.getClass().getName());
        } else if (JMXVersionValidation.isRemoteVersionTmx4j(this.remoteJMXVersion)) {
            Object transformedObject = null;
            try {
                Class[] types2 = new Class[]{Object.class};
                Object[] params = new Object[]{obj};
                Class<?> cls = transformWriter.getClass();
                Method method2 = cls.getMethod("transform", types2);
                obj = transformedObject = method2.invoke(transformWriter, params);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "After transform, obj=" + obj);
                }
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            catch (InvocationTargetException e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceObject");
        }
        return obj;
    }

    public void jmxWriteObject(Object obj, String remoteJMXVersion) throws IOException, JMXTransformException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jmxWriteObject, obj=" + obj);
        }
        this.remoteJMXVersion = remoteJMXVersion;
        this.writeObject(obj);
    }
}

