/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppManagementCommandProvider
extends SimpleCommandProvider {
    private static ResourceBundle resBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
    private static TraceComponent tc = Tr.register(AppManagementCommandProvider.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String newline = System.getProperty("line.separator");
    private static int GOOD_RC = 0;
    private static int BAD_RC = -2;

    /*
     * Loose catch block
     */
    public Object listSqljProfiles(AdminCommand cmd) throws AdminException {
        ArrayList<String> myFileArray;
        block30: {
            String tempSessionDir;
            block29: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "listSqljProfiles");
                }
                myFileArray = new ArrayList<String>();
                tempSessionDir = null;
                Session session = cmd.getConfigSession();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Session id is " + session.getSessionId());
                    Tr.debug(tc, "Session user name is " + session.getUserName());
                }
                String appName = (String)cmd.getParameter("appName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "app name is: " + appName);
                }
                String earName = EditionHelper.getAppEarName(appName, (String)null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "earName: " + earName);
                }
                RepositoryContext appContext = this.getAppContextFromAppName(appName, session);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appContext: " + appContext);
                }
                if (appContext.getFile(earName) == null) {
                    throw new AdminException(AppManagementCommandProvider.getFormattedMessage("ADMA0501E", new Object[]{appName}));
                }
                appContext.extract(earName, false);
                String earPath = appContext.getPath() + File.separator + earName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear path is " + earPath);
                }
                Properties sysProps = System.getProperties();
                if (tc.isDebugEnabled()) {
                    StringWriter sw = new StringWriter();
                    sysProps.list(new PrintWriter(sw));
                    Tr.debug(tc, "Listing of System.getProperties... ", sw);
                }
                tempSessionDir = sysProps.getProperty("user.install.root") + File.separator + "temp" + File.separator + session.getUserName();
                String earExpansionDir = tempSessionDir + File.separator + earName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear expansion dir is " + earExpansionDir);
                }
                EARFile earFile = EarUtils.getEarFile((String)earPath, (boolean)false, (boolean)true);
                EarUtils.extractEar((EARFile)earFile, (String)earExpansionDir, (boolean)false, (int)126);
                earFile.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear file expanded to expansion dir");
                }
                this.recursivelyTraverse(new File(earExpansionDir), new File(earExpansionDir), ".ser", myFileArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expansion dir scanned for .ser files");
                }
                boolean foundBindprops = this.recursivelyTraverse(new File(earExpansionDir), new File(earExpansionDir), ".bindprops", myFileArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expansion dir scanned for .bindprops files");
                }
                if (foundBindprops) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "not searching for .pdqxml files since .bindprops was found");
                    }
                    break block29;
                }
                this.recursivelyTraverse(new File(earExpansionDir), new File(earExpansionDir), ".pdqxml", myFileArray);
                if (!tc.isDebugEnabled()) break block29;
                Tr.debug(tc, "expansion dir scanned for .pdqxml files");
                StringBuilder mfasb = new StringBuilder("List of SQLj profile names and/or pureQuery bind file names follows:");
                for (String profileName : myFileArray) {
                    mfasb.append(newline);
                    mfasb.append(profileName);
                }
                Tr.debug(tc, mfasb.toString());
            }
            Object var17_17 = null;
            if (tempSessionDir == null) break block30;
            try {
                EarUtils.deleteDirTree((String)tempSessionDir);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleted directory tree, " + tempSessionDir);
                }
                break block30;
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while deleting directory tree, " + tempSessionDir, e);
                }
                break block30;
            }
            {
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.management.commands.AppManagementCommandProvider.listSqljProfiles", "129");
                    Tr.error(tc, "ADMA0500E", new Object[]{"listSqljProfiles"});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "listSqljProfiles", th);
                    }
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, AppManagementCommandProvider.getFormattedMessage("ADMA0500E", new Object[]{"listSqljProfiles"}));
                }
            }
            catch (Throwable throwable) {
                block31: {
                    Object var17_18 = null;
                    if (tempSessionDir != null) {
                        try {
                            EarUtils.deleteDirTree(tempSessionDir);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Deleted directory tree, " + tempSessionDir);
                            }
                        }
                        catch (IOException e) {
                            if (!tc.isDebugEnabled()) break block31;
                            Tr.debug(tc, "Exception while deleting directory tree, " + tempSessionDir, e);
                        }
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSqljProfiles", myFileArray.size());
        }
        return myFileArray;
    }

    /*
     * Loose catch block
     */
    public Object listPureQueryBindFiles(AdminCommand cmd) throws AdminException {
        ArrayList<String> myFileArray;
        block29: {
            String tempSessionDir;
            block28: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "listPureQueryBindFiles");
                }
                myFileArray = new ArrayList<String>();
                tempSessionDir = null;
                Session session = cmd.getConfigSession();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Session id is " + session.getSessionId());
                    Tr.debug(tc, "Session user name is " + session.getUserName());
                }
                String appName = (String)cmd.getParameter("appName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "app name is: " + appName);
                }
                String earName = EditionHelper.getAppEarName(appName, (String)null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "earName: " + earName);
                }
                RepositoryContext appContext = this.getAppContextFromAppName(appName, session);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appContext: " + appContext);
                }
                if (appContext.getFile(earName) == null) {
                    throw new AdminException(AppManagementCommandProvider.getFormattedMessage("ADMA0501E", new Object[]{appName}));
                }
                appContext.extract(earName, false);
                String earPath = appContext.getPath() + File.separator + earName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear path is " + earPath);
                }
                Properties sysProps = System.getProperties();
                if (tc.isDebugEnabled()) {
                    StringWriter sw = new StringWriter();
                    sysProps.list(new PrintWriter(sw));
                    Tr.debug(tc, "Listing of System.getProperties... ", sw);
                }
                tempSessionDir = sysProps.getProperty("user.install.root") + File.separator + "temp" + File.separator + session.getUserName();
                String earExpansionDir = tempSessionDir + File.separator + earName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear expansion dir is " + earExpansionDir);
                }
                EARFile earFile = EarUtils.getEarFile((String)earPath, (boolean)false, (boolean)true);
                EarUtils.extractEar((EARFile)earFile, (String)earExpansionDir, (boolean)false, (int)126);
                earFile.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear file expanded to expansion dir");
                }
                boolean foundBindprops = this.recursivelyTraverse(new File(earExpansionDir), new File(earExpansionDir), ".bindprops", myFileArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expansion dir scanned for .bindprops files");
                }
                if (foundBindprops) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "not searching for .pdqxml files since .bindprops was found");
                    }
                    break block28;
                }
                this.recursivelyTraverse(new File(earExpansionDir), new File(earExpansionDir), ".pdqxml", myFileArray);
                if (!tc.isDebugEnabled()) break block28;
                Tr.debug(tc, "expansion dir scanned for .pdqxml files");
                StringBuilder mfasb = new StringBuilder("List of pureQuery bind file names follows:");
                for (String profileName : myFileArray) {
                    mfasb.append(newline);
                    mfasb.append(profileName);
                }
                Tr.debug(tc, mfasb.toString());
            }
            Object var17_17 = null;
            if (tempSessionDir == null) break block29;
            try {
                EarUtils.deleteDirTree((String)tempSessionDir);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleted directory tree, " + tempSessionDir);
                }
                break block29;
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while deleting directory tree, " + tempSessionDir, e);
                }
                break block29;
            }
            {
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.management.commands.AppManagementCommandProvider.listPureQueryBindFiles", "294");
                    Tr.error(tc, "ADMA0500E", new Object[]{"listPureQueryBindFiles"});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "listPureQueryBindFiles", th);
                    }
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, AppManagementCommandProvider.getFormattedMessage("ADMA0500E", new Object[]{"listPureQueryBindFiles"}));
                }
            }
            catch (Throwable throwable) {
                block30: {
                    Object var17_18 = null;
                    if (tempSessionDir != null) {
                        try {
                            EarUtils.deleteDirTree(tempSessionDir);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Deleted directory tree, " + tempSessionDir);
                            }
                        }
                        catch (IOException e) {
                            if (!tc.isDebugEnabled()) break block30;
                            Tr.debug(tc, "Exception while deleting directory tree, " + tempSessionDir, e);
                        }
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listPureQueryBindFiles", myFileArray.size());
        }
        return myFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object processSqljProfiles(AdminCommand cmd) throws AdminException {
        StringBuilder outputSB;
        String[] output;
        block62: {
            String tempSessionDir;
            block60: {
                String appName;
                block64: {
                    Object[] profiles;
                    String options;
                    String password;
                    String user;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "processSqljProfiles");
                    }
                    output = new String[2];
                    int rc = GOOD_RC;
                    output[1] = String.valueOf(BAD_RC);
                    outputSB = new StringBuilder(newline);
                    String baseDir = null;
                    tempSessionDir = null;
                    EARFile earFile = null;
                    String commandName = cmd.getName();
                    ArrayList<String> inputProfileList = new ArrayList();
                    LinkedHashSet<String> cpRelativeProfileNames = new LinkedHashSet<String>();
                    LinkedHashSet<String> profileCpEntries = new LinkedHashSet<String>();
                    boolean inputIsGrpFile = false;
                    boolean processAsPdq = false;
                    Boolean bindOnly = (Boolean)cmd.getParameter("bindOnly");
                    if (bindOnly == null) {
                        bindOnly = false;
                    }
                    appName = (String)cmd.getParameter("appName");
                    Object[] classpath = (String[])cmd.getParameter("classpath");
                    String dbURL = (String)cmd.getParameter("url");
                    if (dbURL == null) {
                        dbURL = "";
                    }
                    if ((user = (String)cmd.getParameter("user")) == null) {
                        user = "";
                    }
                    if ((password = (String)cmd.getParameter("password")) == null) {
                        password = "";
                    }
                    if ((options = (String)cmd.getParameter("options")) == null) {
                        options = "";
                    }
                    if ((profiles = (String[])cmd.getParameter("profiles"))[0] != null) {
                        if (profiles[0].endsWith(".grp")) {
                            inputIsGrpFile = true;
                        }
                        if (this.isBindprops(profiles[0])) {
                            processAsPdq = true;
                        }
                        if (profiles[0].toLowerCase().endsWith(".pdqxml")) {
                            processAsPdq = true;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "bindOnly flag is: " + bindOnly);
                        Tr.debug(tc, "appName is:       " + appName);
                        Tr.debug(tc, "classpath is:     " + this.arrayToString(classpath));
                        Tr.debug(tc, "url is:           " + dbURL);
                        Tr.debug(tc, "user is:          " + user);
                        Tr.debug(tc, "password is:      " + (password.trim().equals("") ? "null" : "non-null"));
                        Tr.debug(tc, "options is:       " + options);
                        Tr.debug(tc, "inputIsGrpFile:   " + inputIsGrpFile);
                        Tr.debug(tc, "processAsPdq:     " + processAsPdq);
                        Tr.debug(tc, "profiles is:      " + this.arrayToString(profiles));
                    }
                    if (processAsPdq) {
                        StringBuilder tempSessionDirSB = new StringBuilder();
                        rc = this.procPdq(cmd, outputSB, appName, (String[])classpath, dbURL, user, password, options, (String[])profiles, tempSessionDirSB);
                        output[1] = String.valueOf(rc);
                        if (tempSessionDirSB.length() > 0) {
                            tempSessionDir = tempSessionDirSB.toString();
                        }
                        break block60;
                    }
                    Session session = cmd.getConfigSession();
                    String sessionId = session.getSessionId();
                    String sessionUserName = session.getUserName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Session id is " + sessionId);
                        Tr.debug(tc, "Session user name is " + sessionUserName);
                    }
                    String earName = EditionHelper.getAppEarName(appName, (String)null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "earName: " + earName);
                    }
                    RepositoryContext appContext = this.getAppContextFromAppName(appName, session);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "appContext: " + appContext);
                    }
                    if (appContext.getFile(earName) == null) {
                        Tr.error(tc, "ADMA0501E", new Object[]{appName});
                        throw new AdminException(AppManagementCommandProvider.getFormattedMessage("ADMA0501E", new Object[]{appName}));
                    }
                    appContext.extract(earName, false);
                    String earPath = appContext.getPath() + File.separator + earName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ear path is " + earPath);
                    }
                    Properties sysProps = System.getProperties();
                    boolean useInProcessCall = Boolean.parseBoolean(sysProps.getProperty("AppManagementCommandProvider.use_InProcess_call", "false"));
                    baseDir = sysProps.getProperty("user.install.root", appContext.getPath());
                    tempSessionDir = baseDir + File.separator + "temp" + File.separator + sessionUserName;
                    String earExpansionDir = tempSessionDir + File.separator + earName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ear expansion dir is " + earExpansionDir);
                    }
                    earFile = EarUtils.getEarFile((String)earPath, (boolean)false, (boolean)true);
                    EarUtils.extractEar((EARFile)earFile, (String)earExpansionDir, (boolean)false, (int)126);
                    earFile.close();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ear file expanded to expansion dir");
                    }
                    if (inputIsGrpFile) {
                        this.loadInputProfileListFromGrp((String)profiles[0], inputProfileList);
                    } else {
                        inputProfileList = Arrays.asList(profiles);
                    }
                    this.parseInputProfileList(inputProfileList, profileCpEntries, cpRelativeProfileNames, outputSB);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "input profile list was parsed");
                    }
                    String tempGrpFilePathName = null;
                    String tempGrpFileName = null;
                    if (inputIsGrpFile) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("sqlj");
                        sb.append(sessionId);
                        sb.append(".grp");
                        tempGrpFileName = sb.toString();
                        tempGrpFilePathName = earExpansionDir + File.separator + tempGrpFileName;
                        this.createTempGrpFile(tempGrpFilePathName, cpRelativeProfileNames);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "temp .grp file was created: " + tempGrpFilePathName);
                        }
                        if (useInProcessCall) {
                            tempGrpFileName = tempGrpFilePathName.substring(baseDir.length() + File.separator.length());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Relative path to temp .grp file is: " + tempGrpFileName);
                        }
                    }
                    List<String> sqljCommand = this.createSqljCommandString(bindOnly, (String[])classpath, profileCpEntries, dbURL, user, password, options, inputIsGrpFile, cpRelativeProfileNames, tempGrpFileName, sysProps);
                    rc = useInProcessCall ? this.runSqljCommandInProcess(sqljCommand, earExpansionDir, outputSB, (String[])classpath) : this.runSqljCommand(sqljCommand, earExpansionDir, outputSB, commandName);
                    output[1] = String.valueOf(rc);
                    if (rc == GOOD_RC && !bindOnly.booleanValue()) {
                        if (inputIsGrpFile) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Deleting temp .grp file " + tempGrpFilePathName);
                            }
                            this.deleteFile(tempGrpFilePathName);
                        }
                        try {
                            block61: {
                                int sleepNumber;
                                CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
                                earFile = (EARFile)factory.openArchive(earExpansionDir);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Preparing to collapse modified EAR contents at " + earExpansionDir);
                                }
                                if ((sleepNumber = Integer.getInteger("AppManagementCommandProvider.EARFile_saveAs_delay", 0).intValue()) > 0) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "AppManagementCommandProvider.EARFile_saveAs_delay = " + sleepNumber);
                                    }
                                    Thread.sleep(sleepNumber);
                                }
                                earFile.saveAs(earPath);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Modified EAR contents collapsed into " + earPath);
                                }
                                appContext.notifyChanged(1, earName);
                                if (!tc.isDebugEnabled()) break block61;
                                Tr.debug(tc, "Workspace was notified of updates to EAR file " + earPath);
                            }
                            Object var39_40 = null;
                        }
                        catch (Throwable throwable) {
                            Object var39_42 = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Closing archive");
                            }
                            if (earFile != null) {
                                earFile.close();
                            }
                            throw throwable;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Closing archive");
                        }
                        if (earFile != null) {
                            earFile.close();
                        }
                        break block64;
                        {
                            catch (Exception x) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception during collapse: ", x);
                                    Tr.debug(tc, "Exception is caught so that ouput[] can be returned to user.");
                                }
                                FFDCFilter.processException(x, "com.ibm.ws.management.commands.AppManagementCommandProvider.processSqljProfiles", "312");
                                Tr.error(tc, "ADMA0502E", new Object[]{appName, earPath});
                                AdminException ae = new AdminException(x, AppManagementCommandProvider.getFormattedMessage("ADMA0502E", new Object[]{appName, earPath}));
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                ae.printStackTrace(pw);
                                outputSB.append(sw.getBuffer());
                                output[1] = String.valueOf(BAD_RC);
                                Object var39_41 = null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Closing archive");
                                }
                                if (earFile != null) {
                                    earFile.close();
                                }
                            }
                        }
                    }
                }
                String msg = null;
                msg = output[1].equals("0") ? AppManagementCommandProvider.getFormattedMessage("ADMA0507I", new Object[]{appName, output[1]}) : AppManagementCommandProvider.getFormattedMessage("ADMA0506I", new Object[]{appName, output[1]});
                Tr.info(tc, msg);
                outputSB.append(newline + msg);
            }
            Object var41_46 = null;
            if (tempSessionDir == null) break block62;
            try {
                EarUtils.deleteDirTree((String)tempSessionDir);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleted directory tree, " + tempSessionDir);
                }
                break block62;
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while deleting directory tree, " + tempSessionDir, e);
                }
                break block62;
            }
            {
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.management.commands.AppManagementCommandProvider.processSqljProfiles", "282");
                    Tr.error(tc, "ADMA0500E", new Object[]{"processSqljProfiles"});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "processSqljProfiles", th);
                    }
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, AppManagementCommandProvider.getFormattedMessage("ADMA0500E", new Object[]{"processSqljProfiles"}));
                }
            }
            catch (Throwable throwable) {
                block63: {
                    Object var41_47 = null;
                    if (tempSessionDir != null) {
                        try {
                            EarUtils.deleteDirTree(tempSessionDir);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Deleted directory tree, " + tempSessionDir);
                            }
                        }
                        catch (IOException e) {
                            if (!tc.isDebugEnabled()) break block63;
                            Tr.debug(tc, "Exception while deleting directory tree, " + tempSessionDir, e);
                        }
                    }
                }
                throw throwable;
            }
        }
        output[0] = outputSB.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Messages from command execution... ", output[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSqljProfiles", Integer.valueOf(output[1]));
        }
        return output;
    }

    /*
     * Loose catch block
     */
    public Object processPureQueryBindFiles(AdminCommand cmd) throws AdminException {
        StringBuilder outputSB;
        int rc;
        String[] output;
        block22: {
            String tempSessionDir;
            block21: {
                String options;
                String password;
                String user;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "processPureQueryBindFiles");
                }
                output = new String[2];
                rc = GOOD_RC;
                output[1] = String.valueOf(BAD_RC);
                outputSB = new StringBuilder(newline);
                StringBuilder tempSessionDirSB = new StringBuilder();
                tempSessionDir = null;
                boolean inputNotPdqFile = false;
                String appName = (String)cmd.getParameter("appName");
                Object[] classpath = (String[])cmd.getParameter("classpath");
                String dbURL = (String)cmd.getParameter("url");
                if (dbURL == null) {
                    dbURL = "";
                }
                if ((user = (String)cmd.getParameter("user")) == null) {
                    user = "";
                }
                if ((password = (String)cmd.getParameter("password")) == null) {
                    password = "";
                }
                if ((options = (String)cmd.getParameter("options")) == null) {
                    options = "";
                }
                Object[] bindfiles = (String[])cmd.getParameter("files");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appName is:       " + appName);
                    Tr.debug(tc, "classpath is:     " + this.arrayToString(classpath));
                    Tr.debug(tc, "url is:           " + dbURL);
                    Tr.debug(tc, "user is:          " + user);
                    Tr.debug(tc, "password is:      " + (password.trim().equals("") ? "null" : "non-null"));
                    Tr.debug(tc, "options is:       " + options);
                    Tr.debug(tc, "inputNotPdqFile:  " + inputNotPdqFile);
                    Tr.debug(tc, "files is:         " + this.arrayToString(bindfiles));
                }
                rc = this.procPdq(cmd, outputSB, appName, (String[])classpath, dbURL, user, password, options, (String[])bindfiles, tempSessionDirSB);
                if (tempSessionDirSB.length() <= 0) break block21;
                tempSessionDir = tempSessionDirSB.toString();
            }
            Object var16_16 = null;
            if (tempSessionDir == null) break block22;
            try {
                EarUtils.deleteDirTree((String)tempSessionDir);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleted directory tree, " + tempSessionDir);
                }
                break block22;
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while deleting directory tree, " + tempSessionDir, e);
                }
                break block22;
            }
            {
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.management.commands.AppManagementCommandProvider.processPureQueryBindFiles", "766");
                    Tr.error(tc, "ADMA0500E", new Object[]{"processPureQueryBindFiles"});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "processPureQueryBindFiles", th);
                    }
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, AppManagementCommandProvider.getFormattedMessage("ADMA0500E", new Object[]{"processPureQueryBindFiles"}));
                }
            }
            catch (Throwable throwable) {
                block23: {
                    Object var16_17 = null;
                    if (tempSessionDir != null) {
                        try {
                            EarUtils.deleteDirTree(tempSessionDir);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Deleted directory tree, " + tempSessionDir);
                            }
                        }
                        catch (IOException e) {
                            if (!tc.isDebugEnabled()) break block23;
                            Tr.debug(tc, "Exception while deleting directory tree, " + tempSessionDir, e);
                        }
                    }
                }
                throw throwable;
            }
        }
        output[0] = outputSB.toString();
        output[1] = Integer.toString(rc);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Messages from command execution... ", output[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPureQueryBindFiles", Integer.valueOf(output[1]));
        }
        return output;
    }

    private int procPdq(AdminCommand cmd, StringBuilder outputSB, String appName, String[] classpath, String dbURL, String user, String password, String options, String[] bindfiles, StringBuilder tempDir) throws WorkSpaceException, AdminException, OpenFailureException, SaveFailureException, IOException {
        AbstractCollection finalFileList;
        ArrayList<String> earPaths;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "procPdq");
        }
        int rc = GOOD_RC;
        LinkedHashSet<String> cpRelativeBindfileNames = new LinkedHashSet<String>();
        LinkedHashSet<String> bindfileCpEntries = new LinkedHashSet<String>();
        String commandName = cmd.getName();
        Session session = cmd.getConfigSession();
        String sessionId = session.getSessionId();
        String sessionUserName = session.getUserName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session id is " + sessionId);
            Tr.debug(tc, "Session user name is " + sessionUserName);
        }
        String earName = EditionHelper.getAppEarName(appName, (String)null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "earName: " + earName);
        }
        RepositoryContext appContext = this.getAppContextFromAppName(appName, session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appContext: " + appContext);
        }
        if (appContext.getFile(earName) == null) {
            Tr.error(tc, "ADMA0501E", new Object[]{appName});
            throw new AdminException(AppManagementCommandProvider.getFormattedMessage("ADMA0501E", new Object[]{appName}));
        }
        appContext.extract(earName, false);
        String earPath = appContext.getPath() + File.separator + earName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ear path is " + earPath);
        }
        Properties sysProps = System.getProperties();
        String baseDir = sysProps.getProperty("user.install.root", appContext.getPath());
        String tempSessionDir = baseDir + File.separator + "temp" + File.separator + sessionUserName;
        String earExpansionDir = tempSessionDir + File.separator + earName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ear expansion dir is " + earExpansionDir);
        }
        tempDir.append(tempSessionDir);
        EARFile earFile = EarUtils.getEarFile((String)earPath, (boolean)false, (boolean)true);
        EarUtils.extractEar((EARFile)earFile, (String)earExpansionDir, (boolean)false, (int)126);
        earFile.close();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ear file expanded to expansion dir");
        }
        if (this.isBindprops(bindfiles[0])) {
            earPaths = this.createEarClasspath(earExpansionDir);
            finalFileList = new ArrayList<String>(bindfiles.length);
            finalFileList.add(bindfiles[0]);
            for (int i = 1; i < bindfiles.length; ++i) {
                if (!this.isBindprops(bindfiles[i])) continue;
                finalFileList.add(bindfiles[i]);
            }
        } else {
            this.parseInputProfileList(Arrays.asList(bindfiles), bindfileCpEntries, cpRelativeBindfileNames, outputSB);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "input profile list was parsed");
            }
            earPaths = new ArrayList<String>(bindfileCpEntries);
            finalFileList = cpRelativeBindfileNames;
        }
        int cmdIndex = 0;
        int[] rcArray = new int[finalFileList.size()];
        Throwable[] exArray = new Throwable[finalFileList.size()];
        for (String bindFile : finalFileList) {
            List<String> bindCommand = this.createPdqBindCommandString(classpath, earPaths, dbURL, user, password, options, bindFile, earExpansionDir, sysProps);
            try {
                int rcTemp;
                rcArray[cmdIndex] = rcTemp = this.runSqljCommand(bindCommand, earExpansionDir, outputSB, commandName);
                exArray[cmdIndex] = null;
                if (rcTemp != GOOD_RC) {
                    rc = BAD_RC;
                }
            }
            catch (AdminException ae) {
                rcArray[cmdIndex] = BAD_RC;
                exArray[cmdIndex] = ae;
                rc = BAD_RC;
            }
            ++cmdIndex;
        }
        String msg = null;
        for (cmdIndex = 0; cmdIndex < bindfiles.length; ++cmdIndex) {
            msg = exArray[cmdIndex] == null ? AppManagementCommandProvider.getFormattedMessage("ADMA0510I", new Object[]{bindfiles[cmdIndex], rcArray[cmdIndex], "null"}) : AppManagementCommandProvider.getFormattedMessage("ADMA0510I", new Object[]{bindfiles[cmdIndex], rcArray[cmdIndex], exArray[cmdIndex]});
            outputSB.append(newline);
            outputSB.append(msg);
        }
        String rcAsString = String.valueOf(rc);
        msg = rc == GOOD_RC ? AppManagementCommandProvider.getFormattedMessage("ADMA0509I", new Object[]{appName, rcAsString}) : AppManagementCommandProvider.getFormattedMessage("ADMA0508I", new Object[]{appName, rcAsString});
        Tr.info(tc, msg);
        outputSB.append(newline + msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "procPdq");
        }
        return rc;
    }

    private void deleteFile(String fileName) {
        File delFile = new File(fileName);
        delFile.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runSqljCommand(List<String> sqljCommand, String workingDirName, StringBuilder cmdOutput, String commandName) throws AdminException {
        PrintWriter pw;
        StringWriter sw;
        int retCode;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runSqljCommand");
            }
            retCode = BAD_RC;
            File workingDir = new File(workingDirName);
            ProcessBuilder procBld = new ProcessBuilder(sqljCommand);
            procBld.directory(workingDir);
            procBld.redirectErrorStream(true);
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            BufferedReader br = null;
            try {
                try {
                    String line;
                    Process sqljProc = procBld.start();
                    InputStream is = sqljProc.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        pw.println(line);
                    }
                    retCode = sqljProc.waitFor();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Child Process return code: " + retCode);
                    }
                }
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.management.commands.AppManagementCommandProvider.runSqljCommand", "395");
                    Tr.error(tc, "ADMA0500E", new Object[]{commandName});
                    pw.close();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception in runSqljCommand.  Command output buffer contents up to the point of failure... ", sw);
                    }
                    cmdOutput.append(sw.getBuffer());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "runSqljCommand", th);
                    }
                    throw new AdminException(th, AppManagementCommandProvider.getFormattedMessage("ADMA0500E", new Object[]{commandName}));
                }
                Object var16_16 = null;
                if (br == null) break block12;
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            br.close();
        }
        pw.close();
        cmdOutput.append(sw.getBuffer());
        if (!tc.isEntryEnabled()) return retCode;
        Tr.exit(tc, "runSqljCommand", String.valueOf(retCode));
        return retCode;
    }

    private int runSqljCommandInProcess(List<String> sqljCommand, String workingDirName, StringBuilder cmdOutput, String[] userClasspath) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runSqljCommandInProcess");
        }
        int retCode = BAD_RC;
        File workingDir = new File(workingDirName);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String[] cmdArgs = new String[sqljCommand.size() - 4];
        String cp = sqljCommand.get(2);
        String cmdClassName = sqljCommand.get(3);
        for (int i = 0; i < cmdArgs.length; ++i) {
            cmdArgs[i] = sqljCommand.get(i + 4);
        }
        try {
            block18: {
                try {
                    ArrayList<File> pathElements = new ArrayList<File>();
                    StringTokenizer path = new StringTokenizer(cp, File.pathSeparator);
                    while (path.hasMoreTokens()) {
                        String element = path.nextToken();
                        boolean elementIsAbsolutePath = false;
                        if (userClasspath != null) {
                            for (int i = 0; i < userClasspath.length; ++i) {
                                if (!element.equals(userClasspath[i])) continue;
                                elementIsAbsolutePath = true;
                                break;
                            }
                        }
                        if (elementIsAbsolutePath) {
                            pathElements.add(new File(element));
                            continue;
                        }
                        pathElements.add(new File(workingDir, element));
                    }
                    URL[] cpurls = new URL[pathElements.size()];
                    for (int i = 0; i < cpurls.length; ++i) {
                        cpurls[i] = ((File)pathElements.get(i)).toURI().toURL();
                    }
                    URLClassLoader ucl = new URLClassLoader(cpurls);
                    if (tc.isDebugEnabled()) {
                        URL[] uclUrls;
                        Tr.debug(tc, "Parent of URLClassLoader is ", ucl.getParent());
                        for (URL url : uclUrls = ucl.getURLs()) {
                            Tr.debug(tc, "URL -- ", url);
                        }
                    }
                    Class<?> sqljToolClass = null;
                    Method sqljToolMethod = null;
                    String methodName = null;
                    methodName = cmdClassName.endsWith("Binder") ? "bindMain" : "customizeMain";
                    sqljToolClass = Class.forName(cmdClassName, true, ucl);
                    sqljToolMethod = sqljToolClass.getMethod(methodName, String[].class, PrintWriter.class, Integer.TYPE, ClassLoader.class);
                    try {
                        retCode = (Integer)sqljToolMethod.invoke(null, cmdArgs, pw, 0, ucl);
                    }
                    catch (InvocationTargetException ite) {
                        ite.getCause().printStackTrace(pw);
                        retCode = -1;
                    }
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "SQLJ Process return code: " + retCode);
                }
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.management.commands.AppManagementCommandProvider.runSqljCommandInProcess", "577");
                    Tr.error(tc, "ADMA0500E", new Object[]{"processSqljProfiles"});
                    pw.close();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception in runSqljCommandInProcess.  Command output buffer contents up to the point of failure... ", sw);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "runSqljCommandInProcess", th);
                    }
                    throw new AdminException(th, AppManagementCommandProvider.getFormattedMessage("ADMA0500E", new Object[]{"processSqljProfiles"}));
                }
            }
            Object var21_32 = null;
        }
        catch (Throwable throwable) {
            Object var21_33 = null;
            throw throwable;
        }
        pw.close();
        cmdOutput.append(sw.getBuffer());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runSqljCommandInProcess", String.valueOf(retCode));
        }
        return retCode;
    }

    private List<String> createSqljCommandString(Boolean bindOnly, String[] classpath, Collection<String> profileCpEntries, String dbURL, String user, String password, String options, boolean inputIsGrpFile, Collection<String> cpRelativeProfileNames, String tempGrpFileName, Properties sysProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSqljCommandString");
        }
        ArrayList<String> commandList = new ArrayList<String>();
        StringBuilder cmdChunkSb = new StringBuilder();
        commandList.add(sysProps.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        if (classpath != null) {
            for (int i = 0; i < classpath.length; ++i) {
                if (i > 0) {
                    cmdChunkSb.append(File.pathSeparatorChar);
                }
                cmdChunkSb.append(classpath[i]);
            }
        }
        Iterator<String> cpIter = profileCpEntries.iterator();
        while (cpIter.hasNext()) {
            if (cmdChunkSb.length() > 0) {
                cmdChunkSb.append(File.pathSeparatorChar);
            }
            cmdChunkSb.append((Object)cpIter.next());
        }
        if (cmdChunkSb.length() > 0) {
            commandList.add("-cp");
            commandList.add(cmdChunkSb.toString());
        }
        commandList.add(bindOnly != false ? "com.ibm.db2.jcc.sqlj.Binder" : "com.ibm.db2.jcc.sqlj.Customizer");
        if (!dbURL.equals("")) {
            commandList.add("-url");
            commandList.add(dbURL);
        }
        if (!user.equals("")) {
            commandList.add("-user");
            commandList.add(user);
        }
        if (!password.equals("")) {
            commandList.add("-password");
            commandList.add(password);
        }
        if (!options.equals("")) {
            this.addOptionsToCommandList(options, commandList);
        }
        if (inputIsGrpFile) {
            commandList.add(tempGrpFileName);
        } else {
            cpIter = cpRelativeProfileNames.iterator();
            while (cpIter.hasNext()) {
                commandList.add(cpIter.next());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandList contains: " + this.hidePwArgs(commandList));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSqljCommandString");
        }
        return commandList;
    }

    private void addOptionsToCommandList(String options, List<String> commandList) {
        String[] sa = options.split("\\s+");
        boolean quoted = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sa.length; ++i) {
            if (quoted) {
                if (sa[i].endsWith("\"")) {
                    quoted = false;
                    sb.append(" ");
                    sb.append(sa[i].substring(0, sa[i].length() - 1));
                    commandList.add(sb.toString().trim());
                    sb.setLength(0);
                    continue;
                }
                sb.append(" ");
                sb.append(sa[i]);
                continue;
            }
            if (sa[i].startsWith("\"")) {
                quoted = true;
                if (sa[i].length() > 1 && sa[i].endsWith("\"")) {
                    quoted = false;
                    commandList.add(sa[i].substring(1, sa[i].length() - 1));
                    continue;
                }
                sb.append(sa[i].substring(1));
                continue;
            }
            commandList.add(sa[i]);
        }
    }

    private List<String> createPdqBindCommandString(String[] classpath, List earPaths, String dbURL, String user, String password, String options, String bindFile, String tempEarDir, Properties sysProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPdqBindCommandString");
        }
        ArrayList<String> commandList = new ArrayList<String>();
        StringBuilder cmdChunkSb = new StringBuilder();
        commandList.add(sysProps.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        if (classpath != null) {
            for (int i = 0; i < classpath.length; ++i) {
                if (i > 0) {
                    cmdChunkSb.append(File.pathSeparatorChar);
                }
                cmdChunkSb.append(classpath[i]);
            }
        }
        if (!earPaths.isEmpty()) {
            for (String pathElement : earPaths) {
                if (cmdChunkSb.length() > 0) {
                    cmdChunkSb.append(File.pathSeparatorChar);
                }
                cmdChunkSb.append(pathElement);
            }
        }
        if (cmdChunkSb.length() > 0) {
            commandList.add("-cp");
            commandList.add(cmdChunkSb.toString());
        }
        commandList.add("com.ibm.pdq.tools.StaticBinder");
        if (!dbURL.equals("")) {
            commandList.add("-url");
            commandList.add(dbURL);
        }
        if (!user.equals("")) {
            commandList.add("-user");
            commandList.add(user);
        }
        if (!password.equals("")) {
            commandList.add("-password");
            commandList.add(password);
        }
        if (!options.equals("")) {
            this.addOptionsToCommandList(options, commandList);
        }
        if (this.isBindprops(bindFile)) {
            commandList.add("-optionsFile");
        } else {
            commandList.add("-pureQueryXml");
        }
        commandList.add(bindFile);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandList contains: " + this.hidePwArgs(commandList));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPdqBindCommandString");
        }
        return commandList;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTempGrpFile(String tempGrpFileName, Collection<String> cpRelativeProfileNames) throws AdminException {
        block10: {
            if (AppManagementCommandProvider.tc.isEntryEnabled()) {
                Tr.entry(AppManagementCommandProvider.tc, "createTempGrpFile", tempGrpFileName);
            }
            bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(tempGrpFileName));
                for (String line : cpRelativeProfileNames) {
                    bw.write(line);
                    bw.newLine();
                }
                var7_7 = null;
                if (bw == null) break block10;
                ** GOTO lbl31
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.management.commands.AppManagementCommandProvider.createTempGrpFile", "488");
                Tr.error(AppManagementCommandProvider.tc, "ADMA0505E", new Object[]{tempGrpFileName});
                if (AppManagementCommandProvider.tc.isEntryEnabled()) {
                    Tr.exit(AppManagementCommandProvider.tc, "createTempGrpFile", e);
                }
                throw new AdminException(e, AppManagementCommandProvider.getFormattedMessage("ADMA0505E", new Object[]{tempGrpFileName}));
            }
            {
                catch (Throwable var6_11) {
                    var7_8 = null;
                    if (bw == null) throw var6_11;
                    try {
                        bw.close();
                        throw var6_11;
                    }
                    catch (Exception e) {
                        if (AppManagementCommandProvider.tc.isDebugEnabled() == false) throw var6_11;
                        Tr.debug(AppManagementCommandProvider.tc, "Exception while closing temp .grp file", e);
                    }
                    throw var6_11;
                }
lbl31:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [3 : 174->181)] { 
lbl32:
                // 1 sources

                bw.close();
lbl34:
                // 1 sources

                catch (Exception e) {}
                if (!AppManagementCommandProvider.tc.isDebugEnabled()) break block10;
                Tr.debug(AppManagementCommandProvider.tc, "Exception while closing temp .grp file", e);
            }
        }
        if (AppManagementCommandProvider.tc.isEntryEnabled() == false) return;
        Tr.exit(AppManagementCommandProvider.tc, "createTempGrpFile");
    }

    private void parseInputProfileList(Collection<String> inputProfileList, Collection<String> profileCpEntries, Collection<String> cpRelativeProfileNames, StringBuilder msgSB) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseInputProfileList");
        }
        for (String earRelativeName : inputProfileList) {
            String cpRelativeName;
            String cpEntry;
            int splitPoint = earRelativeName.lastIndexOf(".jar" + File.separator);
            if (0 <= splitPoint) {
                splitPoint += 4;
            } else {
                splitPoint = earRelativeName.lastIndexOf(".jar/");
                if (0 <= splitPoint) {
                    splitPoint += 4;
                } else {
                    splitPoint = earRelativeName.lastIndexOf("classes" + File.separator);
                    if (0 <= splitPoint) {
                        splitPoint += 7;
                    } else {
                        splitPoint = earRelativeName.lastIndexOf("classes/");
                        if (0 <= splitPoint) {
                            splitPoint += 7;
                        }
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "splitPoint = " + String.valueOf(splitPoint));
            }
            if (splitPoint > 0) {
                cpEntry = earRelativeName.substring(0, splitPoint);
                cpRelativeName = earRelativeName.substring(splitPoint + 1);
            } else {
                cpEntry = ".";
                while (earRelativeName.startsWith("\\") || earRelativeName.startsWith("/")) {
                    earRelativeName = earRelativeName.substring(1);
                }
                cpRelativeName = earRelativeName;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ear-relative name: " + earRelativeName);
                Tr.debug(tc, "classpath part: " + cpEntry);
                Tr.debug(tc, "classpath-relative name: " + cpRelativeName);
            }
            boolean cpAdded = profileCpEntries.add(cpEntry);
            boolean pnAdded = cpRelativeProfileNames.add(cpRelativeName);
            if (tc.isDebugEnabled()) {
                if (!cpAdded) {
                    Tr.debug(tc, "Duplicate classpath entry not added to list.");
                }
                if (!pnAdded) {
                    Tr.debug(tc, "Duplicate profile name entry not added to list.");
                }
                Tr.debug(tc, "---------------");
            }
            if (pnAdded) continue;
            Object[] oa = new Object[]{cpRelativeName, earRelativeName};
            msgSB.append(AppManagementCommandProvider.getFormattedMessage("ADMA0504W", oa) + newline);
            Tr.warning(tc, "ADMA0504W", oa);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseInputProfileList");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadInputProfileListFromGrp(String inputGrpFileName, Collection<String> inputProfileList) throws AdminException {
        block10: {
            if (AppManagementCommandProvider.tc.isEntryEnabled()) {
                Tr.entry(AppManagementCommandProvider.tc, "loadInputProfileListFromGrp", inputGrpFileName);
            }
            frdr = null;
            try {
                frdr = new BufferedReader(new FileReader(inputGrpFileName));
                line = null;
                line = frdr.readLine();
                while (line != null) {
                    inputProfileList.add(line);
                    line = frdr.readLine();
                }
                var6_6 = null;
                if (frdr == null) break block10;
                ** GOTO lbl34
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.management.commands.AppManagementCommandProvider.loadInputProfileListFromGrp", "553");
                Tr.error(AppManagementCommandProvider.tc, "ADMA0503E", new Object[]{inputGrpFileName});
                if (AppManagementCommandProvider.tc.isEntryEnabled()) {
                    Tr.exit(AppManagementCommandProvider.tc, "loadInputProfileListFromGrp", e);
                }
                throw new AdminException(e, AppManagementCommandProvider.getFormattedMessage("ADMA0503E", new Object[]{inputGrpFileName}));
            }
            {
                catch (Throwable var5_10) {
                    var6_7 = null;
                    if (frdr == null) throw var5_10;
                    try {
                        frdr.close();
                        throw var5_10;
                    }
                    catch (Exception e) {
                        if (AppManagementCommandProvider.tc.isDebugEnabled() == false) throw var5_10;
                        Tr.debug(AppManagementCommandProvider.tc, "Exception while closing .grp file", e);
                    }
                    throw var5_10;
                }
lbl34:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [3 : 163->170)] { 
lbl35:
                // 1 sources

                frdr.close();
lbl37:
                // 1 sources

                catch (Exception e) {}
                if (!AppManagementCommandProvider.tc.isDebugEnabled()) break block10;
                Tr.debug(AppManagementCommandProvider.tc, "Exception while closing .grp file", e);
            }
        }
        if (AppManagementCommandProvider.tc.isEntryEnabled() == false) return;
        Tr.exit(AppManagementCommandProvider.tc, "loadInputProfileListFromGrp");
    }

    private RepositoryContext getAppContextFromAppName(String appName, Session session) throws WorkSpaceException, AdminException {
        Collection c;
        String[] appNameAndEdition = EditionHelper.getAppAndEdition(appName);
        String appContextName = appNameAndEdition[0] + ".ear";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appctxname = " + appContextName);
        }
        WorkSpace ws = WorkspaceHelper.getWorkspace((Session)session);
        RepositoryContextType cellType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells");
        RepositoryContext cellContext = (RepositoryContext)ws.findContext(cellType).iterator().next();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell context = " + cellContext);
        }
        if ((c = cellContext.findContext("applications", appContextName)).isEmpty()) {
            Tr.error(tc, "ADMA5045E", new Object[]{appName});
            throw new AdminException(AppManagementCommandProvider.getFormattedMessage("ADMA5045E", new Object[]{appName}));
        }
        RepositoryContext appContext = (RepositoryContext)c.iterator().next();
        return appContext;
    }

    private String arrayToString(Object[] arr) {
        if (arr == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < arr.length; ++i) {
            Object obj = arr[i];
            if (i > 0) {
                sb.append(", ");
            }
            if (obj != null) {
                sb.append(obj);
                continue;
            }
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }

    private List<String> hidePwArgs(List<String> inputList) {
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        boolean hideItem = false;
        for (String item : inputList) {
            if (hideItem) {
                hideItem = false;
                outputList.add("********");
                continue;
            }
            if ("-password".equals(item)) {
                hideItem = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "-password switch encountered.  Obscuring the subsequent argument...");
                }
            }
            outputList.add(item);
        }
        return outputList;
    }

    public boolean recursivelyTraverse(File parentFolder, File dirFile, String suffix, ArrayList<String> list) {
        File[] fileArray = dirFile.listFiles();
        boolean found = false;
        if (fileArray != null) {
            int relativePathIndex = parentFolder.getPath().length() + 1;
            for (int i = 0; i < fileArray.length; ++i) {
                String ending;
                if (fileArray[i].isDirectory()) {
                    found |= this.recursivelyTraverse(parentFolder, fileArray[i], suffix, list);
                    continue;
                }
                String fileName = fileArray[i].getPath();
                int suffixIndex = fileName.length() - suffix.length();
                if (suffixIndex < 0 || !(ending = fileName.substring(suffixIndex)).equalsIgnoreCase(suffix) || fileName.endsWith("StaticSqlSerialized.ser")) continue;
                found |= true;
                String earRelativePath = fileName.substring(relativePathIndex);
                list.add(earRelativePath);
            }
        }
        return found;
    }

    public static String getFormattedMessage(String key, Object[] args) {
        ResourceBundle bundle = resBundle;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage", new Object[]{bundle, key, args});
        }
        String message = null;
        try {
            message = bundle.getString(key);
            if (message == null) {
                message = "Cannot find message key " + key + "in resource bundle" + bundle.toString();
                Tr.event(tc, message);
            }
            message = MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            message = "Cannot find message key " + key + "in resource bundle " + bundle.toString();
            Tr.event(tc, message);
            return message;
        }
        catch (NullPointerException npe) {
            message = "Null pointer exception caught trying to find message key " + key + " in resource bundle " + bundle.toString();
            Tr.event(tc, message);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFormattedMessage", message);
        }
        return message;
    }

    protected String normalizePath(String path) {
        File f = new File(path);
        try {
            f = f.getCanonicalFile();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.commands.AppManagementCommandProvider.normalizePath", "1743", this);
        }
        return f.getPath();
    }

    protected void addToListNoDup(List list, Object item) {
        if (!list.contains(item)) {
            list.add(item);
        }
    }

    protected List createEarClasspath(String earExpansionDir) {
        boolean traceIsOn = TraceComponent.isAnyTracingEnabled();
        if (traceIsOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "createEarClasspath", new Object[]{earExpansionDir});
        }
        LinkedHashSet<String> earCpEntries = new LinkedHashSet<String>();
        earCpEntries.add(".");
        File thisFile = new File(earExpansionDir);
        File[] fileArray = thisFile.listFiles();
        int relativePathIndex = thisFile.getPath().length() + 1;
        for (int i = 0; i < fileArray.length; ++i) {
            if (traceIsOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking filepath " + fileArray[i].getPath());
            }
            if (this.isJarName(fileArray[i].getName())) {
                String relativeFilePath = fileArray[i].getPath().substring(relativePathIndex);
                earCpEntries.add(relativeFilePath);
                if (!traceIsOn || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding path " + relativeFilePath);
                continue;
            }
            if (!this.isWarName(fileArray[i].getName())) continue;
            File warWebInfDir = new File(fileArray[i], "WEB-INF");
            File warClassesDir = new File(warWebInfDir, "classes");
            File warLibDir = new File(warWebInfDir, "lib");
            if (traceIsOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking filepath " + warClassesDir.getPath());
                Tr.debug(tc, "Filepath exists:  " + warClassesDir.exists());
                Tr.debug(tc, "Checking filepath " + warLibDir.getPath());
                Tr.debug(tc, "Filepath exists:  " + warLibDir.exists());
            }
            if (warClassesDir.exists()) {
                String relativeFilePath = warClassesDir.getPath().substring(relativePathIndex);
                earCpEntries.add(relativeFilePath);
                if (traceIsOn && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding path " + relativeFilePath);
                }
            }
            if (!warLibDir.isDirectory()) continue;
            File[] warLibJars = warLibDir.listFiles();
            for (int j = 0; j < warLibJars.length; ++j) {
                if (traceIsOn && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking filepath " + warLibJars[j].getPath());
                }
                if (!this.isJarName(warLibJars[j].getName())) continue;
                String relativeFilePath = warLibJars[j].getPath().substring(relativePathIndex);
                earCpEntries.add(relativeFilePath);
                if (!traceIsOn || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding path " + relativeFilePath);
            }
        }
        ArrayList earCpAsList = new ArrayList(earCpEntries);
        if (traceIsOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "createEarClasspath", new Object[]{earCpAsList});
        }
        return earCpAsList;
    }

    protected boolean isJarName(String fname) {
        return fname.toLowerCase().endsWith(".jar");
    }

    protected boolean isWarName(String fname) {
        return fname.toLowerCase().endsWith(".war");
    }

    protected boolean isBindprops(String fname) {
        return fname.toLowerCase().endsWith(".bindprops");
    }
}

