/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.collaborator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.management.collaborator.PmiJmxBridge;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public abstract class StatisticsProviderCollaborator
extends RuntimeCollaborator {
    private static TraceComponent tc = Tr.register(StatisticsProviderCollaborator.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private static Class pmiRegistry;
    private static Method getPmiJmxBridgeMethod;
    private boolean isStatisticsProvider = false;
    private PmiJmxBridge bridge;

    public void bindMBean(ModelMBeanInfo info, ModelMBean bean) throws Exception {
        Object obj;
        ModelMBeanInfo mbeanInfo = (ModelMBeanInfo)((Object)bean.getMBeanInfo());
        Descriptor desc = mbeanInfo.getMBeanDescriptor();
        if (desc != null && (obj = desc.getFieldValue("statisticsProvider")) != null && obj.equals(Boolean.TRUE)) {
            this.isStatisticsProvider = true;
            this.routeAttributeToThis(mbeanInfo, "stats");
            this.routeOperationToThis(mbeanInfo, "getStats");
            bean.setModelMBeanInfo(mbeanInfo);
        }
        super.bindMBean(mbeanInfo, bean);
    }

    protected void routeAttributeToThis(ModelMBeanInfo info, String attrName) throws MBeanException {
        Descriptor d = info.getDescriptor(attrName, "attribute");
        if (d != null) {
            d.setField("targetObject", this);
            info.setDescriptor(d, "attribute");
        }
    }

    protected void routeOperationToThis(ModelMBeanInfo info, String opName) throws MBeanException {
        Descriptor d = info.getDescriptor(opName, "operation");
        if (d != null) {
            d.setField("targetObject", this);
            info.setDescriptor(d, "operation");
        }
    }

    public boolean isStatisticsProvider() {
        if (!this.isStatisticsProvider || this.getBridge() == null) {
            return false;
        }
        return this.getBridge().isStatisticsProvider();
    }

    public Stats getStats() {
        if (this.getBridge() == null) {
            return null;
        }
        return this.getBridge().getStats();
    }

    private PmiJmxBridge getBridge() {
        if (this.bridge == null) {
            try {
                this.bridge = (PmiJmxBridge)getPmiJmxBridgeMethod.invoke(null, this.getObjectName());
            }
            catch (Exception exc) {
                Manager.Ffdc.log(exc, StatisticsProviderCollaborator.class, "com.ibm.ws.management.collaborator.StatisticsProviderCollaborator.setObjectName", "83");
            }
        }
        return this.bridge;
    }

    static {
        try {
            pmiRegistry = Class.forName("com.ibm.ws.pmi.j2ee.PMIJ2EEStatsHelper");
            getPmiJmxBridgeMethod = pmiRegistry.getMethod("getPmiJmxBridge", ObjectName.class);
        }
        catch (Exception exc) {
            Manager.Ffdc.log(exc, StatisticsProviderCollaborator.class, "com.ibm.ws.management.collaborator.StatisticsProviderCollaborator.<cinit>", "56");
        }
    }
}

