/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.bla.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class UtilHelper {
    private static TraceComponent tc = Tr.register(UtilHelper.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String CLASS_NAME = "com.ibm.ws.management.deploy.util.Util";
    private static final String DEFAULT_BUNDLE_NAME = "com.ibm.ws.management.bla.resources.BLAMessages";
    private static final String NON_ERROR_BUNDLE_NAME = "com.ibm.ws.management.bla.resources.BLANonErrorMessages";

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale) {
        ResourceBundle resBundle;
        block4: {
            if (bundleName == null) {
                bundleName = DEFAULT_BUNDLE_NAME;
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                resBundle = ResourceBundle.getBundle(bundleName, locale);
            }
            catch (MissingResourceException e) {
                resBundle = null;
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error loading class: " + bundleName + ", locale " + locale + e);
            }
        }
        return resBundle;
    }

    public static ResourceBundle getNonErrorBundle(Locale locale) {
        ResourceBundle resBundle;
        block3: {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                resBundle = ResourceBundle.getBundle(NON_ERROR_BUNDLE_NAME, locale);
            }
            catch (MissingResourceException e) {
                resBundle = null;
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Error loading class: com.ibm.ws.management.bla.resources.BLANonErrorMessages, locale " + locale, e);
            }
        }
        return resBundle;
    }

    public static String getMessage(ResourceBundle bundle, String msgKey) {
        String formattedMsg = UtilHelper.getMessage(bundle, msgKey, null);
        return formattedMsg;
    }

    public static String getMessage(ResourceBundle bundle, String msgKey, Object[] args) {
        String formattedMessage = null;
        try {
            if (bundle != null) {
                String msg = bundle.getString(msgKey);
                if (msg != null) {
                    if (args != null && args.length > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Msg args: " + args);
                        }
                        MessageFormat formatter = new MessageFormat(msg, bundle.getLocale());
                        StringBuffer msgBuff = new StringBuffer();
                        formatter.format(args, msgBuff, (FieldPosition)null);
                        formattedMessage = msgBuff.toString();
                    } else {
                        formattedMessage = msg;
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event(tc, "Message key not found: " + msgKey);
                }
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "No bundle specified.  Message key: " + msgKey);
            }
        }
        catch (MissingResourceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.deploy.util.Util.getMessage", "159");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMessage: " + formattedMessage);
        }
        return formattedMessage;
    }

    public static synchronized void deleteDirTree(String dir) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        UtilHelper._deleteDirTree(new File(dir).getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(String dir, boolean followLink) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        UtilHelper._deleteDirTree(new File(dir).getCanonicalFile(), followLink);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(File dir) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        UtilHelper._deleteDirTree(dir.getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(File dir, boolean followLink) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        UtilHelper._deleteDirTree(dir.getCanonicalFile(), followLink);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    private static synchronized void _deleteDirTree(File dir, boolean followLink) throws IOException {
        if (!dir.exists()) {
            Tr.event(tc, "directory does not exist");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteDirTree");
            }
            return;
        }
        String osName = System.getProperty("os.name");
        boolean notSymLink = true;
        if (!followLink && !osName.startsWith("Windows")) {
            notSymLink = osName.equals("OS/400") ? dir.getAbsolutePath().equalsIgnoreCase(dir.getCanonicalPath()) : dir.getAbsolutePath().equals(dir.getCanonicalPath());
        }
        if (!notSymLink) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "file/dir a symlink: " + dir);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteDirTree");
            }
            return;
        }
        if (dir.isDirectory()) {
            String[] entries = dir.list();
            for (int i = 0; i < entries.length; ++i) {
                File f = new File(dir.getPath(), entries[i]);
                UtilHelper._deleteDirTree(f, followLink);
            }
        }
        if (!dir.delete()) {
            Tr.warning(tc, "ADMA0078W", dir);
        }
    }

    public static Object createFactory(String implName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFactory", new Object[]{implName});
        }
        Object factoryObject = null;
        Class<?> cls = Class.forName(implName);
        Constructor<?> cs = cls.getConstructor(new Class[0]);
        factoryObject = cs.newInstance(new Object[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFactory", new Object[]{factoryObject});
        }
        return factoryObject;
    }

    public static ObjectName completeObjectName(String s, String primKey) throws MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeObjectName: " + s + ", key=" + primKey);
        }
        String str = s;
        ObjectName retVal = null;
        try {
            retVal = new ObjectName(str);
        }
        catch (MalformedObjectNameException moex) {
            if (str.indexOf(61) == -1) {
                str = primKey + "=" + str;
            }
            if (!str.startsWith("WebSphere:")) {
                str = "WebSphere:" + str;
            }
            try {
                retVal = new ObjectName(str);
            }
            catch (MalformedObjectNameException moex1) {
                throw new MalformedObjectNameException(UtilHelper.getMessage(UtilHelper.getBundle(DEFAULT_BUNDLE_NAME, null), "CWWMH0100E", new Object[]{s}));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeObjectName: " + retVal);
        }
        return retVal;
    }

    public static VariableMap createVarMap(String configRoot, String cellName, String nodeName, String processName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVarMap");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConfigRoot: " + configRoot + ", " + "CellName: " + cellName + ", " + "NodeName: " + nodeName + ", " + "ProcName: " + processName);
        }
        Repository repository2 = RepositoryFactory.createRepository("ws-server", configRoot, cellName, nodeName, processName);
        VariableMap map = VariableMapFactory.createVariableMap(repository2);
        map.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + map);
        }
        return map;
    }

    public static VariableMap createVarMap(ConfigRepository repository2, String cellName, String nodeName) throws Exception {
        String cRoot = (String)repository2.getConfig().get("was.repository.root");
        VariableMap map = UtilHelper.createVarMap(cRoot, cellName, nodeName, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + map);
        }
        return map;
    }

    public static String getAssetDisplayURI(String assetPath) {
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAssetDisplayURI", new Object[]{assetPath});
        }
        if (UtilHelper.isEmpty(assetPath)) {
            return assetPath;
        }
        String tempFileNameSeparator = "__###__";
        File file = new File(assetPath);
        String assetName = file.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "asset name is " + assetName);
        }
        if ((index = assetName.indexOf(tempFileNameSeparator)) >= 0) {
            assetName = file.getName().substring(index + tempFileNameSeparator.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "after removing separator, asset name is " + assetName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAssetDisplayURI", new Object[]{assetName});
        }
        return assetName;
    }

    public static String getShortName(ObjectName objName, String key) {
        String ret;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getShortName", new Object[]{objName, key});
            }
            ret = objName.toString();
            try {
                ObjectName obj = new ObjectName("WebSphere", key, objName.getKeyProperty(key));
                ret = obj.toString();
            }
            catch (MalformedObjectNameException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "invalid objName " + objName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getShortName: " + ret);
        }
        return ret;
    }
}

