/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.bla.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.wsspi.management.bla.model.AssetSpec;
import com.ibm.wsspi.management.bla.model.BLA;
import com.ibm.wsspi.management.bla.model.BLASpec;
import com.ibm.wsspi.management.bla.model.CompositionUnitIn;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import com.ibm.wsspi.management.bla.op.OperationContext;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityUtilHelper {
    private static TraceComponent _tc = Tr.register(SecurityUtilHelper.class, "BLA", "com.ibm.ws.management.bla.resources.BLAMessages");
    private static final String MODEL_IMPL_NAME = "com.ibm.ws.management.bla.util.SecurityUtilHelperImpl";
    private static SecurityUtilHelper _factory = null;

    public static synchronized SecurityUtilHelper getSingleton() throws OpExecutionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getSingleton");
        }
        if (_factory == null) {
            try {
                _factory = (SecurityUtilHelper)UtilHelper.createFactory(MODEL_IMPL_NAME);
            }
            catch (Exception ex) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Exception in SecurityUtilHelperImpl.getSingleton()", ex);
                }
                FFDCFilter.processException(ex, "SecurityUtilHelperImpl.getSingleton", "45");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getSingleton", new Object[]{_factory});
        }
        return _factory;
    }

    public static String getCellDocURI(String cellName) {
        return "cells/" + cellName;
    }

    public static String getBLADocURI(String cellName, String blaName) {
        return "cells/" + cellName + "/" + "blas" + "/" + blaName;
    }

    public static String getAssetDocURI(String cellName, String assetName) {
        return "cells/" + cellName + "/" + "assets" + "/" + assetName;
    }

    public static String getClusterDocURI(String cellName, String clusterName) {
        return "cells/" + cellName + "/clusters/" + clusterName;
    }

    public static String getServerDocURI(String cellName, String nodeName, String serverName) {
        return "cells/" + cellName + "/nodes/" + nodeName + "/servers/" + serverName;
    }

    public abstract boolean checkCellLevelAdminAccess(String var1);

    public abstract boolean checkBLALevelAdminAccess(String var1, String var2);

    public abstract boolean checkAdminAccessBLA(String var1, String var2, String var3);

    public abstract boolean checkAssetLevelAdminAccess(String var1, String var2);

    public abstract boolean checkAdminAccessAsset(String var1, String var2, String var3);

    public abstract boolean checkAdminAccess(String var1, String var2);

    public abstract void checkTargetAccess(BLA var1, String var2, OperationContext var3, Vector<String> var4) throws OpExecutionException;

    public abstract String convertTarget2URI(ObjectName var1, String var2);

    public abstract void blaFG_Cell_ConfiguratororCell_Deployer(OperationContext var1, String var2) throws OpExecutionException;

    public abstract void blaFG_CellorAsset_Monitor(AssetSpec var1, OperationContext var2) throws OpExecutionException;

    public abstract void blaFG_Cell_ConfiguratororCell_DeployerorAsset_Deployer(AssetSpec var1, OperationContext var2, String var3) throws OpExecutionException;

    public abstract void blaFG_CellorBla_Monitor(BLASpec var1, OperationContext var2) throws OpExecutionException;

    public abstract void blaFG_Cell_ConfiguratororCell_DeployerorBla_Deployer(BLASpec var1, OperationContext var2, String var3) throws OpExecutionException;

    public abstract void blaFG_CellorBLAorTargetAndDeployerorOperator(BLA var1, OperationContext var2) throws OpExecutionException;

    public abstract void blaFG_Cell_ConfiguratororCell_DeployerorBla_DeployerTarget_Deployers(Vector<String> var1, OperationContext var2) throws OpExecutionException;

    public abstract void blaFG_CellDeployerorCellConfiguratororBlaDeployerTargetDeployers(List<CompositionUnitIn> var1, OperationContext var2) throws Exception;

    public abstract void blaFG_add_editCU(Vector<String> var1, OperationContext var2, String var3, Object var4, String var5) throws OpExecutionException;

    public abstract List<String> listBLAs(String var1) throws OpExecutionException;

    public abstract List<String> listAssets(String var1) throws OpExecutionException;

    public abstract List<String> listBLAs(List<String> var1, String var2) throws OpExecutionException;

    public abstract List<String> listAssets(List<String> var1, String var2) throws OpExecutionException;
}

