/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.client.ResourceValidationHelper;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.WebModule;

public class ValidateResourceTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(ValidateResourceTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    protected static AppdeploymentFactory appFactory;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        ResourceValidationHelper resValHelper = null;
        try {
            Hashtable tbl = this.scheduler.getProperties();
            String validateValue = (String)tbl.get("validateinstall");
            WorkSpace ws = this.scheduler.getWorkSpace();
            String cellName = this.scheduler.getCellContext().getName();
            EARFile earFile = this.scheduler instanceof InstallScheduler ? ((InstallScheduler)this.scheduler).getEarFile(false, true) : ((EditScheduler)this.scheduler).getEarFile();
            String ear = earFile.getURI();
            tbl.put("earfile", earFile);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tbl " + tbl);
            }
            resValHelper = new ResourceValidationHelper(ear, ws.getUserName(), tbl, "resource.mapper.app.validation.op", true);
            Vector msgs = resValHelper.appResourceValidation();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < msgs.size(); ++i) {
                String error = (String)msgs.elementAt(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error " + error);
                }
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Warning", error, null));
                b.append("\n" + error);
            }
            Vector msg2 = this.checkDuplicateWebContext(earFile, ws);
            if (msg2.size() != 0) {
                msgs.addAll(msg2);
            }
            if (msgs.size() > 0 && "fail".equals(validateValue)) {
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA5059E", new Object[]{this.scheduler.getAppName(), b.toString()}));
            }
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", msgs.size() > 0 ? "ADMA5068I" : "ADMA5067I", new Object[]{this.scheduler.getAppName()}));
            boolean bl = true;
            Object var13_16 = null;
            if (resValHelper != null) {
                resValHelper.close();
            }
            return bl;
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "performTask", "150", this);
                if (th instanceof AdminException) {
                    this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", th.getMessage(), null));
                    throw (AdminException)th;
                }
                String msg = AppUtils.getMessage(this.getResourceBundle(), "ADMA5060E", new String[]{this.scheduler.getAppName(), th.toString()});
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", msg, null));
                throw new AdminException(th, msg);
            }
            catch (Throwable throwable) {
                block12: {
                    Object var13_17 = null;
                    if (resValHelper == null) break block12;
                    resValHelper.close();
                }
                throw throwable;
            }
        }
    }

    private Vector checkDuplicateWebContext(EARFile earFile, WorkSpace ws) {
        Vector<String> msgs = new Vector<String>();
        String appName = this.scheduler.getAppName();
        Hashtable props = this.scheduler.getProperties();
        if (appFactory == null) {
            AppdeploymentPackage apppkg = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            appFactory = apppkg.getAppdeploymentFactory();
        }
        try {
            RepositoryContext _cellC = this.scheduler.getCellContext();
            EList mlist = earFile.getModuleRefs();
            String duri = "WEB-INF/web.xml";
            ModuleRef mf = null;
            Hashtable<String, Hashtable> nodes = new Hashtable<String, Hashtable>(10);
            for (int i = 0; i < mlist.size(); ++i) {
                Hashtable tbl;
                ArrayList wlist = new ArrayList(10);
                mf = (ModuleRef)mlist.get(i);
                if (!mf.isWeb()) continue;
                WebModule web = (WebModule)mf.getModule();
                ArrayList el = new ArrayList(3);
                String muri = web.getUri();
                WebAppBinding bnd = (WebAppBinding)mf.getBindings();
                if (bnd == null) continue;
                String vHost = bnd.getVirtualHostName();
                String croot = web.getContextRoot();
                String mkey = vHost + "+" + croot;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "croot = " + croot + "vhost=" + vHost);
                }
                if ((tbl = (Hashtable)this.scheduler.getProperties().get("moduleToServer")) == null) {
                    return msgs;
                }
                String key = util.createUniqueModuleName(duri, muri);
                String targets = this.getTargets(tbl, key, muri);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "key: " + key + " .. targets: " + targets);
                }
                Vector tlist = ConfigRepoHelper.getServerNames(targets, key, this.scheduler.getCellContext(), ws);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tlist: " + tlist);
                }
                Vector svrs = new Vector();
                svrs = this.getServersForModule(tlist, _cellC, ws, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "svrs: " + svrs);
                }
                Hashtable allNodes = ConfigRepoHelper.getNodeServerRelation(ws, svrs);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "allNodes: " + allNodes);
                }
                nodes.put(mkey, allNodes);
            }
            Enumeration en = nodes.keys();
            while (en.hasMoreElements()) {
                String ckey = (String)en.nextElement();
                Hashtable h = (Hashtable)nodes.get(ckey);
                String[] keys = ckey.split("\\+");
                String vHost = keys[0];
                String croot = "";
                if (keys.length > 1) {
                    croot = keys[1];
                }
                Enumeration nen = h.keys();
                while (nen.hasMoreElements()) {
                    RepositoryContext rCtx = (RepositoryContext)nen.nextElement();
                    String nName = rCtx.getName();
                    URI uri = URI.createURI("serverindex.xml");
                    Resource res = rCtx.getResourceSet().createResource(uri);
                    HashMap options = new HashMap();
                    res.load(options);
                    if (res == null || res.getContents().size() == 0) continue;
                    ServerIndex top = (ServerIndex)res.getContents().get(0);
                    EList entries = top.getServerEntries();
                    for (int i = 0; i < entries.size(); ++i) {
                        ServerEntry entry = (ServerEntry)entries.get(i);
                        EList appList = entry.getDeployedApplications();
                        for (int an = 0; an < appList.size(); ++an) {
                            int lastIndex;
                            String dName = (String)appList.get(an);
                            String aName = dName.substring((lastIndex = dName.lastIndexOf(47)) + 1);
                            if (aName.equals(appName)) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "The same application " + aName + " skip this");
                                continue;
                            }
                            RepositoryContext apc = AppUtils.findAppContextFromConfig(aName, ws, props);
                            if (apc == null) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Error getting rc for application " + dName);
                                continue;
                            }
                            ApplicationDeployment appDepl2 = ConfigRepoHelper.getAppDeploymentForApp(apc);
                            EARFile earFile2 = ConfigRepoHelper.getEarFileFromDeployment(ws, apc);
                            EList mds2 = appDepl2.getModules();
                            EList mlist2 = earFile2.getModuleRefs();
                            for (int j = 0; j < mlist2.size(); ++j) {
                                String tvHost;
                                mf = (ModuleRef)mlist2.get(j);
                                if (!mf.isWeb()) continue;
                                WebModule web = (WebModule)mf.getModule();
                                String muri = web.getUri();
                                String tcroot = web.getContextRoot();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "module = " + muri + " Context root  = " + tcroot);
                                }
                                if (!croot.equals(tcroot)) continue;
                                ModuleDeployment md2 = null;
                                boolean found = false;
                                for (int k = 0; k < mds2.size(); ++k) {
                                    md2 = (ModuleDeployment)mds2.get(k);
                                    if (!md2.getUri().equals(muri)) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) continue;
                                WebModuleDeployment webm = (WebModuleDeployment)md2;
                                EList mappings = webm.getTargetMappings();
                                WebAppBinding bnd = (WebAppBinding)mf.getBindings();
                                if (bnd == null || !(tvHost = bnd.getVirtualHostName()).equals(vHost) || !tcroot.equals(croot)) continue;
                                DeploymentTargetMapping map = null;
                                for (int k = 0; k < mappings.size(); ++k) {
                                    map = (DeploymentTargetMapping)mappings.get(k);
                                    DeploymentTarget t = map.getTarget();
                                    Vector not = new Vector(0);
                                    Vector svrs = ConfigRepoHelper.getServersForModuleDeployment(webm, not, _cellC, ws, true);
                                    Hashtable allNodes = ConfigRepoHelper.getNodeServerRelation(ws, svrs);
                                    Enumeration nlist = allNodes.keys();
                                    while (nlist.hasMoreElements()) {
                                        RepositoryContext nodeCtx = (RepositoryContext)nlist.nextElement();
                                        if (!nodeCtx.getName().equals(nName)) continue;
                                        String error = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0159W", new Object[]{tcroot, nName, vHost});
                                        msgs.addElement(error);
                                        this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Warning", error, null));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "checkDuplicateWebContext", "335", this);
            if (th instanceof AdminException) {
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", th.getMessage(), null));
            }
            String ms = AppUtils.getMessage(this.getResourceBundle(), "ADMA5060E", new String[]{this.scheduler.getAppName(), th.toString()});
            this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", ms, null));
        }
        return msgs;
    }

    private Vector getServersForModule(Vector targetList, RepositoryContext cellContext, WorkSpace ws, boolean includeClusterMembers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModule");
        }
        Vector<RepositoryContext> retVal = new Vector<RepositoryContext>();
        ArrayList<DeploymentTargetMapping> mappings = new ArrayList<DeploymentTargetMapping>(10);
        try {
            for (int i = 0; i < targetList.size(); i += 2) {
                RepositoryContext rc = (RepositoryContext)targetList.elementAt(i);
                String config = (String)targetList.elementAt(i + 1);
                DeploymentTarget target = ValidateResourceTask.createTarget(rc, appFactory);
                DeploymentTargetMapping mapping = appFactory.createDeploymentTargetMapping();
                mapping.setTarget(target);
                mappings.add(mapping);
            }
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "getServersForModule", "376", this);
        }
        for (int j = 0; j < mappings.size(); ++j) {
            DeploymentTarget t = ((DeploymentTargetMapping)mappings.get(j)).getTarget();
            if (t == null) continue;
            if (t instanceof ClusteredTarget) {
                RepositoryContext rc = AppUtils.findContext("clusters", t.getName(), null, cellContext, ws, true);
                if (rc == null) continue;
                if (!retVal.contains(rc)) {
                    retVal.addElement(rc);
                }
            }
            if (!(t instanceof ServerTarget)) continue;
            String nodeName = ((ServerTarget)t).getNodeName();
            RepositoryContext rc = AppUtils.findContext("servers", t.getName(), nodeName, cellContext, ws, false);
            if (rc == null) continue;
            if (!includeClusterMembers && AppUtils.getClusterFromMember(AppUtils.findContext("servers", t.getName(), nodeName, cellContext, ws, false), ws) != null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Ignoring  cluster member: " + t.getName());
                continue;
            }
            if (retVal.contains(rc)) continue;
            retVal.addElement(rc);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server for depl: " + retVal);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModule");
        }
        return retVal;
    }

    private static DeploymentTarget createTarget(RepositoryContext rc, AppdeploymentFactory appFactory) throws Exception {
        DeploymentTarget target = null;
        target = AppUtils.isCluster(rc) ? appFactory.createClusteredTarget() : appFactory.createServerTarget();
        target.setName(rc.getName());
        if (target instanceof ServerTarget) {
            ((ServerTarget)target).setNodeName(rc.getParent().getName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created target: " + target);
        }
        return target;
    }

    private String getTargets(Hashtable tbl, String key, String mURI) {
        String targets = (String)tbl.get(key);
        if (targets != null) {
            return targets;
        }
        int index = mURI.lastIndexOf(46);
        if (index != -1 && (targets = (String)tbl.get("*" + mURI.substring(index))) != null) {
            return targets;
        }
        return (String)tbl.get("*");
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/ValidateResourceTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.13");
        }
        CLASS_NAME = ValidateResourceTask.class.getName();
    }
}

