/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.DownloadFile;
import com.ibm.websphere.management.cmdframework.UploadFile;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropBasedConfigTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(PropBasedConfigTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    @Override
    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            block23: {
                EARFile earFile = null;
                if (this.scheduler instanceof InstallScheduler || this.scheduler instanceof EditScheduler) {
                    EARFile eARFile = earFile = this.scheduler instanceof InstallScheduler ? ((InstallScheduler)this.scheduler).getEarFile(false, true) : ((EditScheduler)this.scheduler).getEarFile();
                    if (earFile.containsFile("META-INF/ibm-was-config.props")) {
                        InputStream is = earFile.getFile("META-INF/ibm-was-config.props").getInputStream();
                        this.callPropertyBasedConfig(this.scheduler.getProperties(), is);
                        is.close();
                    }
                } else if (this.scheduler instanceof UpdateScheduler) {
                    UpdateScheduler ush = (UpdateScheduler)this.scheduler;
                    if (ush == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "UpdateScheduler is NULL!!!");
                        }
                    } else {
                        if (ush.getContentType() == null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "UpdateScheduler contentType is NULL!!!");
                        }
                        boolean isDeleteOp = false;
                        if (ush.getOperation() != null && ush.getOperation().equalsIgnoreCase("delete")) {
                            isDeleteOp = true;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "UpdateScheduler operation is NULL!!!");
                        }
                        if (!ush.getContentType().equals("modulefile") && !isDeleteOp) {
                            RepositoryContext rc = AppUtils.findAppContextFromConfig(ush.getAppName(), ush.getWorkSpace(), ush.getProperties());
                            try {
                                earFile = ConfigRepoHelper.getEarFileForApp(ush.getWorkSpace(), rc, this.getResourceBundle(), true);
                                if (earFile.containsFile("META-INF/ibm-was-config.props")) {
                                    InputStream is = earFile.getFile("META-INF/ibm-was-config.props").getInputStream();
                                    this.callPropertyBasedConfig(this.scheduler.getProperties(), is);
                                    is.close();
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Update archive doesn't have META-INF/ibm-was-config.props file in it");
                                }
                            }
                            catch (Exception ex) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "RECEIVED following EXCEPTION in PropBasedConfigTask", ex);
                                }
                                if (!tc.isDebugEnabled()) break block23;
                                Tr.debug(tc, "If the ear file has ibm-was-config.props file then none of the properties in the file will be applied during this update because we can't find the earFile.", ex);
                            }
                        }
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "performTask", "136", this);
            if (th instanceof AdminException) {
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", th.getMessage(), null));
                throw (AdminException)th;
            }
            String msg = AppUtils.getMessage(this.getResourceBundle(), "ADMA5057E", new String[]{th.toString()});
            this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", msg, null));
            throw new AdminException(th, msg);
        }
    }

    private void callPropertyBasedConfig(Hashtable<?, ?> tbl, InputStream is) throws Throwable {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "callPropertyBasedConfig()", tbl);
        }
        if (tbl != null) {
            Object obj = tbl.get("PropertyBasedConfigHelper");
            if (obj != null) {
                if (obj instanceof Hashtable) {
                    Hashtable pConfigTbl = (Hashtable)obj;
                    this.callApplyConfigPropTask(is, pConfigTbl);
                }
            } else {
                this.callApplyConfigPropTask(is, null);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "callPropertyBasedConfig()");
        }
    }

    private void callApplyConfigPropTask(InputStream is, Hashtable<?, ?> pConfigTbl) throws Throwable {
        block17: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "callApplyConfigPropTask()", new Object[]{is, pConfigTbl});
            }
            Session session = new Session(this.scheduler.getWorkSpace().getUserName(), true);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            try {
                try {
                    CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                    AdminCommand aCmd = cmdMgr.createCommand("applyConfigProperties");
                    aCmd.setConfigSession(session);
                    File file = File.createTempFile("ibm-was-config", ".properties");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load following file!!:  ", file.getAbsolutePath());
                    }
                    AppUtils.copyFile(is, file.getAbsolutePath());
                    String path = file.getAbsolutePath().replace("\\", "/");
                    if (path == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exit without calling property based config.");
                        }
                        aCmd.dispose();
                        Object var12_10 = null;
                        return;
                    }
                    aCmd.setParameter("propertiesFileName", new UploadFile(path));
                    if (pConfigTbl != null && pConfigTbl.containsKey("variableMap")) {
                        HashMap vMap = (HashMap)pConfigTbl.get("variableMap");
                        Properties props = new Properties();
                        props.putAll((Map<?, ?>)vMap);
                        aCmd.setParameter("variablesMap", props);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "variabled value for prop based config:  ", props);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        DownloadFile df = new DownloadFile(file.getParentFile().getAbsolutePath() + File.separator + "applyConfig.log");
                        Tr.debug(tc, "Generating reportFile @:  ", df);
                        aCmd.setParameter("reportFileName", df);
                        aCmd.setParameter("reportFilterMechanism", "All");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Before execute:  ");
                    }
                    aCmd.execute();
                    Object cmdRes = aCmd.getCommandResult().getResult();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Return from propBasedConfig:  ", cmdRes);
                    }
                    if (!aCmd.getCommandResult().isSuccessful()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Command was unsuccessful as isSuccessful returns false:", cmdRes);
                        }
                        throw new AdminException("Command applyConfigProperties was unsuccessful.");
                    }
                    if (tc.isDebugEnabled()) break block17;
                    file.delete();
                }
                catch (Throwable th) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Received following Exception: ", th);
                    }
                    throw th;
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                throw throwable;
            }
        }
        Object var12_11 = null;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "callApplyConfigPropTask()");
        }
    }

    private String createTempPropfile(File file, InputStream is) {
        String path;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createTempPropfile()");
            }
            path = null;
            try {
                FileOutputStream out;
                if (file.canWrite()) {
                    int i;
                    out = new FileOutputStream(file);
                    while ((i = is.read()) != -1) {
                        ((OutputStream)out).write(i);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cannot write to this location!!!");
                    }
                    throw new AdminException("Error in writing to temp file, user system configuration error.");
                }
                ((OutputStream)out).close();
                path = file.getAbsolutePath();
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception caught!!!", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTempPropfile()", path);
        }
        return path;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/PropBasedConfigTask.java, WAS.admin.appmgmt, WAS70.SERV1, cf050925.09, ver. 1.5");
        }
        CLASS_NAME = PropBasedConfigTask.class.getName();
    }
}

