/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.NestedArchiveIterator;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(MetadataTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final String METADATA_PATTERN = "META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*";
    public static final String THISDIR_PATTERN = "/[^/]*";
    public static final String WHOLEDIR_PATTERN = "/.*";
    public static final String DelModules = "MetadataTask.deletedMods";
    public static final String AddedModules = "MetadataTask.addedMods";

    @Override
    public boolean performTask() throws AdminException {
        boolean bl;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "performTask");
            }
            Archive localear = null;
            try {
                RepositoryContext appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
                if (this.scheduler instanceof InstallScheduler) {
                    List l = MetadataTask.saveEarConfigDocs(appContext.getPath(), ((InstallScheduler)this.scheduler).getEarFile(false, true), this.getResourceBundle());
                    Hashtable ejbBndTbl = (Hashtable)this.scheduler.getProperties().get("EJBBindingFile");
                    if (ejbBndTbl != null) {
                        AppUtils.dbg(tc, "Hashtable recevied for EJBBindingFileTask:  \n  size: " + ejbBndTbl.size() + "\n  content:" + ejbBndTbl);
                        this.processBindingInfo(appContext.getPath(), ejbBndTbl, l);
                    } else {
                        AppUtils.dbg(tc, "Nothing to do for EJBBindingFileTask!!  Returned: NULL");
                    }
                    appContext.notifyChanged(0, l);
                    this.checkForMarkerFileInWebModule(((InstallScheduler)this.scheduler).getEarFile(false, true), appContext);
                } else if (this.scheduler instanceof UpdateScheduler) {
                    localear = ConfigRepoHelper.getEarFileFromBinaries(appContext, this.scheduler.getWorkSpace(), this.getResourceBundle(), true);
                    this.updateDeploymentFromPartialEar(appContext, (EARFile)localear);
                }
                AppNotification appNotify = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
                this.scheduler.propagateTaskEvent(appNotify);
                if (appContext.isAvailable("META-INF/ibm-application-ha.props")) {
                    AppUtils.dbg(tc, "hidden app flag found from MetadataTask");
                    appNotify = this.createNotification("Completed", "ADMA5110I", new String[]{this.scheduler.getAppName()});
                    this.scheduler.propagateTaskEvent(appNotify);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "performTask");
                }
                bl = true;
                Object var6_7 = null;
                if (localear == null) break block14;
            }
            catch (Throwable th) {
                try {
                    RasUtils.logException(th, tc, CLASS_NAME, "performTask", "156", this);
                    this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), th.toString()}));
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (localear != null) {
                        localear.close();
                    }
                    this.scheduler.getProperties().remove(DelModules);
                    this.scheduler.getProperties().remove(AddedModules);
                    throw throwable;
                }
            }
            localear.close();
        }
        this.scheduler.getProperties().remove(DelModules);
        this.scheduler.getProperties().remove(AddedModules);
        return bl;
    }

    private void processBindingInfo(String strCRoot, Hashtable ejbBndTbl, List l) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processBindingInfo", ejbBndTbl);
        }
        Hashtable data = new Hashtable();
        Enumeration enumList = ejbBndTbl.keys();
        while (enumList.hasMoreElements()) {
            String strWSUri;
            String strDest;
            String modName = (String)enumList.nextElement();
            AppUtils.dbg(tc, "Processing ModuleName: " + modName);
            data = (Hashtable)ejbBndTbl.get(modName);
            String currUri = (String)data.get("current.uri");
            String destUri = (String)data.get("default.destination.uri");
            AppUtils.dbg(tc, "currUri:  " + currUri);
            AppUtils.dbg(tc, "destUri:  " + destUri);
            if (currUri == null || currUri.trim().equals("")) {
                AppUtils.dbg(tc, "Skip module:  " + modName);
                continue;
            }
            File bndFile = new File(currUri = currUri.replace("\\", "/"));
            if (!bndFile.exists()) {
                throw new FileNotFoundException(AppUtils.getMessage(this.getResourceBundle(), "ADMA9004E", new Object[]{currUri}));
            }
            destUri = destUri.replace("\\", "/");
            AppUtils.dbg(tc, "Destination Uri after path conversion:  " + destUri);
            if (destUri.startsWith("./")) {
                destUri = destUri.substring(2, destUri.length());
                AppUtils.dbg(tc, "Destination Uri:  " + destUri);
            }
            if (destUri.endsWith("/")) {
                destUri = destUri.substring(0, destUri.length() - 1);
            }
            AppUtils.dbg(tc, "appName from scheduler:  " + this.scheduler.getAppName());
            if (modName.equals(this.scheduler.getAppName())) {
                AppUtils.dbg(tc, "App level binding information.");
                strDest = strCRoot + File.separator + destUri;
                strWSUri = destUri;
            } else {
                AppUtils.dbg(tc, "Module level bnding information");
                strDest = strCRoot + File.separator + modName + File.separator + destUri;
                strWSUri = modName + "/" + destUri;
            }
            strDest = strDest.replace("\\", "/");
            File loc = new File(strDest);
            if (!loc.exists()) {
                throw new FileNotFoundException(AppUtils.getMessage(this.getResourceBundle(), "ADMA9003E", new Object[]{destUri}));
            }
            String fileName = currUri.substring(currUri.lastIndexOf("/"));
            AppUtils.copyFile(new File(currUri), strDest + fileName);
            l.add(strWSUri + fileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processBindingInfo");
        }
    }

    private void updateDeploymentFromPartialEar(RepositoryContext _appC, EARFile ear) throws Exception {
        int i;
        int i2;
        boolean updated;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentFromPartialEar");
        }
        _appC.extract(false);
        String root = _appC.getPath() + "/";
        UpdateScheduler sch = (UpdateScheduler)this.scheduler;
        String exDir = AppUtils.getAppTempExtractDir(sch);
        List delFiles = (List)this.scheduler.getProperties().get("DeltaDataTask.DelFiles");
        List delM = (List)this.scheduler.getProperties().get(DelModules);
        List addM = (List)this.scheduler.getProperties().get(AddedModules);
        AppUtils.dbg(tc, "delFiles: " + delFiles);
        AppUtils.dbg(tc, "delM: " + delM);
        AppUtils.dbg(tc, "addM: " + addM);
        String remove_pattern = "";
        if (sch.getContentType().equals("modulefile") && (updated = this.updateAppDDInDeployment(ear, delM, addM, _appC))) {
            _appC.notifyChanged(1, "META-INF/application.xml");
        }
        for (i2 = 0; i2 < delFiles.size(); ++i2) {
            remove_pattern = remove_pattern.equals("") ? (String)delFiles.get(i2) : remove_pattern + "|" + delFiles.get(i2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pattern for remove loose: " + remove_pattern);
        }
        if (delM != null) {
            for (i2 = 0; i2 < delM.size(); i2 += 2) {
                String mURI = (String)delM.get(i2);
                String alt = (String)delM.get(i2 + 1);
                if (!this.hasModule(ear, mURI)) {
                    mURI = mURI + WHOLEDIR_PATTERN;
                    String string = remove_pattern = remove_pattern.equals("") ? mURI : remove_pattern + "|" + mURI;
                }
                if (AppUtils.isEmpty(alt)) continue;
                remove_pattern = remove_pattern.equals("") ? alt : remove_pattern + "|" + alt;
                remove_pattern = remove_pattern + "|ALT-INF/" + delM.get(i2) + WHOLEDIR_PATTERN;
            }
        }
        AppUtils.dbg(tc, "Pattern for remove loose and mod: " + remove_pattern);
        if (!AppUtils.isEmpty(remove_pattern)) {
            ArrayList<String> toDelete = new ArrayList<String>();
            for (String f : _appC.getFiles()) {
                if (!f.matches(remove_pattern)) continue;
                AppUtils.dbg(tc, "Delete file: " + f);
                toDelete.add(f);
            }
            AppUtils.dbg(tc, "Delete files: " + toDelete);
            if (toDelete.size() > 0) {
                _appC.notifyChanged(2, toDelete);
            }
        }
        String looseAddPat = METADATA_PATTERN;
        EList l = ear.getModuleRefs();
        for (int i3 = 0; i3 < l.size(); ++i3) {
            ModuleRef mRef = (ModuleRef)l.get(i3);
            if (mRef.getAltDeploymentDescriptor() == null) continue;
            String alt = mRef.getAltDeploymentDescriptor().eResource().getURI().toString();
            String altDir = mRef.getAltRoot();
            looseAddPat = looseAddPat + "|" + alt + "|" + altDir + WHOLEDIR_PATTERN;
        }
        AppUtils.dbg(tc, "Loose add pattern: " + looseAddPat);
        EList rootFiles = ear.getFiles();
        for (i = 0; i < rootFiles.size(); ++i) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File file = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)rootFiles.get(i);
            if (!file.getURI().matches(looseAddPat) || _appC.isAvailable(file.getURI()) && !new File(exDir + "/" + file.getURI()).exists()) continue;
            String dest = _appC.getPath() + "/" + file.getURI();
            AppUtils.dbg(tc, "root file to be copied: " + file.getURI() + " to " + dest);
            AppUtils.copyFile(ear.getInputStream(file.getURI()), dest);
            if (_appC.isAvailable(file.getURI())) {
                _appC.notifyChanged(1, file.getURI());
                continue;
            }
            _appC.notifyChanged(0, file.getURI());
        }
        l = ear.getModuleRefs();
        for (i = 0; i < l.size(); ++i) {
            boolean partial;
            ModuleRef mRef = (ModuleRef)l.get(i);
            File updateModule = new File(exDir + "/" + mRef.getUri());
            boolean full = addM != null && addM.contains(mRef.getUri()) || updateModule.exists() && updateModule.isFile();
            boolean bl = partial = updateModule.exists() && updateModule.isDirectory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mUri: " + mRef.getUri() + ", " + full + "," + partial);
            }
            if (full) {
                ArrayList<String> delfull = new ArrayList<String>();
                String delFullPat = mRef.getUri() + WHOLEDIR_PATTERN;
                for (String uri : _appC.getFiles()) {
                    if (!uri.matches(delFullPat)) continue;
                    delfull.add(uri);
                }
                AppUtils.dbg(tc, "del files for full module add/update: " + delfull);
                _appC.notifyChanged(2, delfull);
                ArrayList metaFiles = new ArrayList();
                MetadataTask.saveArchiveConfigDocs(mRef.getModuleFile(), METADATA_PATTERN, root, mRef.getUri(), metaFiles, this.getResourceBundle());
                _appC.notifyChanged(0, metaFiles);
                AppUtils.dbg(tc, "add files for full module add/update: " + metaFiles);
            }
            if (!partial) continue;
            List looseFiles = AppUtils.getURIs(exDir + "/" + mRef.getUri());
            for (int j = 0; j < looseFiles.size(); ++j) {
                String looseFile = (String)looseFiles.get(j);
                if (looseFile.equals("META-INF/ibm-partialapp-delete.props") || !looseFile.matches(METADATA_PATTERN)) continue;
                looseFile = mRef.getUri() + "/" + looseFile;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loose metadata file: " + looseFile);
                }
                AppUtils.dbg(tc, "Loose metadata file: " + looseFile);
                AppUtils.copyFile(new File(exDir + "/" + looseFile), root + looseFile);
                if (_appC.isAvailable(looseFile)) {
                    _appC.notifyChanged(1, looseFile);
                    continue;
                }
                _appC.notifyChanged(0, looseFile);
            }
        }
        this.checkForMarkerFileInWebModule(addM, delM, root);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentFromPartialEar");
        }
    }

    private boolean hasModule(EARFile ear, String uri) {
        EList l = ear.getModuleRefs();
        for (int i = 0; i < l.size(); ++i) {
            if (!((ModuleRef)l.get(i)).getUri().equals(uri)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateAppDDInDeployment(EARFile ear, List delM, List addM, RepositoryContext appC) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAppDDInDeployment");
        }
        Archive deplEar = null;
        boolean updated = false;
        try {
            block20: {
                try {
                    int i;
                    String appDDUri = ear.getDeploymentDescriptorUri();
                    boolean earHasAppDD = ear.containsFile(appDDUri);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ear has " + appDDUri + " : " + earHasAppDD);
                    }
                    if (!earHasAppDD || (delM == null || delM.isEmpty()) && (addM == null || addM.isEmpty())) break block20;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "modifying app DD for module type");
                    }
                    deplEar = ConfigRepoHelper.getEarFileFromDeploymentOnly(this.scheduler.getWorkSpace(), appC, false);
                    if (delM != null) {
                        ArrayList<Module> delMods = new ArrayList<Module>();
                        for (i = 0; i < delM.size(); i += 2) {
                            String mURI = (String)delM.get(i);
                            String alt = (String)delM.get(i + 1);
                            if (alt.equals("")) {
                                alt = null;
                            }
                            Module delMod = deplEar.getModule(mURI, alt);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "delMod: " + delMod);
                            }
                            if (delMod == null) throw new AdminException("Internal error in module del: no module with " + mURI + ":" + alt);
                            delMods.add(delMod);
                        }
                        for (i = 0; i < delMods.size(); ++i) {
                            deplEar.getDeploymentDescriptor().getModules().remove(delMods.get(i));
                            updated = true;
                        }
                    }
                    if (addM != null) {
                        for (int i2 = 0; i2 < addM.size(); i2 += 2) {
                            Module addMod;
                            String mURI = (String)addM.get(i2);
                            String alt = (String)addM.get(i2 + 1);
                            if (alt.equals("")) {
                                alt = null;
                            }
                            if ((addMod = ear.getModule(mURI, alt)) == null) throw new AdminException("Internal error in module add: no module with " + mURI + ":" + alt);
                            Module newMod = (Module)EtoolsCopyUtility.createCopy(addMod);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "newMod: " + newMod);
                            }
                            deplEar.getDeploymentDescriptor().getModules().add(newMod);
                            updated = true;
                        }
                    }
                    EList binRoles = ear.getDeploymentDescriptor().getSecurityRoles();
                    for (i = 0; i < binRoles.size(); ++i) {
                        SecurityRole binRole = (SecurityRole)binRoles.get(i);
                        if (deplEar.getDeploymentDescriptor().getSecurityRoleNamed(binRole.getRoleName()) == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "new role to be added: " + binRole.getRoleName());
                            }
                            SecurityRole newRole = (SecurityRole)EtoolsCopyUtility.createCopy(binRole);
                            deplEar.getDeploymentDescriptor().getSecurityRoles().add(newRole);
                            updated = true;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "role unchanged: " + binRole.getRoleName());
                    }
                    if (!updated) break block20;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Saving app DD");
                    }
                    FileOutputStream fout = new FileOutputStream(appC.getPath() + "/META-INF/application.xml");
                    deplEar.getDeploymentDescriptor().eResource().save(fout, new HashMap());
                    fout.flush();
                    fout.close();
                }
                catch (Throwable th) {
                    throw new AdminException(th, null);
                }
            }
            Object var15_18 = null;
            if (deplEar == null) return updated;
            deplEar.close();
            return updated;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            if (deplEar == null) throw throwable;
            deplEar.close();
            throw throwable;
        }
    }

    public static List saveEarConfigDocs(String resRoot, EARFile earFile, ResourceBundle resBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveEarConfigDocs");
        }
        LinkedList<String> configURI = new LinkedList<String>();
        String root = resRoot;
        if (!root.endsWith(File.separator)) {
            root = root + File.separator;
        }
        if (File.separatorChar != '/') {
            root = root.replace('/', File.separatorChar);
        }
        MetadataTask.saveArchiveConfigDocs(earFile, METADATA_PATTERN, root, null, configURI, resBundle);
        EList mRefs = earFile.getModuleRefs();
        for (int i = 0; i < mRefs.size(); ++i) {
            ModuleRef mRef = (ModuleRef)mRefs.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving docs for: " + mRef.getUri());
            }
            MetadataTask.saveArchiveConfigDocs(mRef.getModuleFile(), METADATA_PATTERN, root, mRef.getUri(), configURI, resBundle);
            if (mRef.getAltDeploymentDescriptor() == null) continue;
            String altURI = mRef.getAltDeploymentDescriptor().eResource().getURI().toString();
            InputStream is = earFile.getInputStream(altURI);
            MetadataTask.save2File(is, root + altURI, resBundle);
            is.close();
            configURI.add(altURI);
            String altBndURI = mRef.getAltBindings().eResource().getURI().toString();
            String altBndDir = altBndURI.substring(0, altBndURI.lastIndexOf(47));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving alt docs from : " + altURI + " and binding: " + altBndDir);
            }
            MetadataTask.saveArchiveConfigDocs(earFile, altBndDir + THISDIR_PATTERN, root, null, configURI, resBundle);
        }
        return configURI;
    }

    public static void saveArchiveConfigDocs(Archive archive, String pattern, String root, String offset, List configURI, ResourceBundle resBundle) throws Exception {
        String path = root;
        if (offset != null) {
            path = path + offset + File.separator;
        }
        FileIterator anIterator = null;
        anIterator = archive.getLoadStrategy().getFileIterator();
        while (anIterator != null && anIterator.hasNext()) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File nextFile = anIterator.next();
            if (nextFile instanceof Container || nextFile.isSetDirectoryEntry() && nextFile.isDirectoryEntry()) continue;
            String fName = nextFile.getURI();
            if (!(fName = fName.replace('\\', '/')).matches(pattern)) continue;
            String wURI = (offset == null ? "" : offset + "/") + fName;
            if (configURI.contains(wURI)) continue;
            InputStream nextInputStream = anIterator.getInputStream(nextFile);
            MetadataTask.save2File(nextInputStream, path + fName, resBundle);
            nextInputStream.close();
            AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6016I", new Object[]{wURI}));
            configURI.add(wURI);
        }
        if (anIterator != null && anIterator instanceof NestedArchiveIterator) {
            ((NestedArchiveIterator)anIterator).close();
        }
    }

    static void save2File(InputStream is, String uri, ResourceBundle resBundle) throws Exception {
        byte[] bar;
        int bRead;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save2File");
        }
        FileOutputStream os2 = MetadataTask.getFOStream(uri);
        int avail = is.available();
        while (avail > 0 && (bRead = is.read(bar = new byte[avail])) >= 1) {
            os2.write(bar, 0, bRead);
            avail = is.available();
        }
        os2.flush();
        os2.close();
        AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6017I", new Object[]{uri}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save2File");
        }
    }

    static void save2File(Resource res, String uri, ResourceBundle resBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save2File: " + res);
        }
        FileOutputStream os2 = MetadataTask.getFOStream(uri);
        res.save(os2, new HashMap());
        os2.flush();
        os2.close();
        AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6017I", new Object[]{uri}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save2File");
        }
    }

    private static FileOutputStream getFOStream(String uri) throws Exception {
        String name = uri;
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        File file = new File(name);
        FileOutputStream os2 = null;
        try {
            file.getParentFile().mkdirs();
            os2 = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            MetadataTask.checkURILength(file.getAbsolutePath());
            throw e;
        }
        return os2;
    }

    public static void checkURILength(String uri) throws IOException {
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().indexOf("windows") >= 0 && uri.length() > 259) {
            throw new IOException("URI length is greater than Windows limit of 259 characters. " + uri);
        }
    }

    private void checkForMarkerFileInWebModule(List<String> addModuleList, List<String> delModuleList, String deployCtxRoot) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForMarkerFileInWebModule", new Object[]{addModuleList, delModuleList, deployCtxRoot});
        }
        AppUtils.checkForMarkerFileInWebModule("create.merker.file", delModuleList, deployCtxRoot);
        AppUtils.checkForMarkerFileInWebModule("delete.merker.file", addModuleList, deployCtxRoot);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFormMarkerFileInWebModule");
        }
    }

    private void checkForMarkerFileInWebModule(EARFile earFile, RepositoryContext appContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFormMarkerFileInWebModule", new Object[]{earFile, appContext});
        }
        ArrayList<String> matchWebModsList = new ArrayList<String>();
        List<String> webModsList = AppUtils.getListWebModulesFromAppCtx(appContext);
        List warFiles = earFile.getWARFiles();
        for (WARFile warFile : warFiles) {
            String name = warFile.getName();
            AppUtils.dbg(tc, "webmodule: " + name);
            if (!webModsList.contains(name)) continue;
            AppUtils.dbg(tc, "adding: " + name);
            matchWebModsList.add(name);
        }
        AppUtils.dbg(tc, "List of matching web modules: " + matchWebModsList);
        AppUtils.checkForMarkerFileInWebModule("delete.merker.file", matchWebModsList, appContext.getPath() + "/");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFormMarkerFileInWebModule");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/MetadataTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.21.2.16");
        }
        CLASS_NAME = MetadataTask.class.getName();
    }
}

