/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUpdate;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.security.util.JaccUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;

public class FileMergeTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(FileMergeTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String DEFAULT_CONTEXT_ROOT = "/";
    private final AppUpdateHelper _appUpdateHelper;
    private final List<String> _added = new ArrayList<String>();
    private final List<String> _deleted = new ArrayList<String>();
    private final List<String> _updated = new ArrayList<String>();
    private final List<String> _moduleUris = new ArrayList<String>();
    private UpdateScheduler _updateScheduler;
    private Hashtable<String, Object> _properties = null;
    private String _operation = null;
    private String _contentUri = null;
    private String _contentType = null;
    private String _origContentType = null;
    private String _tempDirectory = null;
    private RepositoryContext _appContext = null;
    private EARFile _earFile = null;
    private boolean doSecurityCheck;

    public FileMergeTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this._appUpdateHelper = new AppUpdateHelper();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performTask() throws AdminException {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "performTask");
            }
            boolean result = true;
            try {
                try {
                    if (this.scheduler instanceof UpdateScheduler) {
                        this._updateScheduler = (UpdateScheduler)this.scheduler;
                        this.init();
                        this.update();
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "performTask", "not an update");
                    }
                    AppNotification notification = this.createNotification("Completed", "ADMA5064I", new String[]{this.scheduler.getAppName()});
                    this.scheduler.propagateTaskEvent(notification);
                }
                catch (Throwable t) {
                    RasUtils.logException(t, tc, CLASS_NAME, "performTask", "150", this);
                    AppNotification notification = this.createNotification("Failed", "ADMA5065E", new String[]{t.toString()});
                    this.scheduler.propagateTaskEvent(notification);
                    AdminException adminException = new AdminException(t, "Exception merging files");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "performTask", adminException);
                    }
                    throw adminException;
                }
                Object var6_4 = null;
                if (this._earFile == null) break block11;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (this._earFile != null) {
                    this._earFile.close();
                    this._earFile = null;
                }
                throw throwable;
            }
            this._earFile.close();
            this._earFile = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(true));
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", _appUpdateHelper=");
        stringBuilder.append(this._appUpdateHelper);
        stringBuilder.append(", _added=");
        stringBuilder.append(this._added);
        stringBuilder.append(", _deleted=");
        stringBuilder.append(this._deleted);
        stringBuilder.append(", _updated=");
        stringBuilder.append(this._updated);
        stringBuilder.append(", _moduleUris=");
        stringBuilder.append(this._moduleUris);
        stringBuilder.append(", _updateScheduler=");
        stringBuilder.append(this._updateScheduler);
        stringBuilder.append(", _properties=");
        stringBuilder.append(this._properties);
        stringBuilder.append(", _operation=");
        stringBuilder.append(this._operation);
        stringBuilder.append(", _contentUri=");
        stringBuilder.append(this._contentUri);
        stringBuilder.append(", _contentType=");
        stringBuilder.append(this._contentType);
        stringBuilder.append(", _origContentType=");
        stringBuilder.append(this._origContentType);
        stringBuilder.append(", _tempDirectory=");
        stringBuilder.append(this._tempDirectory);
        stringBuilder.append(", _appContext=");
        stringBuilder.append(this._appContext);
        stringBuilder.append(", _earFile=");
        stringBuilder.append(this._earFile);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void init() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this._properties = this.scheduler.getProperties();
        this._operation = this._updateScheduler.getOperation();
        this._contentUri = this._updateScheduler.getContentURI();
        this._contentType = this._updateScheduler.getContentType();
        this._origContentType = this._updateScheduler.getOrigContentType();
        this._tempDirectory = AppUtils.getAppTempExtractDir(this.scheduler);
        this._appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this._properties);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_appContext: ", this._appContext.getName());
        }
        ApplicationDeployment appDeployment = ConfigRepoHelper.getAppDeploymentForApp(this._appContext);
        EList modules = appDeployment.getModules();
        for (ModuleDeployment module : modules) {
            this._moduleUris.add(module.getUri());
        }
        this._properties.put("DeltaDataTask.DelFiles", this._deleted);
        this._properties.put("DeltaDataTask.AddFiles", this._added);
        this._properties.put("DeltaDataTask.UpdateFiles", this._updated);
        this.doSecurityCheck = !AppManagementImpl.isLocalMode() && appDeployment.isZeroEarCopy() && WSSecurityHelper.isGlobalSecurityEnabled() && !JaccUtil.supportsAppDynamicUpdates();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "security check is " + this.doSecurityCheck);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    private void update() throws Exception {
        boolean partialMode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update");
        }
        boolean bl = partialMode = this._contentType.equals("file") || this._contentType.equals("partialapp") || this._contentType.equals("modulefile") && ("update".equals(this._operation) || "addupdate".equals(this._operation) && this._moduleUris.contains(this._contentUri));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "update", "partialMode=" + partialMode);
        }
        this._earFile = ConfigRepoHelper.getEarFileFromBinaries(this._appContext, this._updateScheduler.getWorkSpace(), this.getResourceBundle(), partialMode);
        List oldRoles = null;
        if (this.doSecurityCheck) {
            oldRoles = this.getSecurityRolesFromEAR(this._earFile);
        }
        if (partialMode) {
            this.updatePartialEar();
        } else {
            this.updateModuleFile();
        }
        this._earFile.rollUpRoles();
        if (this.doSecurityCheck) {
            String recycle;
            List newRoles = null;
            newRoles = this.getSecurityRolesFromEAR(this._earFile);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new Roles = " + newRoles);
            }
            if (this.isSecurityRolesUpdated(oldRoles, newRoles) && (recycle = (String)this.scheduler.getProperties().get("update.recycle")) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security roles are updated, hence setting the recycle mode as FULL_RECYLE.");
                }
                this.scheduler.getProperties().put("update.recycle", "update.recycle.app");
            }
        }
        RepositoryContext parentContext = this._appContext.getParent();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentContext: ", parentContext.getPath());
        }
        String appBinEarName = EditionHelper.getAppEarName(this.scheduler.getAppName(), this._properties);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appBinEarName: ", appBinEarName);
        }
        if (partialMode) {
            this._earFile.saveAs(parentContext.getPath() + File.separator + appBinEarName);
        } else {
            this._earFile.save();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "update", new String[]{"_added=" + this._added, "_deleted=" + this._deleted, "_updated=" + this._updated});
        }
        parentContext.notifyChanged(1, appBinEarName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    private void updatePartialEar() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePartialEar");
        }
        String mergeRoot = AppUtils.getAppTempMergeDir(this.scheduler);
        new File(mergeRoot).mkdirs();
        this._earFile.extractTo(mergeRoot, 0);
        this._earFile.close();
        this._earFile = null;
        this._appUpdateHelper.setLists(this._deleted, this._added, this._updated);
        String operation = this._contentType.equals("partialapp") ? "addupdate" : this._operation;
        this._appUpdateHelper.mergeFiles(operation, this._tempDirectory, mergeRoot);
        this._earFile = AppInstallHelper.getEarFile(mergeRoot, false, true, this.getResourceBundle());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePartialEar");
        }
    }

    private void updateModuleFile() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateModuleFile");
        }
        if ("delete".equals(this._operation)) {
            this.deleteModuleFile();
        } else {
            this.addUpdateModuleFile();
        }
        String appDDUri = this._earFile.getDeploymentDescriptorUri();
        boolean earContainsAppDD = this._earFile.containsFile(appDDUri);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateModuleFile", new String[]{"appDDUri=" + appDDUri, "earContainsAppDD=" + earContainsAppDD});
        }
        if (earContainsAppDD) {
            this._updated.add(appDDUri);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateModuleFile");
        }
    }

    private void deleteModuleFile() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteModuleFile");
        }
        ArrayList<ModuleRef> moduleRefsToDelete = new ArrayList<ModuleRef>();
        String type = "moduletype.unknown";
        EList moduleRefs = this._earFile.getModuleRefs();
        for (ModuleRef moduleRef : moduleRefs) {
            if (!this._contentUri.equals(moduleRef.getUri())) continue;
            moduleRef.getModuleFile();
            moduleRefsToDelete.add(moduleRef);
            type = ConfigRepoHelper.getModuleType(moduleRef);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleteModuleFile", "moduleRefsToDelete=" + moduleRefsToDelete);
        }
        for (ModuleRef moduleRef : moduleRefsToDelete) {
            this._earFile.remove(moduleRef);
        }
        if (moduleRefsToDelete.size() > 0) {
            this._deleted.add(this._contentUri);
            this._properties.put("moduletype", type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteModuleFile");
        }
    }

    private void addUpdateModuleFile() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addUpdateModuleFile");
        }
        ModuleFile moduleFile = (ModuleFile)this._updateScheduler.getContentAsArchive();
        ModuleRef moduleRef = this._earFile.addCopyRef(moduleFile);
        moduleRef.setURI(this._contentUri);
        if (moduleRef.isWeb()) {
            WebModule webModule = (WebModule)moduleRef.getModule();
            String contextRoot = null;
            Object contextRootProperty = this._properties.get("contextroot");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addUpdateModuleFile", "contextRootProperty=" + contextRootProperty);
            }
            if (contextRootProperty instanceof String) {
                contextRoot = (String)contextRootProperty;
            } else if (contextRootProperty != null) {
                String message = "context root property is not a String; class=" + contextRootProperty.getClass().getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addUpdateModuleFile", message);
                }
                assert (false) : message;
            }
            if (AppUtils.isEmpty(contextRoot)) {
                contextRoot = DEFAULT_CONTEXT_ROOT;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addUpdateModuleFile", "contextRoot=" + contextRoot);
            }
            webModule.setContextRoot(contextRoot);
        }
        this._added.add(this._contentUri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addUpdateModuleFile");
        }
    }

    private List getSecurityRolesFromEAR(EARFile earFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityRolesFromEAR", new Object[]{earFile});
        }
        ArrayList<String> roleNames = new ArrayList<String>();
        EList roles = earFile.getDeploymentDescriptor().getSecurityRoles();
        for (int i = 0; i < roles.size(); ++i) {
            SecurityRole role = (SecurityRole)roles.get(i);
            roleNames.add(role.getRoleName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityRolesFromEAR", new Object[]{roleNames});
        }
        return roleNames;
    }

    private boolean isSecurityRolesUpdated(List oldRoles, List newRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityRolesUpdated", new Object[]{oldRoles, newRoles});
        }
        boolean ret = true;
        if ((oldRoles == null || oldRoles.isEmpty()) && (newRoles == null || newRoles.isEmpty())) {
            ret = false;
        } else if (oldRoles != null && !oldRoles.isEmpty()) {
            ArrayList delta = (ArrayList)((ArrayList)newRoles).clone();
            for (int i = 0; i < oldRoles.size(); ++i) {
                if (delta.contains(oldRoles.get(i))) {
                    delta.remove(oldRoles.get(i));
                    continue;
                }
                delta.add(oldRoles.get(i));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "delta Roles = " + delta);
            }
            boolean bl = ret = delta.size() != 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityRolesUpdated", new Object[]{new Boolean(ret)});
        }
        return ret;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/FileMergeTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.17.1.2");
        }
        CLASS_NAME = FileMergeTask.class.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AppUpdateHelper
    extends AppUpdate {
        AppUpdateHelper() {
        }

        @Override
        public List<String> getURIs() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getURIs");
            }
            List uris = AppUtils.getURIs(FileMergeTask.this._tempDirectory);
            if ("delete".equals(FileMergeTask.this._operation) && "file".equals(FileMergeTask.this._contentType)) {
                uris.add(FileMergeTask.this._contentUri);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getURIs", uris);
            }
            return uris;
        }

        public List<String> getURIsNoDelete() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getURIsNoDelete");
            }
            ArrayList<String> uris = new ArrayList<String>();
            if (!"delete".equals(FileMergeTask.this._operation) || !"file".equals(FileMergeTask.this._contentType)) {
                for (String uri : this.getURIs()) {
                    if (uri.endsWith("META-INF/ibm-partialapp-delete.props")) continue;
                    uris.add(uri);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getURIsNoDelete", uris);
            }
            return uris;
        }

        @Override
        public InputStream getContentAsInputStream(String uri) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getContentAsInputStream", "uri=" + uri);
            }
            FileInputStream inputStream = null;
            try {
                String fileName = FileMergeTask.this._tempDirectory + File.separator + uri;
                inputStream = new FileInputStream(fileName);
                File srcFile = new File(fileName);
                this.fileTimeStamps.put(uri, new Long(srcFile.lastModified()));
            }
            catch (Throwable t) {
                RasUtils.logException(t, tc, CLASS_NAME, "getContentAsInputStream", "607", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getContentAsInputStream", inputStream);
            }
            return inputStream;
        }

        @Override
        protected boolean addToCollapse(String archiveURI) throws Exception {
            return !FileMergeTask.this._moduleUris.contains(archiveURI);
        }
    }
}

