/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractionTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(ExtractionTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final int BUFFER_SIZE = 1024;
    private String directory = null;

    public ExtractionTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    @Override
    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean result = true;
        try {
            this.directory = AppUtils.getAppTempExtractDir(this.scheduler);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performTask", "directory=" + this.directory);
            }
            new java.io.File(this.directory).mkdirs();
            if (this.scheduler instanceof InstallScheduler) {
                this.install((InstallScheduler)this.scheduler);
            } else if (this.scheduler instanceof UpdateScheduler) {
                this.update((UpdateScheduler)this.scheduler);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performTask", "unexpected scheduler; class=" + this.scheduler.getClass().getName());
            }
            AppNotification notification = this.createNotification("Completed", "ADMA5009I", new String[]{this.directory});
            this.scheduler.propagateTaskEvent(notification);
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "performTask", "144", this);
            AppNotification notification = this.createNotification("Failed", "ADMA5010E", new String[]{this.directory, t.toString()});
            this.scheduler.propagateTaskEvent(notification);
            if (t instanceof AdminException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "performTask", t.toString());
                }
                throw (AdminException)t;
            }
            String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0064E");
            AdminException adminException = new AdminException(t, message);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask", adminException);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(result));
        }
        return result;
    }

    private void install(InstallScheduler installScheduler) throws AdminException, IOException, SaveFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install");
        }
        if (tc.isDebugEnabled()) {
            String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA6013I", new String[]{this.directory});
            Tr.debug(tc, "install", message);
        }
        EARFile earFile = installScheduler.getEarFile(false, true);
        EarUtils.extractEar((EARFile)earFile, (String)this.directory, (boolean)true);
        installScheduler.setEarPath(this.directory);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(UpdateScheduler updateScheduler) throws Exception {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update");
            }
            boolean warExpanded = false;
            String contentType = updateScheduler.getContentType();
            String operation = updateScheduler.getOperation();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "update", new String[]{"contentType=" + contentType, "operation=" + operation});
            }
            Hashtable properties = this.scheduler.getProperties();
            RepositoryContext appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), properties);
            ApplicationDeployment appDeployment = ConfigRepoHelper.getAppDeploymentForApp(appContext);
            boolean zeroEarCopy = appDeployment.isZeroEarCopy();
            if (contentType.equals("partialapp")) {
                warExpanded = this.updatePartialEar(updateScheduler);
            } else if (contentType.equals("modulefile") && !operation.equals("delete")) {
                warExpanded = this.updateModule(updateScheduler, appContext, zeroEarCopy);
            } else if (contentType.equals("file") && !operation.equals("delete")) {
                this.updateFile(updateScheduler);
            }
            if (!warExpanded) {
                properties.remove("preCompileJSPs");
            }
            if (zeroEarCopy) {
                EARFile earFile = null;
                try {
                    earFile = ConfigRepoHelper.getEarFileFromDeployment(this.scheduler.getWorkSpace(), appContext);
                    AppSaveFilter saveFilter = new AppSaveFilter(appContext, earFile);
                    earFile.setSaveFilter(saveFilter);
                    RepositoryContext parentContext = appContext.getParent();
                    String parentName = parentContext.getName();
                    String destination = parentContext.getPath() + java.io.File.separator + parentName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "update", "save ear to " + destination);
                    }
                    earFile.saveAs(destination);
                    parentContext.notifyChanged(0, parentName);
                    Object var15_14 = null;
                    if (earFile == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    if (earFile != null) {
                        earFile.close();
                    }
                    throw throwable;
                }
                earFile.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updatePartialEar(UpdateScheduler updateScheduler) throws AdminException, AppDeploymentException, IOException, SaveFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePartialEar");
        }
        boolean warExpanded = false;
        if (updateScheduler.getProperties().containsKey("Update_Offset")) {
            String offset = (String)updateScheduler.getProperties().get("Update_Offset");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "offset= " + offset + ", extract to " + this.directory + "/" + offset);
            }
            this.extractZip(updateScheduler.getContentPath(), this.directory + "/" + offset);
        } else {
            this.extractZip(updateScheduler.getContentPath(), this.directory);
        }
        updateScheduler.setContentPath(this.directory);
        if (updateScheduler.getOrigContentType().equals("modulefile") && AppUtils.isPreCompileJSPs(updateScheduler)) {
            String filePath;
            String moduleUri = updateScheduler.getContentURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updatePartialEar", "expand module " + moduleUri + " from partial ear to " + this.directory);
            }
            if (new java.io.File(filePath = this.directory + java.io.File.separator + moduleUri).exists()) {
                Archive archive = null;
                try {
                    archive = AppInstallHelper.getArchive(filePath, false, true, this.getResourceBundle(), false);
                    if (archive.isWARFile()) {
                        archive.extractNoReopen(2);
                        warExpanded = true;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "updatePartialEar", "not a war in partial ear");
                    }
                    Object var7_6 = null;
                    archive.close();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    archive.close();
                    throw throwable;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updatePartialEar", "error: " + filePath + " does not exist");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePartialEar", Boolean.toString(warExpanded));
        }
        return warExpanded;
    }

    private boolean updateModule(UpdateScheduler updateScheduler, RepositoryContext appContext, boolean zeroEarCopy) throws AdminException, ReopenException, SaveFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateModule", new String[]{"appContext=" + appContext, "zeroEarCopy=" + zeroEarCopy});
        }
        boolean warExpanded = false;
        this.directory = this.directory + java.io.File.separator + updateScheduler.getContentURI();
        Archive archive = updateScheduler.getContentAsArchive();
        if (AppUtils.isPreCompileJSPs(updateScheduler) && archive.isWARFile()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateModule", "expand module to " + this.directory);
            }
            java.io.File file = new java.io.File(this.directory);
            file.mkdirs();
            archive.extractTo(this.directory, 2);
            warExpanded = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateModule", "save module " + (zeroEarCopy ? "metadata " : "") + "to " + this.directory);
            }
            if (zeroEarCopy) {
                MetadataSaveFilter saveFilter = new MetadataSaveFilter(archive);
                archive.setSaveFilter(saveFilter);
            }
            archive.saveAsNoReopen(this.directory);
        }
        updateScheduler.setContentPath(this.directory);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateModule", Boolean.toString(warExpanded));
        }
        return warExpanded;
    }

    private void updateFile(UpdateScheduler updateScheduler) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateFile");
        }
        String contentPath = updateScheduler.getContentPath();
        String fileDirectory = this.directory + java.io.File.separator + updateScheduler.getContentURI();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateFile", "copy file to " + fileDirectory);
        }
        AppUtils.copyFile(new java.io.File(contentPath), fileDirectory);
        updateScheduler.setContentPath(this.directory);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateFile");
        }
    }

    public Vector<String> extractZip(String zipFileName, String directory) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractZip", new String[]{"zipFileName=" + zipFileName, "directory=" + directory});
        }
        Vector<String> memberUris = null;
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(zipFileName);
                memberUris = ExtractionTask.extractZip(inputStream, directory);
            }
            catch (IOException e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "extractZip", "436", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractZip", e.toString());
                }
                throw e;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            AppUtils.closeInputStream(inputStream);
            throw throwable;
        }
        AppUtils.closeInputStream(inputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractZip", memberUris);
        }
        return memberUris;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Vector<String> extractZip(InputStream inputStream, String directory) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractZip", new String[]{"inputStream=" + inputStream, "directory=" + directory});
        }
        Vector<String> memberPathList = new Vector<String>();
        ZipInputStream zipInputStream = null;
        try {
            try {
                zipInputStream = new ZipInputStream(inputStream);
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String memberURI = zipEntry.getName();
                    long srcLastModTime = zipEntry.getTime();
                    String memberFilePath = directory.replace('/', java.io.File.separatorChar) + java.io.File.separator + memberURI.replace('/', java.io.File.separatorChar);
                    java.io.File memberFile = new java.io.File(memberFilePath);
                    java.io.File memberParentDirectory = new java.io.File(memberFile.getParent());
                    if (!memberParentDirectory.exists()) {
                        memberParentDirectory.mkdirs();
                    }
                    if (!zipEntry.isDirectory()) {
                        Object var15_15;
                        memberPathList.addElement(memberURI);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "extractZip", "extract " + memberURI + " to " + memberFilePath);
                        }
                        BufferedOutputStream outputStream = null;
                        try {
                            try {
                                byte[] buffer = new byte[1024];
                                outputStream = new BufferedOutputStream(new FileOutputStream(memberFile));
                                int bytesRead = 0;
                                while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                                    ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                                }
                                ((OutputStream)outputStream).flush();
                            }
                            catch (IOException e) {
                                RasUtils.logException(e, tc, CLASS_NAME, "extractZip", "499");
                                throw e;
                            }
                            var15_15 = null;
                        }
                        catch (Throwable throwable) {
                            var15_15 = null;
                            AppUtils.closeOutputStream(outputStream);
                            throw throwable;
                        }
                        AppUtils.closeOutputStream(outputStream);
                    }
                    zipInputStream.closeEntry();
                    memberFile.setLastModified(srcLastModTime);
                    if (!tc.isDebugEnabled() || memberFile.lastModified() == srcLastModTime) continue;
                    Tr.debug(tc, "Error modifying timestamp of memberfile " + memberFile.getName());
                }
                Object var17_17 = null;
            }
            catch (IOException e) {
                RasUtils.logException(e, tc, CLASS_NAME, "extractZip", "517");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractZip", e.toString());
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            AppUtils.closeInputStream(zipInputStream);
            throw throwable;
        }
        AppUtils.closeInputStream(zipInputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractZip", memberPathList);
        }
        return memberPathList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", directory=");
        stringBuilder.append(this.directory);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/ExtractionTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.38");
        }
        CLASS_NAME = ExtractionTask.class.getName();
    }

    private static class MetadataSaveFilter
    extends SaveFilterImpl {
        private static final String METADATA_REGEX = "META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*";
        private Set<String> uris = new HashSet<String>();

        public MetadataSaveFilter(Archive archive) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "MetadataSaveFilter.<init>", "archive=" + archive);
            }
            Pattern pattern = Pattern.compile(METADATA_REGEX);
            EList files = archive.getFiles();
            for (File file : files) {
                String uri;
                Matcher matcher;
                if (file.isDirectoryEntry() || !(matcher = pattern.matcher(uri = file.getURI().replace('\\', '/'))).matches()) continue;
                this.uris.add(uri);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MetadataSaveFilter.<init>", "uris=" + this.uris);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MetadataSaveFilter.<init>");
            }
        }

        public boolean shouldSave(String uri, Archive archive) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "MetadataSaveFilter.shouldSave", new String[]{"uri=" + uri, "archive=" + archive});
            }
            boolean save = this.uris.contains(uri);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MetadataSaveFilter.shouldSave", Boolean.toString(save));
            }
            return save;
        }
    }

    private static class AppSaveFilter
    extends SaveFilterImpl {
        private final RepositoryContext appContext;
        private final Set<String> uris = new HashSet<String>();

        public AppSaveFilter(RepositoryContext appContext, EARFile earFile) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "AppSaveFilter.<init>", new String[]{"appContext=" + appContext, "earFile=" + earFile});
            }
            this.appContext = appContext;
            EList moduleRefs = earFile.getModuleRefs();
            for (ModuleRef moduleRef : moduleRefs) {
                String uri = moduleRef.getUri();
                this.uris.add(uri);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppSaveFilter.<init>", "uris=" + this.uris);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AppSaveFilter.<init>");
            }
        }

        public boolean shouldSave(String uri, Archive archive) {
            boolean save;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "AppSaveFilter.shouldSave", new String[]{"uri=" + uri, "archive=" + archive});
            }
            boolean bl = save = this.uris.contains(uri) || this.appContext.isAvailable(uri);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AppSaveFilter.shouldSave", Boolean.toString(save));
            }
            return save;
        }
    }
}

