/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DistributionStatusSchedulerImpl;
import com.ibm.ws.management.util.RasUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class DistributionStatusTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(DistributionStatusTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String OPNAME = "_getAppDistributionStatus";

    public DistributionStatusTask() {
        this.appTaskName = "AppDistribution";
    }

    public boolean performTask() throws AdminException {
        List nodes = ((DistributionStatusSchedulerImpl)this.scheduler).get_nodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Hashtable uris;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Inside the performTask for node : " + nodes.get(i));
            }
            if ((uris = AppUtils.getAppDocuments(this.scheduler.getAppName(), (String)nodes.get(i))) == null || uris.size() == 0) {
                throw new AdminException("Error getting application documents from master repository.  The application may not be in the repository.");
            }
            String s = this.handleNode((String)nodes.get(i), uris);
            String cs = ((DistributionStatusSchedulerImpl)this.scheduler).addCompStatus(s);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Status : " + s + " cs = " + cs);
            }
            Properties nprops = new Properties();
            nprops.put("AppDistributionNode", s);
            nprops.put("AppDistributionAll", cs);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " nprops : " + nprops + " CS = " + cs);
            }
            AppNotification notify = this.createTranslatedNotification("InProgress", s, null);
            notify.setProperties(nprops);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " PROPOGATING TASK .." + notify.toString());
            }
            this.scheduler.propagateTaskEvent(notify);
        }
        return true;
    }

    private String handleNode(String node, Hashtable uris) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNode: " + node + ", app = " + this.scheduler.getAppName());
        }
        String cellName = null;
        try {
            cellName = this.scheduler.getCellContext().getName();
            ObjectName on = new ObjectName("WebSphere:type=AdminOperations,node=" + node + ",process=" + (AdminServiceFactory.getAdminService().getNodeName().equals(node) ? AdminServiceFactory.getAdminService().getProcessName() : "nodeagent") + ",*");
            Set s = AdminServiceFactory.getAdminService().queryNames(on, null);
            if (s == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNode: set is null");
                }
                return this.getStr(cellName, node, "unknown", "unknown");
            }
            Iterator iter = s.iterator();
            if (!iter.hasNext()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "No MBean on the node");
                }
                return this.getStr(cellName, node, "unknown", "unknown");
            }
            on = (ObjectName)iter.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "on = " + on);
            }
            if (!this.checkForOp(on)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Back level MBean on " + node);
                }
                return this.getStr(cellName, node, "unknown", "unknown");
            }
            Hashtable tbl = (Hashtable)AdminServiceFactory.getAdminService().invoke(on, OPNAME, new Object[]{this.scheduler.getAppName(), new Hashtable()}, new String[]{String.class.getName(), Hashtable.class.getName()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tbl = " + tbl);
            }
            if (tbl == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Table returned from node is null " + node);
                }
                return this.getStr(cellName, node, "unknown", "unknown");
            }
            Object status = tbl.get(this.scheduler.getAppName());
            if (status != null) {
                status = status instanceof Boolean ? ((status = ((Boolean)status).toString()).equals("true") ? "0" : "-1") : (String)status;
            }
            if (status == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file status returned from node is null " + node);
                }
                return this.getStr(cellName, node, "unknown", "unknown");
            }
            if (status.equals("0")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file still exists " + node);
                }
                return this.getStr(cellName, node, "false", "inprogress");
            }
            if (!status.equals("-1")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file contains error " + status + " on " + node);
                }
                return this.getStr(cellName, node, "false", "error");
            }
            Hashtable nuris = (Hashtable)tbl.get("uri");
            if (nuris == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "URI Table returned from node is null " + node);
                }
                return this.getStr(cellName, node, "unknown", "notprocessing");
            }
            if (uris.size() != nuris.size()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "URI Tables of different size for " + node + ", " + uris.size() + ", " + nuris.size());
                }
                return this.getStr(cellName, node, "false", "notprocessing");
            }
            Enumeration en = uris.keys();
            while (en.hasMoreElements()) {
                DocumentDigest n_digest;
                String uri = (String)en.nextElement();
                if (!nuris.containsKey(uri)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "URI " + uri + "does not exist on " + node);
                    }
                    return this.getStr(cellName, node, "false", "notprocessing");
                }
                DocumentDigest digest = (DocumentDigest)uris.get(uri);
                if (((Object)digest).equals(n_digest = (DocumentDigest)nuris.get(uri))) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Digest diff for " + uri);
                }
                return this.getStr(cellName, node, "false", "notprocessing");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "All fine for " + node);
            }
            return this.getStr(cellName, node, "true", "notprocessing");
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "handleNode", "231", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exception thrown in handleNode: " + th);
            }
            return this.getStr(cellName, node, "unknown", "unknown");
        }
    }

    private String getStr(String cell, String node, String status, String expansion) {
        return "WebSphere:cell=" + cell + ",node=" + node + ",distribution=" + status + ",expansion=" + expansion;
    }

    private boolean checkForOp(ObjectName on) throws Exception {
        MBeanInfo minfo = AdminServiceFactory.getAdminService().getMBeanInfo(on);
        MBeanOperationInfo[] opinfo = minfo.getOperations();
        for (int i = 0; i < opinfo.length; ++i) {
            if (!OPNAME.equals(opinfo[i].getName())) continue;
            return true;
        }
        return false;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/DistributionStatusTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.2.2.4");
        }
        CLASS_NAME = DistributionStatusTask.class.getName();
    }
}

