/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.ejs.util.deployment.deploywrapper.DeployUtil;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.ejbdeploy.EJBDeploymentException;
import com.ibm.etools.ejbdeploy.IStatusMonitor;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.util.PlatformHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployEJBTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(DeployEJBTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String EJBCALLER = "EJBCALLER";
    private static final String WEBSPHERE = "WEBSPHERE";
    private static final String EXPAND_DIRECTORY = "EXP";
    private String deployFileName = null;
    private Hashtable<String, ?> deployEjbOptions = null;
    private final List<String> jars = new ArrayList<String>();
    private String tempDirectory = null;

    public DeployEJBTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    @Override
    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean result = true;
        Hashtable properties = this.scheduler.getProperties();
        this.deployEjbOptions = (Hashtable)properties.get("deployejb.options");
        if (this.deployEjbOptions != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performTask", "deployEjbOptions=" + this.deployEjbOptions);
            }
            try {
                this.tempDirectory = AppUtils.getAppTempDeployDir(this.scheduler);
                String appName = this.scheduler.getAppName();
                this.deployFileName = this.tempDirectory + File.separator + AppUtils.getAppDeployFileName(appName);
                if (this.scheduler instanceof InstallScheduler) {
                    this.install((InstallScheduler)this.scheduler);
                }
                if (this.scheduler instanceof UpdateScheduler) {
                    this.update((UpdateScheduler)this.scheduler);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "performTask", "unexpected scheduler; class=" + this.scheduler.getClass().getName());
                }
                assert (false) : "unexpected scheduler; class=" + this.scheduler.getClass().getName();
            }
            catch (Throwable t) {
                RasUtils.logException(t, tc, CLASS_NAME, "performTask", "148", this);
                AppNotification notification = this.createNotification("Failed", "ADMA0063E", new String[]{t.toString()});
                this.scheduler.propagateTaskEvent(notification);
                if (t instanceof AdminException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "performTask", t.toString());
                    }
                    throw (AdminException)t;
                }
                String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0063E", new Object[]{t.toString()});
                AdminException adminException = new AdminException(t, message);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "performTask", adminException);
                }
                throw adminException;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performTask", "no deploy ejb options");
            }
            AppNotification notification = this.createNotification("Completed", "ADMA0213W", null);
            this.scheduler.propagateTaskEvent(notification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(result));
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", deployFileName=");
        stringBuilder.append(this.deployFileName);
        stringBuilder.append(", deployEjbOptions=");
        stringBuilder.append(this.deployEjbOptions);
        stringBuilder.append(", tempDirectory=");
        stringBuilder.append(this.tempDirectory);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void install(InstallScheduler installScheduler) throws AdminException, AppDeploymentException, EJBDeploymentException, ReopenException, SaveFailureException {
        File earPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install");
        }
        this.deployFileName = this.deployFileName + ".ear";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "install", "deployFileName=" + this.deployFileName);
        }
        if ((earPath = new File(installScheduler.getEarPath())).isDirectory()) {
            String appName = installScheduler.getAppName();
            String preDeployFileName = this.tempDirectory + File.separator + AppUtils.getPreAppDeployFileName(appName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "install", "copying source directory to ear " + preDeployFileName);
            }
            EARFile earFile = installScheduler.getEarFile(false, true);
            earFile.saveAs(preDeployFileName);
            installScheduler.setEarPath(preDeployFileName);
        }
        EARFile archive = installScheduler.getEarFile(false, true);
        this.ejbDeploy(archive);
        installScheduler.setEarPath(this.deployFileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(UpdateScheduler updateScheduler) throws AdminException, AppDeploymentException, EJBDeploymentException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update");
        }
        this.deployFileName = this.deployFileName + ".jar";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "update", "deployFileName=" + this.deployFileName);
        }
        Archive archive = null;
        boolean closeArchive = false;
        try {
            String contentType;
            block25: {
                contentType = updateScheduler.getContentType();
                String operation = updateScheduler.getOperation();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "update", new String[]{"contentType=" + contentType, "operation=" + operation});
                }
                if (contentType.equals("modulefile") && !"delete".equals(operation)) {
                    Archive a = updateScheduler.getContentAsArchive();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "update", "a=" + a);
                    }
                    if (a.isEJBJarFile()) {
                        archive = a;
                        closeArchive = false;
                        WorkSpace workSpace = this.scheduler.getWorkSpace();
                        RepositoryContext appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), workSpace, this.scheduler.getProperties());
                        EARFile earFile = null;
                        try {
                            earFile = ConfigRepoHelper.getEarFileFromBinaries(appContext, workSpace, this.getResourceBundle(), true);
                            String directory = this.tempDirectory + File.separator + EXPAND_DIRECTORY;
                            this.expandDependentJars(earFile, archive, this.jars, directory);
                            List<String> libraryDirectoryJars = AppUtils.extractLibraryDirectoryJars(this.scheduler, earFile);
                            this.jars.addAll(libraryDirectoryJars);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "update", "jars=" + this.jars);
                            }
                            Object var13_13 = null;
                            if (earFile == null) break block25;
                        }
                        catch (Throwable throwable) {
                            Object var13_14 = null;
                            if (earFile != null) {
                                earFile.close();
                            }
                            throw throwable;
                        }
                        earFile.close();
                    }
                }
            }
            String originalContentType = updateScheduler.getOrigContentType();
            if (contentType.equals("partialapp") && originalContentType.equals("modulefile")) {
                Archive a;
                String filePath = updateScheduler.getContentPath() + File.separator + updateScheduler.getContentURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "update", "filePath=" + filePath);
                }
                if ((a = AppInstallHelper.getArchive(filePath, false, true, this.getResourceBundle(), false)).isEJBJarFile()) {
                    archive = a;
                    closeArchive = true;
                } else {
                    a.close();
                }
            }
            this.ejbDeploy(archive);
            if (contentType.equals("partialapp")) {
                archive.close();
                archive = null;
                closeArchive = false;
            } else if (contentType.equals("modulefile")) {
                updateScheduler.setContentPath(this.deployFileName);
            }
            String oldPath = archive.getURI();
            boolean deleted = new File(oldPath).delete();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "update", new String[]{"oldPath=" + oldPath, "deleted=" + deleted});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "update", "copy " + this.deployFileName + " to " + oldPath);
            }
            AppUtils.copyFile(new File(this.deployFileName), oldPath);
            if (contentType.equals("modulefile")) {
                updateScheduler.setContentPath(oldPath);
            }
            Object var15_16 = null;
            if (archive != null && closeArchive) {
                archive.close();
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (archive != null && closeArchive) {
                archive.close();
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    private void ejbDeploy(Archive archive) throws AdminException, EJBDeploymentException {
        PlatformHelper platformHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ejbDeploy", "archive=" + archive);
        }
        if (archive == null) {
            String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0040E");
            AdminException adminException = new AdminException(message);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ejbDeploy", adminException);
            }
            throw adminException;
        }
        DeployOptions deployOptions = this.createDeployOptions(archive);
        File tempDir = new File(this.tempDirectory);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        if ((platformHelper = AdminHelper.getPlatformHelper()).isZOS()) {
            this.zSetEnv();
        }
        AppNotification startNotification = this.createNotification("InProgress", "ADMA5018I", new String[]{archive.getURI()});
        this.scheduler.propagateTaskEvent(startNotification);
        StatusMonitorImpl statusMonitor = new StatusMonitorImpl();
        try {
            try {
                DeployUtil.deploy(archive, deployOptions, (IStatusMonitor)statusMonitor);
                AppNotification notification = this.createNotification("Completed", "ADMA5007I", new String[]{archive.getURI()});
                this.scheduler.propagateTaskEvent(notification);
            }
            catch (EJBDeploymentException e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "ejbDeploy", "407", this);
                AppNotification notification = this.createNotification("Failed", "ADMA5008E", new String[]{archive.getURI(), e.toString()});
                this.scheduler.propagateTaskEvent(notification);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ejbDeploy", (Object)e);
                }
                throw e;
            }
            Object var10_11 = null;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.zUnsetEnv();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.zUnsetEnv();
            }
            throw throwable;
        }
        List<String> errors = statusMonitor.getErrors();
        if (errors.size() > 0) {
            String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0062E", new Object[]{errors});
            AdminException adminException = new AdminException(message);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ejbDeploy", adminException);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ejbDeploy");
        }
    }

    private DeployOptions createDeployOptions(Archive archive) {
        String sqljClassPath;
        String dataAccessTypeOption;
        String complianceLevel;
        String dbSchema;
        String dbType;
        Boolean codegen;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDeployOptions", "archive=" + archive);
        }
        DeployOptions deployOptions = new DeployOptions();
        deployOptions.setInputModuleName(archive.getURI());
        deployOptions.setDeployedModuleName(this.deployFileName);
        deployOptions.setWorkingDirectory(this.tempDirectory);
        String rmic = (String)this.deployEjbOptions.get("deployejb.rmic");
        if (!AppUtils.isEmpty(rmic)) {
            deployOptions.setRMICOptions(rmic);
        }
        String classPath = (String)this.deployEjbOptions.get("deployejb.classpath");
        if (this.jars != null && !this.jars.isEmpty()) {
            StringBuilder buffer = new StringBuilder(512);
            if (classPath != null) {
                buffer.append(classPath);
                if (!classPath.endsWith(File.pathSeparator)) {
                    buffer.append(File.pathSeparator);
                }
            }
            for (String path : this.jars) {
                buffer.append(path);
                buffer.append(File.pathSeparator);
            }
            classPath = buffer.toString();
        }
        if (!AppUtils.isEmpty(classPath)) {
            classPath = classPath.replace('/', File.separatorChar);
            classPath = classPath.replace('\\', File.separatorChar);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createDeployOptions", "classPath=" + classPath);
            }
            deployOptions.setClasspath(classPath);
        }
        if ((codegen = (Boolean)this.deployEjbOptions.get("deployejb.codegen")) != null) {
            deployOptions.setCodegenOnly(codegen);
        }
        if (!AppUtils.isEmpty(dbType = (String)this.deployEjbOptions.get("deployejb.dbtype"))) {
            deployOptions.setDatabaseType(dbType);
        }
        if (!AppUtils.isEmpty(dbSchema = (String)this.deployEjbOptions.get("deployejb.dbschema"))) {
            deployOptions.setSchemaName(dbSchema);
        }
        if (!AppUtils.isEmpty(complianceLevel = (String)this.deployEjbOptions.get("deployejb.complianceLevel"))) {
            deployOptions.setComplianceLevel(complianceLevel);
        }
        if (!AppUtils.isEmpty(dataAccessTypeOption = (String)this.deployEjbOptions.get("deployejb.dbaccesstype")) && dataAccessTypeOption.equals("SQLj")) {
            deployOptions.setSQLJDeploy(true);
        }
        if (!AppUtils.isEmpty(sqljClassPath = (String)this.deployEjbOptions.get("deployejb.sqljclasspath"))) {
            String dependentClassPath;
            StringBuilder buffer = new StringBuilder(512);
            buffer.append(sqljClassPath);
            if (!sqljClassPath.endsWith(File.pathSeparator)) {
                buffer.append(File.pathSeparator);
            }
            if ((dependentClassPath = deployOptions.getDependentClasspath()) == null) {
                dependentClassPath = "";
            }
            buffer.append(dependentClassPath);
            String newClassPath = buffer.toString();
            newClassPath = newClassPath.replace('/', File.separatorChar);
            newClassPath = newClassPath.replace('\\', File.separatorChar);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createDeployOptions", "newClassPath=" + newClassPath);
            }
            deployOptions.setClasspath(newClassPath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDeployOptions", deployOptions);
        }
        return deployOptions;
    }

    private void zSetEnv() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "zSetEnv");
        }
        PlatformUtils platformUtils = AdminServiceImpl.getPlatformUtils();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "zSetEnv", "platformUtils=" + platformUtils);
        }
        if (platformUtils != null) {
            platformUtils.setenv(EJBCALLER, WEBSPHERE);
            String env = platformUtils.getenv(EJBCALLER);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "zSetEnv", "env=" + env);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zSetEnv");
        }
    }

    private void zUnsetEnv() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "zUnsetEnv");
        }
        PlatformUtils platformUtils = AdminServiceImpl.getPlatformUtils();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "zUnsetEnv", "platformUtils=" + platformUtils);
        }
        if (platformUtils != null) {
            platformUtils.setenv(EJBCALLER, "");
            String env = platformUtils.getenv(EJBCALLER);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "zUnsetEnv", "env=" + env);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zUnsetEnv");
        }
    }

    private void expandDependentJars(Container parent, Archive archive, List<String> jars, String directory) throws Exception {
        String[] classPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandDependentJars", new String[]{"parent=" + parent, "archive=" + archive, "jars=" + jars, "directory=" + directory});
        }
        ArchiveManifest manifest = archive.getManifest();
        for (String path : classPath = manifest.getClassPathTokenized()) {
            String fileName;
            String offset;
            Object[] data;
            Container container;
            org.eclipse.jst.j2ee.commonarchivecore.internal.File file;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expandDependentJars", "path=" + path);
            }
            if ((file = (container = (Container)(data = AppUtils.getContainerAndOffset(parent, path))[0]).getFile(offset = (String)data[1])) == null || jars.contains(fileName = directory + File.separator + file.getURI())) continue;
            jars.add(fileName);
            if (file instanceof Archive) {
                this.expandDependentJars(container, (Archive)file, jars, directory);
            }
            AppUtils.copyFile(file, fileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandDependentJars");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/DeployEJBTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.56");
        }
        CLASS_NAME = DeployEJBTask.class.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatusMonitorImpl
    implements IStatusMonitor {
        private final List<String> errors = Collections.synchronizedList(new ArrayList());

        public synchronized void errorMessage(String message, int severity) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "errorMessage", new String[]{"message=" + message, "severity=" + severity});
            }
            switch (severity) {
                case 2: {
                    Tr.error(tc, "ADMA0086E", new Object[]{message});
                    this.errors.add(message);
                    AppNotification notification = DeployEJBTask.this.createTranslatedNotification("InProgress", message, null);
                    DeployEJBTask.this.scheduler.propagateTaskEvent(notification);
                    break;
                }
                case 1: {
                    Tr.warning(tc, "ADMA0087W", new Object[]{message});
                    AppNotification notification = DeployEJBTask.this.createTranslatedNotification("InProgress", message, null);
                    DeployEJBTask.this.scheduler.propagateTaskEvent(notification);
                    break;
                }
                case 0: {
                    Tr.info(tc, "ADMA0113I", new Object[]{message});
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "errorMessage", "unexpected severity " + severity);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "errorMessage");
            }
        }

        public boolean isCanceled() {
            return false;
        }

        public synchronized void subtaskMessage(String message) {
            Tr.info(tc, "ADMA0158I", new Object[]{message});
        }

        public synchronized void taskMessage(String message) {
            Tr.info(tc, "ADMA0158I", new Object[]{message});
            AppNotification notification = DeployEJBTask.this.createTranslatedNotification("InProgress", message, null);
            DeployEJBTask.this.scheduler.propagateTaskEvent(notification);
        }

        public synchronized List<String> getErrors() {
            return this.errors;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(this.hashCode()));
            stringBuilder.append("[errors=");
            stringBuilder.append(this.errors);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

