/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DeltaFile;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class DeltaDataTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(DeltaDataTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private DeltaFile _deltaFile;
    private RepositoryContext _appC;
    public static final String DelFiles = "DeltaDataTask.DelFiles";
    public static final String AddFiles = "DeltaDataTask.AddFiles";
    public static final String UpdateFiles = "DeltaDataTask.UpdateFiles";
    public static final String FULLUPDATE_PROP = "com.ibm.websphere.management.application.fullupdate";

    public boolean performTask() throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            String deplName;
            this._appC = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            String appName = EditionHelper.getCompositeName(this.scheduler.getAppName(), this.scheduler.getProperties());
            String offset = "deltas/" + appName;
            this._deltaFile = new DeltaFile(this._appC.getParent().getPath() + "/" + offset);
            Element update_stanza = this._deltaFile.createElement("change_input");
            this._deltaFile.appendChild(update_stanza);
            if (this.scheduler instanceof InstallScheduler) {
                update_stanza.setAttribute("contenttype", "app");
                deplName = this._appC.getParent().getName();
                if (EditionHelper.isEditionSupportEnabled()) {
                    deplName = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
                }
                update_stanza.setAttribute("contenturi", deplName);
                update_stanza.setAttribute("changetype", "install");
            } else if (this.scheduler instanceof EditScheduler) {
                update_stanza.setAttribute("contenttype", "app");
                deplName = this._appC.getParent().getName();
                if (EditionHelper.isEditionSupportEnabled()) {
                    deplName = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
                }
                update_stanza.setAttribute("contenturi", deplName);
                update_stanza.setAttribute("changetype", "edit");
                String uri = ((EditScheduler)this.scheduler).getEarFile().getURI();
                if (uri.replace('\\', '/').endsWith("deployments/" + this.scheduler.getAppName())) {
                    update_stanza.setAttribute("useMetaDataFromBinary", "false");
                } else {
                    update_stanza.setAttribute("useMetaDataFromBinary", "true");
                }
            } else if (this.scheduler instanceof UpdateScheduler) {
                String propAppName = appName.replace(' ', '_');
                if ("true".equalsIgnoreCase((String)this.scheduler.getProperties().get(FULLUPDATE_PROP)) || Boolean.getBoolean(FULLUPDATE_PROP) || Boolean.getBoolean("com.ibm.websphere.management.application.fullupdate." + propAppName)) {
                    this.handleAsFullUpdate(update_stanza, offset);
                } else {
                    this.handleFGUpdate(update_stanza);
                }
            }
            this._deltaFile.writeToDisk();
            this._appC.getParent().notifyChanged(0, offset + "/" + this._deltaFile.getFileName());
            AppNotification appNotify = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            this.scheduler.propagateTaskEvent(appNotify);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            bl = true;
            Object var7_8 = null;
            this.scheduler.getProperties().remove(DelFiles);
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "performTask", "151", this);
                this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), th.toString()}));
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.scheduler.getProperties().remove(DelFiles);
                this.scheduler.getProperties().remove(AddFiles);
                throw throwable;
            }
        }
        this.scheduler.getProperties().remove(AddFiles);
        return bl;
    }

    private void handleAsFullUpdate(Element update_stanza, String dirPath) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleAsFullUpdate - " + dirPath);
        }
        ArrayList<String> temp = new ArrayList<String>();
        Set set = this._appC.getParent().getFiles();
        for (String fileName : set) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file = " + fileName);
            }
            if (!fileName.startsWith(dirPath)) continue;
            temp.add(fileName);
        }
        for (String fileName : temp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleting file = " + fileName);
            }
            this._appC.getParent().delete(fileName);
        }
        update_stanza.setAttribute("contenttype", "app");
        String deplName = this._appC.getParent().getName();
        if (EditionHelper.isEditionSupportEnabled()) {
            deplName = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
        }
        update_stanza.setAttribute("contenturi", deplName);
        update_stanza.setAttribute("changetype", "install");
    }

    private void handleFGUpdate(Element update_stanza) throws Exception {
        int j;
        Element e;
        int i;
        String recycle;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFGUpdate");
        }
        UpdateScheduler ush = (UpdateScheduler)this.scheduler;
        String uri = null;
        update_stanza.setAttribute("changetype", "fg-update");
        update_stanza.setAttribute("contenttype", ush.getContentType());
        if (!AppUtils.isEmpty(ush.getOperation())) {
            update_stanza.setAttribute("operation", ush.getOperation());
        }
        if (!AppUtils.isEmpty(ush.getContentURI())) {
            update_stanza.setAttribute("contenturi", ush.getContentURI());
        }
        if ("modulefile".equals(ush.getContentType()) && "delete".equals(ush.getOperation())) {
            update_stanza.setAttribute("moduletype", (String)this.scheduler.getProperties().get("moduletype"));
        }
        if ((recycle = (String)this.scheduler.getProperties().get("update.recycle")) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "recycle " + recycle);
            }
            if (recycle.equals("update.recycle.modules") && this.scheduler.getProperties().get("update.recycle.modules") == null) {
                AppNotification appNotify = this.createNotification("InProgress", "ADMA5063W", new String[]{"update.recycle.modules"});
                this.scheduler.propagateTaskEvent(appNotify);
            } else {
                update_stanza.setAttribute("update.recycle", recycle);
                if (this.scheduler.getProperties().get("update.recycle.modules") != null) {
                    update_stanza.setAttribute("update.recycle.modules", (String)this.scheduler.getProperties().get("update.recycle.modules"));
                }
            }
        }
        Element files = this._deltaFile.createElement("files");
        this._deltaFile.appendChild(files);
        List[] lists = DeltaDataTask.getChangedLists(ush);
        List deletes = lists[0];
        List adds = lists[1];
        List updates = lists[2];
        List deltaC = ((UpdateSchedulerImpl)ush).getDeltaContents();
        for (i = 0; i < deltaC.size(); i += 2) {
            uri = (String)deltaC.get(i);
            String deltatype = (String)deltaC.get(i + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "delta contents: " + uri + ", " + deltatype);
            }
            if ("add".equals(deltatype)) {
                adds.add(uri);
                continue;
            }
            if ("delete".equals(deltatype)) {
                deletes.add(uri);
                continue;
            }
            if ("update".equals(deltatype)) {
                updates.add(uri);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Unexpected behavior: " + uri + ", " + deltatype);
        }
        for (i = 0; i < deletes.size(); ++i) {
            uri = (String)deletes.get(i);
            e = this._deltaFile.createElement("file");
            e.setAttribute("uri", uri);
            e.setAttribute("operation", "delete");
            files.appendChild(e);
        }
        for (j = 0; j < adds.size(); ++j) {
            uri = (String)adds.get(j);
            e = this._deltaFile.createElement("file");
            e.setAttribute("uri", uri);
            e.setAttribute("operation", "add");
            files.appendChild(e);
        }
        for (j = 0; j < updates.size(); ++j) {
            uri = (String)updates.get(j);
            e = this._deltaFile.createElement("file");
            e.setAttribute("uri", uri);
            e.setAttribute("operation", "update");
            files.appendChild(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleFGUpdate");
        }
    }

    public static List[] getChangedLists(UpdateScheduler ush) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChangedLists");
        }
        List deletes = DeltaDataTask.getFileList(ush, "delete", DelFiles);
        List adds = DeltaDataTask.getFileList(ush, "add", AddFiles);
        List updates = DeltaDataTask.getFileList(ush, "update", UpdateFiles);
        List deltaC = ((UpdateSchedulerImpl)ush).getDeltaContents();
        for (int i = 0; i < deltaC.size(); i += 2) {
            String uri = (String)deltaC.get(i);
            String deltatype = (String)deltaC.get(i + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "delta contents: " + uri + ", " + deltatype);
            }
            if ("add".equals(deltatype)) {
                adds.add(uri);
                continue;
            }
            if ("delete".equals(deltatype)) {
                deletes.add(uri);
                continue;
            }
            if ("update".equals(deltatype)) {
                updates.add(uri);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Unexpected behavior: " + uri + ", " + deltatype);
        }
        List[] retVal = new List[]{deletes, adds, updates};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChangedLists: " + retVal);
        }
        return retVal;
    }

    private static List getFileList(Scheduler scheduler, String op, String internalOp) {
        Object changeFiles;
        List appUpdateContentUriTableFiles;
        Hashtable tbl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileList " + scheduler.getProperties());
        }
        HashSet<String> files = new HashSet<String>();
        List DeltaDataTaskFiles = (List)scheduler.getProperties().get(internalOp);
        if (DeltaDataTaskFiles != null) {
            files.addAll(DeltaDataTaskFiles);
        }
        if ((tbl = (Hashtable)scheduler.getProperties().get("contenturi_table")) != null && (appUpdateContentUriTableFiles = (List)tbl.get(op)) != null) {
            files.addAll(appUpdateContentUriTableFiles);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "op: " + op + " internalOp " + internalOp);
        }
        if (null != (changeFiles = scheduler.getProperties().get(op))) {
            if (changeFiles instanceof List) {
                files.addAll((List)changeFiles);
            } else if (changeFiles instanceof String) {
                String[] s = ((String)changeFiles).split("\\+");
                for (int i = 0; i < s.length; ++i) {
                    files.add(s[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileList " + files);
        }
        return new ArrayList(files);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/DeltaDataTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.9.1.7");
        }
        CLASS_NAME = DeltaDataTask.class.getName();
    }
}

