/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class DeleteAppConfigTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(DeleteAppConfigTask.class);
    private static final String CLASS_NAME;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            RepositoryContext appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to delete appContext: " + appContext);
            }
            boolean bDelParent = true;
            List depls = appContext.getParentContext().getChildren(AppUtils.getContextType("deployments"));
            if (depls.size() > 1) {
                bDelParent = false;
            }
            if (bDelParent) {
                appContext.getParentContext().delete(true);
            } else {
                String earName = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delete ear: " + earName);
                }
                if (appContext.getParent().isAvailable(earName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Available hence delete: " + earName);
                    }
                    appContext.getParent().delete(earName);
                }
                try {
                    Properties p = AppUtils.getEditionProps(appContext);
                    String marker = EditionHelper.getEditionPropSuffix(appContext.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "key marker is " + marker);
                    }
                    Enumeration<Object> keys = p.keys();
                    ArrayList<String> l = new ArrayList<String>();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String[] appAndEdition = EditionHelper.getAppAndEdition(key);
                        if (marker.length() == 0) {
                            if (appAndEdition[1].trim().length() != 0) continue;
                            l.add(key);
                            continue;
                        }
                        if (!key.endsWith(marker)) continue;
                        l.add(key);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "remove keys: " + l);
                    }
                    if (l.size() > 0) {
                        for (int i = 0; i < l.size(); ++i) {
                            p.remove(l.get(i));
                        }
                        AppUtils.setEditionProps(appContext, p);
                    }
                }
                catch (AdminException ex) {
                    RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "performTask", "116", this);
                    this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA5109E", new String[]{ex.toString(), this.scheduler.getAppName()}));
                }
                appContext.delete(true);
            }
            this.checkForMarkerFileInWebModule(appContext);
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5102I", new String[]{this.scheduler.getAppName()}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "performTask", "137", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5103E", new String[]{this.scheduler.getAppName()}));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error deleting app binaries: " + th);
            }
            return true;
        }
    }

    private void checkForMarkerFileInWebModule(RepositoryContext appContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFormMarkerFileInWebModule", new Object[]{appContext});
        }
        List<String> webModsList = AppUtils.getListWebModulesFromAppCtx(appContext);
        AppUtils.checkForMarkerFileInWebModule("create.merker.file", webModsList, appContext.getPath() + "/");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFormMarkerFileInWebModule");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/DeleteAppConfigTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.15");
        }
        CLASS_NAME = DeleteAppConfigTask.class.getName();
    }
}

