/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.ConnectorModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;

public class ConfigRepoHelper {
    private static TraceComponent tc = Tr.register(ConfigRepoHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static Object workSpaceIdLock;
    private static int workSpaceIdCounter;

    public static boolean containsEList(EList list, Object o) {
        if (o == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(o)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkSpace getWorkSpace(String wID) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Init config and create workspace");
        }
        ModelMgr.initialize("ws-server");
        RepositoryMetaDataFactory.initialize();
        AppdeploymentPackageImpl.init();
        String id = wID;
        if (id == null) {
            Object object = workSpaceIdLock;
            synchronized (object) {
                workSpaceIdCounter = (workSpaceIdCounter + 1) % 100;
                id = "" + System.currentTimeMillis() + workSpaceIdCounter;
            }
        }
        return WorkSpaceManagerFactory.getManager().getWorkSpace(id);
    }

    public static void removeWorkSpace(boolean bSync, WorkSpace ws) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeWorkSpace");
        }
        if (bSync) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sync workspace");
            }
            ws.synch(new HashMap());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "remove workspace");
        }
        String un = ws.getUserName();
        WorkSpaceManagerFactory.getManager().removeWorkSpace(un);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeWorkSpace");
        }
    }

    public static boolean isEditAllowed(ApplicationDeployment appDepl) {
        return !appDepl.isZeroBinaryCopy() && (!appDepl.isZeroEarCopy() || !appDepl.isUseMetadataFromBinaries());
    }

    public static EARFile getEarFileForApp(WorkSpace ws, RepositoryContext rc, ResourceBundle bundle, boolean bReadOnly) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarFileForApp", new Object[]{new Boolean(bReadOnly)});
        }
        EARFile earFile = null;
        ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
        earFile = appDepl.isUseMetadataFromBinaries() ? ConfigRepoHelper.getEarFileFromBinaries(rc, ws, bundle, bReadOnly) : ConfigRepoHelper.getEarFileFromDeployment(ws, rc, bReadOnly);
        if (!ConfigRepoHelper.isMetadataComplete(appDepl)) {
            earFile.rollUpRoles();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileForApp", new Object[]{earFile});
        }
        return earFile;
    }

    public static EARFile getEarFileFromDeployment(WorkSpace ws, RepositoryContext rc) throws Exception {
        return ConfigRepoHelper.getEarFileFromDeployment(ws, rc, true);
    }

    public static EARFile getEarFileFromDeployment(WorkSpace ws, RepositoryContext rc, boolean bReadOnly) throws Exception {
        ApplicationDeployment ad = ConfigRepoHelper.getAppDeploymentForApp(rc);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarFileFromDeployment", new Object[]{rc, new Boolean(bReadOnly)});
        }
        if (ad.isZeroBinaryCopy()) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0144E", new Object[]{rc.getName()}));
        }
        rc.extract(false);
        String binariesURL = ConfigRepoHelper.getEarPathForDeployment(ws, rc, ad, bReadOnly);
        EARFile earFile = AppInstallHelper.getEarFile(rc.getPath(), false, bReadOnly, AppUtils.getBundle(null), binariesURL, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileFromDeployment: " + earFile);
        }
        if (earFile == null) {
            throw new AdminException("Can not instantiate earfile for: " + rc.getName());
        }
        return earFile;
    }

    public static EARFile getEarFileFromDeploymentOnly(WorkSpace ws, RepositoryContext rc, boolean bReadOnly) throws Exception {
        ApplicationDeployment ad = ConfigRepoHelper.getAppDeploymentForApp(rc);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarFileFromDeploymentOnly");
        }
        if (ad.isZeroBinaryCopy()) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0144E", new Object[]{rc.getName()}));
        }
        rc.extract(false);
        EARFile earFile = AppInstallHelper.getEarFile(rc.getPath(), false, bReadOnly, AppUtils.getBundle(null));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileFromDeploymentOnly: " + earFile);
        }
        if (earFile == null) {
            throw new AdminException("Can not instantiate earfile for: " + rc.getName());
        }
        return earFile;
    }

    protected static String getEarPathForDeployment(WorkSpace ws, RepositoryContext rc, ApplicationDeployment appDeployment, boolean bReadOnly) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarPathForDeployment", new Object[]{rc, new Boolean(bReadOnly)});
        }
        boolean metadataComplete = ConfigRepoHelper.isMetadataComplete(appDeployment);
        String earPath = null;
        if (!metadataComplete) {
            earPath = rc.getParent().getPath() + File.separator + rc.getName() + ".ear";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "search earPath " + earPath);
            }
            String earName = rc.getName() + ".ear";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "earName is " + earName);
            }
            if (rc.getParent().isAvailable(earName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extracting " + earName);
                }
                rc.getParent().extract(earName, false);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bReadOnly: " + bReadOnly);
                }
                if (!bReadOnly && appDeployment.isZeroBinaryCopy()) {
                    ApplicationDeployment appdepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), appdepl.isZeroBinaryCopy() ? "ADMA0145E" : "ADMA0147E", new Object[]{rc.getName()}));
                }
                earPath = ConfigRepoHelper.getAbsoluteBinariesURL(rc, ws, true);
                if (new File(earPath).exists()) {
                    ApplicationDeployment appdepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
                    EList l = appdepl.getProperties();
                    for (int i = 0; i < l.size(); ++i) {
                        Property p = (Property)l.get(i);
                        if (!p.getName().equals("was.loose.config")) continue;
                        LooseConfigRegister.singleton().addLooseMapping(earPath, p.getValue());
                        break;
                    }
                } else {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0173E", new String[]{rc.getName(), "getEarPathFromDeployment"}));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarPathForDeployment", new Object[]{earPath});
        }
        return earPath;
    }

    public static boolean isMetadataComplete(ApplicationDeployment appDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMetadataComplete", new Object[]{appDeployment});
        }
        boolean metadataComplete = false;
        Property metadataProp = ConfigRepoHelper.getMetadataCompleteProp(appDeployment);
        if (metadataProp != null && metadataProp.getValue().equals("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "metadata complete property is set to true");
            }
            metadataComplete = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMetadataComplete", new Object[]{new Boolean(metadataComplete)});
        }
        return metadataComplete;
    }

    public static Property getMetadataCompleteProp(ApplicationDeployment appDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataCompleteProp", new Object[]{appDeployment});
        }
        Property metadataProp = null;
        EList props = appDeployment.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            Property p = (Property)props.get(i);
            if (!p.getName().equals("metadata.complete")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found metadata complete property");
            }
            metadataProp = p;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataCompleteProp", new Object[]{metadataProp});
        }
        return metadataProp;
    }

    protected static String expandVariable(String var) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandVariable", var);
        }
        VariableMap variableMap = null;
        String result = var;
        try {
            class RequiredClass {
                RequiredClass() {
                }
            }
            variableMap = WsServiceRegistry.getService(new RequiredClass(), VariableMap.class);
            if (variableMap != null) {
                result = variableMap.expand(var);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandVariable", result);
        }
        return result;
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext rc, WorkSpace ws, ResourceBundle resBundle, String configRoot) throws Exception {
        return ConfigRepoHelper.getEarFileFromBinaries(rc, ws, resBundle, true);
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext rc, WorkSpace ws, ResourceBundle resBundle, String configRoot, boolean bReadOnly) throws Exception {
        return ConfigRepoHelper.getEarFileFromBinaries(rc, ws, resBundle, bReadOnly);
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext rc, WorkSpace ws, ResourceBundle resBundle, boolean bReadOnly) throws Exception {
        EARFile earFile;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEarFileFromBinaries: " + rc);
            }
            earFile = null;
            RepositoryContext appBinCtx = rc.getParent();
            ApplicationDeployment appdepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            try {
                String earName = rc.getName() + ".ear";
                if (rc.getParent().isAvailable(earName)) {
                    rc.getParent().extract(earName, false);
                    earFile = AppInstallHelper.getEarFile(appBinCtx.getPath() + File.separator + earName, false, bReadOnly, resBundle);
                    break block8;
                }
                if (!bReadOnly) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), appdepl.isZeroBinaryCopy() ? "ADMA0145E" : "ADMA0147E", new Object[]{rc.getName()}));
                }
                String binURL = ConfigRepoHelper.getAbsoluteBinariesURL(rc, ws);
                if (new File(binURL).exists()) {
                    EList l = appdepl.getProperties();
                    for (int i = 0; i < l.size(); ++i) {
                        Property p = (Property)l.get(i);
                        if (!p.getName().equals("was.loose.config")) continue;
                        LooseConfigRegister.singleton().addLooseMapping(binURL, p.getValue());
                        break;
                    }
                    earFile = AppInstallHelper.getEarFile(binURL, false, bReadOnly, resBundle);
                    break block8;
                }
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0173E", new String[]{rc.getName(), "getEarFile"}));
            }
            catch (Throwable th) {
                throw new AdminException(th, "Can not instantiate earfile for: " + appBinCtx.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileFromBinaries: " + earFile);
        }
        return earFile;
    }

    public static String getAbsoluteBinariesURL(RepositoryContext rc, WorkSpace ws) throws Exception {
        return ConfigRepoHelper.getAbsoluteBinariesURL(rc, ws, false);
    }

    public static String getAbsoluteBinariesURL(RepositoryContext rc, WorkSpace ws, boolean alwaysExpand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAbsoluteBinariesURL", new Object[]{rc, ws, new Boolean(alwaysExpand)});
        }
        ApplicationDeployment appdepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
        String appdepl_binURL = appdepl.getBinariesURL();
        String binURL = null;
        String nodeName = null;
        String configRoot = null;
        String profileKey = AdminContext.peek();
        if (profileKey != null) {
            Repository rep;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " In AdminSubsytem", profileKey);
            }
            if ((rep = (Repository)AdminSubsystemServiceRegistry.getService(Repository.class.getName())) != null) {
                configRoot = rep.getConfigRoot().getConfigRootPath();
            }
        } else {
            configRoot = System.getProperty("was.repository.root");
            if (configRoot == null) {
                configRoot = System.getProperty("user.install.root") + "/config";
            }
        }
        Object[] ctxs = AppUtils.getContextArray("nodes", rc.getParent().getParent(), ws);
        if (ctxs.length == 1 || alwaysExpand) {
            nodeName = ((RepositoryContext)ctxs[0]).getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Base env, nodeName = " + nodeName);
            }
        } else {
            nodeName = ConfigRepoHelper.getNodeNameIfDeployedOnDmgr(appdepl);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ND env, app deployed on dmgr, nodeName = " + nodeName);
            }
        }
        if (nodeName != null) {
            VariableMap map = AppUtils.createVarMap(configRoot, rc.getParent().getParent().getName(), nodeName, null);
            binURL = AppUtils.convert2AbsPath(appdepl_binURL, map);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "binURL = " + binURL);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The binariesURL can be resolved only if the app is deployed in Base or on the Dmgr in ND");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "binURL: " + binURL);
        }
        if (binURL != null) {
            return binURL;
        }
        return new String();
    }

    public static String getNodeNameIfDeployedOnDmgr(ApplicationDeployment appdepl) {
        String nodeName = null;
        block0: for (int i = 0; nodeName == null && i < appdepl.getModules().size(); ++i) {
            ModuleDeployment moddepl = (ModuleDeployment)appdepl.getModules().get(i);
            EList modtargets = moddepl.getTargetMappings();
            Iterator modtgt_iter = modtargets.iterator();
            while (modtgt_iter.hasNext()) {
                DeploymentTarget deplTarget = ((DeploymentTargetMapping)modtgt_iter.next()).getTarget();
                if (!ConfigRepoHelper.isDeployedOnDmgr(deplTarget)) continue;
                nodeName = ((ServerTarget)deplTarget).getNodeName();
                continue block0;
            }
        }
        return nodeName;
    }

    public static boolean isDeployedOnDmgr(DeploymentTarget deplTarget) {
        return deplTarget instanceof ServerTarget && deplTarget.getName().equals("dmgr");
    }

    public static Resource getAppDeploymentResource(RepositoryContext rc) throws Exception {
        URI uri = URI.createURI("deployment.xml");
        Resource res = rc.getResourceSet().createResource(uri);
        HashMap options = new HashMap();
        res.load(options);
        return res;
    }

    public static ApplicationDeployment getAppDeploymentForApp(RepositoryContext rc) throws Exception {
        return ConfigRepoHelper.getAppDeploymentForApp(ConfigRepoHelper.getAppDeploymentResource(rc));
    }

    public static ApplicationDeployment getAppDeploymentForApp(Resource res) throws Exception {
        AppdeploymentPackageImpl.init();
        Deployment d = (Deployment)res.getContents().get(0);
        return (ApplicationDeployment)d.getDeployedObject();
    }

    public static Vector getServersForAppDeployment(ApplicationDeployment appDepl, Vector notFound, RepositoryContext cellContext, WorkSpace ws, boolean includeClusterMembers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForAppDeployment");
        }
        Vector retVal = new Vector();
        for (int i = 0; i < appDepl.getModules().size(); ++i) {
            ModuleDeployment depl = (ModuleDeployment)appDepl.getModules().get(i);
            Vector ret = ConfigRepoHelper.getServersForModuleDeployment(depl, notFound, cellContext, ws, includeClusterMembers);
            retVal.addAll(ret);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server for appDepl: " + retVal);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForAppDeployment");
        }
        return retVal;
    }

    public static Vector getServersForAppDeploymentModule(ApplicationDeployment appDepl, Vector notFound, RepositoryContext cellContext, WorkSpace ws, boolean includeClusterMembers, String moduleuri) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForAppDeployment");
        }
        Vector retVal = new Vector();
        for (int i = 0; i < appDepl.getModules().size(); ++i) {
            ModuleDeployment depl = (ModuleDeployment)appDepl.getModules().get(i);
            if (depl.getUri().equals(moduleuri)) continue;
            Vector ret = ConfigRepoHelper.getServersForModuleDeployment(depl, notFound, cellContext, ws, includeClusterMembers);
            retVal.addAll(ret);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server for appDepl: " + retVal);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForAppDeployment");
        }
        return retVal;
    }

    public static Vector getServersForModuleDeployment(ModuleDeployment depl, Vector notFound, RepositoryContext cellContext, WorkSpace ws, boolean includeClusterMembers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModuleDeployment");
        }
        Vector<RepositoryContext> retVal = new Vector<RepositoryContext>();
        EList mappings = depl.getTargetMappings();
        for (int j = 0; j < mappings.size(); ++j) {
            DeploymentTarget t = ((DeploymentTargetMapping)mappings.get(j)).getTarget();
            if (t == null) continue;
            if (t instanceof ClusteredTarget) {
                RepositoryContext rc = AppUtils.findContext("clusters", t.getName(), null, cellContext, ws, true);
                if (rc == null) {
                    if (notFound != null) {
                        if (notFound.contains(t.getName())) continue;
                        notFound.addElement(t.getName());
                        continue;
                    }
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5027E", new Object[]{t.getName()}));
                }
                if (!retVal.contains(rc)) {
                    retVal.addElement(rc);
                }
            }
            if (!(t instanceof ServerTarget)) continue;
            String nodeName = ((ServerTarget)t).getNodeName();
            RepositoryContext rc = AppUtils.findContext("servers", t.getName(), nodeName, cellContext, ws, false);
            if (rc == null) {
                if (notFound != null) {
                    if (notFound.contains(t.getName())) continue;
                    notFound.addElement(t.getName());
                    continue;
                }
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5028E", new Object[]{t.getName(), nodeName}));
            }
            if (!includeClusterMembers && AppUtils.getClusterFromMember(AppUtils.findContext("servers", t.getName(), nodeName, cellContext, ws, false), ws) != null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Ignoring  cluster member: " + t.getName());
                continue;
            }
            if (retVal.contains(rc)) continue;
            retVal.addElement(rc);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server for depl: " + retVal);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModuleDeployment");
        }
        return retVal;
    }

    public static boolean validateTarget(List mappings, RepositoryContext cellContext, WorkSpace ws) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModuleDeployment");
        }
        boolean retVal = false;
        for (int j = 0; j < mappings.size(); ++j) {
            RepositoryContext rc;
            DeploymentTarget t = ((DeploymentTargetMapping)mappings.get(j)).getTarget();
            if (t == null) continue;
            if (t instanceof ClusteredTarget && (rc = AppUtils.findContext("clusters", t.getName(), null, cellContext, ws, true)) == null) {
                return retVal;
            }
            if (!(t instanceof ServerTarget)) continue;
            String nodeName = ((ServerTarget)t).getNodeName();
            RepositoryContext rc2 = AppUtils.findContext("servers", t.getName(), nodeName, cellContext, ws, false);
            if (rc2 != null) continue;
            return retVal;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModuleDeployment");
        }
        return true;
    }

    public static Hashtable getNodeServerRelation(WorkSpace ws, Vector svrs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeServerRelation");
        }
        Hashtable ret = new Hashtable();
        Vector servers = ConfigRepoHelper.getAllServers(ws, svrs);
        for (int i = 0; i < servers.size(); ++i) {
            RepositoryContext rc = (RepositoryContext)servers.elementAt(i);
            Vector<RepositoryContext> vals = (Vector<RepositoryContext>)ret.get(rc.getParent());
            if (vals == null) {
                vals = new Vector<RepositoryContext>();
                ret.put(rc.getParent(), vals);
            }
            if (vals.contains(rc)) continue;
            vals.addElement(rc);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node-server relation: " + ret);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeServerRelation");
        }
        return ret;
    }

    public static Vector getAllServers(WorkSpace ws, Vector svrs) throws Exception {
        final WorkSpace wsFinal = ws;
        final Vector svrsFinal = svrs;
        Vector v = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            v = (Vector)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ConfigRepoHelper._getAllServersAsSystem(wsFinal, svrsFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            throw new AdminException(ex, "Failed to get the servers");
        }
        return v;
    }

    private static Vector _getAllServersAsSystem(WorkSpace ws, Vector svrs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "orig svrs: " + svrs);
        }
        if (svrs.size() == 0) {
            return svrs;
        }
        Vector<RepositoryContext> ret = new Vector<RepositoryContext>();
        for (int i = 0; i < svrs.size(); ++i) {
            RepositoryContext rc = (RepositoryContext)svrs.elementAt(i);
            if (AppUtils.isServer(rc) && !ret.contains(rc)) {
                ret.addElement(rc);
            }
            if (!AppUtils.isCluster(rc)) continue;
            URI uri = URI.createURI("cluster.xml");
            Resource res = rc.getResourceSet().createResource(uri);
            HashMap options = new HashMap();
            res.load(options);
            ServerCluster clst = (ServerCluster)res.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cluster obj: " + clst);
            }
            EList l = clst.getMembers();
            for (int lcv = 0; lcv < l.size(); ++lcv) {
                ClusterMember member = (ClusterMember)l.get(lcv);
                RepositoryContext memContext = AppUtils.findContext("servers", member.getMemberName(), member.getNodeName(), rc.getParent(), ws, false);
                if (memContext == null) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{member.getMemberName(), rc.getName()}));
                }
                if (ret.contains(memContext)) continue;
                ret.addElement(memContext);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ret svrs: " + ret);
        }
        return ret;
    }

    public static String getSIEntryText(RepositoryContext rc) {
        return rc.getParent().getName() + "/" + "deployments" + "/" + rc.getName();
    }

    public static RepositoryContext getAppContextFromSIEntry(String siEntry, RepositoryContext cellC, WorkSpace ws) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppContextFromSIEntry:" + siEntry);
        }
        int i1 = siEntry.indexOf("/");
        int i2 = siEntry.lastIndexOf("/");
        if (i1 == -1 || i2 == -1 || i1 == i2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppContextFromSIEntry: Malformed si entry");
            }
            return null;
        }
        String binName = siEntry.substring(0, i1);
        String appName = siEntry.substring(i2 + 1, siEntry.length());
        RepositoryContext rc = AppUtils.findContext("deployments", appName, binName, cellC, ws, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppContextFromSIEntry:" + rc);
        }
        return rc;
    }

    public static Hashtable updateServerIndexDocs(RepositoryContext appC, WorkSpace ws, Vector svrs, boolean bAdd, ResourceBundle resBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerIndexDocs: " + svrs);
        }
        Hashtable allNodes = ConfigRepoHelper.getNodeServerRelation(ws, svrs);
        AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6018I", new Object[]{allNodes}));
        Hashtable indexDocs = ConfigRepoHelper.getServerIndexDocs(ws, allNodes.keys());
        if (indexDocs == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server index docs not found!!");
            }
            return new Hashtable();
        }
        Enumeration en = allNodes.keys();
        Hashtable retVal = new Hashtable();
        String siText = ConfigRepoHelper.getSIEntryText(appC);
        String lastNode = "";
        try {
            while (en.hasMoreElements()) {
                RepositoryContext nc = (RepositoryContext)en.nextElement();
                Vector sc = (Vector)allNodes.get(nc);
                Vector<String> servers = new Vector<String>();
                for (int i = 0; i < sc.size(); ++i) {
                    servers.addElement(((RepositoryContext)sc.elementAt(i)).getName());
                }
                Resource res = (Resource)indexDocs.get(nc);
                if (res.getContents().size() == 0) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5070E", new Object[]{nc.getName()}));
                }
                ServerIndex top = (ServerIndex)res.getContents().get(0);
                ArrayList<String> retS = new ArrayList<String>();
                retVal.put(nc.getName(), retS);
                lastNode = nc.getName();
                EList entries = top.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "servers for " + nc.getName() + " are " + servers);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + nc.getName() + " are " + entries);
                }
                for (int i = 0; i < entries.size(); ++i) {
                    ServerEntry entry = (ServerEntry)entries.get(i);
                    if (!servers.contains(entry.getServerName())) continue;
                    if (bAdd) {
                        EList depls = entry.getDeployedApplications();
                        if (!depls.contains(siText)) {
                            depls.add(siText);
                            AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6020I", new Object[]{appC, entry.getServerName(), nc.getName()}));
                        }
                    } else {
                        boolean done = entry.getDeployedApplications().remove(siText);
                        AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6021I", new Object[]{siText, entry.getServerName(), nc.getName(), "" + done}));
                    }
                    retS.add(entry.getServerName());
                }
                HashMap options = new HashMap();
                res.save(options);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServerIndexDocs: " + retVal);
            }
            return retVal;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "updateServerIndexDocs", "976");
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, "Server Index update failed at  the last node of " + lastNode);
        }
    }

    public static String getNodeStrFromNodeSvrTable(Hashtable ret, String cell) {
        if (ret == null) {
            return "";
        }
        StringBuffer retS = new StringBuffer();
        boolean bFirst = true;
        Enumeration en = ret.keys();
        while (en.hasMoreElements()) {
            String delimiter = bFirst ? "" : "+";
            retS.append(delimiter + "WebSphere:cell=" + cell + ",node=" + en.nextElement());
            bFirst = false;
        }
        return retS.toString();
    }

    public static Hashtable getServerIndexDocs(WorkSpace ws, Enumeration en) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndexDocs");
        }
        Hashtable<RepositoryContext, Resource> retVal = new Hashtable<RepositoryContext, Resource>();
        while (en.hasMoreElements()) {
            RepositoryContext rCtx = (RepositoryContext)en.nextElement();
            URI uri = URI.createURI("serverindex.xml");
            Resource res = rCtx.getResourceSet().createResource(uri);
            HashMap options = new HashMap();
            res.load(options);
            if (res == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{"serverindex.xml", rCtx}));
            }
            retVal.put(rCtx, res);
        }
        Tr.debug(tc, "retVal: " + retVal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndexDocs");
        }
        return retVal;
    }

    public static String getDDUri(ModuleRef mRef) throws Exception {
        if (mRef.getAltDeploymentDescriptor() != null && !mRef.getAltDeploymentDescriptor().eResource().getURI().toString().equals("")) {
            return mRef.getDeploymentDescriptor().eResource().getURI().toString();
        }
        if (mRef.isEJB()) {
            return "META-INF/ejb-jar.xml";
        }
        if (mRef.isWeb()) {
            return "WEB-INF/web.xml";
        }
        if (mRef.isConnector()) {
            return "META-INF/ra.xml";
        }
        return mRef.getDeploymentDescriptor().eResource().getURI().toString();
    }

    public static String getDDUri(ModuleDeployment md2) throws Exception {
        if (md2.getAltDD() != null && !md2.getAltDD().equals("")) {
            return md2.getAltDD();
        }
        if (md2 instanceof EJBModuleDeployment) {
            return "META-INF/ejb-jar.xml";
        }
        if (md2 instanceof WebModuleDeployment) {
            return "WEB-INF/web.xml";
        }
        if (md2 instanceof ConnectorModuleDeployment) {
            return "META-INF/ra.xml";
        }
        return null;
    }

    public static Hashtable getCNP(String unique, ApplicationDeployment appDepl, String cellName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCNP");
        }
        Hashtable<String, String> ret = new Hashtable<String, String>();
        boolean done = false;
        EList mds = appDepl.getModules();
        for (int i = 0; i < mds.size(); ++i) {
            ModuleDeployment md2 = (ModuleDeployment)mds.get(i);
            String dd = ConfigRepoHelper.getDDUri(md2);
            if (dd == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unknown module deployment: " + md2);
                continue;
            }
            String un = util.createUniqueModuleName(dd, md2.getUri());
            if (!AppUtils.isEmpty(unique)) {
                if (!unique.equals(un)) continue;
                ret.put(un, ConfigRepoHelper.getCNP(md2, cellName));
                return ret;
            }
            ret.put(un, ConfigRepoHelper.getCNP(md2, cellName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCNP: " + ret);
        }
        return ret;
    }

    public static String getCNP(ModuleDeployment md2, String cell) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCNP: " + md2);
        }
        String retVal = "";
        EList l = md2.getTargetMappings();
        for (int i = 0; i < l.size(); ++i) {
            DeploymentTargetMapping map = (DeploymentTargetMapping)l.get(i);
            DeploymentTarget target = map.getTarget();
            String t = "";
            if (target instanceof ClusteredTarget) {
                t = "WebSphere:cell=" + cell + ",cluster=" + target.getName();
            } else {
                if (!(map.getTarget() instanceof ServerTarget)) continue;
                t = "WebSphere:cell=" + cell + ",node=" + ((ServerTarget)target).getNodeName() + ",server=" + target.getName();
            }
            if (map.getConfig() != null && !AppUtils.isEmpty(((ModuleConfig)map.getConfig()).getName())) {
                t = t + ",config=" + ((ModuleConfig)map.getConfig()).getName();
            }
            retVal = AppUtils.isEmpty(retVal) ? t : retVal + "+" + t;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCNP: " + retVal);
        }
        return retVal;
    }

    public static String getTargetString(RepositoryContext rc, String orig) {
        String s = null;
        s = AppUtils.isCluster(rc) ? "WebSphere:cell=" + rc.getParent().getName() + ",cluster=" + rc.getName() : "WebSphere:cell=" + rc.getParent().getParent().getName() + ",node=" + rc.getParent().getName() + ",server=" + rc.getName();
        if (AppUtils.isEmpty(orig)) {
            return s;
        }
        return orig + "+" + s;
    }

    public static String getTargetString(ObjectName on, String orig) {
        String s = "WebSphere:cell=" + on.getKeyProperty("cell") + ",node=" + on.getKeyProperty("node") + ",server=" + on.getKeyProperty("process");
        if (AppUtils.isEmpty(orig)) {
            return s;
        }
        return orig + "+" + s;
    }

    public static Vector getServerNames(String names, String unique, RepositoryContext cellContext, WorkSpace ws) throws Exception {
        return ConfigRepoHelper.getServerNames(names, unique, true, cellContext, ws);
    }

    public static Vector getServerNames(String names, String unique, boolean returnConfig, RepositoryContext cellContext, WorkSpace ws) throws Exception {
        Vector v = ConfigRepoHelper.getAddRemoveServerNames(names, unique, returnConfig, cellContext, ws);
        return (Vector)v.elementAt(0);
    }

    private static boolean parseServersString(String names, Vector addList, Vector remList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseServerString: " + names);
        }
        boolean replacement = false;
        String remDelim = "-WebSphere:";
        String addDelim = "+WebSphere:";
        if (!names.startsWith("+") && !names.startsWith("-")) {
            replacement = true;
            if (names.indexOf(remDelim) > -1) {
                throw new AdminException("Target string: " + names + " without any delimiter prefix is specified for replacement, should" + "contain " + "+" + " delimiters only.");
            }
            StringTokenizer adds = new StringTokenizer(names, "+");
            while (adds.hasMoreTokens()) {
                addList.addElement(adds.nextToken());
            }
        } else {
            Vector<String> v = new Vector<String>();
            StringTokenizer st = new StringTokenizer(names, "WebSphere:");
            while (st.hasMoreTokens()) {
                String s = (String)st.nextElement();
                String c = s.substring(s.length() - 1);
                if (!"+".equals(c) && !"-".equals(c)) continue;
                v.add(c);
            }
            String[] tArray = names.split("\\" + addDelim + "|" + remDelim);
            ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(tArray));
            tokens.remove(0);
            AppUtils.dbg(tc, "delims = " + v);
            AppUtils.dbg(tc, "tokens = " + tokens);
            for (int i = 0; i < tokens.size(); ++i) {
                String token = tokens.get(i);
                String delim = (String)v.elementAt(i);
                if ("+".equals(delim)) {
                    addList.add("WebSphere:" + token);
                    continue;
                }
                if (!"-".equals(delim)) continue;
                remList.add("WebSphere:" + token);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseServerString: addList=" + addList + " , remList =" + remList);
        }
        return replacement;
    }

    public static Vector getAddRemoveServerNames(String names, String unique, boolean returnConfig, RepositoryContext cellContext, WorkSpace ws) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAddRemoveServerNames");
        }
        if (AppUtils.isEmpty(names)) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getAddRemoveServerNames: null");
            }
            return null;
        }
        Vector adds = new Vector();
        Vector rems = new Vector();
        boolean replacement = ConfigRepoHelper.parseServersString(names, adds, rems);
        Iterator remList = rems.iterator();
        Vector<String> tempRemList = new Vector<String>();
        while (remList.hasNext()) {
            String r = (String)remList.next();
            if (!adds.contains(r)) continue;
            adds.remove(r);
            tempRemList.add(r);
        }
        for (int i = 0; i < tempRemList.size(); ++i) {
            rems.remove(tempRemList.elementAt(i));
        }
        Vector<Serializable> ret = new Vector<Serializable>();
        Vector addNames = ConfigRepoHelper.getServerNames(adds, unique, returnConfig, cellContext, ws);
        Vector remNames = ConfigRepoHelper.getServerNames(rems, unique, returnConfig, cellContext, ws);
        ret.add(0, addNames);
        ret.add(1, remNames);
        ret.add(2, new Boolean(replacement));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAddRemoveServerNames: names to add = " + addNames + " , names to rem = " + remNames + " , straight replacement? " + replacement);
        }
        return ret;
    }

    public static Vector getServerNames(Vector names, String unique, boolean returnConfig, RepositoryContext cellContext, WorkSpace ws) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerNames: " + names);
        }
        Vector<Object> retVal = new Vector<Object>();
        if (names == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getServerNames: null");
            }
            return retVal;
        }
        Iterator st = names.iterator();
        Object[] sContexts = AppUtils.getContextArray("servers", cellContext, ws);
        while (st.hasNext()) {
            String token = ((String)st.next()).trim();
            if (AppUtils.isEmpty(token)) continue;
            ObjectName on = null;
            try {
                on = new ObjectName(token);
            }
            catch (MalformedObjectNameException ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bad token: " + token);
                }
                throw new AdminException(ex, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{token}));
            }
            RepositoryContext rc = null;
            String clName = on.getKeyProperty("cluster");
            if (!AppUtils.isEmpty(clName)) {
                rc = AppUtils.findContext("clusters", clName = clName.trim(), null, cellContext, ws, true);
                if (rc == null) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5022E", new Object[]{clName, unique}));
                }
            } else {
                String sName = on.getKeyProperty("server");
                if (AppUtils.isEmpty(sName)) {
                    sName = on.getKeyProperty("process");
                }
                String nName = on.getKeyProperty("node");
                if (AppUtils.isEmpty(sName)) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{token, unique}));
                }
                sName = sName.trim();
                rc = AppUtils.getContextFromArray(sContexts, sName, nName, false);
            }
            if (rc == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{token, unique}));
            }
            String config = on.getKeyProperty("config");
            if (config == null) {
                config = "";
            }
            if (!retVal.contains(rc)) {
                retVal.addElement(rc);
                if (!returnConfig) continue;
                retVal.addElement(config);
                continue;
            }
            Tr.warning(tc, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5032W", new Object[]{rc.getName(), names, token}));
        }
        for (int i = 0; i < retVal.size(); i += 2) {
            RepositoryContext clContext;
            RepositoryContext rc = (RepositoryContext)retVal.elementAt(i);
            if (AppUtils.isCluster(rc) || (clContext = AppUtils.getClusterFromMember(rc, ws)) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target has member: " + rc + " which belongs to " + clContext);
            }
            if (retVal.contains(clContext)) continue;
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5033E", new Object[]{rc.getName(), clContext.getName(), unique}));
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getServerNames: " + retVal);
        }
        return retVal;
    }

    public static String getModuleType(Object mRefOrmFile) {
        if (mRefOrmFile instanceof ModuleRef) {
            ModuleRef mRef = (ModuleRef)mRefOrmFile;
            if (mRef.isEJB()) {
                return "moduletype.ejb";
            }
            if (mRef.isWeb()) {
                return "moduletype.web";
            }
            if (mRef.isConnector()) {
                return "moduletype.connector";
            }
        } else if (mRefOrmFile instanceof ModuleFile) {
            ModuleFile mFile = (ModuleFile)mRefOrmFile;
            if (mFile.isEJBJarFile()) {
                return "moduletype.ejb";
            }
            if (mFile.isWARFile()) {
                return "moduletype.web";
            }
            if (mFile.isRARFile()) {
                return "moduletype.connector";
            }
        }
        return "moduletype.unknown";
    }

    public static boolean isDeployable(Object mRefOrmFile) {
        if (mRefOrmFile instanceof ModuleRef) {
            ModuleRef mRef = (ModuleRef)mRefOrmFile;
            return mRef.isEJB() || mRef.isWeb() || mRef.isConnector();
        }
        if (mRefOrmFile instanceof ModuleFile) {
            ModuleFile mRef = (ModuleFile)mRefOrmFile;
            return mRef.isEJBJarFile() || mRef.isWARFile() || mRef.isRARFile();
        }
        return false;
    }

    public static String find_index(String id, Hashtable hash) {
        String str = (String)hash.get(id);
        String sss = id;
        while (str != null) {
            int indx = sss.lastIndexOf("-");
            if (indx == -1) {
                sss = id + "-" + Integer.toString(1);
            } else {
                String snum = sss.substring(indx + 1);
                try {
                    int inum = Integer.valueOf(snum);
                    sss = id.substring(0, indx) + "-" + Integer.toString(++inum);
                }
                catch (NumberFormatException ex) {
                    sss = id + "-" + Integer.toString(999);
                }
            }
            str = (String)hash.get(sss);
        }
        return sss;
    }

    public static ObjectName getObjectName(RepositoryContext ctx) throws MalformedObjectNameException {
        if (AppUtils.isServer(ctx)) {
            return new ObjectName("WebSphere:cell=" + ctx.getParent().getParent().getName() + ",node=" + ctx.getParent().getName() + ",server=" + ctx.getName());
        }
        return new ObjectName("WebSphere:cell=" + ctx.getParent().getName() + ",cluster=" + ctx.getName());
    }

    public static List getServerNameForServerEntries(List serverEntries) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerNameForServerEntries");
        }
        ArrayList<String> serverNameEntries = new ArrayList<String>();
        for (int i = 0; i < serverEntries.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)serverEntries.get(i);
            String serverName = serverEntry.getServerName();
            serverNameEntries.add(serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerNameForServerEntries", new Object[]{serverNameEntries});
        }
        return serverNameEntries;
    }

    public static ServerEntry createServerEntry(ServerIndex si, String serverName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerEntry", new Object[]{si, serverName});
        }
        ServerindexFactory indexFactory = null;
        ServerEntry serverEntry = null;
        ServerindexPackage ipkg = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        indexFactory = ipkg.getServerindexFactory();
        serverEntry = indexFactory.createServerEntry();
        serverEntry.setServerName(serverName);
        serverEntry.setServerType("APPLICATION_SERVER");
        serverEntry.setServerDisplayName(serverName);
        si.getServerEntries().add(serverEntry);
        serverEntry.eResource().save(new HashMap());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerEntry");
        }
        return serverEntry;
    }

    public static ServerIndex getReferenceToSystemAppsXML(WorkSpace ws, Hashtable props) throws WorkSpaceException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReferenceToSystemAppsXML");
        }
        String cellName = (String)props.get("cell.name");
        String nodeName = (String)props.get("node.name");
        WorkSpace workspace = ws;
        String sysAppPath = "/cells/" + cellName + "/nodes/" + nodeName + "/" + "systemapps.xml";
        File systemappsXMLPath = new File(workspace.getPath() + sysAppPath);
        String configRoot = System.getProperty("was.repository.root");
        File systemappsXMLPathConfig = new File(configRoot + sysAppPath);
        AppUtils.dbg(tc, "xxx systemappsXMLPath = " + systemappsXMLPath);
        AppUtils.dbg(tc, "xxx systemappsXMLPathConfig  = " + systemappsXMLPathConfig);
        if (systemappsXMLPath.exists() || systemappsXMLPathConfig.exists()) {
            RepositoryContext nodeContext = workspace.findContext("cells/" + cellName + "/nodes/" + nodeName);
            nodeContext.extract("systemapps.xml", false);
            Resource resource = nodeContext.getResourceSet().createResource(URI.createURI("systemapps.xml"));
            resource.load(new HashMap());
            return (ServerIndex)resource.getContents().get(0);
        }
        RepositoryContext nodeContext = workspace.findContext("cells/" + cellName + "/nodes/" + nodeName);
        return ConfigRepoHelper.createSystemAppsXML(nodeContext, workspace, props);
    }

    public static ServerIndex createSystemAppsXML(RepositoryContext nodeContext, WorkSpace ws, Hashtable props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSystemAppsXML", new Object[]{nodeContext});
        }
        ServerindexFactory indexFactory = null;
        ServerindexPackage ipkg = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        indexFactory = ipkg.getServerindexFactory();
        ServerIndex newServerIndex = indexFactory.createServerIndex();
        String hostName = (String)props.get("host.name");
        newServerIndex.setHostName(hostName);
        String tempResUri = ConfigRepoHelper.makeTemporary(newServerIndex);
        ServerIndex si = (ServerIndex)ConfigRepoHelper.getTemporaryObject(tempResUri);
        String refId = ConfigRepoHelper.createFileInWorkSpace(ws, nodeContext.getURI(), "systemapps.xml", si, "systemapps.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSystemAppsXML");
        }
        return si;
    }

    private static String createFileInWorkSpace(WorkSpace workSpace, String contextId, String resourceUri, EObject object, String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFileInWorkSpace", new Object[]{workSpace, contextId, resourceUri, object, fileName});
        }
        RepositoryContext context = null;
        Resource resource = null;
        String refId = null;
        String contextUri = ConfigRepoHelper.decodeContextUri(contextId);
        AppUtils.dbg(tc, "contextURI = " + contextUri);
        try {
            context = workSpace.findContext(contextUri);
            AppUtils.dbg(tc, "context = " + context);
        }
        catch (WorkSpaceException wse) {
            Tr.error(tc, "error in finding context " + wse.toString());
            return null;
        }
        ResourceSet resourceSet = context.getResourceSet();
        AppUtils.dbg(tc, "resourceSet = " + resourceSet);
        URI uri = URI.createURI(fileName);
        AppUtils.dbg(tc, "resourceSet.getResource " + resourceSet.getResource(uri, false));
        if (!context.isAvailable(fileName) || resourceSet.getResource(uri, false) == null) {
            Tr.warning(tc, "File " + fileName + " was not available in context, " + context.getURI());
            Resource.Factory factory = workSpace.getResourceFactoryRegistry().getFactory(URI.createURI(fileName));
            resource = factory.createResource(URI.createURI(fileName));
            resourceSet.getResources().add(resource);
            AppUtils.dbg(tc, "resource = " + resource);
        }
        if (object.eResource() != null) {
            ((XMIResource)object.eResource()).setID(object, null);
        }
        EList collection = resource.getContents();
        collection.add(object);
        try {
            resource.save(new HashMap());
            refId = ((XMIResource)object.eResource()).getID(object);
        }
        catch (Exception e) {
            Tr.error(tc, "error in saving resource for root object " + e.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFileInWorkSpace");
        }
        return refId;
    }

    private static String decodeContextUri(String contextUri) {
        String newContextUri = null;
        if (contextUri == null) {
            return newContextUri;
        }
        newContextUri = contextUri.replace(':', '/');
        return newContextUri;
    }

    private static String makeTemporary(EObject eObject) {
        String tempResourceUri = RefObjectHelperFactory.getRefObjectHelper().makeTemporary(eObject);
        return tempResourceUri;
    }

    private static EObject getTemporaryObject(String tempResourceUri) {
        EObject eObject = RefObjectHelperFactory.getRefObjectHelper().getTemporaryObject(tempResourceUri);
        return eObject;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/ConfigRepoHelper.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.105.1.13");
        }
        CLASS_NAME = ConfigRepoHelper.class.getName();
        workSpaceIdLock = new Object();
        workSpaceIdCounter = 0;
    }
}

