/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigArchiveTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(ConfigArchiveTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public ConfigArchiveTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean result = true;
        if (this.scheduler instanceof InstallScheduler) {
            InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
            EARFile earFile = installScheduler.getEarFile(false, true);
            String appName = this.scheduler.getAppName();
            WorkSpace workSpace = this.scheduler.getWorkSpace();
            String cellName = AppManagementImpl.getCellName();
            String binDir = AppUtils.getAppBinDirName(null, appName);
            EnhancedEarConfigurator enhancedEarConfigurator = null;
            try {
                try {
                    enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, earFile, true, cellName, appName, binDir);
                    RepositoryContext context = AppUtils.findAppContextFromConfig(appName, workSpace, this.scheduler.getProperties());
                    Resource resource = ConfigRepoHelper.getAppDeploymentResource(context);
                    Deployment deployment = (Deployment)resource.getContents().get(0);
                    EList targets = deployment.getDeploymentTargets();
                    enhancedEarConfigurator.updateApplicationConfiguration((List)targets);
                }
                catch (Exception e) {
                    RasUtils.logException((Throwable)e, tc, CLASS_NAME, "performTask", "108", this);
                    Object var14_15 = null;
                    this.closeEnhancedEarConfigurator(enhancedEarConfigurator);
                }
                Object var14_14 = null;
                this.closeEnhancedEarConfigurator(enhancedEarConfigurator);
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                this.closeEnhancedEarConfigurator(enhancedEarConfigurator);
                throw throwable;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "performTask", "not an install");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(true));
        }
        return true;
    }

    private void closeEnhancedEarConfigurator(EnhancedEarConfigurator configurator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeEnhancedEarConfigurator", "configurator=" + configurator);
        }
        if (configurator != null) {
            try {
                configurator.cleanup();
            }
            catch (Throwable t) {
                RasUtils.logException(t, tc, CLASS_NAME, "closeEnhancedEarConfigurator", "137", this);
                Tr.warning(tc, "ADMA0077W", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeEnhancedEarConfigurator");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        return stringBuilder.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/ConfigArchiveTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.9");
        }
        CLASS_NAME = ConfigArchiveTask.class.getName();
    }
}

