/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileJspTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(CompileJspTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String DESTINATION_DIRECTORY_NAME;
    private static final String CLASS_NAME_JSP_TOOLS_FACTORY_HELPER = "com.ibm.wsspi.jsp.tools.JspToolsFactoryHelper";
    private static final String METHOD_GET_JSP_TOOLS_FACTORY = "getJspToolsFactory";
    private static final String CLASS_NAME_JSP_TOOLS_FACTORY = "com.ibm.wsspi.jsp.tools.JspToolsFactory";
    private static final String METHOD_CREATE_JSP_TOOLS = "createJspTools";
    private static final String CLASS_NAME_JSP_TOOLS = "com.ibm.wsspi.jsp.tools.JspTools";
    private static final String METHOD_COMPILE_APP = "compileApp";
    private static final String METHOD_SET_CLASSPATH = "setClasspath";
    private static final String METHOD_SET_LOGGER = "setLogger";
    private Hashtable<String, ?> compileJspOptions = null;
    private List<String> libraryDirectoryJars = Collections.EMPTY_LIST;
    private boolean compileError = false;

    public CompileJspTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    @Override
    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean result = true;
        Hashtable properties = this.scheduler.getProperties();
        this.compileJspOptions = (Hashtable)properties.get("preCompileJSPs.options");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "performTask", "compileJspOptions=" + this.compileJspOptions);
        }
        if (this.compileJspOptions == null) {
            this.compileJspOptions = new Hashtable();
        }
        try {
            if (this.scheduler instanceof InstallScheduler) {
                this.install((InstallScheduler)this.scheduler);
            } else if (this.scheduler instanceof UpdateScheduler) {
                this.update((UpdateScheduler)this.scheduler);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "performTask", "unexpected scheduler; class=" + this.scheduler.getClass().getName());
                }
                assert (false) : "unexpected scheduler; class=" + this.scheduler.getClass().getName();
            }
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "performTask", "140", this);
            AppNotification notification = this.createNotification("Failed", "ADMA0021E", new String[]{t.toString()});
            this.scheduler.propagateTaskEvent(notification);
            AdminException adminException = null;
            if (t instanceof AdminException) {
                adminException = (AdminException)t;
            } else {
                String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0021E", new Object[]{t.toString()});
                adminException = new AdminException(t, message);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask", adminException);
            }
            throw adminException;
        }
        if (this.compileError) {
            boolean failOnError = Boolean.getBoolean("com.ibm.websphere.management.application.failOnJspCompileError");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performTask", "failOnError=" + failOnError);
            }
            if (failOnError) {
                AppNotification notification = this.createNotification("Failed", "ADMA0216E", null);
                this.scheduler.propagateTaskEvent(notification);
                String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0216E");
                AdminException adminException = new AdminException(message);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "performTask", adminException);
                }
                throw adminException;
            }
        }
        AppNotification notification = this.createNotification("Completed", "ADMA0215I", null);
        this.scheduler.propagateTaskEvent(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(true));
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", compileJspOptions=");
        stringBuilder.append(this.compileJspOptions);
        stringBuilder.append(", libraryDirectoryJars=");
        stringBuilder.append(this.libraryDirectoryJars);
        stringBuilder.append(", compileError=");
        stringBuilder.append(this.compileError);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void install(InstallScheduler installScheduler) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install");
        }
        ArrayList<War> wars = new ArrayList<War>();
        String earPath = installScheduler.getEarPath();
        EARFile earFile = installScheduler.getEarFile(false, true);
        List warFiles = earFile.getWARFiles();
        for (WARFile warFile : warFiles) {
            String name = warFile.getName();
            String source = earPath + File.separator + name;
            String uri = warFile.getURI();
            String classPath = this.getClassPath(uri);
            War war = new War(source, classPath);
            wars.add(war);
        }
        this.libraryDirectoryJars = AppUtils.extractLibraryDirectoryJars(this.scheduler, earFile);
        installScheduler.setEarPath(earPath);
        this.compileWars(wars);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(UpdateScheduler updateScheduler) throws Exception {
        ArrayList<War> wars;
        String source;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update");
            }
            source = null;
            String classPath = null;
            String contentUri = updateScheduler.getContentURI();
            String contentType = updateScheduler.getContentType();
            if (contentType.equals("modulefile")) {
                source = updateScheduler.getContentPath();
                classPath = this.getClassPath(contentUri);
            } else if (contentType.equals("partialapp")) {
                String contentPath = updateScheduler.getContentPath();
                source = contentPath + File.separator + contentUri;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "update", "unexpected context type " + contentType);
                }
                assert (false) : "unexpected context type " + contentType;
            }
            wars = new ArrayList<War>(1);
            War war = new War(source, classPath);
            wars.add(war);
            WorkSpace workSpace = this.scheduler.getWorkSpace();
            RepositoryContext appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), workSpace, this.scheduler.getProperties());
            EARFile earFile = null;
            try {
                earFile = ConfigRepoHelper.getEarFileFromBinaries(appContext, workSpace, this.getResourceBundle(), true);
                this.libraryDirectoryJars = AppUtils.extractLibraryDirectoryJars(this.scheduler, earFile);
                Object var12_11 = null;
                if (earFile == null) break block13;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (earFile != null) {
                    earFile.close();
                }
                throw throwable;
            }
            earFile.close();
        }
        this.compileWars(wars);
        String originalContentType = updateScheduler.getOrigContentType();
        if (originalContentType.equals("modulefile")) {
            Archive archive = AppInstallHelper.getArchive(source, false, true, this.getResourceBundle(), false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "update", "collapsing " + archive.getURI());
            }
            archive.saveNoReopen();
            archive.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    private void compileWars(List<War> wars) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compileWars", "wars=" + wars);
        }
        if (!wars.isEmpty()) {
            Class jspToolsFactoryHelperClass = CompileJspTask.loadClass(CLASS_NAME_JSP_TOOLS_FACTORY_HELPER);
            Method getJspToolsFactoryMethod = jspToolsFactoryHelperClass.getMethod(METHOD_GET_JSP_TOOLS_FACTORY, null);
            Object jspToolsFactory = getJspToolsFactoryMethod.invoke(null, (Object[])null);
            Class jspToolsFactoryClass = CompileJspTask.loadClass(CLASS_NAME_JSP_TOOLS_FACTORY);
            Method createJspToolsMethod = jspToolsFactoryClass.getMethod(METHOD_CREATE_JSP_TOOLS, String.class);
            Class jspToolsClass = CompileJspTask.loadClass(CLASS_NAME_JSP_TOOLS);
            Method compileAppMethod = jspToolsClass.getMethod(METHOD_COMPILE_APP, String.class);
            Method setClasspathMethod = jspToolsClass.getMethod(METHOD_SET_CLASSPATH, String.class);
            Method setLoggerMethod = jspToolsClass.getMethod(METHOD_SET_LOGGER, Logger.class);
            Logger logger = Logger.getLogger(CLASS_NAME, this.getResourceBundleName());
            for (War war : wars) {
                String source = war.getSource();
                String name = new File(source).getName();
                String destination = source + File.separator + DESTINATION_DIRECTORY_NAME;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "compileWars", new String[]{"source=" + source, "name=" + name, "destination=" + destination});
                }
                Object jspTools = createJspToolsMethod.invoke(jspToolsFactory, destination);
                setLoggerMethod.invoke(jspTools, logger);
                String classPath = this.buildClassPath(war.getClassPath());
                if (!AppUtils.isEmpty(classPath)) {
                    setClasspathMethod.invoke(jspTools, classPath);
                }
                Object result = compileAppMethod.invoke(jspTools, source);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "compileWars", "result=" + result);
                }
                AppNotification notification = null;
                if (((Boolean)result).booleanValue()) {
                    notification = this.createNotification("InProgress", "ADMA5003I", new String[]{name});
                } else {
                    notification = this.createNotification("InProgress", "ADMA5004W", new String[]{name});
                    this.compileError = true;
                }
                this.scheduler.propagateTaskEvent(notification);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "compileWars", "no wars to compile");
            }
            AppNotification notification = this.createNotification("InProgress", "ADMA0214W", null);
            this.scheduler.propagateTaskEvent(notification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compileWars");
        }
    }

    private String getClassPath(String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassPath", "uri=" + uri);
        }
        String classPath = null;
        Object object = this.compileJspOptions.get(uri);
        if (object instanceof String) {
            classPath = (String)object;
        } else if (object != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getClassPath", "unexpected object type for uri " + uri + "; class=" + object.getClass().getName());
            }
            assert (false) : "unexpected object type for uri " + uri + "; class=" + object.getClass().getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassPath", classPath);
        }
        return classPath;
    }

    private String buildClassPath(String warClassPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildClassPath", "warClassPath=" + warClassPath);
        }
        StringBuilder buffer = new StringBuilder(512);
        if (!AppUtils.isEmpty(warClassPath)) {
            buffer.append(warClassPath);
            if (!warClassPath.endsWith(File.pathSeparator)) {
                buffer.append(File.pathSeparator);
            }
        }
        for (String jar : this.libraryDirectoryJars) {
            buffer.append(jar);
            buffer.append(File.pathSeparator);
        }
        String classPath = buffer.toString();
        classPath = classPath.replace('/', File.separatorChar);
        classPath = classPath.replace('\\', File.separatorChar);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildClassPath", classPath);
        }
        return classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class loadClass(String className) throws ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadClass", "className=" + className);
        }
        Class<?> classObject = null;
        try {
            try {
                classObject = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                ExtClassLoader extClassLoader = ExtClassLoader.getInstance();
                if (extClassLoader == null) {
                    RasUtils.logException(e, tc, CLASS_NAME, "loadClass", "494");
                    throw e;
                }
                classObject = Class.forName(className, true, ExtClassLoader.getInstance());
                Object var5_3 = null;
                if (!tc.isEntryEnabled()) return classObject;
                Tr.exit(tc, "loadClass", classObject);
                return classObject;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "loadClass", classObject);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return classObject;
        Tr.exit(tc, "loadClass", classObject);
        return classObject;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/CompileJspTask.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.31");
        }
        CLASS_NAME = CompileJspTask.class.getName();
        DESTINATION_DIRECTORY_NAME = "WEB-INF" + File.separator + "classes";
    }

    private static final class War {
        private final String source;
        private final String classPath;

        public War(String source, String classPath) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "War.<init>", new String[]{"source=" + source, "classPath=" + classPath});
            }
            this.source = source;
            this.classPath = classPath;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "War.<init>");
            }
        }

        public String getSource() {
            return this.source;
        }

        public String getClassPath() {
            return this.classPath;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(this.hashCode()));
            stringBuilder.append("[source=");
            stringBuilder.append(this.source);
            stringBuilder.append(", classPath=");
            stringBuilder.append(this.classPath);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

