/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.ws.management.application.AppUpdate;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.util.RasUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;

public class RemoveBinaryTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(RemoveBinaryTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private AppUpdateHelper _aHelper;
    private Hashtable _props;
    ArrayList deleted = new ArrayList();
    ArrayList added = new ArrayList();
    ArrayList updated = new ArrayList();
    private AppData _cachedAd;
    private AppData _newAd;
    private static final String deleteJSPProp = "com.ibm.websphere.deletejspclasses";
    private static final String deleteJSPProp_Delete = "com.ibm.websphere.deletejspclasses.delete";
    private static final String deleteJSPProp_Update = "com.ibm.websphere.deletejspclasses.update";

    public RemoveBinaryTask() {
        this._aHelper = new AppUpdateHelper();
        this._aHelper.setLists(this.deleted, this.added, this.updated);
        this._aHelper.setSyncMode(true);
    }

    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        if (!this.appWasDeployedOnNode(cachedAD.getAppName())) {
            return true;
        }
        if (!newAD.isDistEnabled()) {
            return true;
        }
        this._props = props;
        this._cachedAd = cachedAD;
        this._newAd = newAD;
        int op = this._newAd.getOperations();
        if ((op & 0x10) != 0 || (op & 0x10000) != 0 || (op & 0x1000) != 0 || !this.appIsDeployedOnNode(newAD.getAppName())) {
            boolean b = this.fullAppUpdate(true);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return b;
        }
        if ((op & 0x100000) != 0) {
            return this.fineGrainUpdate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private boolean fullAppUpdate(boolean isDelete) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fullAppUpdate");
        }
        String appName = this._cachedAd.getAppName();
        Tr.debug(tc, "Uninstall J2EEApplication on application: " + appName);
        this.uninstallJ2EEApplication(appName);
        Tr.debug(tc, " --- Delete " + appName + " from " + this._cachedAd.getBinURL());
        AppUtils.deleteDirTree(this._cachedAd.getBinURL(), false);
        try {
            this.deleteTempJSP(appName, (Vector)this._cachedSIMap.get(appName), null, isDelete);
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error deleting temp JSP: " + appName);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "fullAppUpdate", "126", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fullAppUpdate");
        }
        return true;
    }

    private boolean fineGrainUpdate() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fineGrainUpdate");
        }
        String pName = "";
        String srcPath = this._cachedAd.getEarURI().substring(0, this._cachedAd.getEarURI().lastIndexOf(47));
        String destPath = this._cachedAd.getBinURL();
        this._aHelper.mergeFiles("delete", srcPath, destPath);
        String appName = this._cachedAd.getAppName();
        try {
            this.deleteTempJSP(appName, (Vector)this._cachedSIMap.get(appName), (List)this._newAd.getPartialUpdateDetails().get("DOCSREMOVED_KEY"), false);
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error deleting temp JSP: " + appName);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "fineGrainUpdate", "150", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fineGrainUpdate");
        }
        return true;
    }

    private void uninstallJ2EEApplication(String appName) {
        block15: {
            if (this._isLocal) {
                return;
            }
            try {
                Iterator it;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "uninstallJ2EEApplication");
                }
                String q = "WebSphere:j2eeType=J2EEApplication,node=" + this._nodeName + ",name=" + appName + ",*";
                ObjectName on = new ObjectName(q);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Query for: " + q);
                }
                if ((it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator()) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "it is null for: " + on);
                    }
                    return;
                }
                ObjectName appMgrName = null;
                while (it.hasNext()) {
                    String pName = ((ObjectName)it.next()).getKeyProperty("process");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "process Name " + pName);
                    }
                    try {
                        Iterator it1;
                        q = "WebSphere:type=ApplicationManager,node=" + this._nodeName + ",process=" + pName + ",*";
                        on = new ObjectName(q);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Query for: " + q);
                        }
                        if ((it1 = AdminServiceFactory.getAdminService().queryNames(on, null).iterator()) == null || !it1.hasNext()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Could not find: " + q);
                            continue;
                        }
                        appMgrName = (ObjectName)it1.next();
                        AdminServiceFactory.getAdminService().invoke(appMgrName, "_applicationUninstalled", new Object[]{appName}, new String[]{String.class.getName()});
                    }
                    catch (Throwable th) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error uninstalling J2EEApplication at app: " + appName + " on: " + pName + " by: " + appMgrName);
                        }
                        RasUtils.logException(th, tc, CLASS_NAME, "uninstallJ2EEApplication", "220", this);
                    }
                }
            }
            catch (Throwable th) {
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Unexpected excetion in installing/uninstalling J2EEApplication: " + th);
                RasUtils.logException(th, tc, CLASS_NAME, "uninstallJ2EEApplication", "231", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallJ2EEApplication");
        }
    }

    private void deleteTempJSP(String deplName, Vector svrList, List moduleList, boolean isDelete) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTempJSP: " + deplName + " isDel: " + isDelete + " modules: " + moduleList);
        }
        String root = System.getProperty("user.install.root");
        Tr.debug(tc, "server  root :" + root);
        if (root == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "** server root: " + root);
            }
            return;
        }
        boolean flag = "true".equals(System.getProperty(deleteJSPProp));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "flag 1: " + flag);
        }
        if (!flag) {
            flag = isDelete ? "true".equals(System.getProperty(deleteJSPProp_Delete)) : "true".equals(System.getProperty(deleteJSPProp_Update));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "flag 2: " + flag);
            }
        }
        try {
            if (!flag) {
                boolean bl = flag = "true".equals(System.getProperty("com.ibm.websphere.deletejspclasses." + deplName)) || "true".equals(System.getProperty("com.ibm.websphere.deletejspclasses.delete." + deplName.replace(' ', '/')));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "flag 3: " + flag);
                }
                if (!flag) {
                    if (isDelete) {
                        flag = "true".equals(System.getProperty("com.ibm.websphere.deletejspclasses.delete." + deplName)) || "true".equals(System.getProperty("com.ibm.websphere.deletejspclasses.delete." + deplName.replace(' ', '/')));
                    } else {
                        boolean bl2 = flag = "true".equals(System.getProperty("com.ibm.websphere.deletejspclasses.update." + deplName)) || "true".equals(System.getProperty("com.ibm.websphere.deletejspclasses.delete." + deplName.replace(' ', '/')));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "flag 4: " + flag);
                }
            }
            if (!flag) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No prop for deleting " + deplName);
                }
                Tr.debug(tc, "No prop for removing jsp: " + deplName);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "svrList: " + svrList);
            }
            for (int i = 0; i < svrList.size(); ++i) {
                String path = svrList.elementAt(i) + "/" + deplName;
                path = path.replace(' ', '_');
                path = root + "/temp/" + this._nodeName + "/" + path;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Path = " + path);
                }
                if (moduleList != null) {
                    for (int j = 0; j < moduleList.size(); ++j) {
                        String modulePath = path + "/" + (String)moduleList.get(j);
                        Tr.debug(tc, "Deleting jsp classes from module: " + modulePath);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deleting jsp classes from module: " + modulePath);
                        }
                        AppUtils.deleteDirTree(modulePath);
                    }
                    continue;
                }
                Tr.debug(tc, "Deleting jsp classes from: " + path);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleting jsp classes from: " + path);
                }
                AppUtils.deleteDirTree(path);
            }
        }
        catch (Throwable th) {
            Tr.debug(tc, "Unexpected exception deleting jsp classes: " + th);
            Tr.warning(tc, "Unexpected exception deleting jsp classes: " + th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteTempJSP");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/RemoveBinaryTask.java, WAS.admin.appmgmt.sync, WAS70.SERV1, cf050925.09, ver. 1.13.1.2");
        }
        CLASS_NAME = RemoveBinaryTask.class.getName();
    }

    private class AppUpdateHelper
    extends AppUpdate {
        private AppUpdateHelper() {
        }

        public List getURIs() {
            List l;
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "getURIs");
            }
            if ((l = (List)RemoveBinaryTask.this._newAd.getPartialUpdateDetails().get("DOCSREMOVED_KEY")) == null) {
                return new ArrayList();
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getURIs:" + l);
            }
            return l;
        }

        public InputStream getContentAsInputStream(String uri) {
            return null;
        }
    }
}

