/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.application.sync.AppSyncChange;
import com.ibm.websphere.management.application.sync.AppSyncConstants;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DeltaFile;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.security.util.JaccUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ChangeProcessor
implements AppSyncChange,
AppSyncConstants {
    private static TraceComponent tc = Tr.register(ChangeProcessor.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private String earURI;
    private String earChange;
    private String deplURI;
    private String deplChange;
    private Hashtable deltaChanges;
    private Hashtable uriChanges;
    private EARFile earFile;
    private boolean isLocal;
    private int _recycleMode = 256;
    private List _stopModules = new ArrayList();
    private List _startModules = new ArrayList();
    private List _recycleModules = new ArrayList();
    private int _op = 0;
    private String _configRoot;
    private Hashtable _result_files = new Hashtable();
    private Hashtable _result_uri = new Hashtable();
    private Hashtable _result_modules = new Hashtable();

    public ChangeProcessor(EARFile ear, boolean isL, String cRoot) {
        this.earFile = ear;
        this.isLocal = isL;
        this._configRoot = cRoot;
        this._result_uri.put("DOCSADDED_KEY", new ArrayList());
        this._result_uri.put("DOCSREMOVED_KEY", new ArrayList());
        this._result_modules.put("DOCSADDED_KEY", new ArrayList());
        this._result_modules.put("DOCSREMOVED_KEY", new ArrayList());
        this._result_modules.put("DOCSMODIFIED_KEY", new ArrayList());
    }

    public void init(String ear_uri, String ear_change, String depl_uri, String depl_change, Hashtable delta_changes, Hashtable file_changes) {
        this.earURI = ear_uri;
        this.earChange = ear_change;
        this.deplURI = depl_uri;
        this.deplChange = depl_change;
        this.deltaChanges = delta_changes;
        this.uriChanges = file_changes;
    }

    public String toString() {
        return ">>ChangeProcessor(" + this.deplURI + ")" + "\n" + "op = " + Integer.toHexString(this._op) + "\n" + "recyclemode = " + Integer.toHexString(this._recycleMode) + "\n" + "startMod = " + this._startModules + "\n" + "stopMod = " + this._stopModules + "\n" + "recycleMod = " + this._recycleModules + "\n" + "uri table = " + this._result_uri + "\n" + "module_table = " + this._result_modules + "\n" + "<<ChangeProcessor  \n";
    }

    public void setOp(int o) {
        if (o == 1 || o == 16 || o == 65536) {
            this._op = o;
            this._result_files.clear();
            ((List)this._result_uri.get("DOCSADDED_KEY")).clear();
            ((List)this._result_uri.get("DOCSREMOVED_KEY")).clear();
        } else {
            this._op |= o;
        }
    }

    public void setRecycle(int r) {
        if (this._recycleMode == 1) {
            return;
        }
        this._recycleMode = r;
        if (1 == this._recycleMode) {
            this._stopModules.clear();
            this._startModules.clear();
            this._recycleModules.clear();
        }
    }

    public void setForceRecycle(int r) {
        this._recycleMode = r;
        if (1 == this._recycleMode) {
            this._stopModules.clear();
            this._startModules.clear();
            this._recycleModules.clear();
        }
    }

    private int getRecycle() {
        return this._recycleMode;
    }

    public void processDeltaAsV5(ApplicationDeployment oldDepl, ApplicationDeployment newDepl, String oldBinURL, String binURL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processDeltaAsV5: " + oldDepl + ", NEW = " + newDepl + ", binURL= " + binURL);
        }
        if ("DOCSADDED_KEY".equals(this.deplChange) || "DOCSREMOVED_KEY".equals(this.deplChange) || "DOCSADDED_KEY".equals(this.earChange) || "DOCSMODIFIED_KEY".equals(this.earChange) || "DOCSREMOVED_KEY".equals(this.earChange) || oldBinURL != null && !oldBinURL.equals(binURL)) {
            this.processDelta(oldDepl, newDepl, oldBinURL, binURL);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processDeltaAsV5");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDelta(ApplicationDeployment oldDepl, ApplicationDeployment newDepl, String oldBinURL, String binURL) {
        block49: {
            block48: {
                if (ChangeProcessor.tc.isEntryEnabled()) {
                    Tr.entry(ChangeProcessor.tc, "processDelta: " + oldDepl + ", NEW = " + newDepl + ", binURL= " + binURL);
                }
                if ("DOCSADDED_KEY".equals(this.deplChange)) {
                    this.setOp(1);
                    if (ChangeProcessor.tc.isDebugEnabled() == false) return;
                    Tr.debug(ChangeProcessor.tc, "Detected install: " + this.deplURI);
                    return;
                }
                if ("DOCSREMOVED_KEY".equals(this.deplChange)) {
                    this.setOp(16);
                    if (ChangeProcessor.tc.isDebugEnabled() == false) return;
                    Tr.debug(ChangeProcessor.tc, "Detected uninstall: " + this.deplURI);
                    return;
                }
                if (((List)this.deltaChanges.get("DOCSREMOVED_KEY")).size() > 0) {
                    this.setOp(65536);
                    this.setRecycle(1);
                    if (ChangeProcessor.tc.isDebugEnabled() == false) return;
                    Tr.debug(ChangeProcessor.tc, "Detected fullupdate(deltaDelete): " + this.deplURI);
                    return;
                }
                if (oldDepl != null && newDepl != null && oldDepl.isEnableDistribution() != newDepl.isEnableDistribution()) {
                    this.setOp(65536);
                    this.setRecycle(1);
                    if (ChangeProcessor.tc.isDebugEnabled() == false) return;
                    Tr.debug(ChangeProcessor.tc, "Ear just came in: " + this.earURI);
                    return;
                }
                if (oldBinURL != null && !oldBinURL.equals(binURL)) {
                    this.setOp(65536);
                    this.setRecycle(1);
                    if (ChangeProcessor.tc.isDebugEnabled() == false) return;
                    Tr.debug(ChangeProcessor.tc, "binURL changed: " + oldBinURL);
                    return;
                }
                if ("DOCSADDED_KEY".equals(this.earChange)) {
                    this.setOp(65536);
                    this.setRecycle(1);
                    if (ChangeProcessor.tc.isDebugEnabled() == false) return;
                    Tr.debug(ChangeProcessor.tc, "Ear just came in: " + this.earURI);
                    return;
                }
                v0 = dchange = ((List)this.deltaChanges.get("DOCSADDED_KEY")).size() != 0 || ((List)this.deltaChanges.get("DOCSREMOVED_KEY")).size() != 0;
                if (!dchange && "DOCSMODIFIED_KEY".equals(this.earChange)) {
                    this.setOp(65536);
                    this.setRecycle(1);
                    if (ChangeProcessor.tc.isDebugEnabled() == false) return;
                    Tr.debug(ChangeProcessor.tc, "Detected fullupdate (noDeltaChange, earChange): " + this.deplURI);
                    return;
                }
                if (!dchange && "DOCSMODIFIED_KEY".equals(this.deplChange)) {
                    this.setRecycle(1);
                    if (ChangeProcessor.tc.isDebugEnabled() == false) return;
                    Tr.debug(ChangeProcessor.tc, "Detected fullupdate (noDeltaChange, deplChange): " + this.deplURI);
                    return;
                }
                v1 = uchange = ((List)this.uriChanges.get("DOCSADDED_KEY")).size() != 0 || ((List)this.uriChanges.get("DOCSREMOVED_KEY")).size() != 0 || ((List)this.uriChanges.get("DOCSMODIFIED_KEY")).size() != 0;
                if (!dchange && uchange) {
                    wars = this.earFile != null ? this.earFile.getWebModuleRefs() : new ArrayList<E>();
                    modURI = new ArrayList<String>();
                    altMap = new Hashtable<String, String>();
                    for (i = 0; i < wars.size(); ++i) {
                        mRef = (ModuleRef)wars.get(i);
                        modURI.add(mRef.getUri());
                        if (AppUtils.isEmpty(mRef.getAltRoot())) continue;
                        altMap.put(mRef.getUri(), mRef.getAltRoot());
                    }
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "modURI: " + modURI);
                    }
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "altMap: " + altMap);
                    }
                    this.handleConfigChange((List)this.uriChanges.get("DOCSADDED_KEY"), modURI, altMap);
                    this.handleConfigChange((List)this.uriChanges.get("DOCSREMOVED_KEY"), modURI, altMap);
                    this.handleConfigChange((List)this.uriChanges.get("DOCSMODIFIED_KEY"), modURI, altMap);
                    return;
                }
                if (!this.isLocal && this.getRecycle() != 1 && newDepl != null && ClassLoaderPolicy.SINGLE_LITERAL.equals(newDepl.getWarClassLoaderPolicy())) {
                    this.setRecycle(1);
                }
                fin = null;
                try {
                    l = (List)this.deltaChanges.get("DOCSADDED_KEY");
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "Process all deltas: " + l);
                    }
                    for (i = 0; i < l.size(); ++i) {
                        fin = new FileInputStream(this._configRoot + "/" + (String)l.get(i));
                        df = new DeltaFile(fin);
                        this.processDeltaFile(df, (String)l.get(i));
                        fin.close();
                        fin = null;
                    }
                    var13_22 = null;
                    if (fin == null) break block48;
                    ** GOTO lbl140
                }
                catch (DeltaProcessDoneEx ex) {
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "Delta Processing Done - " + ex.getMessage());
                    }
                    var13_22 = null;
                    if (fin == null) break block48;
                    try {
                        fin.close();
                    }
                    catch (IOException ioex) {
                        if (ChangeProcessor.tc.isDebugEnabled()) {
                            Tr.debug(ChangeProcessor.tc, "Excpetion closing delta file " + ioex);
                        }
                        RasUtils.logException((Throwable)ioex, ChangeProcessor.tc, ChangeProcessor.CLASS_NAME, "processDelta", "352", this);
                        if (this.isLocal) {
                            ioex.printStackTrace();
                        }
                        break block48;
                    }
                }
                catch (Throwable th) {
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "Unexpected exception: " + th);
                    }
                    RasUtils.logException(th, ChangeProcessor.tc, ChangeProcessor.CLASS_NAME, "processDelta", "332", this);
                    if (this.isLocal) {
                        th.printStackTrace();
                    }
                    this.setRecycle(1);
                    if ("DOCSMODIFIED_KEY".equals(this.earChange)) {
                        this.setOp(65536);
                    }
                    var13_22 = null;
                    if (fin == null) break block48;
                    try {}
                    catch (IOException ioex) {
                        if (ChangeProcessor.tc.isDebugEnabled()) {
                            Tr.debug(ChangeProcessor.tc, "Excpetion closing delta file " + ioex);
                        }
                        RasUtils.logException((Throwable)ioex, ChangeProcessor.tc, ChangeProcessor.CLASS_NAME, "processDelta", "352", this);
                        if (this.isLocal) {
                            ioex.printStackTrace();
                        }
                        break block48;
                    }
                    fin.close();
                }
                {
                    catch (Throwable var12_26) {
                        var13_23 = null;
                        if (fin == null) throw var12_26;
                        ** try [egrp 2[TRYBLOCK] [6 : 1291->1299)] { 
lbl131:
                        // 1 sources

                        fin.close();
                        throw var12_26;
lbl133:
                        // 1 sources

                        catch (IOException ioex) {
                            if (ChangeProcessor.tc.isDebugEnabled()) {
                                Tr.debug(ChangeProcessor.tc, "Excpetion closing delta file " + ioex);
                            }
                            RasUtils.logException((Throwable)ioex, ChangeProcessor.tc, ChangeProcessor.CLASS_NAME, "processDelta", "352", this);
                            if (this.isLocal == false) throw var12_26;
                            ioex.printStackTrace();
                        }
                        throw var12_26;
                    }
lbl140:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [6 : 1291->1299)] { 
lbl141:
                    // 1 sources

                    fin.close();
lbl143:
                    // 1 sources

                    catch (IOException ioex) {}
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "Excpetion closing delta file " + ioex);
                    }
                    RasUtils.logException((Throwable)ioex, ChangeProcessor.tc, ChangeProcessor.CLASS_NAME, "processDelta", "352", this);
                    if (!this.isLocal) break block48;
                    ioex.printStackTrace();
                }
            }
            if (!this.isLocal && this.getRecycle() != 1 && this.earFile != null && !newDepl.isZeroEarCopy()) {
                localEar = null;
                try {
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "checking security stuff");
                    }
                    if (!WSSecurityHelper.isGlobalSecurityEnabled() || JaccUtil.supportsAppDynamicUpdates()) break block49;
                    l = new ArrayList<String>();
                    roles = this.earFile.getDeploymentDescriptor().getSecurityRoles();
                    for (i = 0; i < roles.size(); ++i) {
                        role = (SecurityRole)roles.get(i);
                        l.add(role.getRoleName());
                    }
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "new roles = " + l);
                    }
                    localEar = AppInstallHelper.getEarFile(binURL, false, true, AppUtils.getBundle(null));
                    oldRoles = localEar.getDeploymentDescriptor().getSecurityRoles();
                    for (i = 0; i < oldRoles.size(); ++i) {
                        role = (SecurityRole)oldRoles.get(i);
                        if (ChangeProcessor.tc.isDebugEnabled()) {
                            Tr.debug(ChangeProcessor.tc, "role from old ear = " + role.getRoleName());
                        }
                        if (l.contains(role.getRoleName())) {
                            l.remove(role.getRoleName());
                            continue;
                        }
                        l.add(role.getRoleName());
                    }
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "After diff = " + l);
                    }
                    if (l.size() != 0) {
                        this.setRecycle(1);
                    }
                }
                catch (Throwable th) {
                    if (ChangeProcessor.tc.isDebugEnabled()) {
                        Tr.debug(ChangeProcessor.tc, "Exception checking security stuff: " + th);
                    }
                    RasUtils.logException(th, ChangeProcessor.tc, ChangeProcessor.CLASS_NAME, "processDelta", "406", this);
                    if (localEar == null) break block49;
                    localEar.close();
                }
            }
        }
        if (ChangeProcessor.tc.isEntryEnabled() == false) return;
        Tr.exit(ChangeProcessor.tc, "processDelta");
    }

    private String getModuleFromURI(String uri, List modURI, Hashtable altMap) {
        for (int i = 0; i < modURI.size(); ++i) {
            if (!uri.startsWith((String)modURI.get(i) + "/")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uri + " is in war " + modURI.get(i));
            }
            return (String)modURI.get(i);
        }
        Enumeration keys = altMap.keys();
        while (keys.hasMoreElements()) {
            String mURI = (String)keys.nextElement();
            String altRoot = (String)altMap.get(mURI);
            if (!uri.startsWith(altRoot + "/")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uri + " found in alt dd for: " + mURI);
            }
            return mURI;
        }
        return null;
    }

    private void handleConfigChange(List uris, List modURI, Hashtable altMap) {
        for (int i = 0; i < uris.size(); ++i) {
            String uri = (String)uris.get(i);
            String mod = this.getModuleFromURI(uri, modURI, altMap);
            if (mod == null) {
                this.setRecycle(1);
                continue;
            }
            this.addModuleForStartStop(mod, "update");
        }
    }

    private void processDeltaFile(DeltaFile df, String deltaPath) throws Exception {
        Element root;
        NodeList nl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processing: " + deltaPath);
        }
        if ((nl = (root = df.getDocumentElement()).getElementsByTagName("change_input")).getLength() < 1) {
            throw new Exception("Malformed delta file " + deltaPath + ". No update stanza.");
        }
        Element update = (Element)nl.item(0);
        boolean processFilesForRecycle = this.processUpdateElement(update, deltaPath);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processFilesForRecycle: " + processFilesForRecycle + ", recycleMode=" + this.getRecycleMode());
        }
        if (this.getRecycleMode() == 1) {
            processFilesForRecycle = false;
        }
        if (this.earFile == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "distribution disabled on ND or zero bin copy");
            }
            if (processFilesForRecycle) {
                this.setRecycle(1);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processDeltaFile");
            }
            return;
        }
        nl = root.getElementsByTagName("files");
        if (nl.getLength() > 0) {
            Element files = (Element)nl.item(0);
            if ((nl = files.getElementsByTagName("file")).getLength() == 0) {
                Tr.warning(tc, "ADMA7018W", new Object[]{deltaPath});
                return;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                this.processFileURI((Element)nl.item(i), processFilesForRecycle);
                if (this.getRecycleMode() != 1) continue;
                processFilesForRecycle = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processed: " + deltaPath);
        }
    }

    private boolean processUpdateElement(Element update, String deltaPath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processUpdateElement");
        }
        boolean processFilesForRecycle = false;
        Properties p = this.getProps(update);
        String u_op = p.getProperty("changetype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "u_op = " + u_op);
        }
        if ("install".equals(u_op)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "full update detected");
            }
            this.setOp(65536);
            this.setRecycle(1);
            throw new DeltaProcessDoneEx("Full recycle detected due to add in delta file: " + deltaPath);
        }
        if ("edit".equals(u_op)) {
            boolean use = "true".equals(p.getProperty("useMetaDataFromBinary"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "edit detected, useMetadataFromBinaries: " + use);
            }
            this.setRecycle(1);
            this.setOp(use ? 4096 : 256);
        } else if ("fg-update".equals(u_op)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fine-grained update detected");
            }
            this.setOp(0x100000);
            String recycle = p.getProperty("update.recycle");
            String cType = p.getProperty("contenttype");
            String op = p.getProperty("operation");
            String uri = p.getProperty("contenturi");
            String mType = p.getProperty("moduletype");
            if (recycle != null) {
                if ("update.recycle.app".equals(recycle)) {
                    this.setForceRecycle(1);
                } else if ("update.recycle.none".equals(recycle)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "recycle none set explicitly");
                    }
                    this.setForceRecycle(256);
                } else if ("update.recycle.modules".equals(recycle)) {
                    String modstr = p.getProperty("update.recycle.modules");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "recycle modules as specified in user input: " + modstr);
                    }
                    if (modstr != null) {
                        String[] mods = modstr.split("\\+");
                        for (int i = 0; i < mods.length; ++i) {
                            this.addModuleForStartStop(mods[i], "delete");
                            this.addModuleForStartStop(mods[i], "add");
                        }
                        this.setForceRecycle(16);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unknown recycle type: " + recycle + ", treat as full recycle");
                    }
                    this.setForceRecycle(1);
                }
            } else if (this.getRecycle() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In fgupdate, recycle mode already set to full so no processing");
                }
            } else if ("modulefile".equals(cType)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modulefile op=" + op + ", uri=" + uri + ", mType=" + mType);
                }
                if (this.isWeb(mType, uri)) {
                    this.addModuleForStartStop(uri, op);
                } else if ("add".equals(op)) {
                    this.addModuleForStartStop(uri, op);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "needs a full recycle");
                    }
                    this.setRecycle(1);
                }
            } else if ("file".equals(cType) || "partialapp".equals(cType)) {
                processFilesForRecycle = true;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "recycle not set and cType not known - full recycle");
                }
                this.setRecycle(1);
            }
            if ("modulefile".equals(cType)) {
                if ("add".equals(op)) {
                    ((List)this._result_modules.get("DOCSADDED_KEY")).add(uri);
                }
                if ("update".equals(op)) {
                    ((List)this._result_modules.get("DOCSMODIFIED_KEY")).add(uri);
                }
                if ("delete".equals(op)) {
                    ((List)this._result_modules.get("DOCSREMOVED_KEY")).add(uri);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processUpdateElement");
        }
        return processFilesForRecycle;
    }

    private void processFileURI(Element e, boolean processFileForRecycle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processFileURI: " + processFileForRecycle);
        }
        Properties props = this.getProps(e);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "file tag props = " + props);
        }
        String uri = props.getProperty("uri");
        String action = props.getProperty("operation");
        Object[] obj = AppUtils.getContainerAndOffset(this.earFile, uri);
        Container c = (Container)obj[0];
        String offset = (String)obj[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Container for  " + uri + " is:" + c + " offset is: " + offset);
        }
        this._result_files.put(uri, new Object[]{action, c, offset});
        if (c.containsFile(offset)) {
            ((List)this._result_uri.get("DOCSADDED_KEY")).add(uri);
        } else {
            ((List)this._result_uri.get("DOCSREMOVED_KEY")).add(uri);
        }
        if (processFileForRecycle) {
            boolean isInsideWeb;
            boolean bl = isInsideWeb = c instanceof WARFile || c.getContainer() != null && c.getContainer() instanceof WARFile;
            if (isInsideWeb) {
                String uri_in = uri.substring(c.getURI().length() + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uri_in: " + uri_in);
                }
                if (c instanceof EJBJarFile) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, uri + " is inside a JAR in a WAR so bounce the web app");
                    }
                    this.addModuleForStartStop(c.getContainer().getURI(), "update");
                } else if (uri_in.matches("META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*") || uri_in.startsWith("WEB-INF/lib/") || uri_in.startsWith("WEB-INF/classes/") || uri_in.startsWith("WEB-INF/tld/")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, uri + " is metadata of a WAR so bounce the web app");
                    }
                    this.addModuleForStartStop(c.getURI(), "update");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, uri + " is non metadata of WARFile so no recycle.");
                }
            } else if (c instanceof EARFile && !uri.matches("META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*") && "add".equals(action)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, uri + " is non metadata add at app level. Hence no-op.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "full recycle as something changed/deleted at app or non web level: " + uri + ", action=" + action);
                }
                this.setRecycle(1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processFileURI");
        }
    }

    private Properties getProps(Element e) {
        Properties p = new Properties();
        NamedNodeMap map = e.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attr = (Attr)map.item(i);
            p.put(attr.getName(), attr.getValue());
        }
        return p;
    }

    private boolean isWeb(String mType, String uri) {
        if ("moduletype.web".equals(mType)) {
            return true;
        }
        if (this.earFile == null) {
            return false;
        }
        EList mRefs = this.earFile.getModuleRefs();
        for (int i = 0; i < mRefs.size(); ++i) {
            ModuleRef mRef = (ModuleRef)mRefs.get(i);
            if (!mRef.getUri().equals(uri) || !mRef.isWeb()) continue;
            return true;
        }
        return false;
    }

    private void addModuleForStartStop(String uri, String change) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addModuleForStartStop: " + uri + ", change=" + change);
        }
        if (this.getRecycle() == 1) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "Already in full recycle mode");
            }
            return;
        }
        this.setRecycle(16);
        if ("add".equals(change)) {
            if (!this._startModules.contains(uri)) {
                this._startModules.add(uri);
            }
            if (this._recycleModules.contains(uri)) {
                this._recycleModules.remove(uri);
            }
        } else if ("delete".equals(change)) {
            if (!this._stopModules.contains(uri)) {
                this._stopModules.add(uri);
            }
            if (this._startModules.contains(uri)) {
                this._startModules.remove(uri);
            }
            if (this._recycleModules.contains(uri)) {
                this._recycleModules.remove(uri);
            }
        } else if ("update".equals(change)) {
            if (!this._recycleModules.contains(uri)) {
                this._recycleModules.add(uri);
            }
            if (this._startModules.contains(uri)) {
                this._startModules.remove(uri);
            }
            if (this._stopModules.contains(uri)) {
                this._stopModules.remove(uri);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ERROR - unknown change type for module recycle: " + change);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addModuleForStartStop: " + uri + ", start=" + this._startModules + ", stop=" + this._stopModules + ", recycle=" + this._recycleModules);
        }
    }

    public int getOperations() {
        return this._op;
    }

    public String getEarURI() {
        return this.earURI;
    }

    public String getEarURIChangeType() {
        return this.earChange;
    }

    public String getDeploymentURI() {
        return this.deplURI;
    }

    public String getDeploymentURIChangeType() {
        return this.deplChange;
    }

    public Hashtable getPartialUpdateDetails() {
        return this._result_uri;
    }

    public Hashtable getPatialStruct() {
        return this._result_files;
    }

    public int getRecycleMode() {
        return this.getRecycle();
    }

    public List getModulesToStop() {
        return this._stopModules;
    }

    public List getModulesToStart() {
        return this._startModules;
    }

    public List getModulesToRecycle() {
        return this._recycleModules;
    }

    public static void main(String[] args) {
    }

    public Hashtable getFileChangesInRepository() {
        return this.uriChanges;
    }

    public Hashtable getPartialUpdateModuleDetails() {
        return this._result_modules;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/ChangeProcessor.java, WAS.admin.appmgmt.sync, WAS70.SERV1, cf050925.09, ver. 1.4.1.9");
        }
        CLASS_NAME = ChangeProcessor.class.getName();
    }

    class DeltaProcessDoneEx
    extends Exception {
        private static final long serialVersionUID = 3480906202801981104L;

        public DeltaProcessDoneEx(String msg) {
            super(msg);
        }
    }
}

