/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class AppSyncEventsTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(AppSyncEventsTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    private Hashtable _props;
    private AppData _cachedAd;
    private AppData _newAd;

    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        if (this._isLocal) {
            return true;
        }
        if (!this.appIsDeployedOnNode(newAD.getAppName()) && !this.appWasDeployedOnNode(cachedAD.getAppName())) {
            return true;
        }
        this._cachedAd = cachedAD;
        this._newAd = newAD;
        String notifType = "";
        int op = this._newAd.getOperations();
        notifType = (op & 1) != 0 ? "installsync" : ((op & 0x10) != 0 ? "uninstallsync" : "updatesync");
        if (props == null) {
            throw new Exception("props is null");
        }
        this._props = props;
        String sync_status = (Boolean)props.get("syncstatus") != false ? "Completed" : "Failed";
        Properties notfProps = new Properties();
        String sync_msg = (String)props.get("appSyncMessage");
        if (sync_msg == null) {
            sync_msg = sync_status;
        }
        if (sync_status.equals("Failed")) {
            String syncFailure;
            String taskFailed = (String)props.get("appSyncTaskFailed");
            if (taskFailed != null) {
                notfProps.put("appSyncTaskFailed", taskFailed);
            }
            notfProps.put("appSyncFailure", (syncFailure = (String)props.get("appSyncFailure")) != null ? syncFailure : "");
            Object tasksNotExec = props.get("appSyncTasksNotExecuted");
            if (tasksNotExec != null) {
                notfProps.put("appSyncTasksNotExecuted", tasksNotExec);
            }
        }
        this.propagateEvent(cachedAD.getAppName(), new AppNotification(notifType, "", sync_status, "", sync_msg, notfProps), sync_msg);
        return true;
    }

    public boolean performTask(Hashtable appStatusTbl, Hashtable appTypeTbl) throws Exception {
        if (this._isLocal) {
            return true;
        }
        HashMap<String, String> sucessAppMap = new HashMap<String, String>();
        HashMap<String, String> failedAppMap = new HashMap<String, String>();
        String appName2 = null;
        for (String appName2 : appStatusTbl.keySet()) {
            String sync_status = (Boolean)appStatusTbl.get(appName2) != false ? "Completed" : "Failed";
            String notifType = (String)appTypeTbl.get(appName2);
            if (sync_status.equalsIgnoreCase("Completed")) {
                sucessAppMap.put(appName2, notifType);
                continue;
            }
            failedAppMap.put(appName2, notifType);
        }
        if (failedAppMap.size() > 0 || sucessAppMap.size() > 0) {
            this.propagateEvent(sucessAppMap, failedAppMap, new AppNotification("appsync", "", "Completed", "", "completed"), "completed");
        }
        return true;
    }

    private void propagateEvent(String appname, AppNotification e, String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateTaskEvent");
        }
        Properties props = null;
        if (e.props != null) {
            props = e.props;
        } else {
            props = new Properties();
            e.setProperties(props);
        }
        props.put("appname", appname);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending notification: " + e);
        }
        this.emitNotification(msg, e);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateTaskEvent");
        }
    }

    private void propagateEvent(Map sucessAppMap, Map failedAppMap, AppNotification e, String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateTaskEvent");
        }
        Properties props = null;
        if (e.props != null) {
            props = e.props;
        } else {
            props = new Properties();
            e.setProperties(props);
        }
        props.put("Completed", sucessAppMap);
        props.put("Failed", failedAppMap);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending notification: " + e);
        }
        this.emitNotification(msg, e);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateTaskEvent");
        }
    }

    public static String getNotifTypeFromOP(int op) {
        String notifType = null;
        notifType = (op & 1) != 0 ? "installsync" : ((op & 0x10) != 0 ? "uninstallsync" : "updatesync");
        return notifType;
    }

    private void emitNotification(String msg, AppNotification not) {
        if (AdminServiceFactory.getAdminService() == null) {
            return;
        }
        String NTFY_MBEAN_NAME = "WebSphere:*,type=NotificationService,process=" + AdminServiceFactory.getAdminService().getProcessName();
        try {
            Set s = AdminServiceFactory.getAdminService().queryNames(new ObjectName(NTFY_MBEAN_NAME), null);
            if (s.isEmpty()) {
                Tr.error(tc, "ADMU0008E", new Object[]{NTFY_MBEAN_NAME, "none"});
            }
            AdminServiceFactory.getAdminService().invoke((ObjectName)s.iterator().next(), "emitNotification", new Object[]{"websphere.admin.appmgmt.sync", msg, not}, NTFY_PARAMS);
        }
        catch (Exception exc) {
            Tr.error(tc, "ADMU0008E", new Object[]{NTFY_MBEAN_NAME, exc});
        }
    }
}

