/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.sync.AppDataMgr;
import com.ibm.ws.management.application.sync.AppSyncEventsTask;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.DefaultAppSyncTaskProvider;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.wsspi.runtime.variable.UndefinedVariableException;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.security.auth.Subject;
import org.eclipse.emf.ecore.resource.Resource;

public class AppBinaryProcessor
implements ConfigRepositoryListener,
NotificationListener {
    private static TraceComponent tc = Tr.register(AppBinaryProcessor.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String DMGR = "dmgr";
    private static final long SYNC_ID = -1L;
    private ConfigRepository _repository;
    private boolean _isLocal;
    private String _cellName = null;
    private int _cellType = -1;
    private String _nodeName = null;
    private String _serverName = null;
    private String _cRoot = null;
    private boolean _isInNodeSync = false;
    private Hashtable _changeTables = null;
    public Hashtable<Long, ChangeTable> _syncExpandTblCache = null;
    private Object notify = null;
    private Class cls = null;
    private String __renamecellcmdexc__ = null;
    private static ResourceBundle _bundle;
    private static AppBinaryProcessor processor;
    private static AppBinThread binThread;
    private static List<AppBinThread> allSaveThreads;
    private boolean notificationSignaled = false;
    static Vector appAddedTasks;
    static Vector appRemovedTasks;
    static Vector appModifiedTasks;

    public static ResourceBundle getBundle() {
        if (_bundle == null) {
            _bundle = AppUtils.getBundle(null);
        }
        return _bundle;
    }

    public static AppBinaryProcessor getAppBinInstance() {
        return processor;
    }

    public static List getAllSaveThreads() {
        return allSaveThreads;
    }

    public static List getAppsInProgress() {
        ArrayList appslist = new ArrayList();
        List binthreads = AppBinaryProcessor.getAllSaveThreads();
        Iterator iter = binthreads.iterator();
        while (iter.hasNext()) {
            List apps = ((AppBinThread)iter.next()).getAppsBeingProcessed();
            if (apps == null) continue;
            appslist.addAll(apps);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Apps in progress: ", appslist);
        }
        return appslist;
    }

    public void waitForThreadCompletion() {
        if (binThread == null) {
            return;
        }
        AppBinaryProcessor.binThread.waitForThreadCompletion();
    }

    public void notifyWaiter() {
        if (binThread == null) {
            return;
        }
        AppBinaryProcessor.binThread.notifyWaiter();
    }

    public AppBinaryProcessor(Boolean local, ConfigRepository repo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppBinaryProcessor: " + local);
        }
        this._isLocal = local;
        this._repository = repo;
        this._cRoot = (String)this._repository.getConfig().get("was.repository.root");
        this._changeTables = new Hashtable();
        NodeSync.addLocalSyncEventListener((NotificationListener)this);
        if (processor != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Other instance exist!");
        }
        processor = this;
        try {
            String clsStr = "com.ibm.ws.security.authorize.AppInstallNotify";
            try {
                AppUtils.dbg(tc, "trying loading of class " + clsStr);
                this.cls = Class.forName(clsStr);
                AppUtils.dbg(tc, "class = " + this.cls);
            }
            catch (ClassNotFoundException cnfe) {
                AppUtils.dbg(tc, "ClassNotFoundException expected");
                ExtClassLoader ecl = ExtClassLoader.getInstance();
                AppUtils.dbg(tc, "ecl = " + ecl);
                if (ecl == null) {
                    throw cnfe;
                }
                this.cls = Class.forName(clsStr, true, ExtClassLoader.getInstance());
                AppUtils.dbg(tc, "after class.forname " + clsStr);
            }
            String oName = "getInstance";
            Class<?>[] pp = null;
            Object[] params = null;
            Method mtd = this.cls.getMethod(oName, pp);
            this.notify = mtd.invoke(null, params);
        }
        catch (Exception ex) {
            Tr.warning(tc, "ADMA7012E", new Object[]{ex});
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "<init>", "292", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppBinaryProcessor");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(final ConfigRepositoryEvent event2) {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            ClassLoader ecl = ExtClassLoader.getInstance();
                            if (ecl == null) {
                                ecl = this.getClass().getClassLoader();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "setting CCL = " + ecl);
                            }
                            Thread.currentThread().setContextClassLoader(ecl);
                            AppBinaryProcessor.this._onChangeStart(event2);
                            Object var4_3 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            throw throwable;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException paex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in doPriv() " + paex + " cause  = " + paex.getCause());
                }
                RasUtils.logException((Throwable)paex, tc, CLASS_NAME, "onChangeStart", "330", this);
                if (paex.getCause() == null) break block3;
                paex.getCause().printStackTrace();
            }
        }
    }

    private void _onChangeStart(ConfigRepositoryEvent event2) {
        Tr.entry(tc, "onChangeStart");
        this.__renamecellcmdexc__ = System.getProperty("__renamecellcmdexc__");
        if (this.__renamecellcmdexc__ != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_onChangeStart - cell renamed XXXX needs special processing");
            }
            return;
        }
        ChangeTable changeTable = null;
        long id = this._isInNodeSync ? -1L : event2.getId();
        ConfigChangeNotifier[] changes = event2.getChanges();
        for (int i = 0; i < changes.length; ++i) {
            try {
                int type;
                if (this._cellName == null || this._nodeName == null) {
                    this.createNodeInfo(changes[i].getUri());
                }
                if ((type = AppSyncUtils.shouldProcess(changes[i].getUri(), this._cellName, this._nodeName, this._isInNodeSync, this._isLocal)) == 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "process: " + changes[i].getUri() + " id=" + id);
                }
                if (changeTable == null && (changeTable = (ChangeTable)this._changeTables.get(new Long(id))) == null) {
                    changeTable = new ChangeTable(this._cellName, this._nodeName, this._serverName, this._repository, this._isLocal);
                    this._changeTables.put(new Long(id), changeTable);
                }
                String chg = AppSyncUtils.getSyncEventFromRepoEvent(changes[i].getChangeType());
                switch (type) {
                    case 1: {
                        changeTable.handleAppDocument(changes[i].getUri(), chg);
                        break;
                    }
                    case 3: {
                        changeTable.handleSIDocument(changes[i].getUri(), chg, this._nodeName);
                        break;
                    }
                    case 2: {
                        changeTable.handleVarDocument(changes[i].getUri(), chg);
                    }
                }
                continue;
            }
            catch (Throwable th) {
                Tr.warning(tc, "ADMA7000W", new Object[]{th});
                RasUtils.logException(th, tc, CLASS_NAME, "onChangeStart", "392", this);
            }
        }
        if (!this._isInNodeSync) {
            this.printTable("pre", id, (ChangeTable)this._changeTables.get(new Long(id)));
        }
        Tr.exit(tc, "onChangeStart");
    }

    public void onChangeCompletion(final ConfigRepositoryEvent event2) {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            ClassLoader ecl = ExtClassLoader.getInstance();
                            if (ecl == null) {
                                ecl = this.getClass().getClassLoader();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "setting CCL onChangecompletion = " + ecl);
                            }
                            Thread.currentThread().setContextClassLoader(ecl);
                            AppBinaryProcessor.this._onChangeCompletion(event2);
                            Object var4_3 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            Thread.currentThread().setContextClassLoader(cl);
                            throw throwable;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException paex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in doPriv() " + paex + " cause  = " + paex.getCause());
                }
                RasUtils.logException((Throwable)paex, tc, CLASS_NAME, "onChangeCompletion", "432", this);
                if (paex.getCause() == null) break block3;
                paex.getCause().printStackTrace();
            }
        }
    }

    public void _onChangeCompletion(ConfigRepositoryEvent event2) {
        String nodeName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_onChangeCompletion", "event=" + event2);
        }
        if (this.__renamecellcmdexc__ != null) {
            String oldCellName = this.__renamecellcmdexc__;
            this.__renamecellcmdexc__ = null;
            this.processCellNameChange(oldCellName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_onChangeCompletion - cell renamed XXXX needs special processing");
            }
            return;
        }
        boolean currentNodeDeleted = false;
        String currentNodeUri = NODES_CONTEXT + this._nodeName + "/node.xml";
        boolean newNodeAdded = false;
        String newNodeName = null;
        ConfigChangeNotifier[] changes = event2.getChanges();
        for (int i = 0; i < changes.length; ++i) {
            if (changes[i].getChangeType() == 1 && changes[i].getUri().endsWith(currentNodeUri)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_onChangeCompletion", "current node deleted; _nodeName=" + this._nodeName);
                }
                currentNodeDeleted = true;
            }
            if (changes[i].getChangeType() != 0 || !changes[i].getUri().endsWith("/node.xml")) continue;
            newNodeAdded = true;
            StringTokenizer stoken = new StringTokenizer(changes[i].getUri(), "/");
            stoken.nextToken();
            stoken.nextToken();
            stoken.nextToken();
            newNodeName = stoken.nextToken();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "_onChangeCompletion", "new node added; newNodeName=" + newNodeName);
        }
        boolean synch = this._isLocal ? true : "UnManagedProcess".equals(AdminServiceFactory.getAdminService().getProcessType());
        String string = nodeName = currentNodeDeleted && newNodeAdded ? newNodeName : this._nodeName;
        if (!this._isInNodeSync) {
            this.postProcess(this._isInNodeSync ? -1L : event2.getId(), synch, nodeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_onChangeCompletion");
        }
    }

    public void onRepositoryEpochRefresh() {
    }

    public void handleNotification(Notification notf, Object handback) {
        Tr.entry(tc, "handleNotification");
        if (notf.getType().equals("websphere.nodesync.initiated")) {
            this._isInNodeSync = true;
        } else if (notf.getType().equals("websphere.nodesync.complete")) {
            boolean retry;
            this._isInNodeSync = false;
            this.printTable("pre", -1L, (ChangeTable)this._changeTables.get(new Long(-1L)));
            if (notf.getUserData() != null && Boolean.TRUE.equals(notf.getUserData())) {
                this.postProcess(-1L, this._isLocal);
            }
            if (retry = this.checkForFailedEars()) {
                this.postProcess(-1L, this._isLocal);
            }
        }
        Tr.exit(tc, "handleNotification");
    }

    public boolean checkForFailedEars() {
        boolean retry;
        block14: {
            int end;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkForFailedEars");
            }
            retry = false;
            String mDir = CommonAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), "");
            String markerDir = mDir.substring(0, end = mDir.lastIndexOf(46));
            File appsyn = new File(markerDir);
            String[] files = appsyn.list();
            if (files != null) {
                try {
                    Hashtable newsiMap = AppSyncUtils.buildSIMap(this._cellName, this._nodeName, this._repository);
                    if (newsiMap == null) {
                        return retry;
                    }
                    Enumeration ee = newsiMap.keys();
                    ee = newsiMap.keys();
                    while (ee.hasMoreElements()) {
                        boolean retryExpandEar = false;
                        String markerFileName = null;
                        String appName = (String)ee.nextElement();
                        String binName = AppSyncUtils.getBinName(appName, this._cellName);
                        try {
                            markerFileName = CommonAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), appName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Marker file to check is = " + markerFileName);
                            }
                            FileInputStream markerFile = new FileInputStream(markerFileName);
                            int markerFileSize = markerFile.available();
                            markerFile.close();
                            if (markerFileSize > 4) {
                                retry = true;
                                ChangeTable changeTable = null;
                                changeTable = (ChangeTable)this._changeTables.get(new Long(-1L));
                                if (changeTable == null) {
                                    changeTable = new ChangeTable(this._cellName, this._nodeName, this._serverName, this._repository, this._isLocal);
                                    this._changeTables.put(new Long(-1L), changeTable);
                                }
                                try {
                                    changeTable.handleAppDocument(AppSyncUtils.getDeplURI(appName, this._cellName), "DOCSADDED_KEY");
                                }
                                catch (Throwable th) {
                                    th.printStackTrace();
                                    RasUtils.logException(th, tc, CLASS_NAME, "checkForFailedEars", "602", this);
                                }
                                Tr.error(tc, "ADMA7008E", appName + " application FAILED to expand - will retry ear expansion");
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Still in process of expanding application = " + appName);
                        }
                        catch (Exception ex) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Marker file doesn't exist for application " + binName);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Failed to create SI map ex=" + ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForFailedEars returns " + retry);
        }
        return retry;
    }

    public void postProcessSynchronousExt(long id, String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postProcessSynchronousExt: " + id);
        }
        String pKey = AdminContext.peek();
        Subject subject = null;
        if (!this._isLocal) {
            subject = SecurityHelper.getOwnedSubject();
        }
        try {
            if (this._syncExpandTblCache == null || this._syncExpandTblCache.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_syncExpandTblCache is either null or empty.");
                    Tr.exit(tc, "postProcessSynchronousExt()");
                }
                return;
            }
            ChangeTable table = this._syncExpandTblCache.remove(new Long(id));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "syncExpandTblCache size: ", this._syncExpandTblCache.size());
                Tr.debug(tc, "TABLE: ", table);
            }
            if (table == null) {
                if (tc.isDebugEnabled() && table == null) {
                    Tr.exit(tc, "postProcessSynchronousExt  table is null or BAD !!!! " + id);
                }
                return;
            }
            ExpandApp exApp = new ExpandApp(this._cellName, this._nodeName, this._repository, AppBinaryProcessor.getBundle(), table);
            exApp.expand(pKey, appName, subject, this.cls, this.notify, this._isLocal);
        }
        catch (Throwable th) {
            Tr.error(tc, "ADMA7007E", new Object[]{th, new Long(id)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postProcessSynchronousExt: " + id);
        }
    }

    public void postProcess(long id, boolean isSynchronous) {
        this.postProcess(id, isSynchronous, this._nodeName);
    }

    public void postProcess(long id, boolean isSynchronous, String nodeName) {
        block14: {
            ChangeTable table;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "postProcess", new String[]{"id=" + id + "isSynchronous=" + isSynchronous, "nodeName=" + nodeName});
            }
            if ((table = (ChangeTable)this._changeTables.remove(new Long(id))) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess", "table is null or BAD !!!! " + id);
                }
                return;
            }
            AppBinThread t = null;
            try {
                table.postProcess(nodeName);
                this.printTable("post", id, table);
                if (this._syncExpandTblCache == null) {
                    this._syncExpandTblCache = new Hashtable();
                }
                this.populateSyncExpandTable(id, table, isSynchronous);
                t = new AppBinThread(this._cellName, this._cellType, nodeName, table, this._repository);
                if (!isSynchronous) {
                    allSaveThreads.add(t);
                }
                String pKey = AdminContext.peek();
                t.setProfileKey(pKey);
                binThread = t;
                t.setSecurity(this.notify, this.cls);
                t.setLocal(this._isLocal);
                if (!isSynchronous) {
                    Thread thread2 = new Thread(t);
                    ClassLoader ccl = ExtClassLoader.getInstance();
                    if (ccl == null) {
                        ccl = this.getClass().getClassLoader();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "postProcess: Setting context classloader: ", ccl);
                    }
                    thread2.setContextClassLoader(ccl);
                    thread2.start();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AppExpansion is Synchronous!!");
                }
            }
            catch (Throwable th) {
                Tr.error(tc, "ADMA7007E", new Object[]{th, new Long(id)});
                if (t == null) break block14;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "postProcess", "unable to launch the AppBinThread, " + t + ", so removing it from the cached threads.");
                }
                allSaveThreads.remove(t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postProcess", "id=" + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createNodeInfo(String uri) throws Exception {
        block28: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createNodeInfo: " + uri);
            }
            if (!this._isLocal) {
                this._cellName = AdminServiceFactory.getAdminService().getCellName();
                this._nodeName = AdminServiceFactory.getAdminService().getNodeName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "!_isLocal, _cellName = " + this._cellName + ", _nodeName = " + this._nodeName);
                }
            } else if (this._isInNodeSync) {
                this._cellName = NodeSync.getNodeSync().getCellName();
                this._nodeName = NodeSync.getNodeSync().getNodeName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_isInNodeSync, _cellName = " + this._cellName + ", _nodeName = " + this._nodeName);
                }
            } else {
                if (uri.indexOf(CELLS_CONTEXT) == -1) {
                    return;
                }
                if (uri.indexOf("node-metadata.properties") != -1) {
                    return;
                }
                this._cellName = uri.substring(uri.indexOf(CELLS_CONTEXT) + CELLS_CONTEXT.length());
                if (this._cellName.indexOf(47) <= 0) {
                    this._cellName = null;
                    return;
                }
                this._cellName = this._cellName.substring(0, this._cellName.indexOf(47));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell: " + this._cellName);
                }
                Resource res = AppSyncUtils.getResource(this._repository, CELLS_CONTEXT + this._cellName + "/" + "cell.xml", "cell.xml");
                Cell cell = (Cell)res.getContents().get(0);
                WorkSpace ws = null;
                try {
                    block27: {
                        try {
                            ws = ConfigRepoHelper.getWorkSpace(null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Created workspace: " + ws);
                            }
                            RepositoryContext cc = AppUtils.findContext("cells", this._cellName, null, null, ws, true);
                            this._cellType = cell.getCellType().getValue();
                            if (cell.getCellType().getValue() == 1) {
                                this._nodeName = AppSyncUtils.getDmgrNodeName(this._repository, this._cellName);
                                if (this._nodeName == null) {
                                    RepositoryContext rc = AppUtils.findContext("servers", DMGR, null, cc, ws, true);
                                    if (rc == null) {
                                        Object[] ar = AppUtils.getContextArray("servers", cc, ws);
                                        rc = (RepositoryContext)ar[0];
                                    }
                                    this._nodeName = rc.getParent().getName();
                                }
                                break block27;
                            }
                            this._nodeName = AppSyncUtils.getNodeNameFromBaseServer(this._repository, this._cellName);
                            Object[] ar = AppUtils.getContextArray("nodes", cc, ws);
                            RepositoryContext nc = (RepositoryContext)ar[0];
                            if (this._nodeName == null) {
                                this._nodeName = ((RepositoryContext)ar[0]).getName();
                            }
                            List l = nc.getChildren();
                            RepositoryContext sc = null;
                            if (l.size() <= 0) break block27;
                            sc = (RepositoryContext)l.get(0);
                            this._serverName = sc.getName();
                        }
                        catch (Exception ex) {
                            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "createNodeInfo", "839", this);
                            Object var11_14 = null;
                            if (ws != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Deleting workspace: " + ws);
                                }
                                ConfigRepoHelper.removeWorkSpace(false, ws);
                            }
                            break block28;
                        }
                    }
                    Object var11_13 = null;
                    if (ws == null) break block28;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    if (ws != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deleting workspace: " + ws);
                        }
                        ConfigRepoHelper.removeWorkSpace(false, ws);
                    }
                    throw throwable;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleting workspace: " + ws);
                }
                ConfigRepoHelper.removeWorkSpace(false, ws);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell: " + this._cellName + ", node: " + this._nodeName, " , serverName " + this._serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeInfo");
        }
    }

    private void printTable(String s, long id, ChangeTable tbl) {
        if (tc.isDebugEnabled()) {
            if (tbl == null) {
                Tr.debug(tc, "xxxxxxxxxxx " + s + ": " + id + " xxxxxxxxxx: NULL");
                return;
            }
            Tr.debug(tc, "xxxxxxxxxxx " + s + ": " + id + " xxxxxxxxxx");
            String appName = null;
            AppDataMgr ad = null;
            Enumeration apps = tbl.keys();
            while (apps.hasMoreElements()) {
                appName = (String)apps.nextElement();
                ad = tbl.getTableEntry(appName);
                Tr.debug(tc, "\n=================================\n" + ad.toString() + "\n" + "=================================\n");
            }
            Tr.debug(tc, "xxxxENDxxxx id: " + id + " xxxxENDxxxx");
        }
    }

    private void populateSyncExpandTable(Long id, ChangeTable table, boolean isSync) {
        ChangeTable ctSync;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "populateSyncExpandTable()", new Object[]{id, table, isSync});
        }
        if (table != null) {
            ctSync = new ChangeTable(table.cellName, this._nodeName, this._serverName, table.repository, table._isLocal);
            if (table.get_table() != null) {
                ctSync.set_table(new Hashtable(table.get_table()));
            } else {
                ctSync.set_table(new Hashtable());
            }
            if (table.getCachedSIMap() != null) {
                ctSync.setCachedSIMap(new Hashtable(table.getCachedSIMap()));
            } else {
                ctSync.setCachedSIMap(new Hashtable());
            }
            ctSync.setCRoot(table.getCRoot());
            if (table.getNewSIMap() != null) {
                ctSync.setNewSIMap(new Hashtable(table.getNewSIMap()));
            } else {
                ctSync.setNewSIMap(new Hashtable());
            }
            ctSync.setVarMap(table.getVarMap());
            if (table.getVarTable() != null) {
                ctSync.setVarTable(new Hashtable(table.getVarTable()));
            } else {
                ctSync.setVarTable(new Hashtable());
            }
            ctSync.setVarChanged(table.isVarChanged());
            ctSync.setVariablexml(table.isVariablexml());
            String appName = null;
            AppDataMgr ad = null;
            Enumeration apps = table.keys();
            while (apps.hasMoreElements()) {
                appName = (String)apps.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "original ChangeTable appName : " + appName);
                }
                ad = table.getTableEntry(appName);
                if (!isSync) {
                    if (ad._deplChangeType.equals("DOCSREMOVED_KEY")) continue;
                    if (ad.getExpandSynchronously()) {
                        table.remove(appName);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "appName: " + appName + " is not supposed to be expanded synchronously.");
                    }
                    ctSync.remove(appName);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "All the apps need to be expanded synchronously");
                }
                table.remove(appName);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "table passed in is null!!!");
            }
            ctSync = null;
        }
        if (ctSync != null && !ctSync.get_table().isEmpty()) {
            this._syncExpandTblCache.put(id, ctSync);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_syncExpandTblCache.size()", this._syncExpandTblCache.size());
                Enumeration appNames = ctSync.keys();
                while (appNames.hasMoreElements()) {
                    Tr.debug(tc, "synchronous ChangeTable appName : " + appNames.nextElement());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "populateSyncExpandTable()", this._syncExpandTblCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCellNameChange(String oldCellName) {
        block37: {
            block36: {
                if (AppBinaryProcessor.tc.isEntryEnabled()) {
                    Tr.entry(AppBinaryProcessor.tc, "processCellNameChange: " + oldCellName);
                }
                ws = null;
                try {
                    ws = ConfigRepoHelper.getWorkSpace(null);
                    c = ws.findContext(AppUtils.getContextType("cells"));
                    cellCtx = (RepositoryContext)c.toArray()[0];
                    cellName = cellCtx.getName();
                    if (AppBinaryProcessor.tc.isDebugEnabled()) {
                        Tr.debug(AppBinaryProcessor.tc, "cell = " + cellName);
                    }
                    if ((nodeName = System.getProperty("local.node")) == null) {
                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.tc, "no local node defined.  This command will not work on managed node");
                        }
                        nodeName = (cell = (Cell)(res = AppSyncUtils.getResource(this._repository, "cells/" + cellName + "/" + "cell.xml", "cell.xml")).getContents().get(0)).getCellType().getValue() == 1 ? AppSyncUtils.getDmgrNodeName(this._repository, cellName) : AppSyncUtils.getNodeNameFromBaseServer(this._repository, cellName);
                    }
                    if (AppBinaryProcessor.tc.isDebugEnabled()) {
                        Tr.debug(AppBinaryProcessor.tc, "node = " + nodeName);
                    }
                    nodeCtx = ws.findContext("cells/" + cellName + "/nodes/" + nodeName);
                    serverName = null;
                    if (nodeCtx.getChildren().size() > 0) {
                        serverName = ((RepositoryContext)nodeCtx.getChildren().get(0)).getName();
                    }
                    if (AppBinaryProcessor.tc.isDebugEnabled()) {
                        Tr.debug(AppBinaryProcessor.tc, "server = " + serverName);
                    }
                    cRoot = (String)this._repository.getConfig().get("was.repository.root");
                    vMap = AppUtils.createVarMap(cRoot, cellName, nodeName, serverName);
                    if (AppBinaryProcessor.tc.isDebugEnabled()) {
                        Tr.debug(AppBinaryProcessor.tc, "got var map: " + vMap);
                    }
                    v = new Vector<E>();
                    EditApplication.listAppsOnNode(v, nodeName, null, cellCtx, ws, AppBinaryProcessor.getBundle(), true);
                    c = ws.findContext(AppUtils.getContextType("deployments"));
                    for (RepositoryContext ctx : c) {
                        block35: {
                            block34: {
                                if (!v.contains(ctx.getName())) {
                                    if (!AppBinaryProcessor.tc.isDebugEnabled()) continue;
                                    Tr.debug(AppBinaryProcessor.tc, "app not for this node: " + ctx.getName());
                                    continue;
                                }
                                ear = null;
                                try {
                                    try {
                                        appDepl = ConfigRepoHelper.getAppDeploymentForApp(ctx);
                                        if ((appDepl.isZeroBinaryCopy() || appDepl.isZeroEarCopy() || !appDepl.isEnableDistribution()) && AppBinaryProcessor.tc.isDebugEnabled()) {
                                            Tr.debug(AppBinaryProcessor.tc, "not processing app: " + ctx.getName());
                                        }
                                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                                            Tr.debug(AppBinaryProcessor.tc, "processing app: " + ctx.getName());
                                        }
                                        binURL = appDepl.getBinariesURL();
                                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                                            Tr.debug(AppBinaryProcessor.tc, "bin url = " + binURL);
                                        }
                                        binURL = vMap.expand(binURL);
                                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                                            Tr.debug(AppBinaryProcessor.tc, "expanded bin url = " + binURL);
                                        }
                                        if (!binURL.contains("/" + cellName + "/")) {
                                            if (AppBinaryProcessor.tc.isDebugEnabled()) {
                                                Tr.debug(AppBinaryProcessor.tc, "no cell name so don't process: " + binURL);
                                            }
                                            var21_23 = null;
                                            if (ear == null) continue;
                                            break block34;
                                        }
                                        oldBinURL = binURL.replaceAll("/" + cellName + "/", "/" + oldCellName + "/");
                                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                                            Tr.debug(AppBinaryProcessor.tc, "Delete from: " + oldBinURL);
                                        }
                                        AppUtils.deleteDirTree(oldBinURL);
                                        earName = EditionHelper.getAppEarName(ctx.getName(), (String)null);
                                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                                            Tr.debug(AppBinaryProcessor.tc, "EAR name: " + earName);
                                        }
                                        if (!ctx.getParent().isAvailable(earName)) break block35;
                                        ctx.getParent().extract(earName, false);
                                        path = ctx.getParent().getPath() + "/" + earName;
                                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                                            Tr.debug(AppBinaryProcessor.tc, "EAR path: " + path);
                                        }
                                        ear = EarUtils.getEarFile((String)path, (boolean)false, (boolean)true);
                                        EarUtils.extractEar((EARFile)ear, (String)binURL, (boolean)true);
                                        break block35;
                                    }
                                    catch (Throwable th1) {
                                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                                            Tr.debug(AppBinaryProcessor.tc, "error processing app: " + ctx.getName(), th1);
                                        }
                                        var21_23 = null;
                                        if (ear == null) continue;
                                        ear.close();
                                        continue;
                                    }
                                }
                                catch (Throwable var20_24) {
                                    var21_23 = null;
                                    if (ear == null) throw var20_24;
                                    ear.close();
                                    throw var20_24;
                                }
                            }
                            ear.close();
                            continue;
                        }
                        var21_23 = null;
                        if (ear == null) continue;
                        ear.close();
                    }
                    appInstallRoot = vMap.expand("$(APP_INSTALL_ROOT)");
                    oldDir = new File(appInstallRoot + "/" + oldCellName);
                    done = oldDir.delete();
                    if (!AppBinaryProcessor.tc.isDebugEnabled()) break block36;
                    Tr.debug(AppBinaryProcessor.tc, "old app install dir: " + oldDir + ", " + done);
                }
                catch (Throwable th) {
                    if (AppBinaryProcessor.tc.isDebugEnabled()) {
                        Tr.debug(AppBinaryProcessor.tc, "error processCellNameChange: " + oldCellName, th);
                    }
                    var23_26 = null;
                    if (ws == null) break block37;
                    try {
                        ConfigRepoHelper.removeWorkSpace(false, ws);
                    }
                    catch (Throwable th) {
                        if (AppBinaryProcessor.tc.isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.tc, "Exception in removing workspace: " + th);
                        }
                        break block37;
                    }
                }
            }
            var23_25 = null;
            if (ws == null) break block37;
            {
                catch (Throwable var22_31) {
                    var23_27 = null;
                    if (ws == null) throw var22_31;
                    ** try [egrp 4[TRYBLOCK] [10 : 1393->1401)] { 
lbl122:
                    // 1 sources

                    ConfigRepoHelper.removeWorkSpace(false, ws);
                    throw var22_31;
lbl124:
                    // 1 sources

                    catch (Throwable th) {
                        if (AppBinaryProcessor.tc.isDebugEnabled() == false) throw var22_31;
                        Tr.debug(AppBinaryProcessor.tc, "Exception in removing workspace: " + th);
                    }
                    throw var22_31;
                }
                ** try [egrp 4[TRYBLOCK] [10 : 1393->1401)] { 
lbl129:
                // 1 sources

                ConfigRepoHelper.removeWorkSpace(false, ws);
lbl131:
                // 1 sources

                catch (Throwable th) {}
                if (!AppBinaryProcessor.tc.isDebugEnabled()) break block37;
                Tr.debug(AppBinaryProcessor.tc, "Exception in removing workspace: " + th);
            }
        }
        if (AppBinaryProcessor.tc.isEntryEnabled() == false) return;
        Tr.exit(AppBinaryProcessor.tc, "processCellNameChange: " + oldCellName);
    }

    static /* synthetic */ AppBinThread access$1202(AppBinThread x0) {
        binThread = x0;
        return binThread;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/AppBinaryProcessor.java, WAS.admin.appmgmt.sync, WAS70.SERV1, cf050925.09, ver. 1.88.1.30");
        }
        CLASS_NAME = AppBinaryProcessor.class.getName();
        processor = null;
        binThread = null;
        allSaveThreads = new ArrayList<AppBinThread>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExpandApp {
        ConfigRepository _repository;
        String _cellName;
        String _nodeName;
        ResourceBundle _resBundle;
        ChangeTable _changeTbl;
        AbstractAppSyncTask _task;
        protected int nextTaskNum = 0;

        public ExpandApp(String cellName, String nodeName, ConfigRepository repo, ResourceBundle resBundle, ChangeTable changeTbl) {
            this._repository = repo;
            this._cellName = cellName;
            this._nodeName = nodeName;
            this._resBundle = resBundle;
            this._changeTbl = changeTbl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void expand(String profileKey, String strAppName, Subject subject, Class<?> cls, Object notify, boolean isLocal) {
            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                Tr.entry(AppBinaryProcessor.access$200(), "expand()");
            }
            bSuccess = true;
            isPushedProfile = false;
            appStatusTbl = new Hashtable<String, V>();
            appTypeTbl = new Hashtable<String, String>();
            try {
                block57: {
                    block56: {
                        if (profileKey != null) {
                            isPushedProfile = AdminContext.push(profileKey);
                        }
                        if (subject != null) {
                            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                Tr.debug(AppBinaryProcessor.access$200(), "Push creds: " + subject);
                            }
                            subject = SecurityHelper.pushInvocationSubject(subject);
                        }
                        applist = this._changeTbl.keys();
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            while (applist.hasMoreElements()) {
                                Tr.debug(AppBinaryProcessor.access$200(), "app: ", applist.nextElement());
                            }
                            applist = this._changeTbl.keys();
                        }
                        appName = null;
                        adm = null;
                        taskList = null;
                        try {
                            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                Tr.debug(AppBinaryProcessor.access$200(), "Cached SI = " + this._changeTbl.getCachedSIMap());
                            }
                            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                Tr.debug(AppBinaryProcessor.access$200(), "New SI = " + this._changeTbl.getNewSIMap());
                            }
                            while (applist.hasMoreElements()) {
                                block55: {
                                    block61: {
                                        block53: {
                                            block60: {
                                                block52: {
                                                    this._task = null;
                                                    taskList = null;
                                                    this.nextTaskNum = 0;
                                                    appName = strAppName == null ? (String)applist.nextElement() : strAppName;
                                                    adm = this._changeTbl.getTableEntry(appName);
                                                    try {
                                                        try {
                                                            adm.postProcess(this._changeTbl.getVarMap(), this._changeTbl.getNewSIMap(), this._changeTbl.getCachedSIMap(), isLocal, this._resBundle);
                                                            this._changeTbl.postProcessVarChanged(adm, appName);
                                                            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                                Tr.debug(AppBinaryProcessor.access$200(), "ADM: " + adm);
                                                            }
                                                            if (adm.getNewAD() == null && adm.getCachedAD() == null) {
                                                                var17_17 = null;
                                                                break block52;
                                                            }
                                                            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                                Tr.debug(AppBinaryProcessor.access$200(), "Operation: ", adm.getNewAD().getOperations());
                                                            }
                                                            taskList = this.getTaskList(adm.getNewAD().getOperations());
                                                            this._task = this.getNextTask(taskList);
                                                            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                                Tr.debug(AppBinaryProcessor.access$200(), "TASK Name: ", this._task);
                                                            }
                                                            while (this._task != null && bSuccess) {
                                                                this._task.setData(this._repository, this._cellName, this._nodeName, isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                                this._task.setSecurity(subject, notify, cls);
                                                                Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + this._task);
                                                                bSuccess = this._task.performTask(adm.getCachedAD(), adm.getNewAD(), adm.getProps());
                                                                if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                                    Tr.debug(AppBinaryProcessor.access$200(), "bSuccess: ", bSuccess);
                                                                }
                                                                if (!bSuccess) break;
                                                                this._task = this.getNextTask(taskList);
                                                            }
                                                            adm.getProps().put("syncstatus", new Boolean(bSuccess));
                                                            if (bSuccess) {
                                                                adm.getProps().put("appSyncMessage", AppUtils.getMessage(this._resBundle, "ADMA7021I", new Object[]{appName}));
                                                                Tr.info(AppBinaryProcessor.access$200(), "ADMA7021I", new Object[]{appName});
                                                                break block53;
                                                            } else {
                                                                this.logAppSyncFailure(appName, adm.getProps(), this._task, taskList, null);
                                                            }
                                                            break block53;
                                                        }
                                                        catch (Throwable e) {
                                                            block58: {
                                                                if (e instanceof UndefinedVariableException) {
                                                                    if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                                        Tr.debug(AppBinaryProcessor.access$200(), "Ignore the throwable because it's in migration or new variable which will sync later.", e);
                                                                    }
                                                                    adm.getProps().put("syncstatus", new Boolean(true));
                                                                    var17_17 = null;
                                                                    try {
                                                                        appStatusTbl.put(appName, adm.getProps().get("syncstatus"));
                                                                        appTypeTbl.put(appName, AppSyncEventsTask.getNotifTypeFromOP(adm.getNewAD().getOperations()));
                                                                        t = new AppSyncEventsTask();
                                                                        Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + t);
                                                                        t.setData(this._repository, this._cellName, this._nodeName, isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                                        t.performTask(adm.getCachedAD(), adm.getNewAD(), adm.getProps());
                                                                    }
                                                                    catch (Throwable e) {
                                                                        if (isLocal) {
                                                                            e.printStackTrace();
                                                                        }
                                                                        RasUtils.logException(e, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "941", this);
                                                                    }
                                                                    adm.cleanup(true);
                                                                    continue;
                                                                }
                                                                if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                                    Tr.debug(AppBinaryProcessor.access$200(), "throwable recevied: ", e);
                                                                }
                                                                adm.getProps().put("syncstatus", new Boolean(false));
                                                                this.logAppSyncFailure(appName, adm.getProps(), this._task, taskList, e);
                                                                var17_17 = null;
                                                                ** try [egrp 5[TRYBLOCK] [7 : 847->978)] { 
lbl104:
                                                                // 1 sources

                                                                appStatusTbl.put(appName, adm.getProps().get("syncstatus"));
                                                                appTypeTbl.put(appName, AppSyncEventsTask.getNotifTypeFromOP(adm.getNewAD().getOperations()));
                                                                t = new AppSyncEventsTask();
                                                                Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + t);
                                                                t.setData(this._repository, this._cellName, this._nodeName, isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                                t.performTask(adm.getCachedAD(), adm.getNewAD(), adm.getProps());
                                                                break block58;
lbl114:
                                                                // 1 sources

                                                                catch (Throwable e) {
                                                                    if (isLocal) {
                                                                        e.printStackTrace();
                                                                    }
                                                                    RasUtils.logException(e, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "941", this);
                                                                }
                                                            }
                                                            adm.cleanup(true);
                                                            break block55;
                                                        }
                                                    }
                                                    catch (Throwable var16_19) {
                                                        block59: {
                                                            var17_17 = null;
                                                            ** try [egrp 5[TRYBLOCK] [7 : 847->978)] { 
lbl125:
                                                            // 1 sources

                                                            appStatusTbl.put(appName, adm.getProps().get("syncstatus"));
                                                            appTypeTbl.put(appName, AppSyncEventsTask.getNotifTypeFromOP(adm.getNewAD().getOperations()));
                                                            t = new AppSyncEventsTask();
                                                            Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + t);
                                                            t.setData(this._repository, this._cellName, this._nodeName, isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                            t.performTask(adm.getCachedAD(), adm.getNewAD(), adm.getProps());
                                                            break block59;
lbl135:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (isLocal) {
                                                                    e.printStackTrace();
                                                                }
                                                                RasUtils.logException(e, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "941", this);
                                                            }
                                                        }
                                                        adm.cleanup(true);
                                                        throw var16_19;
                                                    }
                                                }
                                                ** try [egrp 5[TRYBLOCK] [7 : 847->978)] { 
lbl144:
                                                // 1 sources

                                                appStatusTbl.put(appName, adm.getProps().get("syncstatus"));
                                                appTypeTbl.put(appName, AppSyncEventsTask.getNotifTypeFromOP(adm.getNewAD().getOperations()));
                                                t = new AppSyncEventsTask();
                                                Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + t);
                                                t.setData(this._repository, this._cellName, this._nodeName, isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                t.performTask(adm.getCachedAD(), adm.getNewAD(), adm.getProps());
                                                break block60;
lbl154:
                                                // 1 sources

                                                catch (Throwable e) {
                                                    if (isLocal) {
                                                        e.printStackTrace();
                                                    }
                                                    RasUtils.logException(e, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "941", this);
                                                }
                                            }
                                            adm.cleanup(true);
                                            continue;
                                        }
                                        var17_17 = null;
                                        ** try [egrp 5[TRYBLOCK] [7 : 847->978)] { 
lbl164:
                                        // 1 sources

                                        appStatusTbl.put(appName, adm.getProps().get("syncstatus"));
                                        appTypeTbl.put(appName, AppSyncEventsTask.getNotifTypeFromOP(adm.getNewAD().getOperations()));
                                        t = new AppSyncEventsTask();
                                        Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + t);
                                        t.setData(this._repository, this._cellName, this._nodeName, isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                        t.performTask(adm.getCachedAD(), adm.getNewAD(), adm.getProps());
                                        break block61;
lbl174:
                                        // 1 sources

                                        catch (Throwable e) {
                                            if (isLocal) {
                                                e.printStackTrace();
                                            }
                                            RasUtils.logException(e, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "941", this);
                                        }
                                    }
                                    adm.cleanup(true);
                                }
                                if (strAppName == null) continue;
                            }
                            if (subject == null) break block56;
                            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                Tr.debug(AppBinaryProcessor.access$200(), "Pop creds: " + subject);
                            }
                            SecurityHelper.popInvocationSubject(subject);
                            subject = null;
                        }
                        catch (Throwable th) {
                            RasUtils.logException(th, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "1627", this);
                            if (isLocal) {
                                th.printStackTrace();
                            }
                            var20_21 = null;
                            try {
                                t = new AppSyncEventsTask();
                                Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + t);
                                t.performTask(appStatusTbl, appTypeTbl);
                            }
                            catch (Throwable e) {
                                if (isLocal) {
                                    e.printStackTrace();
                                }
                                RasUtils.logException(e, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "1639", this);
                            }
                            break block57;
                        }
                    }
                    var20_20 = null;
                    {
                        catch (Throwable var19_29) {
                            var20_22 = null;
                            ** try [egrp 6[TRYBLOCK] [12 : 1115->1163)] { 
lbl212:
                            // 1 sources

                            t = new AppSyncEventsTask();
                            Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + t);
                            t.performTask(appStatusTbl, appTypeTbl);
                            throw var19_29;
lbl217:
                            // 1 sources

                            catch (Throwable e) {
                                if (isLocal) {
                                    e.printStackTrace();
                                }
                                RasUtils.logException(e, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "1639", this);
                            }
                            throw var19_29;
                        }
                        ** try [egrp 6[TRYBLOCK] [12 : 1115->1163)] { 
lbl223:
                        // 1 sources

                        t = new AppSyncEventsTask();
                        Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + t);
                        t.performTask(appStatusTbl, appTypeTbl);
lbl228:
                        // 1 sources

                        catch (Throwable e) {}
                        if (isLocal) {
                            e.printStackTrace();
                        }
                        RasUtils.logException(e, AppBinaryProcessor.access$200(), AppBinaryProcessor.access$900(), "run", "1639", this);
                    }
                }
                AppBinaryProcessor.this.notifyWaiter();
                AppBinaryProcessor.access$1202(null);
                var23_30 = null;
            }
            catch (Throwable var22_32) {
                var23_31 = null;
                if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                    Tr.exit(AppBinaryProcessor.access$200(), "expand()");
                }
                if (isPushedProfile == false) throw var22_32;
                AdminContext.pop();
                throw var22_32;
            }
            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                Tr.exit(AppBinaryProcessor.access$200(), "expand()");
            }
            if (isPushedProfile == false) return;
            AdminContext.pop();
        }

        private void logAppSyncFailure(String appName, Hashtable admProps, AbstractAppSyncTask task, Vector taskList, Throwable failure) {
            Object[] objectArray;
            String impact;
            block18: {
                block17: {
                    String msgkey = null;
                    Object[] msgargs = null;
                    try {
                        if (task != null) {
                            String taskFailed = task.getClass().getName();
                            admProps.put("appSyncTaskFailed", taskFailed);
                            if (failure != null) {
                                msgkey = "ADMA7024E";
                                msgargs = new Object[]{appName, taskFailed, failure.getMessage()};
                                admProps.put("appSyncFailure", failure.getMessage());
                            } else {
                                msgkey = "ADMA7023E";
                                msgargs = new Object[]{appName, taskFailed};
                            }
                        } else {
                            msgkey = "ADMA7022E";
                            msgargs = new Object[]{appName, null};
                            if (failure != null) {
                                msgargs[1] = failure.getMessage();
                                admProps.put("appSyncFailure", failure.getMessage());
                            }
                        }
                        admProps.put("appSyncMessage", AppUtils.getMessage(this._resBundle, msgkey, msgargs));
                        Tr.error(tc, msgkey, msgargs);
                    }
                    catch (Throwable th) {
                        if (!tc.isDebugEnabled()) break block17;
                        Tr.debug(tc, "Error logging appsync failure" + th.getMessage());
                    }
                }
                impact = null;
                try {
                    if (taskList != null) {
                        List tasksNotExec = this.getUnExecutedTaskNames(taskList);
                        admProps.put("appSyncTasksNotExecuted", tasksNotExec);
                        if (!tasksNotExec.isEmpty()) {
                            impact = "For application " + appName + " following application synchronization tasks will not be executed " + tasksNotExec.toString().replaceAll("[\\[{1}\\]{1}]", "\"");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "For application " + appName + " following application synchronization tasks will not be executed ", tasksNotExec.toArray());
                            }
                        }
                    } else {
                        impact = "For application " + appName + " none of the application synchronization tasks will be executed.";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, impact);
                        }
                    }
                }
                catch (Throwable th) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Error identifying unexecuted tasks" + th.getMessage());
                }
            }
            if (AppBinaryProcessor.this._isLocal && failure != null) {
                failure.printStackTrace();
            }
            Throwable throwable = failure != null ? failure : new AdminException((String)admProps.get("appSyncTaskFailed"));
            TraceComponent traceComponent = tc;
            String string = CLASS_NAME;
            if (impact != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = impact;
            } else {
                objectArray = null;
            }
            RasUtils.logException(throwable, traceComponent, string, "run", "1726", this, objectArray);
        }

        private Vector getTaskList(int op) throws Exception {
            DefaultAppSyncTaskProvider provider = new DefaultAppSyncTaskProvider();
            if ((op & 1) != 0) {
                Vector appAddedTasks = new Vector();
                provider.provideAppAddedSyncTasks(appAddedTasks);
                appAddedTasks = ExtensionHelper.processAppAddedSyncExtensions(appAddedTasks);
                return appAddedTasks;
            }
            if ((op & 0x10) != 0) {
                Vector appRemovedTasks = new Vector();
                provider.provideAppRemovedSyncTasks(appRemovedTasks);
                appRemovedTasks = ExtensionHelper.processAppRemovedSyncExtensions(appRemovedTasks);
                return appRemovedTasks;
            }
            Vector appModifiedTasks = new Vector();
            provider.provideAppModifiedSyncTasks(appModifiedTasks);
            appModifiedTasks = ExtensionHelper.processAppModifiedSyncExtensions(appModifiedTasks);
            return appModifiedTasks;
        }

        private AbstractAppSyncTask getNextTask(Vector tasks) throws AdminException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNextTask");
            }
            if (this.nextTaskNum >= tasks.size()) {
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNextTask");
            }
            return (AbstractAppSyncTask)tasks.elementAt(this.nextTaskNum++);
        }

        private List getUnExecutedTaskNames(Vector tasks) {
            ArrayList<String> ret = new ArrayList<String>();
            if (this.nextTaskNum < tasks.size()) {
                List rTasks = tasks.subList(this.nextTaskNum, tasks.size());
                Iterator rTasksIter = rTasks.iterator();
                while (rTasksIter.hasNext()) {
                    ret.add(rTasksIter.next().getClass().getName());
                }
            }
            return ret;
        }
    }

    private class ChangeTable {
        private Hashtable _table = new Hashtable();
        private String cellName;
        private boolean variablexml;
        private VariableMap vMap = null;
        private Hashtable cachedsiMap = null;
        private Hashtable newsiMap = null;
        ConfigRepository repository;
        boolean _isLocal;
        boolean varChanged = false;
        Hashtable varTable = null;
        String cRoot = null;

        ChangeTable(String cellname, String nodename, String serverName, ConfigRepository repo, boolean isL) {
            this.cellName = cellname;
            this.repository = repo;
            this._isLocal = isL;
            try {
                this.cRoot = (String)repo.getConfig().get("was.repository.root");
                this.vMap = AppUtils.createVarMap(this.cRoot, cellname, nodename, serverName);
            }
            catch (Exception e) {
                Tr.warning(tc, "ADMA7016W", new Object[]{e, "ChangeTable"});
            }
        }

        public void handleAppDocument(String uri, String type) {
            String appName = AppSyncUtils.getAppNameFromAppDoc(uri, this.cellName);
            AppDataMgr mgr = (AppDataMgr)this._table.get(appName);
            if (mgr == null) {
                mgr = new AppDataMgr(appName, this.cellName, this.repository, this.vMap);
                this._table.put(appName, mgr);
            }
            mgr.addAppDocument(uri, type, this.vMap);
        }

        public void handleSIDocument(String uri, String type, String nodeName) {
            block3: {
                try {
                    if (this.cachedsiMap == null) {
                        this.cachedsiMap = AppSyncUtils.buildSIMap(this.cellName, nodeName, this.repository);
                    }
                }
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, "handleSIDocument", "1249", this);
                    if (!this._isLocal) break block3;
                    th.printStackTrace();
                }
            }
        }

        public void handleVarDocument(String uri, String type) {
            this.varChanged = true;
            this.varTable = this.getBinURLTable();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "oldVarTable: " + this.varTable);
            }
        }

        public Hashtable getCachedSIMap() {
            return this.cachedsiMap;
        }

        public Hashtable getNewSIMap() {
            return this.newsiMap;
        }

        public void postProcess(String nodeName) {
            block12: {
                block11: {
                    try {
                        this.newsiMap = AppSyncUtils.buildSIMap(this.cellName, nodeName, this.repository);
                        if (this.cachedsiMap == null) {
                            this.cachedsiMap = this.newsiMap;
                        }
                    }
                    catch (Throwable th) {
                        RasUtils.logException(th, tc, CLASS_NAME, "postProcess", "1278", this);
                        if (!this._isLocal) break block11;
                        th.printStackTrace();
                    }
                }
                if (this.varChanged && this.varTable != null) {
                    try {
                        this.vMap = AppUtils.createVarMap(this.cRoot, AppBinaryProcessor.this._cellName, nodeName, AppBinaryProcessor.this._serverName);
                        Hashtable newTable = this.getBinURLTable();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "newVarTable: " + newTable);
                        }
                        Hashtable<String, String[]> diffTable = new Hashtable<String, String[]>();
                        Enumeration en = newTable.keys();
                        while (en.hasMoreElements()) {
                            String newVal;
                            String key = (String)en.nextElement();
                            String oldVal = (String)this.varTable.get(key);
                            if (oldVal == null || (newVal = (String)newTable.get(key)).equals(oldVal)) continue;
                            diffTable.put(key, new String[]{oldVal, newVal});
                            if (this._table.get(key) != null) continue;
                            try {
                                this.handleAppDocument(AppSyncUtils.getDeplURI(key, AppBinaryProcessor.this._cellName), "DOCSMODIFIED_KEY");
                            }
                            catch (Throwable th) {
                                RasUtils.logException(th, tc, CLASS_NAME, "postProcess", "1306", this);
                                if (!this._isLocal) continue;
                                th.printStackTrace();
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "diffTable: " + diffTable);
                        }
                        this.varTable = diffTable;
                    }
                    catch (Exception e) {
                        RasUtils.logException((Throwable)e, tc, CLASS_NAME, "postProcess", "1320", this);
                        if (!this._isLocal) break block12;
                        e.printStackTrace();
                    }
                }
            }
        }

        public void postProcessVarChanged(AppDataMgr adm, String appName) {
            if (!this.varChanged || this.varTable == null || this.varTable.get(appName) == null) {
                return;
            }
            String[] paths = (String[])this.varTable.get(appName);
            adm.processVarChanged(paths[0], paths[1]);
        }

        public VariableMap getVarMap() {
            return this.vMap;
        }

        public void setVarMap(VariableMap varMap) {
            this.vMap = varMap;
        }

        public Enumeration keys() {
            return this._table.keys();
        }

        public AppDataMgr getTableEntry(String appName) {
            return (AppDataMgr)this._table.get(appName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hashtable getBinURLTable() {
            Hashtable<String, String> temp;
            block13: {
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "getBinURLTable");
                }
                temp = new Hashtable<String, String>();
                try {
                    String[] depls = this.repository.listResourceNames(AppBinaryProcessor.CELLS_CONTEXT + AppBinaryProcessor.this._cellName + "/applications", 1, Integer.MAX_VALUE, new ResourceNameFilter(){

                        public boolean accept(String parent, String name) {
                            return parent.indexOf("/deployments/") != -1 && name.equals("deployment.xml");
                        }
                    });
                    for (int i = 0; i < depls.length; ++i) {
                        Object var8_9;
                        Resource res = null;
                        try {
                            try {
                                String appName = AppSyncUtils.getAppNameFromAppDoc(depls[i], AppBinaryProcessor.this._cellName);
                                res = AppSyncUtils.getResource(this.repository, depls[i], "deployment.xml");
                                String path = ConfigRepoHelper.getAppDeploymentForApp(res).getBinariesURL();
                                path = this.vMap.expand(path);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "appname:" + appName + ", path: " + path);
                                }
                                if (temp.containsKey(appName) && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "appname:" + appName + " already exist in the BinURLTable overriding the path: " + temp.get(appName));
                                }
                                temp.put(appName, path);
                            }
                            catch (Throwable rTh) {
                                RasUtils.logException(rTh, tc, CLASS_NAME, "getBinURLTable", "1384", this);
                                if (this._isLocal && !(rTh instanceof UndefinedVariableException)) {
                                    rTh.printStackTrace();
                                }
                                var8_9 = null;
                                if (res == null) continue;
                                res.unload();
                                continue;
                            }
                            var8_9 = null;
                            if (res == null) continue;
                            res.unload();
                            continue;
                        }
                        catch (Throwable throwable) {
                            var8_9 = null;
                            if (res != null) {
                                res.unload();
                            }
                            throw throwable;
                        }
                    }
                }
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, "getBinURLTable", "1393", this);
                    if (!this._isLocal) break block13;
                    th.printStackTrace();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getBinURLTable");
            }
            return temp;
        }

        public Object remove(Object key) {
            return this._table.remove(key);
        }

        public Hashtable get_table() {
            return this._table;
        }

        public void set_table(Hashtable _table) {
            this._table = _table;
        }

        public boolean isVariablexml() {
            return this.variablexml;
        }

        public void setVariablexml(boolean variablexml) {
            this.variablexml = variablexml;
        }

        public void setCachedSIMap(Hashtable cachedsiMap) {
            this.cachedsiMap = cachedsiMap;
        }

        public void setNewSIMap(Hashtable newsiMap) {
            this.newsiMap = newsiMap;
        }

        public boolean isVarChanged() {
            return this.varChanged;
        }

        public void setVarChanged(boolean varChanged) {
            this.varChanged = varChanged;
        }

        public Hashtable getVarTable() {
            return this.varTable;
        }

        public void setVarTable(Hashtable varTable) {
            this.varTable = varTable;
        }

        public String getCRoot() {
            return this.cRoot;
        }

        public void setCRoot(String root) {
            this.cRoot = root;
        }
    }

    private class AppBinThread
    implements Runnable {
        ConfigRepository _repository;
        String _cellName;
        String _nodeName;
        ResourceBundle _resBundle;
        Subject _subject = null;
        boolean _isLocal;
        ChangeTable _changeTbl;
        Object _notify;
        Class _cls;
        protected String profileKey = null;
        AbstractAppSyncTask _task;
        protected int nextTaskNum = 0;

        public AppBinThread(String cellname, int celltype, String nodename, ChangeTable tbl, ConfigRepository rep) {
            this._cellName = cellname;
            this._nodeName = nodename;
            this._changeTbl = tbl;
            this._repository = rep;
            this._resBundle = AppBinaryProcessor.getBundle();
            AppSyncUtils.setCellInfo(cellname, celltype);
        }

        public void setSecurity(Object n, Class c) {
            this._notify = n;
            this._cls = c;
        }

        public void setLocal(boolean local) {
            this._isLocal = local;
            if (!local) {
                this._subject = SecurityHelper.getOwnedSubject();
            }
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            ExpandApp exApp = new ExpandApp(this._cellName, this._nodeName, this._repository, this._resBundle, this._changeTbl);
            exApp.expand(this.profileKey, null, this._subject, AppBinaryProcessor.this.cls, AppBinaryProcessor.this.notify, this._isLocal);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "allSaveThreads size: ", allSaveThreads.size());
            }
            boolean done = allSaveThreads.remove(this);
            while (done) {
                done = allSaveThreads.remove(this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }

        public List getAppsBeingProcessed() {
            if (this._changeTbl == null) {
                return null;
            }
            Enumeration applist = this._changeTbl.keys();
            ArrayList l = new ArrayList();
            while (applist.hasMoreElements()) {
                l.add(applist.nextElement());
            }
            return l;
        }

        public void setProfileKey(String pKey) {
            this.profileKey = pKey;
        }

        private synchronized void waitForThreadCompletion() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForThreadCompletion");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Entering waitForThreadCompletion notificationSignaled = " + AppBinaryProcessor.this.notificationSignaled);
            }
            if (!AppBinaryProcessor.this.notificationSignaled) {
                try {
                    this.wait();
                }
                catch (InterruptedException exc) {
                    // empty catch block
                }
            }
            AppBinaryProcessor.this.notificationSignaled = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exiting waitForThreadCompletion");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForThreadCompletion");
            }
        }

        private synchronized void notifyWaiter() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyWaiter");
            }
            AppBinaryProcessor.this.notificationSignaled = true;
            this.notify();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyWaiter");
            }
        }
    }
}

