/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUpdate;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class AddBinaryTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(AddBinaryTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private AppUpdateHelper _aHelper;
    private ArrayList deleted = new ArrayList();
    private ArrayList added = new ArrayList();
    private ArrayList updated = new ArrayList();
    private Hashtable _props;
    private AppData _cachedAd;
    private AppData _newAd;

    public AddBinaryTask() {
        this._aHelper = new AppUpdateHelper();
        this._aHelper.setLists(this.deleted, this.added, this.updated);
        this._aHelper.setSyncMode(true);
    }

    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        if ("false".equalsIgnoreCase(System.getProperty("com.ibm.websphere.management.application.enableDistribution"))) {
            Tr.debug(tc, "EnableDistribution SystemProperty set to false");
            return true;
        }
        if (!this.appIsDeployedOnNode(cachedAD.getAppName())) {
            return true;
        }
        if (!newAD.isDistEnabled()) {
            return true;
        }
        this._cachedAd = cachedAD;
        this._newAd = newAD;
        this._props = props;
        int op = this._newAd.getOperations();
        if ((op & 1) != 0 || (op & 0x10000) != 0 || (op & 0x1000) != 0 || !this.appWasDeployedOnNode(cachedAD.getAppName())) {
            this.fullUpdate(this._newAd.getBinURL(), props);
        } else if ((op & 0x100000) != 0) {
            return this.fineGrainUpdate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private boolean fullUpdate(String binURL, Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fullUpdate");
        }
        String pName = "";
        try {
            AppUtils.deleteDirTree(binURL, false);
            EarUtils.extractEar((EARFile)this._newAd.getEAR(), (String)binURL, (boolean)false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expanded ear");
            }
        }
        catch (Throwable th) {
            props.put("expansionFailue", binURL);
            RasUtils.logException(th, tc, CLASS_NAME, "fullUpdate", "135", this);
            Tr.error(tc, "EAR expansion failued for " + binURL);
        }
        try {
            Vector processList = (Vector)this._newSIMap.get(this._cachedAd.getAppName());
            for (int j = 0; j < processList.size(); ++j) {
                pName = (String)processList.elementAt(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Install J2EEApplication on application: " + this._cachedAd.getAppName() + " ,process: " + pName);
                }
                this.installJ2EEApplication(this._cachedAd.getAppName(), pName);
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "fullUpdate", "156", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fullUpdate");
        }
        return true;
    }

    private boolean fineGrainUpdate() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fineGrainUpdate");
        }
        String pName = "";
        try {
            String srcPath = this._cachedAd.getEarURI().substring(0, this._cachedAd.getEarURI().lastIndexOf(47));
            String destPath = this._cachedAd.getBinURL();
            this._aHelper.mergeFiles("add", srcPath, destPath);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fineGrainUpdate");
            }
            return true;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "fineGrainUpdate", "183", this);
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, "AddBinaryTask failed on fineGrainUpdate.");
        }
    }

    private String getKey(String binName, String appName) {
        String s = binName.substring(binName.indexOf("applications") + "applications".length() + 1);
        s = s.substring(0, s.indexOf(47) + 1);
        s = s + "deployments" + "/" + appName;
        return s;
    }

    private void installJ2EEApplication(String appName, String pName) {
        if (this._isLocal) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installJ2EEApplication");
        }
        ObjectName appMgrName = null;
        try {
            Iterator it1;
            String q = "WebSphere:type=ApplicationManager,node=" + this._nodeName + ",process=" + pName + ",*";
            ObjectName on = new ObjectName(q);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Query for: " + q);
            }
            if ((it1 = AdminServiceFactory.getAdminService().queryNames(on, null).iterator()) == null || !it1.hasNext()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find: " + q);
                }
                return;
            }
            appMgrName = (ObjectName)it1.next();
            AdminServiceFactory.getAdminService().invoke(appMgrName, "_applicationInstalled", new Object[]{appName}, new String[]{String.class.getName()});
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error installing J2EEApplication at app: " + appName + " on process: " + pName + " by: " + appMgrName);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "installJ2EEApplication", "237", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installJ2EEApplication");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/AddBinaryTask.java, WAS.admin.appmgmt.sync, WAS70.SERV1, cf050925.09, ver. 1.17.1.4");
        }
        CLASS_NAME = AddBinaryTask.class.getName();
    }

    private class AppUpdateHelper
    extends AppUpdate {
        private AppUpdateHelper() {
        }

        public List getURIs() {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "getURIs");
            }
            List l = (List)AddBinaryTask.this._newAd.getPartialUpdateDetails().get("DOCSADDED_KEY");
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getURIs:" + l);
            }
            return l;
        }

        public InputStream getContentAsInputStream(String uri) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "getContentAsInputStream: uri = " + uri);
            }
            InputStream fIn = null;
            try {
                Archive a;
                org.eclipse.jst.j2ee.commonarchivecore.internal.File srcFile;
                Object[] o = (Object[])((Hashtable)AddBinaryTask.this._props.get("filestbl")).get(uri);
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "getContentAsInputStream");
                }
                if ((srcFile = (a = (Archive)o[1]).getFile((String)o[2])) != null) {
                    long srcFileLastModTimeStamp = srcFile.getLastModified();
                    this.fileTimeStamps.put(uri, new Long(srcFileLastModTimeStamp));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error trying to keep the last-modified timestamp of: " + uri);
                }
                Tr.debug(tc, "getting inputstream on container: " + a + ", and offset: " + (String)o[2]);
                fIn = a.getInputStream((String)o[2]);
                return fIn;
            }
            catch (Exception e) {
                Tr.debug(tc, "AppBinaryTask.getContentAsInputStream failed");
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "getContentAsInputStream");
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mergeFiles(String operation, String srcPath, String destPath) throws Exception {
            super.mergeFiles(operation, srcPath, destPath);
            ArrayList<String> l = new ArrayList<String>();
            Hashtable tbl = (Hashtable)AddBinaryTask.this._props.get("filestbl");
            Enumeration ee = tbl.keys();
            while (ee.hasMoreElements()) {
                org.eclipse.jst.j2ee.commonarchivecore.internal.File f;
                String uri = (String)ee.nextElement();
                Object[] obj = (Object[])tbl.get(uri);
                if ("delete".equals(obj[0]) || !(obj[1] instanceof EARFile)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Content change at EAR: " + uri);
                }
                if (!((f = ((EARFile)obj[1]).getFile((String)obj[2])) instanceof WARFile) && !(f instanceof RARFile)) continue;
                l.add((String)obj[2]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expand list: " + l);
            }
            for (int i = 0; i < l.size(); ++i) {
                Object var12_12;
                File f = new File(AddBinaryTask.this._cachedAd.getBinURL() + "/" + l.get(i));
                if (!f.exists() || !f.isFile()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expanding: " + l.get(i));
                }
                Archive arch = null;
                try {
                    try {
                        arch = AppInstallHelper.getArchive(f.getPath(), false, true, this.getResourceBundle(), false);
                        arch.extract(66);
                    }
                    catch (Throwable th) {
                        RasUtils.logException(th, tc, CLASS_NAME, "mergeFiles", "346", this);
                        Tr.debug(tc, "Exception in extracting: " + f + ": " + th);
                        var12_12 = null;
                        if (arch != null) {
                            arch.close();
                        }
                        arch = null;
                        continue;
                    }
                    var12_12 = null;
                    if (arch != null) {
                        arch.close();
                    }
                    arch = null;
                    continue;
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    if (arch != null) {
                        arch.close();
                    }
                    arch = null;
                    throw throwable;
                }
            }
        }
    }
}

