/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

public class WrapModuleInEARCmd {
    static TraceComponent tc = Tr.register(WrapModuleInEARCmd.class, null, null);
    private static final String CLASS_NAME;
    private EARFile _earFile;
    private ModuleFile _moduleFile;
    private String _earName;
    private String _directory;
    private String _contextRoot;
    private String _displayName;
    private boolean _isDirectory = false;
    private boolean _isEarFile = false;
    private boolean _closeFile = true;
    private String _alternateAppFileName;
    private String _jarName;
    private CommonarchiveFactory _factory = null;
    ArchiveOptions _archiveOptions = null;

    public WrapModuleInEARCmd(String jarName, String directory) throws Exception {
        this._jarName = jarName;
        this._directory = directory;
        this._closeFile = true;
        this.initializeFactories();
        File file = new File(jarName);
        this._isDirectory = file.isDirectory();
        try {
            Archive archive = this._factory.openArchive(this._archiveOptions, this._jarName);
            if (archive.isModuleFile()) {
                this._moduleFile = (ModuleFile)archive;
            } else {
                archive.close();
            }
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "<init>", "94", this);
            this.closeFiles();
            throw ex;
        }
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String jarName, String directory) {
        this._jarName = jarName;
        this._directory = directory;
        this._closeFile = true;
        this._isDirectory = false;
        this._moduleFile = moduleFile;
        this.initializeFactories();
    }

    public void execute() throws Exception {
        try {
            if (this._moduleFile != null) {
                if (this._moduleFile.isEARFile()) {
                    this._earFile = (EARFile)this._moduleFile;
                    this._isEarFile = true;
                } else if (this._moduleFile.isModuleFile()) {
                    this.wrapModuleJar();
                } else {
                    this._earFile = null;
                }
            }
            this.closeFiles();
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "execute", "129", this);
            String es = "";
            if (ex != null) {
                es = this.PrintNestedArchiveExceptions(ex);
            }
            this.closeFiles();
            throw ex;
        }
    }

    public Collection getResult() {
        if (this._earFile == null) {
            return null;
        }
        Vector<EARFile> v = new Vector<EARFile>(1);
        v.addElement(this._earFile);
        return v;
    }

    protected boolean prepare() {
        return true;
    }

    public WrapModuleInEARCmd(String moduleJarFileName, String directory, String alternateAppName) throws Exception {
        this(moduleJarFileName, directory);
        this._alternateAppFileName = alternateAppName;
    }

    public WrapModuleInEARCmd(String moduleJarFileName, String directory, String alternateAppName, String contextRoot) throws Exception {
        this(moduleJarFileName, directory, alternateAppName);
        this._contextRoot = contextRoot;
    }

    public WrapModuleInEARCmd(String moduleJarFileName, String directory, String alternateAppName, String contextRoot, String displayName) throws Exception {
        this(moduleJarFileName, directory, alternateAppName);
        this._contextRoot = contextRoot;
        this._displayName = displayName;
    }

    public WrapModuleInEARCmd(String moduleJarFileName, String directory, String alternateAppName, boolean closeFile) throws Exception {
        this(moduleJarFileName, directory);
        this._alternateAppFileName = alternateAppName;
        this._closeFile = closeFile;
    }

    public WrapModuleInEARCmd(String moduleJarFileName, String directory, String alternateAppName, String contextRoot, boolean closeFile) throws Exception {
        this(moduleJarFileName, directory, alternateAppName);
        this._contextRoot = contextRoot;
        this._closeFile = closeFile;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String moduleJarFileName, String directory, String alternateAppName) {
        this(moduleFile, moduleJarFileName, directory);
        this._alternateAppFileName = alternateAppName;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String moduleJarFileName, String directory, String alternateAppName, String contextRoot) {
        this(moduleFile, moduleJarFileName, directory, alternateAppName);
        this._contextRoot = contextRoot;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String moduleJarFileName, String directory, String alternateAppName, boolean closeFile) {
        this(moduleFile, moduleJarFileName, directory);
        this._alternateAppFileName = alternateAppName;
        this._closeFile = closeFile;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String moduleJarFileName, String directory, String alternateAppName, boolean closeFile, String displayName) {
        this(moduleFile, moduleJarFileName, directory);
        this._alternateAppFileName = alternateAppName;
        this._closeFile = closeFile;
        this._displayName = displayName;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String moduleJarFileName, String directory, String alternateAppName, String contextRoot, boolean closeFile) {
        this(moduleFile, moduleJarFileName, directory, alternateAppName);
        this._contextRoot = contextRoot;
        this._closeFile = closeFile;
    }

    public WrapModuleInEARCmd(ModuleFile moduleFile, String moduleJarFileName, String directory, String alternateAppName, String contextRoot, boolean closeFile, String displayName) {
        this(moduleFile, moduleJarFileName, directory, alternateAppName);
        this._contextRoot = contextRoot;
        this._closeFile = closeFile;
        this._displayName = displayName;
    }

    public String getEARFileName() {
        String earFileName = null;
        if (this._isEarFile) {
            return this._jarName;
        }
        earFileName = this._directory.endsWith("/") || this._directory.endsWith(File.separator) ? this._directory : this._directory + File.separator;
        if (this._alternateAppFileName != null && this._alternateAppFileName.length() > 0) {
            earFileName = this._alternateAppFileName.endsWith(".ear") ? earFileName + this._alternateAppFileName : earFileName + this._alternateAppFileName + ".ear";
        } else {
            int fileTypeOffset = this._jarName.lastIndexOf(".");
            int fileBegOffset = this._jarName.lastIndexOf(File.separator);
            String derivedJarName = null;
            derivedJarName = fileTypeOffset > 0 ? (fileBegOffset < fileTypeOffset - 1 ? this._jarName.substring(fileBegOffset + 1, fileTypeOffset) : this._jarName.substring(0, fileTypeOffset)) : this._jarName;
            earFileName = earFileName + derivedJarName;
            earFileName = earFileName + ".ear";
        }
        return earFileName;
    }

    public String getDerivedApplicationName() {
        String appName = null;
        if (this._alternateAppFileName != null && this._alternateAppFileName.length() > 0) {
            return this._alternateAppFileName;
        }
        int fileTypeOffset = this._jarName.lastIndexOf(".");
        int fileBegOffset = this._jarName.lastIndexOf(File.separator);
        String derivedJarName = null;
        derivedJarName = fileTypeOffset > 0 ? (fileBegOffset < fileTypeOffset - 1 ? this._jarName.substring(fileBegOffset + 1, fileTypeOffset) : this._jarName.substring(0, fileTypeOffset)) : this._jarName;
        appName = derivedJarName;
        return appName;
    }

    private void initializeFactories() {
        this._factory = CommonarchiveFactoryImpl.getActiveFactory();
        this._archiveOptions = new ArchiveOptions();
    }

    protected void wrapModuleJar() throws Exception {
        try {
            String earName = this.getEARFileName();
            this._earFile = this._factory.createEARFileInitialized(earName);
            Application app = this._earFile.getDeploymentDescriptor();
            if (this._displayName != null) {
                app.setDisplayName(this._displayName);
            } else {
                File f = new File(this._jarName);
                app.setDisplayName(f.getName());
            }
            app.setDescription("Auto-Generated Wrapper EAR for Module " + this._jarName);
            ModuleRef moduleRef = this._earFile.addCopyRef(this._moduleFile);
            moduleRef.setURI(this._moduleFile.getName());
            if (moduleRef.isWeb()) {
                if (this._contextRoot != null && this._contextRoot.length() > 0) {
                    this._contextRoot = this._contextRoot.replace('\\', '/');
                    if (!this._contextRoot.startsWith("/")) {
                        this._contextRoot = "/" + this._contextRoot;
                    }
                } else {
                    this._contextRoot = "/" + this.getDerivedApplicationName();
                }
                WebModule webModule = (WebModule)moduleRef.getModule();
                webModule.setContextRoot(this._contextRoot);
            }
            this._earFile.rollUpRoles();
            this._earFile.save();
            this.closeFiles();
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "wrapModuleJar", "342", this);
            String es = "";
            if (ex != null) {
                es = this.PrintNestedArchiveExceptions(ex);
            }
            this.closeFiles();
            throw ex;
        }
    }

    protected String PrintNestedArchiveExceptions(Exception ex) {
        String errorString = "";
        Exception ex1 = ex;
        while (ex1 instanceof ArchiveRuntimeException) {
            errorString = errorString + "\n" + ex1.toString();
            if (((ArchiveRuntimeException)ex1).getNestedException() == null) continue;
            ex1 = ((ArchiveRuntimeException)ex1).getNestedException();
        }
        return errorString;
    }

    protected void closeFiles() {
        if (this._closeFile) {
            if (this._earFile != null) {
                this._earFile.close();
            }
            if (this._moduleFile != null) {
                this._moduleFile.close();
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/utils/WrapModuleInEARCmd.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.7");
        }
        CLASS_NAME = WrapModuleInEARCmd.class.getName();
    }
}

