/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.util.RasUtils;
import java.io.PrintStream;
import java.util.Iterator;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class ShowBindingsCmd {
    static TraceComponent tc = Tr.register(ShowBindingsCmd.class, null, null);
    private static final String CLASS_NAME;
    EARFile ear = null;
    PrintStream out = System.out;

    public ShowBindingsCmd(EARFile ear) {
        this.ear = ear;
        this.out = System.out;
    }

    public ShowBindingsCmd(EARFile ear, PrintStream out) {
        this.ear = ear;
        this.out = out;
    }

    public void execute() {
        this.showBindings(this.ear);
    }

    protected void showBindings(EARFile ear) {
        try {
            Iterator modules = ear.getModuleFiles().iterator();
            System.out.println("\n------------------------");
            while (modules.hasNext()) {
                Archive module = (Archive)modules.next();
                if (module.isEJBJarFile()) {
                    this.showEjbJarBindings((EJBJarFile)module);
                } else if (module.isWARFile()) {
                    this.showWarBindings((WARFile)module);
                } else if (module.isApplicationClientFile()) {
                    this.showAppClientBindings((ApplicationClientFile)module);
                }
                this.out.println("\n------------------------\n");
            }
            this.out.println();
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "showBindings", "114", this);
            this.out.println("ERROR displaying bindings info ... continuing:" + t.toString());
        }
    }

    protected void showEjbJarBindings(EJBJarFile ejbJar) {
        try {
            String dsJndi;
            ResourceRefBinding defaultDS;
            String cfJndi;
            this.out.println();
            this.out.println(ejbJar.getName());
            EJBJarBinding bindings = ejbJar.getBindings();
            EJBJar dd = ejbJar.getDeploymentDescriptor();
            CMPConnectionFactoryBinding defaultConnFact = bindings.getDefaultCMPConnectionFactory();
            if (defaultConnFact != null && (cfJndi = defaultConnFact.getJndiName()) != null) {
                this.out.println("  Default Connection Factory --> " + cfJndi + "," + Preferences.RES_AUTH[defaultConnFact.getResAuth().getValue()]);
            }
            if ((defaultDS = bindings.getDefaultDatasource()) != null && (dsJndi = defaultDS.getJndiName()) != null) {
                AbstractAuthData auth = defaultDS.getDefaultAuth();
                this.out.println("  Default Data Source --> " + dsJndi + " (" + defaultDS.getClass().getName() + ")");
            }
            Iterator ejbs = dd.getEnterpriseBeans().iterator();
            while (ejbs.hasNext()) {
                try {
                    EnterpriseBean ejb = (EnterpriseBean)ejbs.next();
                    EnterpriseBeanBinding binding = bindings.getEJBBinding(ejb);
                    if (ejb.isMessageDriven()) {
                        this.out.println("  " + ejb.getName());
                        this.out.println("    port: " + ((MessageDrivenBeanBinding)binding).getListenerInputPortName());
                    } else {
                        this.out.println("  " + ejb.getName() + " --> " + binding.getJndiName());
                        if (ejb.isContainerManagedEntity()) {
                            if (dd.isVersion2_0Descriptor()) {
                                CMPConnectionFactoryBinding cfb = binding.getCmpConnectionFactory();
                                if (cfb != null && cfb.getJndiName() != null) {
                                    this.out.println("    Connection Factory --> " + cfb.getJndiName() + "," + Preferences.RES_AUTH[cfb.getResAuth().getValue()]);
                                } else {
                                    this.out.println("    Connection Factory --> default");
                                }
                            }
                            if (dd.isVersion1_1Descriptor()) {
                                ResourceRefBinding dsb = binding.getDatasource();
                                if (dsb != null && dsb.getJndiName() != null) {
                                    this.out.println("    Data Source --> " + dsb.getJndiName());
                                } else {
                                    this.out.println("    Data Source --> default");
                                }
                            }
                        }
                    }
                    for (EjbRef ejbRef : ejb.getEjbRefs()) {
                        EjbRefBinding refBinding = binding.getEjbRefBinding(ejbRef);
                        this.out.println("    <ejb-ref> java:comp/env/" + ejbRef.getName() + " --> " + refBinding.getJndiName());
                    }
                    for (EJBLocalRef ejbRef : ejb.getEjbLocalRefs()) {
                        EjbRefBinding refBinding = binding.getEjbRefBinding(ejbRef);
                        this.out.println("    <ejb-local-ref> java:comp/env/" + ejbRef.getName() + " --> " + refBinding.getJndiName());
                    }
                    Iterator resourceRefs = ejb.getResourceRefs().iterator();
                    while (resourceRefs.hasNext()) {
                        ResourceRef resRef = (ResourceRef)resourceRefs.next();
                        ResourceRefBinding resRefBinding = binding.getResRefBinding(resRef);
                        this.out.println("    <resource-ref> java:comp/env/" + resRef.getName() + " --> " + resRefBinding.getJndiName());
                    }
                    Iterator resourceEnvRefs = ejb.getResourceEnvRefs().iterator();
                    while (resourceEnvRefs.hasNext()) {
                        ResourceEnvRef resEnvRef = (ResourceEnvRef)resourceRefs.next();
                        ResourceEnvRefBinding resEnvRefBinding = binding.getResEnvRefBinding(resEnvRef);
                        this.out.println("    <resource-env-ref> java:comp/env/" + resEnvRef.getName() + " --> " + resEnvRefBinding.getJndiName());
                    }
                }
                catch (Throwable t) {
                    RasUtils.logException(t, tc, CLASS_NAME, "showEjbJarBindings", "257", this);
                }
            }
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "showEjbJarBindings", "262", this);
        }
    }

    protected void showWarBindings(WARFile war) {
        WebApp dd = war.getDeploymentDescriptor();
        WebAppBinding bindings = war.getBindings();
        this.out.println();
        this.out.println(war.getName());
        this.out.println("  <virtual-host> --> " + bindings.getVirtualHostName());
        for (EjbRefBinding ejbRefBinding : bindings.getEjbRefBindings()) {
            this.out.println("  <ejb-ref> java:comp/env/" + ejbRefBinding.getBindingEjbRef().getName() + " --> " + ejbRefBinding.getJndiName());
        }
        for (ResourceRefBinding resRefBinding : bindings.getResRefBindings()) {
            this.out.println("    <resource-ref> java:comp/env/" + resRefBinding.getBindingResourceRef().getName() + " --> " + resRefBinding.getJndiName());
        }
        for (ResourceEnvRefBinding resEnvRefBinding : bindings.getResourceEnvRefBindings()) {
            this.out.println("    <resource-env-ref> java:comp/env/" + resEnvRefBinding.getBindingResourceEnvRef().getName() + " --> " + resEnvRefBinding.getJndiName());
        }
    }

    protected void showAppClientBindings(ApplicationClientFile appClient) {
        ApplicationClient dd = appClient.getDeploymentDescriptor();
        ApplicationClientBinding bindings = appClient.getBindings();
        this.out.println();
        this.out.println(appClient.getName());
        for (EjbRefBinding ejbRefBinding : bindings.getEjbRefs()) {
            this.out.println("  <ejb-ref> java:comp/env/" + ejbRefBinding.getBindingEjbRef().getName() + " --> " + ejbRefBinding.getJndiName());
        }
        for (ResourceRefBinding resRefBinding : bindings.getResourceRefs()) {
            this.out.println("    <resource-ref> java:comp/env/" + (resRefBinding.getBindingResourceRef() != null ? resRefBinding.getBindingResourceRef().getName() : "???") + " --> " + resRefBinding.getJndiName());
        }
        for (ResourceEnvRefBinding resEnvRefBinding : bindings.getResourceEnvRefBindings()) {
            this.out.println("    <resource-env-ref> java:comp/env/" + (resEnvRefBinding.getBindingResourceEnvRef() != null ? resEnvRefBinding.getBindingResourceEnvRef().getName() : "???") + " --> " + resEnvRefBinding.getJndiName());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/utils/ShowBindingsCmd.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.9");
        }
        CLASS_NAME = ShowBindingsCmd.class.getName();
    }
}

