/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.util.RasUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CommandLineUtils {
    static TraceComponent tc = Tr.register(CommandLineUtils.class, null, null);
    private static final String CLASS_NAME;

    public static Hashtable parseCommandLineArgs(String[] args) {
        return CommandLineUtils.parseCommandLineArgs(args, false);
    }

    public static Hashtable parseCommandLineArgs(String[] args, boolean toLowerCase) {
        try {
            Hashtable<String, String> cmdLineArgs = new Hashtable<String, String>();
            for (int i = 0; i < args.length; i += 2) {
                String name = args[i].substring(1, args[i].length());
                if (toLowerCase) {
                    name = name.toLowerCase();
                }
                if (i < args.length - 1) {
                    String value = args[i + 1];
                    if (!value.startsWith("-")) {
                        cmdLineArgs.put(name, value);
                        continue;
                    }
                    cmdLineArgs.put(name, "NO SUB-ARG");
                    --i;
                    continue;
                }
                cmdLineArgs.put(name, "NO SUB-ARG");
            }
            return cmdLineArgs;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "parseCommandLineArgs", "81");
            return null;
        }
    }

    public static void checkArguments(Vector validKeys, Hashtable args, boolean caseSensitive) throws IllegalArgumentException {
        Enumeration argNames = args.keys();
        while (argNames.hasMoreElements()) {
            String argument = (String)argNames.nextElement();
            boolean found = false;
            Enumeration keys = validKeys.elements();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (caseSensitive) {
                    if (!argument.equals(key)) continue;
                    found = true;
                    continue;
                }
                if (!argument.equalsIgnoreCase(key)) continue;
                found = true;
            }
            if (found) continue;
            throw new IllegalArgumentException(argument);
        }
    }

    public static void checkArguments(Vector validKeys, Hashtable args) throws IllegalArgumentException {
        CommandLineUtils.checkArguments(validKeys, args, true);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/utils/CommandLineUtils.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.3");
        }
        CLASS_NAME = CommandLineUtils.class.getName();
    }
}

