/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.util.RasUtils;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class StrategyExporter {
    static TraceComponent tc = Tr.register(StrategyExporter.class, null, null);
    private static final String CLASS_NAME;
    PrintStream out = System.out;
    int indentation = -1;
    EARFile ear = null;

    public StrategyExporter(Preferences preferences, EARFile ear) {
        this.ear = ear;
        try {
            this.out = new PrintStream(new FileOutputStream(preferences.getExportFile()));
        }
        catch (Throwable fnfe) {
            System.err.println("couldnt open export file " + preferences.getExportFile() + " ...  writing to System.out instead ...");
            this.out = System.out;
        }
    }

    public void export() {
        this.out.println("<?xml version=\"1.0\"?>");
        this.out.println("<!DOCTYPE dfltbndngs SYSTEM \"dfltbndngs.dtd\">");
        this.startElement("dfltbndngs", true);
        this.exportGlobalBindings();
        this.exportModuleBindings();
        this.endElement("dfltbndngs", true);
    }

    void exportGlobalBindings() {
        this.startElement("global-bindings", true);
        this.endElement("global-bindings", true);
    }

    void exportModuleBindings() {
        this.startElement("module-bindings", true);
        for (Archive module : this.ear.getModuleFiles()) {
            if (module.isEJBJarFile()) {
                this.exportEjbJarFile((EJBJarFile)module);
                continue;
            }
            if (module.isWARFile()) {
                this.exportWarFile((WARFile)module);
                continue;
            }
            if (!module.isApplicationClientFile()) continue;
            this.exportClientJar((ApplicationClientFile)module);
        }
        this.endElement("module-bindings", true);
    }

    void exportEjbJarFile(EJBJarFile jar) {
        Iterator ejbs;
        CMPConnectionFactoryBinding defaultCF;
        this.startElement("ejb-jar-binding", true);
        this.printElement("jar-name", jar.getURI());
        EJBJarBinding bindings = jar.getBindings();
        EJBJar dd = jar.getDeploymentDescriptor();
        ResourceRefBinding defaultDS = bindings.getDefaultDatasource();
        if (defaultDS != null) {
            this.exportDataSource(defaultDS.getJndiName(), "_user_", "_password_");
        }
        if ((defaultCF = bindings.getDefaultCMPConnectionFactory()) != null) {
            this.exportConnectionFactory(defaultCF.getJndiName(), Preferences.RES_AUTH[defaultCF.getResAuth().getValue()]);
        }
        if ((ejbs = dd.getEnterpriseBeans().iterator()).hasNext()) {
            this.startElement("ejb-bindings", true);
            while (ejbs.hasNext()) {
                try {
                    Iterator resourceEnvRefs;
                    Iterator resourceRefs;
                    EnterpriseBean ejb = (EnterpriseBean)ejbs.next();
                    EnterpriseBeanBinding binding = bindings.getEJBBinding(ejb);
                    this.startElement("ejb-binding", true);
                    this.printElement("ejb-name", ejb.getName());
                    if (ejb.isMessageDriven()) {
                        this.printElement("listener-port", ((MessageDrivenBeanBinding)binding).getListenerInputPortName());
                    } else {
                        this.printElement("jndi-name", binding.getJndiName());
                        if (ejb.isContainerManagedEntity()) {
                            ResourceRefBinding dsb;
                            CMPConnectionFactoryBinding cfb;
                            if (dd.isVersion2_0Descriptor() && (cfb = binding.getCmpConnectionFactory()) != null) {
                                this.exportConnectionFactory(cfb.getJndiName(), Preferences.RES_AUTH[cfb.getResAuth().getValue()]);
                            }
                            if (dd.isVersion1_1Descriptor() && (dsb = binding.getDatasource()) != null) {
                                this.exportDataSource(dsb.getJndiName(), "_user_", "_password_");
                            }
                        }
                    }
                    Iterator ejbRefs = ejb.getEjbRefs().iterator();
                    if (ejbRefs.hasNext()) {
                        this.startElement("ejb-ref-bindings", true);
                        while (ejbRefs.hasNext()) {
                            EjbRef ejbRef = (EjbRef)ejbRefs.next();
                            EjbRefBinding ejbRefBinding = binding.getEjbRefBinding(ejbRef);
                            this.exportEjbRef(ejbRef.getName(), ejbRefBinding.getJndiName());
                        }
                        this.endElement("ejb-ref-bindings", true);
                    }
                    if ((resourceRefs = ejb.getResourceRefs().iterator()).hasNext()) {
                        this.startElement("resource-ref-bindings", true);
                        while (resourceRefs.hasNext()) {
                            ResourceRef resRef = (ResourceRef)resourceRefs.next();
                            ResourceRefBinding resRefBinding = binding.getResRefBinding(resRef);
                            this.exportResourceRef(resRef.getName(), resRefBinding.getJndiName());
                        }
                        this.endElement("resource-ref-bindings", true);
                    }
                    if ((resourceEnvRefs = ejb.getResourceEnvRefs().iterator()).hasNext()) {
                        this.startElement("resource-env-ref-bindings", true);
                        while (resourceEnvRefs.hasNext()) {
                            ResourceEnvRef resEnvRef = (ResourceEnvRef)resourceEnvRefs.next();
                            ResourceEnvRefBinding resEnvRefBinding = binding.getResEnvRefBinding(resEnvRef);
                            this.exportResourceEnvRef(resEnvRef.getName(), resEnvRefBinding.getJndiName());
                        }
                        this.endElement("resource-env-ref-bindings", true);
                    }
                }
                catch (Throwable t) {
                    RasUtils.logException(t, tc, CLASS_NAME, "exportEjbJarFile", "209", this);
                }
                this.endElement("ejb-binding", true);
            }
            this.endElement("ejb-bindings", true);
        }
        this.endElement("ejb-jar-binding", true);
    }

    void exportConnectionFactory(String jndiName, String resAuth) {
        if (jndiName != null) {
            this.startElement("connection-factory", true);
            this.printElement("jndi-name", jndiName);
            this.printElement("res-auth", resAuth);
            this.endElement("connection-factory", true);
        }
    }

    void exportDataSource(String jndiName, String user, String password) {
        if (jndiName != null) {
            this.startElement("data-source", true);
            this.printElement("jndi-name", jndiName);
            this.printElement("user", user);
            this.printElement("password", password);
            this.endElement("data-source", true);
        }
    }

    void exportEjbRef(String ejbRef, String jndiName) {
        this.startElement("ejb-ref-binding", true);
        this.printElement("ejb-ref-name", ejbRef);
        this.printElement("jndi-name", jndiName);
        this.endElement("ejb-ref-binding", true);
    }

    void exportResourceRef(String resRef, String jndiName) {
        this.startElement("resource-ref-binding", true);
        this.printElement("resource-ref-name", resRef);
        this.printElement("jndi-name", jndiName);
        this.endElement("resource-ref-binding", true);
    }

    void exportResourceEnvRef(String resRef, String jndiName) {
        this.startElement("resource-env-ref-binding", true);
        this.printElement("resource-env-ref-name", resRef);
        this.printElement("jndi-name", jndiName);
        this.endElement("resource-env-ref-binding", true);
    }

    void exportWarFile(WARFile war) {
        Iterator resourceEnvRefs;
        Iterator resourceRefs;
        this.startElement("war-binding", true);
        WebApp dd = war.getDeploymentDescriptor();
        WebAppBinding bindings = war.getBindings();
        this.printElement("jar-name", war.getURI());
        Iterator ejbRefs = bindings.getEjbRefBindings().iterator();
        if (ejbRefs.hasNext()) {
            this.startElement("ejb-ref-bindings", true);
            while (ejbRefs.hasNext()) {
                EjbRefBinding ejbRefBinding = (EjbRefBinding)ejbRefs.next();
                this.exportEjbRef(ejbRefBinding.getBindingEjbRef().getName(), ejbRefBinding.getJndiName());
            }
            this.endElement("ejb-ref-bindings", true);
        }
        if ((resourceRefs = bindings.getResRefBindings().iterator()).hasNext()) {
            this.startElement("resource-ref-bindings", true);
            while (resourceRefs.hasNext()) {
                ResourceRefBinding resRefBinding = (ResourceRefBinding)resourceRefs.next();
                this.exportResourceRef(resRefBinding.getBindingResourceRef().getName(), resRefBinding.getJndiName());
            }
            this.endElement("resource-ref-bindings", true);
        }
        if ((resourceEnvRefs = bindings.getResourceEnvRefBindings().iterator()).hasNext()) {
            this.startElement("resource-env-ref-bindings", true);
            while (resourceEnvRefs.hasNext()) {
                ResourceEnvRefBinding resEnvRefBinding = (ResourceEnvRefBinding)resourceEnvRefs.next();
                this.exportResourceEnvRef(resEnvRefBinding.getBindingResourceEnvRef().getName(), resEnvRefBinding.getJndiName());
            }
            this.endElement("resource-env-ref-bindings", true);
        }
        this.endElement("war-binding", true);
    }

    void exportClientJar(ApplicationClientFile jar) {
        Iterator resourceEnvRefs;
        Iterator resourceRefs;
        this.startElement("java-binding", true);
        ApplicationClient dd = jar.getDeploymentDescriptor();
        ApplicationClientBinding bindings = jar.getBindings();
        this.printElement("jar-name", jar.getURI());
        Iterator ejbRefs = bindings.getEjbRefs().iterator();
        if (ejbRefs.hasNext()) {
            this.startElement("ejb-ref-bindings", true);
            while (ejbRefs.hasNext()) {
                EjbRefBinding ejbRefBinding = (EjbRefBinding)ejbRefs.next();
                this.exportEjbRef(ejbRefBinding.getBindingEjbRef().getName(), ejbRefBinding.getJndiName());
            }
            this.endElement("ejb-ref-bindings", true);
        }
        if ((resourceRefs = bindings.getResourceRefs().iterator()).hasNext()) {
            this.startElement("resource-ref-bindings", true);
            while (resourceRefs.hasNext()) {
                ResourceRefBinding resRefBinding = (ResourceRefBinding)resourceRefs.next();
                this.exportResourceRef(resRefBinding.getBindingResourceRef().getName(), resRefBinding.getJndiName());
            }
            this.endElement("resource-ref-bindings", true);
        }
        if ((resourceEnvRefs = bindings.getResourceEnvRefBindings().iterator()).hasNext()) {
            this.startElement("resource-env-ref-bindings", true);
            while (resourceEnvRefs.hasNext()) {
                ResourceEnvRefBinding resEnvRefBinding = (ResourceEnvRefBinding)resourceEnvRefs.next();
                this.exportResourceEnvRef(resEnvRefBinding.getBindingResourceEnvRef().getName(), resEnvRefBinding.getJndiName());
            }
            this.endElement("resource-env-ref-bindings", true);
        }
        this.endElement("java-binding", true);
    }

    void printElement(String tag, String value) {
        this.startElement(tag, false);
        this.out.print(value);
        this.endElement(tag, false);
    }

    void startElement(String tag, boolean newLine) {
        this.indent(1);
        if (newLine) {
            this.out.println("<" + tag + ">");
        } else {
            this.out.print("<" + tag + ">");
        }
    }

    void endElement(String tag, boolean indent) {
        if (indent) {
            this.indent();
        }
        this.out.println("</" + tag + ">");
        --this.indentation;
    }

    void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.out.print("  ");
        }
    }

    void indent(int delta) {
        this.indentation += delta;
        this.indent();
    }

    void indent(int delta, boolean indentalso) {
        this.indentation += delta;
        if (indentalso) {
            this.indent();
        }
    }

    void outdent(int delta) {
        this.indentation -= delta;
        this.indent();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/StrategyExporter.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.8");
        }
        CLASS_NAME = StrategyExporter.class.getName();
    }
}

