/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.dfltbndngs.PropertiesEntityResolver;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMParser
implements ErrorHandler {
    static TraceComponent tc = Tr.register(DOMParser.class, null, null);
    private static final String CLASS_NAME;
    DocumentBuilder builder = null;

    public DOMParser() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            this.builder = factory.newDocumentBuilder();
            this.builder.setErrorHandler(this);
            this.builder.setEntityResolver(new PropertiesEntityResolver());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            System.out.println("error in setting up parser feature");
        }
    }

    public Document parse(String uri) throws Exception {
        return this.builder.parse(uri);
    }

    public Document parse(InputSource is) throws Exception {
        return this.builder.parse(is);
    }

    public Node findChild(Node node, String name) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            if (!children.item(i).getNodeName().equals(name)) continue;
            return children.item(i);
        }
        return null;
    }

    public List findChildren(Node node, String name) {
        Vector<Node> result = new Vector<Node>();
        if (node != null) {
            NodeList children = node.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                if (!children.item(i).getNodeName().equals(name)) continue;
                result.add(children.item(i));
            }
        }
        return result;
    }

    public String findValue(String name, Node node, boolean recurse) {
        int i;
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (i = 0; i < length; ++i) {
            if (children.item(i).getNodeType() != 1 || !children.item(i).getNodeName().equals(name)) continue;
            return children.item(i).getFirstChild().getNodeValue();
        }
        if (recurse) {
            for (i = 0; i < length; ++i) {
                String result = this.findValue(name, children.item(i), true);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void error(SAXParseException ex) {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/DOMParser.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.7");
        }
        CLASS_NAME = DOMParser.class.getName();
    }
}

