/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.dfltbndngs.BindingStrategy;
import com.ibm.ws.management.application.dfltbndngs.ConnectionFactoryBinding;
import com.ibm.ws.management.application.dfltbndngs.DOMParser;
import com.ibm.ws.management.application.dfltbndngs.DataSourceBinding;
import com.ibm.ws.management.application.dfltbndngs.DefaultStrategy;
import com.ibm.ws.management.application.dfltbndngs.EjbId;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.dfltbndngs.ResourceRefMapElement;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomizeableStrategy
extends DefaultStrategy {
    static TraceComponent tc = Tr.register(CustomizeableStrategy.class, null, "com.ibm.ws.management.application.dfltbndngs.CustomizeableStrategy");
    private static final String CLASS_NAME;
    public static final String CONNFACT = "connection-factory";
    public static final String DATASOURCE = "data-source";
    public static final String EJB_BINDING = "ejb-binding";
    public static final String EJB_BINDINGS = "ejb-bindings";
    public static final String EJB_JAR_BINDING = "ejb-jar-binding";
    public static final String JAR_NAME = "jar-name";
    public static final String EJB_NAME = "ejb-name";
    public static final String GLOBAL_BINDINGS = "global-bindings";
    public static final String JAVA_BINDING = "java-binding";
    public static final String JNDI_NAME = "jndi-name";
    public static final String LISTERNER_PORT = "listener-port";
    public static final String ACTIVATIONSPEC_JNDI_NAME = "activationspec-jndi-name";
    public static final String MODULE_BINDINGS = "module-bindings";
    public static final String PASSWORD = "password";
    public static final String RESAUTH = "res-auth";
    public static final String EJB_REF = "ejb-ref-binding";
    public static final String EJB_REFS = "ejb-ref-bindings";
    public static final String EJB_REF_NAME = "ejb-ref-name";
    public static final String RESOURCE_ENV_REF = "resource-env-ref-binding";
    public static final String RESOURCE_ENV_REFS = "resource-env-ref-bindings";
    public static final String RESOURCE_ENV_REF_NAME = "resource-env-ref-name";
    public static final String RESOURCE_REF = "resource-ref-binding";
    public static final String RESOURCE_REFS = "resource-ref-bindings";
    public static final String RESOURCE_REF_NAME = "resource-ref-name";
    public static final String USER = "user";
    public static final String VIRTUAL_HOST = "virtual-host";
    public static final String WAR_BINDING = "war-binding";
    public static final String MSGDEST_REF = "message-destination-ref-binding";
    public static final String MSGDEST_REFS = "message-destination-ref-bindings";
    public static final String MSGDEST_REF_NAME = "message-destination-ref-name";
    public static final String LOGIN_CFG = "login-cfg";
    public static final String AUTH_PROPS = "auth-props";
    private String _dataSourceJndiName = null;
    private String _ejbJarName = null;
    private String _ejbName = null;
    private String _jndiName = null;
    private String _password = null;
    private String _resourceRefName = null;
    private String _user = null;
    private boolean _verbose = true;
    private boolean _debugMode = false;
    private Hashtable _datasourceMap = new Hashtable();
    private Hashtable _connectionFactoryMap = new Hashtable();
    private Hashtable _ejbRefMap = new Hashtable();
    private Hashtable _resourceRefMap = new Hashtable();
    private Hashtable _resourceEnvRefMap = new Hashtable();
    private Hashtable _ejbBindingMap = new Hashtable();
    private Hashtable _virtualHostMap = new Hashtable();
    private Hashtable _messageDestinationRefMap = new Hashtable();
    private DataSourceBinding _globalDataSourceBinding = null;
    private ConnectionFactoryBinding _globalConnectionFactoryBinding = null;
    private String _globalVirtualHost = null;

    public CustomizeableStrategy() {
    }

    public CustomizeableStrategy(Preferences prefs) {
        super(prefs);
    }

    public String toString() {
        return "CustomizeableStrategy{ prefs=" + this.preferences + ", ... }";
    }

    public void parse(String docuri) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", new Object[]{"docuri=" + docuri});
        }
        DOMParser parser2 = new DOMParser();
        FileInputStream istrm = new FileInputStream(docuri);
        InputSource isrc = new InputSource(istrm);
        Document doc = parser2.parse(isrc);
        Node root = null;
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            root = children.item(i);
            break;
        }
        this.parseGlobalBindings(parser2, root);
        Node moduleBindings = parser2.findChild(root, MODULE_BINDINGS);
        this.parseEjbJarBindings(parser2, moduleBindings);
        this.parseWarBindings(parser2, moduleBindings);
        this.parseAppClientBindings(parser2, moduleBindings);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parse -  global DS info: " + this._globalDataSourceBinding);
            Tr.debug(tc, "parse - data source map: " + this._datasourceMap.toString());
            Tr.debug(tc, "parse - ejb ref map : " + this._ejbRefMap.toString());
            Tr.debug(tc, "parse - resrce ref map : " + this._resourceRefMap.toString());
            Tr.debug(tc, "parse - EJB bndngs map : " + this._ejbBindingMap.toString());
        }
    }

    void parseGlobalBindings(DOMParser parser2, Node root) {
        String virtualHost;
        Node connFactInfo;
        String authProps;
        String loginCfg;
        Node globalInfo = parser2.findChild(root, GLOBAL_BINDINGS);
        Node globalDataSourceInfo = parser2.findChild(globalInfo, DATASOURCE);
        if (globalDataSourceInfo != null) {
            String jndiName = parser2.findValue(JNDI_NAME, globalDataSourceInfo, false);
            String user = parser2.findValue(USER, globalDataSourceInfo, false);
            String password = parser2.findValue(PASSWORD, globalDataSourceInfo, false);
            loginCfg = parser2.findValue(LOGIN_CFG, globalDataSourceInfo, false);
            authProps = parser2.findValue(AUTH_PROPS, globalDataSourceInfo, false);
            this.setDataSourceBinding(null, null, jndiName, user, password, loginCfg, authProps);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found global datasource", new Object[]{"jndi=" + jndiName, "user=" + user, "pwd=" + password + ",loginCfg" + loginCfg + ",authProps" + authProps});
            }
        }
        if ((connFactInfo = parser2.findChild(globalInfo, CONNFACT)) != null) {
            String jndiName = parser2.findValue(JNDI_NAME, connFactInfo, false);
            String resAuth = parser2.findValue(RESAUTH, connFactInfo, false);
            loginCfg = parser2.findValue(LOGIN_CFG, connFactInfo, false);
            authProps = parser2.findValue(AUTH_PROPS, connFactInfo, false);
            this.setConnectionFactoryBinding(null, null, jndiName, resAuth, loginCfg, authProps);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found global connection factory", new Object[]{this._globalConnectionFactoryBinding});
            }
        }
        if ((virtualHost = parser2.findValue(VIRTUAL_HOST, globalInfo, false)) != null) {
            this.setVirtualHost(null, virtualHost);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found global virtual host", new Object[]{this._globalVirtualHost});
            }
        }
    }

    void parseEjbJarBindings(DOMParser parser2, Node moduleBindings) {
        for (Node jarBindings : parser2.findChildren(moduleBindings, EJB_JAR_BINDING)) {
            Node ejbBindings;
            Node connFact;
            String authProps;
            String loginCfg;
            Node dataSource;
            String ejbJarName = parser2.findValue(JAR_NAME, jarBindings, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found EJB jar binding", new Object[]{"ejbJarName=" + ejbJarName});
            }
            if ((dataSource = parser2.findChild(jarBindings, DATASOURCE)) != null) {
                String jndiName = parser2.findValue(JNDI_NAME, dataSource, false);
                String user = parser2.findValue(USER, dataSource, false);
                String password = parser2.findValue(PASSWORD, dataSource, false);
                loginCfg = parser2.findValue(LOGIN_CFG, dataSource, false);
                authProps = parser2.findValue(AUTH_PROPS, dataSource, false);
                this.setDataSourceBinding(ejbJarName, null, jndiName, user, password, loginCfg, authProps);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parse - found jar level data source", new Object[]{"jndi=" + jndiName, "user=" + user, "password=" + password + ",loginCfg=" + loginCfg + ",authProps" + authProps});
                }
            }
            if ((connFact = parser2.findChild(jarBindings, CONNFACT)) != null) {
                String jndiName = parser2.findValue(JNDI_NAME, connFact, false);
                String resAuth = parser2.findValue(RESAUTH, connFact, false);
                loginCfg = parser2.findValue(LOGIN_CFG, connFact, false);
                authProps = parser2.findValue(AUTH_PROPS, connFact, false);
                ConnectionFactoryBinding binding = new ConnectionFactoryBinding(jndiName, resAuth, loginCfg, authProps);
                this.setConnectionFactoryBinding(ejbJarName, null, jndiName, resAuth, loginCfg, authProps);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parser - found jar level connection factory", new Object[]{binding});
                }
            }
            if ((ejbBindings = parser2.findChild(jarBindings, EJB_BINDINGS)) != null) {
                for (Node ejbBinding : parser2.findChildren(ejbBindings, EJB_BINDING)) {
                    String ejbName = parser2.findValue(EJB_NAME, ejbBinding, false);
                    String ejbJndiName = parser2.findValue(JNDI_NAME, ejbBinding, false);
                    Node ejbDataSource = parser2.findChild(ejbBinding, DATASOURCE);
                    Node ejbConnFact = parser2.findChild(ejbBinding, CONNFACT);
                    String listenerPort = parser2.findValue(LISTERNER_PORT, ejbBinding, false);
                    String activationSpecJNDIName = parser2.findValue(ACTIVATIONSPEC_JNDI_NAME, ejbBinding, false);
                    if (ejbJndiName != null) {
                        this.setEjbJndiName(ejbJarName, ejbName, ejbJndiName);
                    }
                    if (listenerPort != null) {
                        this.setListenerPort(ejbJarName, ejbName, listenerPort);
                    }
                    if (activationSpecJNDIName != null) {
                        this.setActivationSpecJNDIName(ejbJarName, ejbName, activationSpecJNDIName);
                    }
                    if (ejbDataSource != null) {
                        String dsJndiName = parser2.findValue(JNDI_NAME, ejbDataSource, false);
                        String dsUser = parser2.findValue(USER, ejbDataSource, false);
                        String dsPassword = parser2.findValue(PASSWORD, ejbDataSource, false);
                        String loginCfg2 = parser2.findValue(LOGIN_CFG, ejbDataSource, false);
                        String authProps2 = parser2.findValue(AUTH_PROPS, ejbDataSource, false);
                        this.setDataSourceBinding(ejbJarName, ejbName, dsJndiName, dsUser, dsPassword, loginCfg2, authProps2);
                    }
                    if (ejbConnFact != null) {
                        String jndiName = parser2.findValue(JNDI_NAME, ejbConnFact, false);
                        String resAuth = parser2.findValue(RESAUTH, ejbConnFact, false);
                        String loginCfg3 = parser2.findValue(LOGIN_CFG, ejbConnFact, false);
                        String authProps3 = parser2.findValue(AUTH_PROPS, ejbConnFact, false);
                        this.setConnectionFactoryBinding(ejbJarName, ejbName, jndiName, resAuth, loginCfg3, authProps3);
                    }
                    Node ejbRefBindings = parser2.findChild(ejbBinding, EJB_REFS);
                    for (Node ejbRefBinding : parser2.findChildren(ejbRefBindings, EJB_REF)) {
                        String refName = parser2.findValue(EJB_REF_NAME, ejbRefBinding, false);
                        String refJndiName = parser2.findValue(JNDI_NAME, ejbRefBinding, false);
                        Tr.debug(tc, "refName: " + refName + " refJndiName: " + refJndiName);
                        this.setEjbRefBinding(ejbJarName, refName, refJndiName);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parse - EJB jar ejb ref: " + this.getEjbRefMapElement(ejbJarName, refName, false).toString());
                    }
                    Node resourceRefBindings = parser2.findChild(ejbBinding, RESOURCE_REFS);
                    for (Node resourceRefBinding : parser2.findChildren(resourceRefBindings, RESOURCE_REF)) {
                        String refName = parser2.findValue(RESOURCE_REF_NAME, resourceRefBinding, false);
                        String refJndiName = parser2.findValue(JNDI_NAME, resourceRefBinding, false);
                        String loginCfg4 = parser2.findValue(LOGIN_CFG, resourceRefBinding, false);
                        String authProps4 = parser2.findValue(AUTH_PROPS, resourceRefBinding, false);
                        this.setResourceRefBinding(ejbJarName, ejbName, refName, refJndiName, loginCfg4, authProps4);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parse - EJB jar resource ref: " + this.getResourceRefMapElement(ejbJarName, ejbName, refName, false).toString());
                    }
                    Node resourceEnvRefBindings = parser2.findChild(ejbBinding, RESOURCE_ENV_REFS);
                    for (Node resourceEnvRefBinding : parser2.findChildren(resourceEnvRefBindings, RESOURCE_ENV_REF)) {
                        String refName = parser2.findValue(RESOURCE_ENV_REF_NAME, resourceEnvRefBinding, false);
                        String refJndiName = parser2.findValue(JNDI_NAME, resourceEnvRefBinding, false);
                        this.setResourceEnvRefBinding(ejbJarName, ejbName, refName, refJndiName);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parse - EJB jar resource env ref: " + this.getResourceEnvRefMapElement(ejbJarName, ejbName, refName, false).toString());
                    }
                    Node msgDestRefBindings = parser2.findChild(ejbBinding, MSGDEST_REFS);
                    for (Node msgDestRefBinding : parser2.findChildren(msgDestRefBindings, MSGDEST_REF)) {
                        String refName = parser2.findValue(MSGDEST_REF_NAME, msgDestRefBinding, false);
                        String refJndiName = parser2.findValue(JNDI_NAME, msgDestRefBinding, false);
                        this.setMessageDestinationRefBinding(ejbJarName, ejbName, refName, refJndiName);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parse - EJB jar msg dest ref: " + this.getMessageDestinationRefMapElement(ejbJarName, ejbName, refName, false).toString());
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "parse - EJB binding info: ", new Object[]{this.getEjbMapElement(ejbJarName, ejbName, true).toString()});
                }
            }
            Node ejbRefBindings = parser2.findChild(jarBindings, EJB_REFS);
            for (Node ejbRefBinding : parser2.findChildren(ejbRefBindings, EJB_REF)) {
                String refName = parser2.findValue(EJB_REF_NAME, ejbRefBinding, false);
                String refJndiName = parser2.findValue(JNDI_NAME, ejbRefBinding, false);
                Tr.debug(tc, "refName: " + refName + " refJndiName: " + refJndiName);
                this.setEjbRefBinding(ejbJarName, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - EJB jar ejb ref: " + this.getEjbRefMapElement(ejbJarName, refName, false).toString());
            }
            Node resourceRefBindings = parser2.findChild(jarBindings, RESOURCE_REFS);
            for (Node resourceRefBinding : parser2.findChildren(resourceRefBindings, RESOURCE_REF)) {
                String refName = parser2.findValue(RESOURCE_REF_NAME, resourceRefBinding, false);
                String refJndiName = parser2.findValue(JNDI_NAME, resourceRefBinding, false);
                String loginCfg5 = parser2.findValue(LOGIN_CFG, resourceRefBinding, false);
                String authProps5 = parser2.findValue(AUTH_PROPS, resourceRefBinding, false);
                this.setResourceRefBinding(ejbJarName, null, refName, refJndiName, loginCfg5, authProps5);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - EJB jar resource ref: " + this.getResourceRefMapElement(ejbJarName, null, refName, false).toString());
            }
            Node resourceEnvRefBindings = parser2.findChild(jarBindings, RESOURCE_ENV_REFS);
            for (Node resourceEnvRefBinding : parser2.findChildren(resourceEnvRefBindings, RESOURCE_ENV_REF)) {
                String refName = parser2.findValue(RESOURCE_ENV_REF_NAME, resourceEnvRefBinding, false);
                String refJndiName = parser2.findValue(JNDI_NAME, resourceEnvRefBinding, false);
                this.setResourceEnvRefBinding(ejbJarName, null, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - EJB jar resource env ref: " + this.getResourceEnvRefMapElement(ejbJarName, null, refName, false).toString());
            }
            Node msgDestRefBindings = parser2.findChild(jarBindings, MSGDEST_REFS);
            for (Node msgDestRefBinding : parser2.findChildren(msgDestRefBindings, MSGDEST_REF)) {
                String refName = parser2.findValue(MSGDEST_REF_NAME, msgDestRefBinding, false);
                String refJndiName = parser2.findValue(JNDI_NAME, msgDestRefBinding, false);
                this.setMessageDestinationRefBinding(ejbJarName, null, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - EJB jar msg dest ref: " + this.getMessageDestinationRefMapElement(ejbJarName, null, refName, false).toString());
            }
        }
    }

    void parseWarBindings(DOMParser parser2, Node moduleBindings) {
        for (Node warBindings : parser2.findChildren(moduleBindings, WAR_BINDING)) {
            String refJndiName;
            String refName;
            String virtualHost;
            String warName = parser2.findValue(JAR_NAME, warBindings, false);
            Node ejbRefBindings = parser2.findChild(warBindings, EJB_REFS);
            Node resourceRefBindings = parser2.findChild(warBindings, RESOURCE_REFS);
            Node resourceEnvRefBindings = parser2.findChild(warBindings, RESOURCE_ENV_REFS);
            Iterator ejbRefs = parser2.findChildren(ejbRefBindings, EJB_REF).iterator();
            Iterator resourceRefs = parser2.findChildren(resourceRefBindings, RESOURCE_REF).iterator();
            Iterator resourceEnvRefs = parser2.findChildren(resourceEnvRefBindings, RESOURCE_ENV_REF).iterator();
            Node msgDestRefBindings = parser2.findChild(warBindings, MSGDEST_REFS);
            Iterator msgDestRefs = parser2.findChildren(msgDestRefBindings, MSGDEST_REF).iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found .war bindings for " + warName);
            }
            if ((virtualHost = parser2.findValue(VIRTUAL_HOST, warBindings, false)) != null) {
                this.setVirtualHost(warName, virtualHost);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parse - war virtual host: ", virtualHost);
                }
            }
            while (ejbRefs.hasNext()) {
                Node ejbRefBinding = (Node)ejbRefs.next();
                refName = parser2.findValue(EJB_REF_NAME, ejbRefBinding, false);
                refJndiName = parser2.findValue(JNDI_NAME, ejbRefBinding, false);
                Tr.debug(tc, "refName: " + refName + " refJndiName: " + refJndiName);
                this.setEjbRefBinding(warName, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - war ejb ref: " + this.getEjbRefMapElement(warName, refName, false).toString());
            }
            while (resourceRefs.hasNext()) {
                Node resourceRefBinding = (Node)resourceRefs.next();
                refName = parser2.findValue(RESOURCE_REF_NAME, resourceRefBinding, false);
                refJndiName = parser2.findValue(JNDI_NAME, resourceRefBinding, false);
                String loginCfg = parser2.findValue(LOGIN_CFG, resourceRefBinding, false);
                String authProps = parser2.findValue(AUTH_PROPS, resourceRefBinding, false);
                this.setResourceRefBinding(warName, null, refName, refJndiName, loginCfg, authProps);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - war resource ref info: " + this.getResourceRefMapElement(warName, null, refName, false).toString());
            }
            while (resourceEnvRefs.hasNext()) {
                Node resourceEnvRefBinding = (Node)resourceEnvRefs.next();
                refName = parser2.findValue(RESOURCE_ENV_REF_NAME, resourceEnvRefBinding, false);
                refJndiName = parser2.findValue(JNDI_NAME, resourceEnvRefBinding, false);
                this.setResourceEnvRefBinding(warName, null, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - war resource env ref: " + this.getResourceEnvRefMapElement(warName, null, refName, false).toString());
            }
            while (msgDestRefs.hasNext()) {
                Node msgDestRefBinding = (Node)msgDestRefs.next();
                refName = parser2.findValue(MSGDEST_REF_NAME, msgDestRefBinding, false);
                refJndiName = parser2.findValue(JNDI_NAME, msgDestRefBinding, false);
                this.setMessageDestinationRefBinding(warName, null, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - war msg dest ref: " + this.getMessageDestinationRefMapElement(warName, null, refName, false).toString());
            }
        }
    }

    void parseAppClientBindings(DOMParser parser2, Node moduleBindings) {
        for (Node clientBindings : parser2.findChildren(moduleBindings, JAVA_BINDING)) {
            String refJndiName;
            String refName;
            String clientJarName = parser2.findValue(JAR_NAME, clientBindings, false);
            Node ejbRefBindings = parser2.findChild(clientBindings, EJB_REFS);
            Iterator ejbRefs = parser2.findChildren(ejbRefBindings, EJB_REF).iterator();
            Node resourceRefBindings = parser2.findChild(clientBindings, RESOURCE_REFS);
            Iterator resourceRefs = parser2.findChildren(resourceRefBindings, RESOURCE_REF).iterator();
            Node resourceEnvRefBindings = parser2.findChild(clientBindings, RESOURCE_ENV_REFS);
            Iterator resourceEnvRefs = parser2.findChildren(resourceEnvRefBindings, RESOURCE_ENV_REF).iterator();
            Node msgDestRefBindings = parser2.findChild(clientBindings, MSGDEST_REFS);
            Iterator msgDestRefs = parser2.findChildren(msgDestRefBindings, MSGDEST_REF).iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parse - found client bindings for " + clientJarName);
            }
            while (ejbRefs.hasNext()) {
                Node ejbRefBinding = (Node)ejbRefs.next();
                refName = parser2.findValue(EJB_REF_NAME, ejbRefBinding, false);
                refJndiName = parser2.findValue(JNDI_NAME, ejbRefBinding, false);
                Tr.debug(tc, "refName: " + refName + " refJndiName: " + refJndiName);
                this.setEjbRefBinding(clientJarName, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - client ejb ref: " + this.getEjbRefMapElement(clientJarName, refName, false).toString());
            }
            while (resourceRefs.hasNext()) {
                Node resourceRefBinding = (Node)resourceRefs.next();
                refName = parser2.findValue(RESOURCE_REF_NAME, resourceRefBinding, false);
                refJndiName = parser2.findValue(JNDI_NAME, resourceRefBinding, false);
                String loginCfg = parser2.findValue(LOGIN_CFG, resourceRefBinding, false);
                String authProps = parser2.findValue(AUTH_PROPS, resourceRefBinding, false);
                this.setResourceRefBinding(clientJarName, null, refName, refJndiName, loginCfg, authProps);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - client resource ref info: " + this.getResourceRefMapElement(clientJarName, null, refName, false).toString());
            }
            while (resourceEnvRefs.hasNext()) {
                Node resourceEnvRefBinding = (Node)resourceEnvRefs.next();
                refName = parser2.findValue(RESOURCE_ENV_REF_NAME, resourceEnvRefBinding, false);
                refJndiName = parser2.findValue(JNDI_NAME, resourceEnvRefBinding, false);
                this.setResourceEnvRefBinding(clientJarName, null, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - client resource env ref: " + this.getResourceEnvRefMapElement(clientJarName, null, refName, false).toString());
            }
            while (msgDestRefs.hasNext()) {
                Node msgDestRefBinding = (Node)msgDestRefs.next();
                refName = parser2.findValue(MSGDEST_REF_NAME, msgDestRefBinding, false);
                refJndiName = parser2.findValue(JNDI_NAME, msgDestRefBinding, false);
                this.setMessageDestinationRefBinding(clientJarName, null, refName, refJndiName);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "parse - client msg dest ref: " + this.getMessageDestinationRefMapElement(clientJarName, null, refName, false).toString());
            }
        }
    }

    public DataSourceBinding getDefaultDatasourceBindings(String ejbJarName, DataSourceBinding defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        DataSourceBinding result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDatasourceBindings", new Object[]{"ejbJar=" + ejbJarName, "defaults=" + defaults});
        }
        if ((result = (DataSourceBinding)this._datasourceMap.get(ejbJarName)) == null) {
            result = this._globalDataSourceBinding != null ? this._globalDataSourceBinding : super.getDefaultDatasourceBindings(ejbJarName, defaults, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDatasourceBindings", new Object[]{"ejbJar=" + ejbJarName, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public ConnectionFactoryBinding getDefaultConnectionFactoryBindings(String ejbJarName, ConnectionFactoryBinding defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        ConnectionFactoryBinding result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultConnectionFactoryBindings", new Object[]{"ejbJar=" + ejbJarName, "defaults=" + defaults});
        }
        if ((result = (ConnectionFactoryBinding)this._connectionFactoryMap.get(ejbJarName)) == null) {
            result = this._globalConnectionFactoryBinding != null ? this._globalConnectionFactoryBinding : super.getDefaultConnectionFactoryBindings(ejbJarName, defaults, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultConnectionFactoryBindings", new Object[]{"ejbJar=" + ejbJarName, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public String getEJBBinding(EjbId ejbInfo, String defaultName, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + defaultName});
        }
        String ejbName = ejbInfo.getEjbName();
        String result = null;
        EjbBindingMapElement binding = (EjbBindingMapElement)this._ejbBindingMap.get(ejbName);
        if (binding != null && binding.jndiName != null) {
            this._ejbNameMap.setProperty(ejbName, binding.jndiName);
            if (ejbInfo.getHomeInterface() != null) {
                this._ejbHomeMap.setProperty(ejbInfo.getHomeInterface(), binding.jndiName);
            }
            if (ejbInfo.getLocalInterface() != null) {
                this._ejbHomeMap.setProperty(ejbInfo.getLocalInterface(), binding.jndiName);
            }
            result = binding.jndiName;
        } else {
            result = super.getEJBBinding(ejbInfo, defaultName, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + defaultName, "result=" + result});
        }
        return result;
    }

    public ConnectionFactoryBinding getEJBConnectionFactoryBinding(EjbId ejbInfo, ConnectionFactoryBinding defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBConnectionFactoryBinding", new Object[]{"ejbInfo=" + ejbInfo, "defaults=" + defaults});
        }
        ConnectionFactoryBinding result = null;
        EjbBindingMapElement binding = (EjbBindingMapElement)this._ejbBindingMap.get(ejbInfo.getEjbName());
        result = binding != null && binding.connFactInfo != null ? binding.connFactInfo : super.getEJBConnectionFactoryBinding(ejbInfo, defaults, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBConnectionFactoryBinding", new Object[]{"ejbInfo=" + ejbInfo, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public DataSourceBinding getEJBDatasourceBinding(EjbId ejbInfo, DataSourceBinding defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBDatasourceBinding", new Object[]{"ejbInfo=" + ejbInfo, "defaults=" + defaults});
        }
        DataSourceBinding result = null;
        EjbBindingMapElement binding = (EjbBindingMapElement)this._ejbBindingMap.get(ejbInfo.getEjbName());
        result = binding != null && binding.dataSourceInfo != null ? new DataSourceBinding(binding.dataSourceInfo.jndiName, binding.dataSourceInfo.user, binding.dataSourceInfo.password, binding.dataSourceInfo.loginCfg, binding.dataSourceInfo.authProps) : super.getEJBDatasourceBinding(ejbInfo, defaults, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBDatasourceBinding", new Object[]{"ejbInfo=" + ejbInfo, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public String getMDBListenerPort(String mdbName, String defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMDBListenerPort", new Object[]{"mdbName=" + mdbName, "defaults=" + defaults});
        }
        String result = null;
        EjbBindingMapElement binding = (EjbBindingMapElement)this._ejbBindingMap.get(mdbName);
        result = binding != null && binding.listenerPort != null ? binding.listenerPort : super.getMDBListenerPort(mdbName, defaults, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMDBListenerPort", new Object[]{"mdbName=" + mdbName, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public boolean hasMDBListenerPortCustom(String mdbName) {
        EjbBindingMapElement binding = (EjbBindingMapElement)this._ejbBindingMap.get(mdbName);
        return binding != null && binding.listenerPort != null;
    }

    public String getMDBActivationSpec(String mdbName, String defaults, boolean bCreate, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMDBActivationSpec", new Object[]{"mdbName=" + mdbName, "defaults=" + defaults, "bCreate=" + bCreate});
        }
        String result = null;
        EjbBindingMapElement binding = (EjbBindingMapElement)this._ejbBindingMap.get(mdbName);
        String customProp = "com.ibm.websphere.management.application.dfltbndng.mdb.preferMDBCustomBindingsExclusive";
        boolean preferCustomBnd = "true".equalsIgnoreCase(System.getProperty(customProp));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "prefer custom bnd flag for MDB = " + preferCustomBnd);
        }
        if (binding != null && binding.activationSpecJNDIName != null) {
            result = binding.activationSpecJNDIName;
        } else if (preferCustomBnd && binding != null && binding.listenerPort != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no act spec but listener port is in custom file and system prop for preferMDBCustomBindingsExclusive is set, so listener port should be picked up");
            }
            result = null;
        } else if (bCreate) {
            result = super.getMDBActivationSpec(mdbName, defaults, bCreate, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMDBActivationSpec", new Object[]{"mdbName=" + mdbName, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public String getVirtualHost(String defaultBinding, String moduleName, BindingStrategy.WarningCollaborator warningCollaborator) {
        String result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVirtualHost", new Object[]{"virtualHost=" + defaultBinding});
        }
        if ((result = (String)this._virtualHostMap.get(moduleName)) == null) {
            String string = result = this._globalVirtualHost != null ? this._globalVirtualHost : super.getVirtualHost(defaultBinding, moduleName, warningCollaborator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVirtualHost", new Object[]{"virtualHost=" + result});
        }
        return result;
    }

    public String getEJBRefBinding(EjbId ejbInfo, String preExistingBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBRefBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + preExistingBinding});
        }
        String result = null;
        EjbRefMapElement binding = this.getEjbRefMapElement(null, ejbInfo.getEjbName(), false);
        Tr.debug(tc, "binding: " + binding);
        result = binding != null && binding.jndiName != null ? binding.jndiName : super.getEJBRefBinding(ejbInfo, preExistingBinding, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBRefBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + preExistingBinding, "result=" + result});
        }
        return result;
    }

    public ResourceRefMapElement getResourceRefBinding(String resourceRefName, String resourceType, String moduleName, String componentName, String preExistingBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceRefBinding", new Object[]{"res-ref=" + resourceRefName, "type=" + resourceType, "module=" + moduleName, "default=" + preExistingBinding});
        }
        ResourceRefMapElement result = null;
        ResourceRefMapElement binding = this.getResourceRefMapElement(moduleName, componentName, resourceRefName, false);
        if (binding == null && componentName != null) {
            binding = this.getResourceRefMapElement(moduleName, null, resourceRefName, false);
        }
        result = binding != null ? binding : super.getResourceRefBinding(resourceRefName, resourceType, moduleName, componentName, preExistingBinding, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceRefBinding", new Object[]{"res-ref=" + resourceRefName, "type=" + resourceType, "module=" + moduleName, "default=" + preExistingBinding, "result=" + result});
        }
        return result;
    }

    public String getResourceEnvRefBinding(String resourceEnvRefName, String resourceType, String moduleName, String componentName, String preExistingBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceEnvRefBinding", new Object[]{"res-env-ref=" + resourceEnvRefName, "type=" + resourceType, "module=" + moduleName, "default=" + preExistingBinding});
        }
        String result = null;
        ResourceRefMapElement binding = this.getResourceEnvRefMapElement(moduleName, componentName, resourceEnvRefName, false);
        if (binding == null && componentName != null) {
            binding = this.getResourceEnvRefMapElement(moduleName, null, resourceEnvRefName, false);
        }
        result = binding != null ? binding.jndiName : super.getResourceEnvRefBinding(resourceEnvRefName, resourceType, moduleName, componentName, preExistingBinding, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceEnvRefBinding", new Object[]{"res-env-ref=" + resourceEnvRefName, "type=" + resourceType, "module=" + moduleName, "default=" + preExistingBinding, "result=" + result});
        }
        return result;
    }

    public String getMessageDestinationRefBinding(String messageDestinationRefName, String linkName, String moduleName, String componentName, String preExistingBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageDestinationRefBinding", new Object[]{"res-env-ref=" + messageDestinationRefName, "module=" + moduleName, "default=" + preExistingBinding});
        }
        String result = null;
        ResourceRefMapElement binding = this.getMessageDestinationRefMapElement(moduleName, componentName, messageDestinationRefName, false);
        if (binding == null && componentName != null) {
            binding = this.getMessageDestinationRefMapElement(moduleName, null, messageDestinationRefName, false);
        }
        result = binding != null ? binding.jndiName : super.getMessageDestinationRefBinding(messageDestinationRefName, linkName, moduleName, componentName, preExistingBinding, warningCollaborator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageDestinationRefBinding", new Object[]{"res-env-ref=" + messageDestinationRefName, "module=" + moduleName, "default=" + preExistingBinding, "result=" + result});
        }
        return result;
    }

    public void setDataSourceBinding(String moduleName, String ejbName, String jndiName, String user, String password, String loginCfg, String authProps) {
        DataSourceBinding element = new DataSourceBinding(jndiName, user, password, loginCfg, authProps);
        if (moduleName != null) {
            if (ejbName != null) {
                this.getEjbMapElement((String)moduleName, (String)ejbName, (boolean)true).dataSourceInfo = new DataSourceMapElement(jndiName, user, password, loginCfg, authProps);
            } else {
                this._datasourceMap.put(moduleName, element);
            }
        } else {
            this._globalDataSourceBinding = element;
        }
    }

    public void setConnectionFactoryBinding(String moduleName, String ejbName, String jndiName, String resauth, String loginCfg, String authProps) {
        ConnectionFactoryBinding element = new ConnectionFactoryBinding(jndiName, resauth, loginCfg, authProps);
        if (moduleName != null) {
            if (ejbName != null) {
                this.getEjbMapElement((String)moduleName, (String)ejbName, (boolean)true).connFactInfo = new ConnectionFactoryBinding(jndiName, resauth, loginCfg, authProps);
            } else {
                this._connectionFactoryMap.put(moduleName, element);
            }
        } else {
            this._globalConnectionFactoryBinding = element;
        }
    }

    public void setVirtualHost(String moduleName, String virtualHost) {
        if (moduleName != null) {
            this._virtualHostMap.put(moduleName, virtualHost);
        } else {
            this._globalVirtualHost = virtualHost;
        }
    }

    public void setListenerPort(String moduleName, String ejbName, String listenerPortName) {
        this.getEjbMapElement((String)moduleName, (String)ejbName, (boolean)true).listenerPort = listenerPortName;
    }

    public void setActivationSpecJNDIName(String moduleName, String ejbName, String actSpec) {
        this.getEjbMapElement((String)moduleName, (String)ejbName, (boolean)true).activationSpecJNDIName = actSpec;
    }

    public void setEjbJndiName(String moduleName, String ejbName, String jndiName) {
        this.getEjbMapElement((String)moduleName, (String)ejbName, (boolean)true).jndiName = jndiName;
    }

    public void setEjbDatasource(String moduleName, String ejbName, String jndiName, String user, String password, String loginCfg, String authProps) {
        this.getEjbMapElement((String)moduleName, (String)ejbName, (boolean)true).dataSourceInfo = new DataSourceMapElement(jndiName, user, password, loginCfg, authProps);
    }

    public void setEjbConnectionFactory(String moduleName, String ejbName, String jndiName, String resAuth, String loginCfg, String authProps) {
        this.getEjbMapElement((String)moduleName, (String)ejbName, (boolean)true).connFactInfo = new ConnectionFactoryBinding(jndiName, resAuth, loginCfg, authProps);
    }

    public void setEjbRefBinding(String moduleName, String ejbRefName, String jndiName) {
        this.getEjbRefMapElement((String)moduleName, (String)ejbRefName, (boolean)true).jndiName = jndiName;
    }

    public void setResourceRefBinding(String moduleName, String componentName, String refName, String jndiName, String loginCfg, String authProps) {
        this.getResourceRefMapElement((String)moduleName, (String)componentName, (String)refName, (boolean)true).jndiName = jndiName;
        this.getResourceRefMapElement((String)moduleName, (String)componentName, (String)refName, (boolean)true).loginCfg = loginCfg;
        this.getResourceRefMapElement((String)moduleName, (String)componentName, (String)refName, (boolean)true).authProps = authProps;
    }

    public void setResourceEnvRefBinding(String moduleName, String componentName, String refName, String jndiName) {
        this.getResourceEnvRefMapElement((String)moduleName, (String)componentName, (String)refName, (boolean)true).jndiName = jndiName;
    }

    public void setMessageDestinationRefBinding(String moduleName, String componentName, String refName, String jndiName) {
        this.getMessageDestinationRefMapElement((String)moduleName, (String)componentName, (String)refName, (boolean)true).jndiName = jndiName;
    }

    EjbBindingMapElement getEjbMapElement(String moduleName, String ejbName, boolean createIfNull) {
        EjbBindingMapElement element = (EjbBindingMapElement)this._ejbBindingMap.get(ejbName);
        if (element == null && createIfNull) {
            element = new EjbBindingMapElement(null, null, null, null, null);
            this._ejbBindingMap.put(ejbName, element);
        }
        return element;
    }

    EjbRefMapElement getEjbRefMapElement(String moduleName, String refName, boolean createIfNull) {
        EjbRefMapElement element = (EjbRefMapElement)this._ejbRefMap.get(refName);
        if (element == null && createIfNull) {
            element = new EjbRefMapElement(null);
            this._ejbRefMap.put(refName, element);
        }
        return element;
    }

    ResourceRefMapElement getResourceRefMapElement(String moduleName, String componentName, String refName, boolean createIfNull) {
        String key = moduleName + "-" + componentName + "-" + refName;
        ResourceRefMapElement element = (ResourceRefMapElement)this._resourceRefMap.get(key);
        if (element == null && createIfNull) {
            element = new ResourceRefMapElement(null, null, null);
            this._resourceRefMap.put(key, element);
        }
        return element;
    }

    ResourceRefMapElement getResourceEnvRefMapElement(String moduleName, String componentName, String refName, boolean createIfNull) {
        String key = moduleName + "-" + componentName + "-" + refName;
        ResourceRefMapElement element = (ResourceRefMapElement)this._resourceEnvRefMap.get(key);
        if (element == null && createIfNull) {
            element = new ResourceRefMapElement(null, null, null);
            this._resourceEnvRefMap.put(key, element);
        }
        return element;
    }

    ResourceRefMapElement getMessageDestinationRefMapElement(String moduleName, String componentName, String refName, boolean createIfNull) {
        String key = moduleName + "-" + componentName + "-" + refName;
        ResourceRefMapElement element = (ResourceRefMapElement)this._messageDestinationRefMap.get(key);
        if (element == null && createIfNull) {
            element = new ResourceRefMapElement(null, null, null);
            this._messageDestinationRefMap.put(key, element);
        }
        return element;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/CustomizeableStrategy.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.11");
        }
        CLASS_NAME = CustomizeableStrategy.class.getName();
    }

    private class EjbBindingMapElement {
        public String jndiName = null;
        public DataSourceMapElement dataSourceInfo = null;
        public ConnectionFactoryBinding connFactInfo = null;
        public String listenerPort = null;
        public String activationSpecJNDIName = null;

        public EjbBindingMapElement(String jndi, DataSourceMapElement dsi, ConnectionFactoryBinding cfb, String listenerPort, String actSpec) {
            this.jndiName = jndi;
            this.dataSourceInfo = dsi;
            this.connFactInfo = cfb;
            this.listenerPort = listenerPort;
            this.activationSpecJNDIName = actSpec;
        }

        public String toString() {
            return "{" + this.jndiName + "," + (this.dataSourceInfo != null ? this.dataSourceInfo.toString() : "{null}") + "," + this.connFactInfo + "," + this.listenerPort + ", " + this.activationSpecJNDIName + "}";
        }
    }

    private class EjbRefMapElement {
        public String jndiName = null;

        public EjbRefMapElement(String j) {
            this.jndiName = j;
        }

        public String toString() {
            return "{" + this.jndiName + "}";
        }
    }

    private class DataSourceMapElement {
        public String jndiName = null;
        public String user = null;
        public String password = null;
        public String loginCfg = null;
        public String authProps = null;

        public DataSourceMapElement(String j, String u, String p, String lc, String ap) {
            this.jndiName = j;
            this.user = u;
            this.password = p;
            this.loginCfg = lc;
            this.authProps = ap;
        }

        public String toString() {
            return "{" + this.jndiName + "," + this.user + "," + this.password + "," + this.loginCfg + "," + this.authProps + "}";
        }
    }
}

