/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.ws.management.application.dfltbndngs.BindEarCmd;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.dfltbndngs.utils.CommandLineUtils;
import com.ibm.ws.management.application.dfltbndngs.utils.ShowBindingsCmd;
import com.ibm.ws.management.application.dfltbndngs.utils.WrapModuleInEARCmd;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;

public class BindEar {
    private static TraceComponent tc = Tr.register(BindEar.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private EARFile inputEar = null;
    private Archive originalArchive = null;
    private String originalEarName = null;
    private boolean debugMode = false;
    private ResourceBundle nlsBundle;
    private boolean ready = false;
    private String earFileName = null;
    private String outputEarFileName = null;
    private Preferences preferences = new Preferences();
    private boolean verbose = true;

    public static void main(String[] args) {
        BindEar binder = new BindEar();
        binder.processArgs(args);
        try {
            binder.bind();
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "main", "126");
        }
    }

    public BindEar() {
        try {
            this.nlsBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.BindEarNLS");
            this.copyright();
            this.initializeMOF();
            this.ready = true;
        }
        catch (MissingResourceException ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "<init>", "144", this);
            System.err.println("Unable to Find NLS Resources: " + ex.getMessage());
            this.ready = false;
        }
    }

    void initializeMOF() {
    }

    void copyright() {
        System.out.println(this.nlsBundle.getString("product.header"));
        System.out.println(this.nlsBundle.getString("tool.header"));
        System.out.println(this.nlsBundle.getString("ibm.copyright"));
        System.out.println("");
    }

    void usage() {
        System.err.println("");
        System.err.println(this.nlsBundle.getString("usage.main"));
        System.err.println(this.nlsBundle.getString("usage.dbUser"));
        System.err.println(this.nlsBundle.getString("usage.dbPassword"));
        System.err.println(this.nlsBundle.getString("usage.defaultConnFact"));
        System.err.println(this.nlsBundle.getString("usage.defaultDataSource"));
        System.err.println(this.nlsBundle.getString("usage.ejbJndiPrefix"));
        System.err.println(this.nlsBundle.getString("usage.forceBindings"));
        System.err.println(this.nlsBundle.getString("usage.resAuth"));
        for (int i = 0; i < Preferences.RES_AUTH.length; ++i) {
            System.err.println("\t  " + Preferences.RES_AUTH[i]);
        }
        System.err.println(this.nlsBundle.getString("usage.strategy"));
        System.err.println(this.nlsBundle.getString("usage.validate"));
        System.err.println(this.nlsBundle.getString("usage.virtualHost"));
    }

    void processArgs(String[] args) {
        String virtualHost;
        if (System.getProperty("DEBUG_MODE") != null && System.getProperty("DEBUG_MODE").equalsIgnoreCase(this.nlsBundle.getString("answer.true"))) {
            this.debugMode = true;
        }
        Vector<String> validKeys = new Vector<String>(1);
        String[] keys = new String[]{"dbpassword", "dbuser", "defaultdatasource", "defaultconnectionfactory", "defaultresauth", "ear", "ejbJndiPrefix", "forcebindings", "output", "resauth", "strategy", "validate", "virtualhost"};
        for (int i = 0; i < keys.length; ++i) {
            validKeys.addElement(keys[i]);
        }
        Hashtable cmdLineArgs = CommandLineUtils.parseCommandLineArgs(args, true);
        if (cmdLineArgs == null) {
            System.err.println(this.nlsBundle.getString("invalid.num.arguments"));
            this.usage();
            this.ready = false;
            return;
        }
        for (String key : cmdLineArgs.keySet()) {
            String value = (String)cmdLineArgs.get(key);
            if (!value.equals("NO SUB-ARG")) continue;
            System.err.println(MessageFormat.format(this.nlsBundle.getString("no.sub.arg.error"), key));
            System.err.println("");
            this.usage();
            this.ready = false;
            return;
        }
        try {
            CommandLineUtils.checkArguments(validKeys, cmdLineArgs, false);
        }
        catch (IllegalArgumentException ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "processArgs", "264", this);
            if (this.debugMode) {
                ex.printStackTrace();
            }
            System.err.println(MessageFormat.format(this.nlsBundle.getString("illegal.argument"), ex.getMessage()));
            this.usage();
            this.ready = false;
            return;
        }
        if (!cmdLineArgs.containsKey("ear") || !cmdLineArgs.containsKey("output")) {
            System.err.println(this.nlsBundle.getString("required.command.missing"));
            this.usage();
            this.ready = false;
            return;
        }
        this.setEarFileName((String)cmdLineArgs.get("ear"));
        this.setOutputFile((String)cmdLineArgs.get("output"));
        this.getPreferences().setDefaultDataSourceJndiName((String)cmdLineArgs.get("defaultdatasource"));
        this.getPreferences().setDefaultDataSourceUser((String)cmdLineArgs.get("dbuser"));
        this.getPreferences().setDefaultDataSourcePassword((String)cmdLineArgs.get("dbpassword"));
        this.getPreferences().setStrategyFile((String)cmdLineArgs.get("strategy"));
        this.getPreferences().setDefaultConnectionFactoryJndiName((String)cmdLineArgs.get("defaultconnectionfactory"));
        this.getPreferences().setDefaultConnectionFactoryResAuth((String)cmdLineArgs.get("resauth"));
        String ejbPrefix = (String)cmdLineArgs.get("ejbjndiprefix");
        if (ejbPrefix != null) {
            this.getPreferences().setEjbJndiPrefix(ejbPrefix);
        }
        if ((virtualHost = (String)cmdLineArgs.get("virtualhost")) != null) {
            this.getPreferences().setVirtualHost(virtualHost);
        }
        File f = null;
        if (this.getEarFileName() != null) {
            f = new File(this.getEarFileName());
            try {
                this.setEarFileName(f.getCanonicalPath());
            }
            catch (IOException ioex) {
                RasUtils.logException((Throwable)ioex, tc, CLASS_NAME, "processArgs", "321", this);
                this.setEarFileName(f.getAbsolutePath());
            }
        }
        if (this.getOutputFile() != null) {
            f = new File(this.getOutputFile());
            try {
                this.setOutputFile(f.getCanonicalPath());
            }
            catch (IOException ioex) {
                RasUtils.logException((Throwable)ioex, tc, CLASS_NAME, "processArgs", "332", this);
                this.setOutputFile(f.getAbsolutePath());
            }
        }
        this.getPreferences().setForceBindings(this.processBoolean(cmdLineArgs, "forcebindings", false, "invalid.forcebindings"));
    }

    boolean processBoolean(Hashtable cmdLineArgs, String key, boolean defaultValue, String msgKey) {
        boolean result = defaultValue;
        try {
            result = this.calcBoolean((String)cmdLineArgs.get(key));
        }
        catch (IllegalArgumentException ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "processBoolean", "350", this);
            System.err.println(MessageFormat.format(this.nlsBundle.getString(msgKey), ex.getMessage()));
        }
        catch (NoSuchFieldException nex) {
            RasUtils.logException((Throwable)nex, tc, CLASS_NAME, "processBoolean", "354", this);
        }
        return result;
    }

    void log(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    boolean calcBoolean(String iStr) throws IllegalArgumentException, NoSuchFieldException {
        if (iStr != null) {
            if (iStr.equalsIgnoreCase(this.nlsBundle.getString("answer.true")) || iStr.equalsIgnoreCase(this.nlsBundle.getString("answer.t")) || iStr.equalsIgnoreCase(this.nlsBundle.getString("answer.yes")) || iStr.equalsIgnoreCase(this.nlsBundle.getString("answer.y"))) {
                return true;
            }
            if (iStr.equalsIgnoreCase(this.nlsBundle.getString("answer.false")) || iStr.equalsIgnoreCase(this.nlsBundle.getString("answer.f")) || iStr.equalsIgnoreCase(this.nlsBundle.getString("answer.no")) || iStr.equalsIgnoreCase(this.nlsBundle.getString("answer.n"))) {
                return false;
            }
            throw new IllegalArgumentException(iStr);
        }
        throw new NoSuchFieldException();
    }

    public void bind() throws Exception {
        if (this.ready) {
            this.loadEarFile();
            this.bindEarFile();
            this.saveEarFile();
        }
    }

    void loadEarFile() throws Exception {
        try {
            this.log(MessageFormat.format(this.nlsBundle.getString("loading"), this.getEarFileName()));
            ArchiveInit.init();
            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
            this.originalArchive = factory.openArchive(this.getEarFileName());
            if (this.originalArchive.isEARFile()) {
                this.inputEar = (EARFile)this.originalArchive;
                this.inputEar.rollUpRoles();
            } else if (this.originalArchive.isWARFile()) {
                this.wrapWarFile((WARFile)this.originalArchive);
            } else if (this.originalArchive.isEJBJarFile()) {
                this.wrapEjbJarFile((EJBJarFile)this.originalArchive);
            }
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "loadEarFile", "413", this);
            this.log(MessageFormat.format(this.nlsBundle.getString("load.exception"), ex.toString()));
            throw ex;
        }
    }

    EJBJarFile getEjbJar(EARFile ear) {
        List ejbJars = ear.getEJBJarFiles();
        return (EJBJarFile)ejbJars.get(0);
    }

    void wrapWarFile(WARFile archive) throws Exception {
        File f = new File(this.getEarFileName());
        String displayName = archive.getName();
        String contextRoot = "/";
        WrapModuleInEARCmd cmd = new WrapModuleInEARCmd(archive, this.getEarFileName(), f.getParent(), null, contextRoot, false, displayName);
        cmd.execute();
        Collection c = cmd.getResult();
        this.inputEar = (EARFile)c.iterator().next();
        this.log(MessageFormat.format(this.nlsBundle.getString("created.war.wrapper"), this.inputEar.getAbsolutePath(), this.getEarFileName()));
        this.setEarFileName(this.inputEar.getName());
    }

    void wrapEjbJarFile(EJBJarFile archive) throws Exception {
        File f = new File(this.getEarFileName());
        String displayName = archive.getName();
        WrapModuleInEARCmd cmd = new WrapModuleInEARCmd((ModuleFile)archive, this.getEarFileName(), f.getParent(), null, false);
        cmd.execute();
        Collection c = cmd.getResult();
        this.inputEar = (EARFile)c.iterator().next();
        this.log(MessageFormat.format(this.nlsBundle.getString("created.ejbjar.wrapper"), this.inputEar.getName(), this.getEarFileName()));
        this.setEarFileName(this.inputEar.getName());
    }

    void saveEarFile() throws Exception {
        try {
            this.log(this.nlsBundle.getString("saved.ear.to.directory"));
            File f1 = new File(this.getEarFileName());
            File f2 = new File(this.outputEarFileName);
            if (f1.equals(f2)) {
                if (this.outputEarFileName.endsWith(".jar") || this.outputEarFileName.endsWith(".war")) {
                    this.getEjbJar(this.inputEar).save();
                } else {
                    this.inputEar.save();
                }
            } else if (this.outputEarFileName.endsWith(".jar") || this.outputEarFileName.endsWith(".war")) {
                this.getEjbJar(this.inputEar).saveAs(this.outputEarFileName);
            } else {
                this.inputEar.saveAs(this.outputEarFileName);
            }
            this.inputEar.close();
            this.log(this.nlsBundle.getString("saved.ear.to.directory.success"));
        }
        catch (SaveFailureException svex) {
            RasUtils.logException((Throwable)svex, tc, CLASS_NAME, "saveEarFile", "492", this);
            System.err.println(MessageFormat.format(this.nlsBundle.getString("saved.ear.to.directory.failed"), svex.getNestedException().getMessage()));
            if (this.debugMode) {
                svex.printStackTrace();
            }
            throw svex;
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "saveEarFile", "499", this);
            System.err.println(MessageFormat.format(this.nlsBundle.getString("saved.ear.to.directory.failed"), ex.getMessage()));
            if (this.debugMode) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    void bindEarFile() throws Exception {
        try {
            BindEarCmd binder = null;
            binder = new BindEarCmd(this.inputEar, this.getPreferences());
            if (!binder.bind()) {
                for (String warning : binder.getWarnings()) {
                    System.out.println("WARNING: " + warning);
                }
            }
            this.showBindings(this.inputEar);
        }
        catch (BindingError err) {
            RasUtils.logException((Throwable)err, tc, CLASS_NAME, "bindEarFile", "525", this);
            System.err.println("FATAL ERROR: couldnt bind:");
            throw err;
        }
    }

    void showBindings(EARFile ear) {
        ShowBindingsCmd viewer = new ShowBindingsCmd(ear, System.out);
        viewer.execute();
    }

    public String getEarFileName() {
        return this.earFileName;
    }

    public void setEarFileName(String earName) {
        this.earFileName = earName;
    }

    public String getOutputFile() {
        return this.outputEarFileName;
    }

    public void setOutputFile(String outputFile) {
        this.outputEarFileName = outputFile;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/BindEar.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.12");
        }
        CLASS_NAME = BindEar.class.getName();
    }
}

