/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client.driver;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskMessages;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class InstallApp
implements AppNotification.Listener,
NotificationListener {
    public static final String INTERACTIVE = "interactive";
    public static final String API = "api";
    public static final String PREPAREONLY = "prepareonly";
    public static final String USEJMX = "usejmx";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String TYPE = "conntype";
    public static final String HOST_DEFAULT = "localhost";
    public static final String PORT_DEFAULT = "8880";
    public static final String TYPE_DEFAULT = "SOAP";
    private static final String CMDLINE_YES = "yes";
    private static final String CMDLINE_NO = "no";
    private static final String BACKENDID_OPTION = "BackendIdSelection";
    private static final String TRACE_PROP = "com.ibm.ejs.ras.traceString";
    private static final String TRACE_FILE_PROP = "com.ibm.ejs.ras.traceFile";
    public static final String MODULESERVER = "moduleserverfile";
    public static final String TIMEOUT = "timeout";
    public static final int TIMEOUT_DEFAULT = 300;
    private static ResourceBundle resBundle;
    private static boolean bOSGIWAIT;
    private static final long MAX_WAIT_TIME = 600000L;
    private final String waitObject = "waitObject";
    private static final TraceComponent tc;
    private static final String CLASS_NAME;
    private static Vector lSide;
    private static Vector rSide;
    private Hashtable argOptions;
    private ObjectName _on;
    AdminClient _soapClient;
    private String appName;
    private AppDeploymentMessages msgs = new AppDeploymentTaskMessages();

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args[0].equals("")) {
            InstallApp.displayHelp();
            System.exit(0);
        }
        InstallApp.setTrace();
        resBundle = AppUtils.getBundle(null);
        String appName = args[0];
        Hashtable cmdLine = InstallApp.parseCmdLine(args);
        InstallApp.dbg("");
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6001I"));
        InstallApp app = new InstallApp(appName, cmdLine);
        app.prepareApp();
    }

    public static void osgimain(String[] args) throws Exception {
        bOSGIWAIT = true;
        InstallApp.main(args);
    }

    private static void setTrace() {
        String spec = System.getProperty(TRACE_PROP);
        if (spec == null || spec.trim().equals("")) {
            return;
        }
        String traceOutput = "stdout";
        String tracefile = System.getProperty(TRACE_FILE_PROP);
        if (tracefile != null) {
            traceOutput = "named file";
        }
        ManagerAdmin.configureClientTrace(spec, traceOutput, tracefile, true, null, false);
    }

    private static void dbg(Object o) {
        System.out.println(o);
    }

    private static void errorAndExit(String errorMsg) {
        System.out.println(errorMsg);
        System.exit(-1);
    }

    private static void createOptionsText(boolean lonly) {
        lSide = new Vector();
        if (!lonly) {
            rSide = new Vector();
        }
        lSide.addElement("original.ear.location");
        if (!lonly) {
            rSide.addElement("earfilepath (must be specified)");
        }
        lSide.addElement("installed.ear.destination");
        if (!lonly) {
            rSide.addElement("destination_folder (must be specified and must be an absolute path.");
        }
        lSide.addElement("was.install.root");
        if (!lonly) {
            rSide.addElement(" -- deprecated");
        }
        lSide.addElement("config.root");
        if (!lonly) {
            rSide.addElement(" -- deprecated");
        }
        lSide.addElement("cell.name");
        if (!lonly) {
            rSide.addElement("cell (default is hostname)");
        }
        lSide.addElement("node.name");
        if (!lonly) {
            rSide.addElement("node (default is hostname)");
        }
        lSide.addElement("server.name");
        if (!lonly) {
            rSide.addElement("server (default is server1)");
        }
        lSide.addElement("cluster.name");
        if (!lonly) {
            rSide.addElement("cluster");
        }
        lSide.addElement(MODULESERVER);
        if (!lonly) {
            rSide.addElement("a properties file specifying module to server relations in format <moduleURI+ddURI=WebSphere:cell=cellName,server=serverName>");
        }
        lSide.addElement(HOST);
        if (!lonly) {
            rSide.addElement("host name used for -usejmx option, default is localhost");
        }
        lSide.addElement(PORT);
        if (!lonly) {
            rSide.addElement("port num used for -usejmx option, default is 8880");
        }
        lSide.addElement(TYPE);
        if (!lonly) {
            rSide.addElement("connection type used for -usejmx option, default is SOAP");
        }
        lSide.addElement(TIMEOUT);
        if (!lonly) {
            rSide.addElement("timeout (sec) to wait for JMX events, default is 300, -1 for no timeout");
        }
        lSide.addElement("copy.sessionmgr.servername");
        if (!lonly) {
            rSide.addElement("specifies the server name from  which the install logic copies session manager settings into  the app's deployment.xml");
        }
        lSide.addElement("-----");
        if (!lonly) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("-----");
        if (!lonly) {
            rSide.addElement("----- -----");
        }
        lSide.addElement(INTERACTIVE);
        if (!lonly) {
            rSide.addElement("(allows user to enter binding information)");
        }
        lSide.addElement(API);
        if (!lonly) {
            rSide.addElement("(calls AppManagement MBean api directly)");
        }
        lSide.addElement(PREPAREONLY);
        if (!lonly) {
            rSide.addElement("(only collects binding information, does not perform install, ignored in noninteractive mode)");
        }
        lSide.addElement(USEJMX);
        if (!lonly) {
            rSide.addElement("(performs installation by calling AppManagementMBean)");
        }
        lSide.addElement("systemApp");
        if (!lonly) {
            rSide.addElement("(specifies the application to be installed is a system application");
        }
        lSide.addElement("preCompileJSPs");
        if (!lonly) {
            rSide.addElement("yes/no (specifies if preCompile-JSP should be run during update)");
        }
        lSide.addElement("depl.extension.reg");
        if (!lonly) {
            rSide.addElement("(specifies location of properties file for deployment extensions)");
        }
        lSide.addElement("useMetaDataFromBinary");
        if (!lonly) {
            rSide.addElement(" yes/no (specifies useMetadataFromBinaries from deployment.xml");
        }
        lSide.addElement("distributeApp");
        if (!lonly) {
            rSide.addElement(" yes/no (specifies isDistributionEnabled from deployment.xml");
        }
        lSide.addElement("zeroBinaryCopy");
        if (!lonly) {
            rSide.addElement(" yes/no (specifies zero bin copy. Implicitly means useMetdataFromBin=true and enableDistrib=false");
        }
        lSide.addElement("zeroEarCopy");
        if (!lonly) {
            rSide.addElement(" yes/no (specifies zero ear copy. Implicitly means enableDistrib=false");
        }
        lSide.addElement("-----");
        if (!lonly) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("-----");
        if (!lonly) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("redeploy");
        if (!lonly) {
            rSide.addElement(" specifies the reinstall / upgrade operation");
        }
        lSide.addElement("redeploy.ignore.old");
        if (!lonly) {
            rSide.addElement(" specifies that bindings from the older version are ignored during reinstall operation");
        }
        lSide.addElement("redeploy.ignore.new");
        if (!lonly) {
            rSide.addElement(" specifies that bindings from the newer version are ignored during reinstall operation if the older ones exist");
        }
        lSide.addElement("-----");
        if (!lonly) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("-----");
        if (!lonly) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("usedefaultbindings");
        if (!lonly) {
            rSide.addElement(" yes/no (runs default binding generator)");
        }
        lSide.addElement("defaultbinding.datasource.jndi");
        if (!lonly) {
            rSide.addElement("jndi_name (specifies JNDI name for default datasource)");
        }
        lSide.addElement("defaultbinding.datasource.username");
        if (!lonly) {
            rSide.addElement("user_name (specifies user name for default datasource)");
        }
        lSide.addElement("defaultbinding.datasource.password");
        if (!lonly) {
            rSide.addElement("password (specifies password for default datasource)");
        }
        lSide.addElement("defaultbinding.cf.jndi");
        if (!lonly) {
            rSide.addElement("jndi_name (specifies JNDI name for default connection factory)");
        }
        lSide.addElement("defaultbinding.cf.resauth");
        if (!lonly) {
            rSide.addElement("resauth (resauth for connection factory -PerConnFact or Container)");
        }
        lSide.addElement("defaultbinding.ejbjndi.prefix");
        if (!lonly) {
            rSide.addElement("prefix (specifies prefix for JNDI name of EJBs)");
        }
        lSide.addElement("defaultbinding.virtual.host");
        if (!lonly) {
            rSide.addElement("vhost_name (default name for virtual host)");
        }
        lSide.addElement("defaultbinding.force");
        if (!lonly) {
            rSide.addElement("(specifies whether to override current bindings)");
        }
        lSide.addElement("defaultbinding.strategy.file");
        if (!lonly) {
            rSide.addElement("filename (specifies custom strategy file)");
        }
        lSide.addElement("-----");
        if (!lonly) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("-----");
        if (!lonly) {
            rSide.addElement("----- -----");
        }
        lSide.addElement("deployejb");
        if (!lonly) {
            rSide.addElement("yes/no (specifies if EJBDeploy should be run during install)");
        }
        lSide.addElement("deployejb.dbtype");
        if (!lonly) {
            rSide.addElement("(database type " + InstallApp.getDBTypes() + " default:" + AppConstants.APPDEPL_DEPLOYEJB_DBTYPE_OPTION_DEFAULT + ")");
        }
        lSide.addElement("deployejb.dbschema");
        if (!lonly) {
            rSide.addElement("(database schema, default:)");
        }
        lSide.addElement("deployejb.classpath");
        if (!lonly) {
            rSide.addElement("(extra classpath used in EJBDeploy)");
        }
        lSide.addElement("deployejb.rmic");
        if (!lonly) {
            rSide.addElement("(extra RMIC options to be used during EJBDeploy)");
        }
        lSide.addElement("deployejb.dbaccesstype");
        if (!lonly) {
            rSide.addElement("(database access type [JDBC, SQLj] default:JDBC)");
        }
        lSide.addElement("deployejb.sqljclasspath");
        if (!lonly) {
            rSide.addElement("(SQLJ database classpath)");
        }
        lSide.addElement("deployejb.complianceLevel");
        if (!lonly) {
            rSide.addElement("(jdk compliance level, default:)");
        }
        lSide.addElement("blaname");
        if (!lonly) {
            rSide.addElement("(BLA Name)");
        }
        lSide.addElement(BACKENDID_OPTION);
        if (!lonly) {
            rSide.addElement("(specified backendId options for EJBModule)");
        }
        lSide.addElement("classLoaderPolicy");
        if (!lonly) {
            rSide.addElement("(specified use common classloader single/multiple, default is multiple)");
        }
        lSide.addElement("validateinstall");
        if (!lonly) {
            rSide.addElement("(specifed validateinstall off, warn, fail, default is off)");
        }
        lSide.addElement("filepermission");
        if (!lonly) {
            rSide.addElement("(specified filepermission, default is .*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755");
        }
    }

    private static String getDBTypes() {
        String ret = "[";
        String[] s = DeployOptions.getDatabaseTypes();
        for (int i = 0; i < s.length; ++i) {
            if (i != 0) {
                ret = ret + ", ";
            }
            ret = ret + s[i];
        }
        ret = ret + "]";
        return ret;
    }

    private static void displayHelp() {
        InstallApp.dbg("Usage syntax is: InstallApp applicationName [[-option.name optionValue]...]");
        InstallApp.dbg("");
        InstallApp.dbg("Valid options are:");
        InstallApp.dbg("==================");
        InstallApp.createOptionsText(false);
        for (int i = 0; i < lSide.size(); ++i) {
            InstallApp.dbg("\t-" + lSide.elementAt(i) + " " + rSide.elementAt(i));
        }
        InstallApp.dbg("");
        InstallApp.dbg("==================");
        InstallApp.dbg("");
        InstallApp.dbg("For example: ");
        InstallApp.dbg("InstallApp sampleApp -installed.ear.destination C:\\WebSphere\\AppServer\\installedApps -original.ear.location C:\\WebSphere\\AppServer\\installableApps\\sampleApp.ear -server.name server1 -interactive");
    }

    private static String fixPath(String s) {
        if (s == null) {
            return null;
        }
        String retVal = s;
        if (File.separatorChar == '/') {
            retVal = retVal.replace('\\', File.separatorChar);
        }
        if (File.separatorChar == '\\') {
            retVal = retVal.replace('/', File.separatorChar);
        }
        return retVal;
    }

    private static Hashtable parseCmdLine(String[] args) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseCmdLine");
        }
        Hashtable<String, Object> cmdLine = new Hashtable<String, Object>();
        InstallApp.createOptionsText(true);
        for (int i = 1; i < args.length; ++i) {
            String key;
            if (!args[i].startsWith("-")) {
                InstallApp.errorAndExit("Usage error: expected option name beginning with \"-\"; found " + args[i]);
            }
            if (!lSide.contains(key = args[i].substring(1, args[i].length()))) {
                InstallApp.errorAndExit("Invalid option: " + key);
            }
            if (key.equals(INTERACTIVE) || key.equals(PREPAREONLY) || key.equals(USEJMX) || key.equals(API) || key.equals("redeploy") || key.equals("redeploy.ignore.old") || key.equals("redeploy.ignore.new") || key.equals("systemApp")) {
                cmdLine.put(key, new Boolean(true));
                continue;
            }
            if (key.equals("defaultbinding.force")) {
                cmdLine.put(key, "AppDeploymentOption.Yes");
                continue;
            }
            String val = CMDLINE_YES;
            if (args.length > i + 1) {
                val = args[i + 1];
            }
            if (key.equals("original.ear.location") || key.equals("installed.ear.destination")) {
                val = InstallApp.fixPath(val);
            }
            cmdLine.put(key, val);
            ++i;
        }
        if (cmdLine.get("original.ear.location") == null) {
            InstallApp.errorAndExit("Usage error: Original ear not specified.");
        }
        if (cmdLine.get(API) != null && cmdLine.get(MODULESERVER) == null) {
            InstallApp.errorAndExit("Usage error: The -api option can only be used with -moduleserverfile option");
        }
        if (cmdLine.get(USEJMX) != null) {
            if (cmdLine.get(HOST) == null) {
                cmdLine.put(HOST, HOST_DEFAULT);
            }
            if (cmdLine.get(PORT) == null) {
                cmdLine.put(PORT, PORT_DEFAULT);
            }
            if (cmdLine.get(TYPE) == null) {
                cmdLine.put(TYPE, TYPE_DEFAULT);
            }
        } else {
            String dest = (String)cmdLine.get("installed.ear.destination");
            if (dest != null && dest.indexOf(File.separatorChar) == -1 && dest.indexOf("$(") == -1 && dest.indexOf("${") == -1) {
                InstallApp.errorAndExit("Usage error: installed.ear.destination is a relative path since it does not contain " + File.separatorChar + " or a pathmap variable " + " like $(APP_INSTALL_ROOT)");
            }
        }
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        if (cmdLine.get("cell.name") == null) {
            if (host == null) {
                cmdLine.put("cell.name", "BaseApplicationServerCell");
            } else {
                cmdLine.put("cell.name", host);
            }
        }
        if (cmdLine.get("node.name") == null) {
            if (host == null) {
                cmdLine.put("node.name", "DefaultNode");
            } else {
                cmdLine.put("node.name", host);
            }
        }
        if (cmdLine.get("server.name") == null) {
            cmdLine.put("server.name", "server1");
        }
        InstallApp.dbg("");
        InstallApp.dbg("======================");
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6002I"));
        Enumeration keys = cmdLine.keys();
        while (keys.hasMoreElements()) {
            Object k = keys.nextElement();
            InstallApp.dbg(k + " = " + cmdLine.get(k));
        }
        InstallApp.dbg("======================");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseCmdLine");
        }
        return cmdLine;
    }

    public InstallApp(String aName, Hashtable cmdLine) {
        this.appName = aName;
        this.argOptions = cmdLine;
    }

    public void prepareApp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareApp");
        }
        AppDeploymentController flowController = null;
        try {
            String earPath = (String)this.argOptions.get("original.ear.location");
            Hashtable appO = null;
            if (this.argOptions.get(API) == null) {
                Hashtable prefs = new Hashtable();
                if (this.argOptions.containsKey("systemApp")) {
                    InstallApp.dbg("-systemApp option detected....");
                    prefs.put("systemApp", new Boolean(true));
                } else {
                    prefs = this.createPrefsForController();
                }
                InstallApp.dbg(prefs);
                InstallApp.dbg("");
                InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6003I"));
                if (this.argOptions.get(USEJMX) != null) {
                    prefs.put("adminclient", this.getAdminClient());
                }
                if (this.argOptions.get("redeploy") != null && this.argOptions.get("redeploy.ignore.old") == null) {
                    if (this.argOptions.get("redeploy.ignore.new") != null) {
                        prefs.put("redeploy.ignore.new", this.argOptions.get("redeploy.ignore.new"));
                    }
                    flowController = AppManagementFactory.readArchiveForRedeployment(earPath, prefs, this.getOldAppTasks());
                } else {
                    flowController = AppManagementFactory.readArchive(earPath, prefs);
                }
                if (flowController != null) {
                    appO = flowController.getAppOptions();
                    this.patchAppDeploymentController(appO);
                    this.compareSecurityPolicy(flowController);
                    this.getTasks(flowController);
                    appO = this.saveAndClose(flowController);
                }
            }
            if (appO == null) {
                appO = new Hashtable();
                this.patchAppDeploymentController(appO);
            }
            try {
                Runtime.getRuntime().exec("chmod ugo+r " + earPath);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.performInstall(earPath, appO);
        }
        catch (Exception ex) {
            block18: {
                if (flowController != null) {
                    try {
                        flowController.close(false, false, true);
                    }
                    catch (Throwable th) {
                        if (!tc.isDebugEnabled()) break block18;
                        Tr.debug(tc, "Tried closing controller after exception. Error closing controller: " + th);
                    }
                }
            }
            AppUtils.printEx(ex);
            InstallApp.errorAndExit(ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareApp");
        }
    }

    private Hashtable createPrefsForController() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPrefsForController");
        }
        Hashtable prefs = new Hashtable();
        Object ext = this.argOptions.get("depl.extension.reg");
        if (ext != null) {
            InstallApp.dbg("Setting extensions to : " + ext);
            prefs.put("depl.extension.reg", ext);
        }
        try {
            String answer = (String)this.argOptions.get("usedefaultbindings");
            answer = answer == null ? "AppDeploymentOption.No" : (answer.equalsIgnoreCase(this.msgs.getMessage("AppDeploymentOption.No")) ? "AppDeploymentOption.No" : "AppDeploymentOption.Yes");
            if (this.argOptions.get(INTERACTIVE) != null) {
                String eM = this.msgs.getMessage("defaultbinding.enable");
                String newAnswer = this.promptInput(this.msgs, "", true, "AppDeploymentOption.Yes", eM = eM + "[" + this.msgs.getMessage(answer) + "]:", "");
                if (newAnswer != null) {
                    answer = newAnswer;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Answer about gen bindings: " + answer);
            }
            if (answer.equalsIgnoreCase("AppDeploymentOption.Yes")) {
                this.argOptions.put("app.client.locale", Locale.getDefault());
                DefaultBindingHelper helper = new DefaultBindingHelper(this.argOptions);
                DefaultBinding task = (DefaultBinding)helper.createTask(null);
                String earPath = (String)this.argOptions.get("original.ear.location");
                helper.prepareTask(earPath, (AppDeploymentTask)task);
                if (this.argOptions.get(INTERACTIVE) != null) {
                    this.displayAndSetTaskData(task, this.msgs);
                }
                helper.completeTask(null, task);
                Preferences dbPrefs = DefaultBindingHelper.getPreferences(task);
                InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6004I") + dbPrefs);
                prefs.put("usedefaultbindings", dbPrefs);
            }
        }
        catch (AppDeploymentException ex) {
            InstallApp.dbg("Exception " + ex + " in collecting preferences");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPrefsForController " + prefs);
        }
        return prefs;
    }

    private void patchAppDeploymentController(Hashtable appO) {
        String modProp;
        String depl;
        String blaName;
        String fileperm;
        String validate;
        String loader;
        String use;
        Object o;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "patchAppDeploymentController");
        }
        if (this.appName != null && this.appName.trim().length() > 0) {
            appO.put("appname", this.appName);
        }
        appO.put("cell.name", this.argOptions.get("cell.name"));
        appO.put("node.name", this.argOptions.get("node.name"));
        appO.put("server.name", this.argOptions.get("server.name"));
        if (this.argOptions.containsKey("cluster.name")) {
            appO.put("cluster.name", this.argOptions.get("cluster.name"));
        }
        if (this.argOptions.containsKey("systemApp")) {
            appO.put("systemApp", new Boolean(true));
        }
        if (this.argOptions.containsKey("copy.sessionmgr.servername")) {
            appO.put("copy.sessionmgr.servername", this.argOptions.get("copy.sessionmgr.servername"));
        }
        if ((o = this.argOptions.get("installed.ear.destination")) != null) {
            appO.put("installed.ear.destination", o);
        }
        if ((use = (String)this.argOptions.get("useMetaDataFromBinary")) != null && use.equalsIgnoreCase(CMDLINE_YES)) {
            appO.put("useMetaDataFromBinary", Boolean.TRUE);
        }
        if ((use = (String)this.argOptions.get("distributeApp")) != null && use.equalsIgnoreCase(CMDLINE_NO)) {
            appO.put("distributeApp", Boolean.FALSE);
        }
        if ((use = (String)this.argOptions.get("zeroEarCopy")) != null && use.equalsIgnoreCase(CMDLINE_YES)) {
            appO.put("zeroEarCopy", Boolean.TRUE);
        }
        if ((use = (String)this.argOptions.get("zeroBinaryCopy")) != null && use.equalsIgnoreCase(CMDLINE_YES)) {
            appO.put("zeroBinaryCopy", Boolean.TRUE);
        }
        if ((use = (String)this.argOptions.get("preCompileJSPs")) != null && use.equalsIgnoreCase(CMDLINE_YES)) {
            appO.put("preCompileJSPs", Boolean.TRUE);
        }
        if ((loader = (String)this.argOptions.get("classLoaderPolicy")) != null && loader.equalsIgnoreCase("single")) {
            appO.put("classLoaderPolicy", AppConstants.APPDEPL_CLASSLOADERPOLICY_SINGLE);
        }
        if ((validate = (String)this.argOptions.get("validateinstall")) != null && (validate.equalsIgnoreCase("off") || validate.equalsIgnoreCase("warn") || validate.equalsIgnoreCase("fail"))) {
            appO.put("validateinstall", validate);
        }
        if ((fileperm = (String)this.argOptions.get("filepermission")) != null) {
            appO.put("filepermission", fileperm);
        }
        if ((blaName = (String)this.argOptions.get("blaname")) != null) {
            appO.put("blaname", blaName);
        }
        if ((depl = (String)this.argOptions.get("deployejb")) != null && depl.equalsIgnoreCase(CMDLINE_YES)) {
            appO.put("deployejb", Boolean.TRUE);
        } else if (depl != null && depl.equalsIgnoreCase(CMDLINE_NO)) {
            appO.put("deployejb", Boolean.FALSE);
        }
        Hashtable tbl = (Hashtable)appO.get("deployejb.options");
        String key = null;
        key = "deployejb.dbtype";
        if (this.argOptions.get(key) != null) {
            tbl.put(key, this.argOptions.get(key));
        }
        if (this.argOptions.get(key = "deployejb.dbschema") != null) {
            tbl.put(key, this.argOptions.get(key));
        }
        if (this.argOptions.get(key = "deployejb.rmic") != null) {
            tbl.put(key, this.argOptions.get(key));
        }
        if (this.argOptions.get(key = "deployejb.classpath") != null) {
            tbl.put(key, this.argOptions.get(key));
        }
        if (this.argOptions.get(key = "deployejb.dbaccesstype") != null) {
            tbl.put(key, this.argOptions.get(key));
        }
        if (this.argOptions.get(key = "deployejb.sqljclasspath") != null) {
            tbl.put(key, this.argOptions.get(key));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Ejb deploy options created: " + tbl);
        }
        if ((modProp = (String)this.argOptions.get(MODULESERVER)) != null) {
            File modFile = new File(modProp);
            if (!modFile.exists()) {
                InstallApp.dbg("Warning: Properties " + modProp + " file for " + MODULESERVER + " does not exist.");
            } else {
                try {
                    FileInputStream in = new FileInputStream(modFile);
                    Properties props = new Properties();
                    props.load(in);
                    in.close();
                    InstallApp.dbg("Read mod-server relations from " + modProp);
                    Hashtable<Object, String> modSvr = (Hashtable<Object, String>)appO.get("moduleToServer");
                    if (modSvr == null) {
                        modSvr = new Hashtable<Object, String>();
                    }
                    Enumeration<Object> ee = props.keys();
                    while (ee.hasMoreElements()) {
                        Object unique = ee.nextElement();
                        modSvr.put(unique, (String)props.get(unique));
                    }
                    appO.put("moduleToServer", modSvr);
                }
                catch (Throwable th) {
                    InstallApp.dbg("Warning: Exception in reading " + modProp + " ex: " + th);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "patchAppDeploymentController");
        }
    }

    private void compareSecurityPolicy(AppDeploymentController flow) throws Exception {
        Vector retVal = null;
        String wasPolicy = flow.getSecurityPolicyData();
        String warning = flow.getSecurityPolicyWarning();
        if (warning != null) {
            InstallApp.dbg(warning);
        }
        if (wasPolicy == null || wasPolicy.trim().length() == 0) {
            return;
        }
        InstallApp.dbg("");
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6005I"));
        if (this.argOptions.get(USEJMX) == null) {
            AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
            retVal = m.compareSecurityPolicy(wasPolicy, new Hashtable(), null);
        } else {
            AdminClient soapClient = this.getAdminClient();
            ObjectName on = this.getObjectName(soapClient);
            if (on == null) {
                InstallApp.errorAndExit("Could not find AppManagement MBean.");
            }
            retVal = (Vector)soapClient.invoke(on, "compareSecurityPolicy", new Object[]{wasPolicy, new Hashtable(), null}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "retVal: " + retVal);
        }
        if (retVal == null) {
            return;
        }
        for (int i = 0; i < retVal.size(); ++i) {
            InstallApp.dbg(retVal.elementAt(i));
        }
    }

    private void getTasks(AppDeploymentController flowController) throws AppDeploymentException {
        AppDeploymentTask installTask = flowController.getFirstTask();
        int num = 1;
        while (installTask != null) {
            if (this.argOptions.get(INTERACTIVE) != null) {
                InstallApp.dbg("");
                AppDeploymentMessages appM = flowController.getTaskInfo((String)installTask.getName()).appMessages;
                String s = appM.getGoalTitle(installTask.getName());
                InstallApp.dbg("Task[" + num++ + "]: " + s);
                InstallApp.dbg(appM.getGoalMessage(installTask.getName()));
                InstallApp.dbg("");
                if (installTask.isTaskEmpty()) {
                    InstallApp.dbg(appM.getEmptyTaskMessage(installTask.getName()));
                } else if (installTask.isTaskDisabled()) {
                    InstallApp.dbg("...." + appM.getDisableTaskMessage(installTask.getName()));
                } else {
                    if (installTask.getName().equals("EnsureMethodProtectionFor20EJB")) {
                        InstallApp.dbg("**** Possible value entered is uncheck, exclude, or security role names separated by comma");
                        InstallApp.dbg("");
                    } else if (installTask.getName().equals("DataSourceFor20CMPBeans") || installTask.getName().equals("DataSourceFor20EJBModules")) {
                        InstallApp.dbg("**** Possible value for resource authorization is container or per connection factory");
                        InstallApp.dbg("");
                    } else if (installTask.getName().equals("EnsureMethodProtectionFor10EJB")) {
                        InstallApp.dbg("**** Possible value is yes, no, or null");
                        InstallApp.dbg("");
                    }
                    this.displayAndSetTaskData(installTask, appM);
                }
                InstallApp.dbg("=========== End (" + s + ")============");
            } else if (installTask.getName().equals(BACKENDID_OPTION) && !installTask.isTaskEmpty()) {
                String value = (String)this.argOptions.get(BACKENDID_OPTION);
                String[][] taskData = installTask.getTaskData();
                for (int i = 1; i < taskData.length; ++i) {
                    taskData[i][taskData[i].length - 1] = value;
                }
                installTask.setTaskData(taskData);
            }
            installTask = flowController.getNextTask();
        }
    }

    private void displayAndSetTaskData(AppDeploymentTask installTask, AppDeploymentMessages appM) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "displayAndSetTaskData  " + installTask.getName());
        }
        String[][] taskData = installTask.getTaskData();
        for (int i = 1; i < taskData.length; ++i) {
            try {
                for (int j = 0; j < taskData[i].length; ++j) {
                    String data = appM.getColumnName(taskData[0][j], installTask.getName()) + ":  ";
                    if (installTask.getMutableColumns(j)) {
                        data = data + "[";
                    }
                    data = taskData[i][j] != null && (taskData[i][j].equals("AppDeploymentOption.Yes") || taskData[i][j].equals("AppDeploymentOption.No") || taskData[i][j].equals("cmpBinding.container") || taskData[i][j].equals("cmpBinding.perConnectionFactory")) ? data + appM.getMessage(taskData[i][j]) : data + taskData[i][j];
                    if (installTask.getMutableColumns(j)) {
                        data = data + "]: ";
                    }
                    if (installTask.getMutableColumns(j)) {
                        String input = this.promptInput(appM, installTask.getName(), installTask.getRequiredColumns(j), taskData[i][j], data, taskData[0][j]);
                        if (input == null) continue;
                        InstallApp.dbg(".... Setting " + appM.getColumnName(taskData[0][j], installTask.getName()) + " to " + input);
                        taskData[i][j] = input;
                        continue;
                    }
                    InstallApp.dbg(data);
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                InstallApp.dbg("Index out of bound");
            }
        }
        installTask.setTaskData(taskData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "displayAndSetTaskData " + installTask.getName());
        }
    }

    private String promptInput(AppDeploymentMessages appM, String taskName, boolean isRequired, String taskData, String data, String columnName) {
        String answer = null;
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print(data);
                    answer = console.readLine();
                    if (isRequired && (answer == null || answer != null && answer.trim().length() == 0) && (taskData == null || taskData != null && taskData.length() == 0)) {
                        InstallApp.dbg("You have not entered a value for this  required field. Please try again.");
                        continue;
                    }
                    if (answer != null && (isRequired && answer.trim().length() == 0 || !isRequired && answer.length() == 0)) {
                        answer = null;
                    }
                    if (answer == null) break block2;
                    if (taskData != null && (taskData.equals("AppDeploymentOption.Yes") || taskData.equals("AppDeploymentOption.No"))) {
                        if (answer.toLowerCase().equals(CMDLINE_NO)) {
                            answer = "AppDeploymentOption.No";
                            break block2;
                        }
                        if (answer.toLowerCase().equals(CMDLINE_YES)) {
                            answer = "AppDeploymentOption.Yes";
                            break block2;
                        }
                        InstallApp.dbg("This field requires Yes or no as the value. Please try again.");
                        continue;
                    }
                    if (!columnName.equals("resAuth")) break;
                    if (answer.trim().toLowerCase().equals("container")) {
                        answer = "cmpBinding.container";
                        break block2;
                    }
                    if (answer.trim().toLowerCase().equals("per connection factory")) {
                        answer = "cmpBinding.perConnectionFactory";
                        break block2;
                    }
                    if (answer.trim().equals("")) break block2;
                    InstallApp.dbg("This field requires Container or Per connection factory as the value. Please try again.");
                }
                if (!columnName.equals("method.protectionType")) break;
                if (answer.trim().toLowerCase().equals("exclude")) {
                    answer = "methodProtection.exclude";
                    break;
                }
                if (!answer.trim().toLowerCase().equals("uncheck")) break;
                answer = "methodProtection.uncheck";
            }
            catch (IOException ex) {
                InstallApp.dbg("Error reading your input. Please try again");
                continue;
            }
            break;
        }
        return answer;
    }

    private Hashtable saveAndClose(AppDeploymentController flowController) throws AppDeploymentException {
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6006I"));
        if (this.argOptions.get(API) == null) {
            flowController.saveAndClose();
        } else {
            flowController.close(false, true, true);
        }
        Hashtable savedResults = flowController.getAppDeploymentSavedResults();
        return savedResults;
    }

    private Vector getOldAppTasks() throws Exception {
        if (this.argOptions.get(USEJMX) == null) {
            InstallApp.dbg("Getting tasks for: " + this.appName);
            AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
            return m.getApplicationInfo(this.appName, new Hashtable(), null);
        }
        AdminClient soapClient = this.getAdminClient();
        ObjectName on = this.getObjectName(soapClient);
        if (on == null) {
            InstallApp.errorAndExit("Can not find AppManagement MBean.");
        }
        Vector v = (Vector)soapClient.invoke(on, "getApplicationInfo", new Object[]{this.appName, new Hashtable(), null}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"});
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performInstall(String earPath, Hashtable savedResults) throws Exception {
        if (this.argOptions.get(PREPAREONLY) != null) {
            this.printOptions(savedResults);
            return;
        }
        if (this.argOptions.get(USEJMX) == null) {
            InstallApp.dbg("");
            InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6007I"));
            this.printOptions(savedResults);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating local AppManagementImpl");
            }
            AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
            if (this.argOptions.get("redeploy") == null) {
                String string = "waitObject";
                synchronized ("waitObject") {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Before installApplication");
                    }
                    m.installApplicationLocal(earPath, this.appName, savedResults, this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "After installApplication");
                    }
                    try {
                        if (!bOSGIWAIT) return;
                        "waitObject".wait(600000L);
                    }
                    catch (InterruptedException ie) {
                        if (!tc.isDebugEnabled()) return;
                        Tr.debug(tc, "Interrupted; time to work.");
                    }
                    return;
                }
            }
            String string = "waitObject";
            synchronized ("waitObject") {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Before redeployApplicationLocal");
                }
                m.redeployApplicationLocal(earPath, this.appName, savedResults, this, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "After redeployApplicationLocal");
                }
                try {
                    if (!bOSGIWAIT) return;
                    "waitObject".wait(600000L);
                }
                catch (InterruptedException ie) {
                    if (!tc.isDebugEnabled()) return;
                    Tr.debug(tc, "Interrupted; time to work.");
                }
                return;
            }
        }
        this.printOptions(savedResults);
        AdminClient soapClient = this.getAdminClient();
        ObjectName on = this.getObjectName(soapClient);
        if (on == null) {
            InstallApp.errorAndExit("Can not find AppManagement MBean.");
        }
        boolean added = false;
        try {
            NotificationFilterSupport myFilter = new NotificationFilterSupport();
            myFilter.enableType("websphere.admin.appmgmt");
            soapClient.addNotificationListener(on, this, (NotificationFilter)myFilter, (Object)("Install:" + this.appName));
            added = true;
        }
        catch (Throwable th) {
            InstallApp.dbg("Error: Could not add listener to JMX MBean: " + th);
        }
        String methodName = "installApplication";
        if (this.argOptions.get("redeploy") != null) {
            methodName = "redeployApplication";
        }
        soapClient.invoke(on, methodName, new Object[]{earPath, this.appName, savedResults, null}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"});
        InstallApp.dbg("after invoking installapplication.");
        boolean bDone = this.waitForTimeout((String)this.argOptions.get(TIMEOUT));
        if (!bDone) return;
        InstallApp.dbg("Operation timed out.");
        if (!added) return;
        soapClient.removeNotificationListener(on, this);
    }

    private AdminClient getAdminClient() throws Exception {
        if (this._soapClient != null) {
            return this._soapClient;
        }
        Properties config = new Properties();
        config.put(HOST, (String)this.argOptions.get(HOST));
        config.put(PORT, (String)this.argOptions.get(PORT));
        config.put("type", (String)this.argOptions.get(TYPE));
        this._soapClient = AdminClientFactory.createAdminClient(config);
        return this._soapClient;
    }

    private ObjectName getObjectName(AdminClient cl) throws Exception {
        ObjectName x;
        int i;
        if (this._on != null) {
            return this._on;
        }
        ObjectName on1 = new ObjectName("WebSphere:type=AppManagement,*");
        Iterator it = cl.queryNames(on1, null).iterator();
        Vector v = new Vector();
        while (it.hasNext()) {
            v.addElement(it.next());
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            this._on = (ObjectName)v.elementAt(0);
            InstallApp.dbg("App Management object name = " + this._on);
            return this._on;
        }
        for (i = 0; i < v.size(); ++i) {
            x = (ObjectName)v.elementAt(i);
            if (!x.getKeyProperty("process").equals("dmgr")) continue;
            this._on = x;
            InstallApp.dbg("App Management object name = " + this._on);
            return this._on;
        }
        for (i = 0; i < v.size(); ++i) {
            x = (ObjectName)v.elementAt(i);
            if (!x.getKeyProperty("process").equals(x.getKeyProperty("node"))) continue;
            this._on = x;
            InstallApp.dbg("App Management object name = " + this._on);
            return this._on;
        }
        this._on = (ObjectName)v.elementAt(0);
        InstallApp.dbg("App Management object name = " + this._on);
        return this._on;
    }

    private boolean waitForTimeout(String tim) {
        try {
            int timeout = 300;
            if (tim != null) {
                timeout = new Integer(tim);
            }
            if (timeout == -1) {
                return false;
            }
            int interval = 5;
            while (timeout > 0) {
                Thread.sleep(interval * 1000);
                timeout -= interval;
                InstallApp.dbg("..");
            }
            return true;
        }
        catch (Throwable th) {
            InstallApp.dbg("Error in waiting for JMX events.." + th);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void appEventReceived(AppNotification ev) {
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6008I") + ev);
        if (!ev.taskName.equals("InstallApplication")) return;
        if (!ev.taskStatus.equals("Completed")) {
            if (!ev.taskStatus.equals("Failed")) return;
        }
        try {
            if (this._soapClient != null) {
                this._soapClient.removeNotificationListener(this.getObjectName(this._soapClient), this);
            }
            if (bOSGIWAIT) {
                String string = "waitObject";
                // MONITORENTER : "waitObject"
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got STATUS_COMPLETED");
                }
                "waitObject".notify();
                // MONITOREXIT : string
            }
        }
        catch (Throwable th) {
            InstallApp.dbg("Error removing listener: " + th);
        }
        InstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6009I"));
        if (this._soapClient == null) return;
        System.exit(0);
    }

    public void handleNotification(Notification notf, Object handback) {
        if (notf == null) {
            InstallApp.dbg("!! JMX event Recd: (handback obj= " + handback + "): " + "Notification object is null");
            return;
        }
        Object ud = notf.getUserData();
        InstallApp.dbg("!! JMX event Recd: (handback obj= " + handback + "): " + ud);
        if (ud instanceof AppNotification) {
            this.appEventReceived((AppNotification)ud);
        }
    }

    private void printOptions(Hashtable appO) {
        InstallApp.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
        Enumeration keys = appO.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            InstallApp.dbg("");
            InstallApp.dbg(key + " ----> " + appO.get(key));
        }
        InstallApp.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
    }

    static {
        bOSGIWAIT = false;
        tc = Tr.register(InstallApp.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/driver/InstallApp.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.59.1.24");
        }
        CLASS_NAME = InstallApp.class.getName();
    }
}

