/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.MapWebModToVH;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MapWebModToVHHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(MapWebModToVHHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector warBindings = appInstallInfo.getModuleConfig("WAR_BND");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        for (i = 0; i < warBindings.size(); ++i) {
            WebAppBinding warBinding = (WebAppBinding)warBindings.elementAt(i);
            data.addElement(util.getModuleName(appInstallInfo, (WebApp)appInstallInfo.getModuleConfig("WAR_DD").elementAt(i)));
            data.addElement(util.formUriString(appInstallInfo, (EObject)appInstallInfo.getModuleConfig("WAR_DD").elementAt(i)));
            data.addElement(warBinding.getVirtualHostName());
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            Vector warBindings = appInstallInfo.getModuleConfig("WAR_BND");
            for (int i = 0; i < warBindings.size(); ++i) {
                WebAppBinding warBinding = (WebAppBinding)warBindings.elementAt(i);
                WebApp war = (WebApp)appInstallInfo.getModuleConfig("WAR_DD").elementAt(i);
                String[] matchingTaskData = null;
                String[][] taskData = t.getTaskData();
                for (int k = 0; k < taskData.length; ++k) {
                    MapWebModToVH cfr_ignored_0 = (MapWebModToVH)t;
                    if (taskData[k].length <= 2) continue;
                    MapWebModToVH cfr_ignored_1 = (MapWebModToVH)t;
                    if (!util.getModuleName(appInstallInfo, war).equals(taskData[k][0])) continue;
                    MapWebModToVH cfr_ignored_2 = (MapWebModToVH)t;
                    if (!util.compareUriString(appInstallInfo, war, taskData[k][1])) continue;
                    matchingTaskData = taskData[k];
                    break;
                }
                if (matchingTaskData == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No matching task data for WAR Module " + util.getModuleName(appInstallInfo, war));
                    continue;
                }
                MapWebModToVH cfr_ignored_3 = (MapWebModToVH)t;
                warBinding.setVirtualHostName((String)matchingTaskData[2]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        if (!allTypes.contains(ModuleType.WAR)) {
            return null;
        }
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        tbl.put(ModuleType.WAR.toString(), "/");
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.moduleTask2DC(task, dcImpl, uri, 1);
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }
}

