/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.classloader.LibraryRef;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MapSharedLibForModHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(MapSharedLibForModHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] cols = new String[]{"module", "uri", "sharedLibName"};
    static final int moduleColumn = 0;
    static final int urlColumn = 1;
    static final int sharedlibColumn = 2;
    private String[] taskValidateErrorMessages;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            return new WASDeploymentTask(appController, "MapSharedLibForMod", cols, new boolean[]{false, false, false}, new boolean[]{false, false, true}, new boolean[]{false, false, false}, true);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask: task data already set.");
            }
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
        boolean process = t.getAppDeploymentController().getSelectedOptions().contains("processEmbeddedConfig");
        ApplicationDeployment appDepl = ((ArchiveDeploymentInfo)appInstallInfo).getAppDeploymentObject(process);
        Hashtable modToLibTbl = (Hashtable)appInstallInfo.getAppOptions().get("mapSharedLib");
        if (appDepl == null) {
            if ((t.getAppDeploymentController().getDeploymentMode() & 0x10L) != 0L || (t.getAppDeploymentController().getDeploymentMode() & 0x1000L) != 0L || (t.getAppDeploymentController().getDeploymentMode() & 1L) != 0L) {
                String mname = null;
                String uri = null;
                mname = appInstallInfo.getAppDisplayName();
                data.addElement(mname);
                uri = appInstallInfo.getApplication().eResource().getURI().toString();
                data.addElement(uri);
                data.addElement(this.getSharedLib(uri, modToLibTbl));
            }
            for (int i = 0; i < wars.size(); ++i) {
                WebApp web = (WebApp)wars.elementAt(i);
                String mname = util.getModuleName(appInstallInfo, web);
                data.addElement(mname);
                String uri = util.formUriString(appInstallInfo, web);
                data.addElement(uri);
                data.addElement(this.getSharedLib(util.getModuleUriFromUriString(uri), modToLibTbl));
            }
        } else {
            if ((t.getAppDeploymentController().getDeploymentMode() & 0x10L) != 0L || (t.getAppDeploymentController().getDeploymentMode() & 0x1000L) != 0L || (t.getAppDeploymentController().getDeploymentMode() & 1L) != 0L) {
                String appname = appInstallInfo.getAppDisplayName();
                data.addElement(appname);
                String uri = appInstallInfo.getApplication().eResource().getURI().toString();
                data.addElement(uri);
                String slib = this.getSharedLib(uri, modToLibTbl);
                if (slib == null || slib.length() == 0) {
                    Classloader cl = appDepl.getClassloader();
                    slib = this.getLibcolmn(cl);
                }
                data.addElement(slib);
            }
            for (int i = 0; i < wars.size(); ++i) {
                ModuleDeployment md2;
                WebApp web = (WebApp)wars.elementAt(i);
                String mname = util.getModuleName(appInstallInfo, web);
                data.addElement(mname);
                String displayUri = util.formUriString(appInstallInfo, web);
                String uri = appInstallInfo.getModuleForDD(web).getUri();
                data.addElement(displayUri);
                String slib = this.getSharedLib(uri, modToLibTbl);
                if ((slib == null || slib.length() == 0) && (md2 = this.getMDFromModuleRef(appDepl, uri)) != null) {
                    Classloader cl = md2.getClassloader();
                    slib = this.getLibcolmn(cl);
                }
                data.addElement(slib);
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private ModuleDeployment getMDFromModuleRef(ApplicationDeployment appDepl, String uri) {
        EList mlist = appDepl.getModules();
        ModuleDeployment retVal = null;
        for (int i = 0; i < mlist.size(); ++i) {
            ModuleDeployment md2 = (ModuleDeployment)mlist.get(i);
            if (!md2.getUri().equals(uri)) continue;
            retVal = md2;
            break;
        }
        return retVal;
    }

    private String getLibcolmn(Classloader cl) {
        if (cl == null) {
            return null;
        }
        EList libs = cl.getLibraries();
        String slib = "";
        String isShared = "AppDeploymentOption.No";
        for (int i = 0; i < libs.size(); ++i) {
            LibraryRef sref = (LibraryRef)libs.get(i);
            if (sref.getLibraryName().indexOf("assetname=") != -1 || sref.getLibraryName().indexOf("cuname=") != -1) continue;
            if (!AppUtils.isEmpty(slib)) {
                slib = slib + "+";
            }
            slib = slib + "WebSphere:name=" + sref.getLibraryName();
            if (!sref.isSetSharedClassloader()) continue;
            isShared = sref.isSharedClassloader() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            slib = slib + ",isSharedClassloader=" + isShared;
        }
        return slib;
    }

    private String getSharedLib(String uri, Hashtable modToLibTbl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedLib", new Object[]{uri, modToLibTbl});
        }
        String libName = new String();
        if (modToLibTbl != null) {
            libName = (String)modToLibTbl.get(uri);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedLib", new Object[]{libName});
        }
        return libName;
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            String[][] data = t.getTaskData();
            Hashtable<String, String> slibTbl = new Hashtable<String, String>(10);
            String key = null;
            for (int indx = 1; indx < data.length; ++indx) {
                key = data[indx][1];
                String uri = util.getModuleUriFromUriString(key);
                if (uri == null) {
                    uri = key;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uri: " + uri);
                }
                String libStr = data[indx][2];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "libStr: " + libStr);
                }
                if (libStr == null) continue;
                slibTbl.put(uri, libStr);
            }
            appInstallInfo.getAppOptions().put("mapSharedLib", slibTbl);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mapSharedLib: " + appInstallInfo.getAppOptions().get("mapSharedLib"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

