/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndFactory;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndPackage;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndPackage;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsMode;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.MapRunAsRolesToUsers;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.common.Identity;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.jst.j2ee.common.SecurityIdentity;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MapRunAsRolesToUsersHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(MapRunAsRolesToUsersHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        RunAsMap runAsMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        ArrayList<SecurityRole> runAsRoles = new ArrayList<SecurityRole>();
        ApplicationBinding appBinding = appInstallInfo.getApplicationBindings();
        if (appBinding != null && (runAsMap = appBinding.getRunAsMap()) != null) {
            EList rabs = runAsMap.getRunAsBindings();
            for (RunAsBinding rab : rabs) {
                SecurityRole secRole = rab.getSecurityRole();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rab securityrole " + secRole);
                }
                if (secRole == null) continue;
                if (secRole.getRoleName() != null) {
                    runAsRoles.add(secRole);
                    continue;
                }
                Tr.warning(tc, "ADMA0050W", new Object[]{secRole});
            }
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        if (appInstallInfo.getApplication() == null) {
            t.setTaskData(util.buildTaskData(data, colNames.length));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask");
            }
            return;
        }
        this.prepareTaskForEJB(appInstallInfo, t, runAsRoles);
        this.prepareTaskForWAR(appInstallInfo, t, runAsRoles);
        if (runAsRoles.size() > 0) {
            this.updateRunAsBinding(appInstallInfo, t, runAsRoles, data);
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private void prepareTaskForEJB(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, List runAsRoles) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForEJB");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ejbJars: " + ejbJars.size());
        }
        Vector ejbExtensions = appInstallInfo.getModuleConfig("JAR_EXT");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ejbExts: " + ejbExtensions.size());
        }
        for (int i = 0; i < ejbJars.size(); ++i) {
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            int version = AppDeploymentUtil.getModuleVersion(appInstallInfo.getModuleFileForDD(jar));
            if (version == 12) {
                if (((EJBJarExtension)ejbExtensions.elementAt(i)).getEjbExtensions().size() <= 0) continue;
                this.prepareTaskForEJB11(appInstallInfo, t, runAsRoles, (EJBJarExtension)ejbExtensions.elementAt(i));
                continue;
            }
            this.prepareTaskForEJB20AndAbove(appInstallInfo, t, runAsRoles, jar);
            this.prepareTaskForEJB11(appInstallInfo, t, runAsRoles, (EJBJarExtension)ejbExtensions.elementAt(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB");
        }
    }

    private void prepareTaskForEJB11(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, List runAsRoles, EJBJarExtension jarExt) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForEJB11");
        }
        for (EnterpriseBeanExtension ejbext : jarExt.getEjbExtensions()) {
            for (com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity si : ejbext.getRunAsSettings()) {
                RunAsMode mode = si.getRunAsMode();
                if (!(mode instanceof com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity)) continue;
                String roleName = ((com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity)mode).getRunAsSpecifiedIdentity().getRoleName();
                Application dd = appInstallInfo.getApplication();
                if (dd == null || !dd.containsSecurityRole(roleName)) continue;
                Iterator roles = runAsRoles.iterator();
                boolean found = false;
                while (roles.hasNext() && !found) {
                    SecurityRole role = (SecurityRole)roles.next();
                    if (!role.getRoleName().equals(roleName)) continue;
                    found = true;
                }
                if (found) continue;
                runAsRoles.add(dd.getSecurityRoleNamed(roleName));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB11");
        }
    }

    private void prepareTaskForEJB20AndAbove(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, List runAsRoles, EJBJar ejbJar) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForEJB20");
        }
        for (EnterpriseBean ejb : ejbJar.getEnterpriseBeans()) {
            RunAsSpecifiedIdentity runAsIndentity;
            Identity identity;
            SecurityIdentity securityIdentity = ejb.getSecurityIdentity();
            if (securityIdentity == null || !(securityIdentity instanceof RunAsSpecifiedIdentity) || (identity = (runAsIndentity = (RunAsSpecifiedIdentity)securityIdentity).getIdentity()) == null) continue;
            String roleName = identity.getRoleName();
            Application dd = appInstallInfo.getApplication();
            if (dd == null || !dd.containsSecurityRole(roleName)) continue;
            Iterator roles = runAsRoles.iterator();
            boolean found = false;
            while (roles.hasNext() && !found) {
                SecurityRole role = (SecurityRole)roles.next();
                if (!role.getRoleName().equals(roleName)) continue;
                found = true;
            }
            if (found) continue;
            runAsRoles.add(dd.getSecurityRoleNamed(roleName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB20");
        }
    }

    private void prepareTaskForAnnotatedEJB(AppDeploymentInfo appInstallInfo, List runAsRoles, String[] annotatedRunAsRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForEJB30: " + Arrays.toString(annotatedRunAsRoles));
        }
        Application dd = appInstallInfo.getApplication();
        for (String annotatedRunAsRole : annotatedRunAsRoles) {
            if (dd == null || !dd.containsSecurityRole(annotatedRunAsRole)) continue;
            Iterator roles = runAsRoles.iterator();
            boolean found = false;
            while (roles.hasNext() && !found) {
                SecurityRole role = (SecurityRole)roles.next();
                if (!role.getRoleName().equals(annotatedRunAsRole)) continue;
                found = true;
            }
            if (found) continue;
            runAsRoles.add(dd.getSecurityRoleNamed(annotatedRunAsRole));
        }
        if (tc.isDebugEnabled() && runAsRoles != null && !runAsRoles.isEmpty()) {
            SecurityRole[] dumpRoles = (SecurityRole[])runAsRoles.toArray();
            Tr.debug(tc, "RunAs Roles from Annotations and XML");
            for (SecurityRole dumpRole : dumpRoles) {
                Tr.debug(tc, "Role: " + dumpRole.getRoleName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB20");
        }
    }

    private void prepareTaskForWAR(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, List runAsRoles) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForWAR");
        }
        Vector webApps = appInstallInfo.getModuleConfig("WAR_DD");
        Vector webAppBindings = appInstallInfo.getModuleConfig("WAR_BND");
        Vector ejbExtensions = appInstallInfo.getModuleConfig("JAR_EXT");
        for (int i = 0; i < webApps.size(); ++i) {
            WebApp webApp = (WebApp)webApps.elementAt(i);
            if (((XMLResource)webApp.eResource()).getVersionID() < 13) continue;
            for (Servlet servlet : webApp.getServlets()) {
                Identity identity;
                RunAsSpecifiedIdentity runAsIdentity = servlet.getRunAs();
                if (runAsIdentity == null || (identity = runAsIdentity.getIdentity()) == null) continue;
                String roleName = runAsIdentity.getIdentity().getRoleName();
                Tr.debug(tc, "roleName: " + roleName);
                Application dd = appInstallInfo.getApplication();
                if (dd == null || !dd.containsSecurityRole(roleName)) continue;
                Iterator roles = runAsRoles.iterator();
                boolean found = false;
                while (roles.hasNext() && !found) {
                    SecurityRole role = (SecurityRole)roles.next();
                    if (!role.getRoleName().equals(roleName)) continue;
                    found = true;
                }
                if (found) continue;
                runAsRoles.add(dd.getSecurityRoleNamed(roleName));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForWAR");
        }
    }

    private void updateRunAsBinding(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, List runAsRoles, Vector data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRunAsBinding");
        }
        if (runAsRoles.size() > 0) {
            SecurityRole sr;
            ApplicationbndFactory appbndfact = null;
            CommonbndFactory combndfact = null;
            ApplicationbndPackage appbndPkg = (ApplicationbndPackage)EPackage.Registry.INSTANCE.getEPackage("applicationbnd.xmi");
            appbndfact = appbndPkg.getApplicationbndFactory();
            CommonbndPackage commonbndPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
            combndfact = commonbndPkg.getCommonbndFactory();
            RunAsMap runAsMap = appInstallInfo.getApplicationBindings().getRunAsMap();
            if (runAsMap == null) {
                runAsMap = appbndfact.createRunAsMap();
                appInstallInfo.getApplicationBindings().setRunAsMap(runAsMap);
            }
            EList rabs = runAsMap.getRunAsBindings();
            boolean found = false;
            Vector<RunAsBinding> deleteList = new Vector<RunAsBinding>();
            for (RunAsBinding rab : rabs) {
                sr = rab.getSecurityRole();
                if (sr == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Binding w/o entry in DD: " + rab + " will be deleted.");
                    }
                    deleteList.addElement(rab);
                    found = false;
                    continue;
                }
                Iterator roles = runAsRoles.iterator();
                while (roles.hasNext() && !found) {
                    SecurityRole srinlist = (SecurityRole)roles.next();
                    if (sr.getRoleName() == null || !sr.getRoleName().equals(srinlist.getRoleName())) continue;
                    found = true;
                }
                if (!found) {
                    deleteList.addElement(rab);
                }
                found = false;
            }
            Iterator d = deleteList.iterator();
            while (d.hasNext()) {
                rabs.remove(d.next());
            }
            for (SecurityRole srinlist : runAsRoles) {
                Iterator rabsi = rabs.iterator();
                found = false;
                RunAsBinding rab = null;
                while (rabsi.hasNext() && !found) {
                    rab = (RunAsBinding)rabsi.next();
                    sr = rab.getSecurityRole();
                    if (!sr.getRoleName().equals(srinlist.getRoleName())) continue;
                    found = true;
                }
                if (found) continue;
                rab = appbndfact.createRunAsBinding();
                rab.setSecurityRole(srinlist);
                BasicAuthData authData = combndfact.createBasicAuthData();
                rab.setAuthData(authData);
                rabs.add(rab);
            }
            if (data != null) {
                for (RunAsBinding rab : rabs) {
                    sr = rab.getSecurityRole();
                    data.addElement(sr.getRoleName());
                    data.addElement(((BasicAuthData)rab.getAuthData()).getUserId());
                    data.addElement(((BasicAuthData)rab.getAuthData()).getPassword());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRunAsBinding");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            String[][] taskData = t.getTaskData();
            ArrayList<SecurityRole> l = new ArrayList<SecurityRole>();
            for (int i = 1; i < taskData.length; ++i) {
                SecurityRole role = appInstallInfo.getApplication().getSecurityRoleNamed(taskData[i][0]);
                if (role == null) continue;
                l.add(role);
            }
            this.updateRunAsBinding(appInstallInfo, t, l, null);
            RunAsMap rMap = appInstallInfo.getApplicationBindings().getRunAsMap();
            for (RunAsBinding rab : rMap.getRunAsBindings()) {
                String[] matchingTaskData = null;
                for (int j = 0; j < taskData.length; ++j) {
                    MapRunAsRolesToUsers cfr_ignored_0 = (MapRunAsRolesToUsers)t;
                    if (taskData[j].length <= 1) continue;
                    MapRunAsRolesToUsers cfr_ignored_1 = (MapRunAsRolesToUsers)t;
                    if (!taskData[j][0].equals(rab.getSecurityRole().getRoleName())) continue;
                    matchingTaskData = taskData[j];
                    break;
                }
                if (matchingTaskData == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No matching task data for role " + rab.getSecurityRole().getRoleName());
                    continue;
                }
                AbstractAuthData authData = rab.getAuthData();
                if (!(authData instanceof BasicAuthData)) continue;
                MapRunAsRolesToUsers cfr_ignored_2 = (MapRunAsRolesToUsers)t;
                ((BasicAuthData)authData).setUserId((String)matchingTaskData[1]);
                MapRunAsRolesToUsers cfr_ignored_3 = (MapRunAsRolesToUsers)t;
                if (matchingTaskData.length > 2) {
                    MapRunAsRolesToUsers cfr_ignored_4 = (MapRunAsRolesToUsers)t;
                    ((BasicAuthData)authData).setPassword(matchingTaskData[2]);
                    continue;
                }
                ((BasicAuthData)authData).setPassword(null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        Hashtable tbl = new Hashtable();
        if (allTypes.contains(ModuleType.EJB)) {
            Vector<String> v = new Vector<String>();
            v.addElement("/ejb-jar/enterprise-beans/session/security-identity/run-as/role-name");
            v.addElement("/ejb-jar/enterprise-beans/entity/security-identity/run-as/role-name");
            v.addElement("/ejb-jar/enterprise-beans/message-driven/security-identity/run-as/role-name");
            tbl.put(ModuleType.EJB.toString(), v);
        }
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.task2DC(task, dcImpl, new String[]{dcImpl.getDDBean().getText()}, new int[]{0}, false);
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }
}

