/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndFactory;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.Group;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.models.base.bindings.applicationbnd.Subject;
import com.ibm.ejs.models.base.bindings.applicationbnd.User;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.ApplicationbndFactoryImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.MapRolesToUsers;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import com.ibm.ws.management.util.RasUtils;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;

public class MapRolesToUsersHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static final TraceComponent tc = Tr.register(MapRolesToUsersHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask", taskName);
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "createTask", "80", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        long mode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask", new Object[]{appInstallInfo, t});
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        if (appInstallInfo.getApplication() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no application DD");
            }
            t.setTaskData(util.buildTaskData(data, colNames.length));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask");
            }
            return;
        }
        if (t.getAppDeploymentController() != null && ((mode = t.getAppDeploymentController().getDeploymentMode()) == 0x100000L || mode == 65536L)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trying to add/update module - lets not collect user info");
            }
            t.setTaskData(util.buildTaskData(data, colNames.length));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask");
            }
            return;
        }
        try {
            ApplicationBinding applicationBinding = appInstallInfo.getApplicationBindings();
            AuthorizationTable authTable = applicationBinding.getAuthorizationTable();
            EList roles = appInstallInfo.getApplication().getSecurityRoles();
            if (authTable == null) {
                authTable = ApplicationbndFactoryImpl.getActiveFactory().createAuthorizationTable();
                EList roleAssigs = authTable.getAuthorizations();
                for (int i = 0; i < roles.size(); ++i) {
                    SecurityRole role = (SecurityRole)roles.get(i);
                    if (role.getRoleName().equals("DenyAllRole")) continue;
                    RoleAssignment newRa = ApplicationbndFactoryImpl.getActiveFactory().createRoleAssignment();
                    newRa.setRole(role);
                    roleAssigs.add(newRa);
                    this.addTaskData(data, newRa);
                }
                applicationBinding.setAuthorizationTable(authTable);
            } else {
                this.resyncAuthTable(authTable, roles, data);
            }
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "prepareTask", "148", this);
            String message = util.getMessage(t, "ADMA0034E");
            AppDeploymentException appDeploymentException = new AppDeploymentException(message, ex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask", appDeploymentException);
            }
            throw appDeploymentException;
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask", new Object[]{appInstallInfo, t});
        }
        Hashtable tbl = new Hashtable();
        String everyone = null;
        String allAuthUser = null;
        String allAuthRealms = null;
        String user = null;
        String group = null;
        String userAccessId = null;
        String groupAccessId = null;
        if (appInstallInfo.getApplication() == null) {
            return;
        }
        if (!t.isTaskEmpty()) {
            boolean v7OrPlus = true;
            if (t.getClientMajorVersion() < 7) {
                v7OrPlus = false;
            }
            ApplicationBinding applicationBinding = appInstallInfo.getApplicationBindings();
            AuthorizationTable authTable = applicationBinding.getAuthorizationTable();
            EList roles = appInstallInfo.getApplication().getSecurityRoles();
            if (authTable == null) {
                authTable = ApplicationbndFactoryImpl.getActiveFactory().createAuthorizationTable();
                EList roleAssigs = authTable.getAuthorizations();
                for (int i = 0; i < roles.size(); ++i) {
                    SecurityRole role = (SecurityRole)roles.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ROLE NAME: ", role.getRoleName());
                    }
                    if (role.getRoleName().equals("DenyAllRole")) continue;
                    RoleAssignment newRa = ApplicationbndFactoryImpl.getActiveFactory().createRoleAssignment();
                    newRa.setRole(role);
                    roleAssigs.add(newRa);
                }
                applicationBinding.setAuthorizationTable(authTable);
            } else if (appInstallInfo instanceof PartialDeploymentInfo) {
                this.resyncAuthTable(authTable, roles, null);
            }
            for (RoleAssignment auth : appInstallInfo.getApplicationBindings().getAuthorizationTable().getAuthorizations()) {
                String[] matchingTaskData = null;
                String[][] taskData = t.getTaskData();
                MapRolesToUsers task = (MapRolesToUsers)t;
                for (int j = 0; j < taskData.length; ++j) {
                    if (taskData[j].length <= 0) continue;
                    if (!taskData[j][0].equals(auth.getRole().getRoleName())) continue;
                    matchingTaskData = taskData[j];
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Found matching task data for " + auth.getRole().getRoleName());
                    break;
                }
                if (matchingTaskData == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No matching task data for role " + auth.getRole().getRoleName());
                    continue;
                }
                if (matchingTaskData.length > 1) {
                    everyone = matchingTaskData[1];
                }
                if (matchingTaskData.length > 2) {
                    allAuthUser = matchingTaskData[2];
                }
                if (matchingTaskData.length > 3) {
                    user = matchingTaskData[3];
                }
                if (matchingTaskData.length > 4) {
                    group = matchingTaskData[4];
                }
                if (v7OrPlus) {
                    if (matchingTaskData.length > 5) {
                        allAuthRealms = matchingTaskData[5];
                    }
                    if (matchingTaskData.length > 6) {
                        userAccessId = matchingTaskData[6];
                    }
                    if (matchingTaskData.length > 7) {
                        groupAccessId = matchingTaskData[7];
                    }
                }
                this.updateAuthTable(auth, everyone, allAuthUser, user, group, allAuthRealms, userAccessId, groupAccessId);
                if (authTable == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Table: " + authTable);
                }
                this.updateAccessID(auth.getUsers(), user, userAccessId);
                this.updateAccessID(auth.getGroups(), group, groupAccessId);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void updateAccessID(List l, String user, String accessId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAccessID", new Object[]{user, accessId});
        }
        if (accessId != null && !accessId.trim().equals("")) {
            StringTokenizer strRawInfo = new StringTokenizer(user, "|");
            if (accessId.endsWith("|")) {
                accessId = accessId + " ";
            }
            String[] strRawAccessId = accessId.split("\\|");
            int j = 0;
            while (strRawInfo.hasMoreTokens()) {
                String info = strRawInfo.nextToken();
                if (j >= strRawAccessId.length) break;
                String id = strRawAccessId[j];
                ++j;
                for (int i = 0; i < l.size(); ++i) {
                    Subject sub = (Subject)l.get(i);
                    if (sub.getName().equals(info)) {
                        if (id != null && !id.trim().equals("")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "set following sub.getName(): " + sub.getName() + "\nrawInfo: " + info + "\naccessId: " + id);
                            }
                            sub.setAccessId(id);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Ignore the accessId because it's empty");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "skip following sub.getName(): " + sub.getName() + "\nrawInfo: " + info + "\naccessId: " + id);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAccessID");
        }
    }

    private void resyncAuthTable(AuthorizationTable table, List roles, Vector data) {
        Iterator j;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resyncAuthTable");
        }
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            try {
                SecurityRole role = (SecurityRole)i.next();
                boolean found = false;
                j = table.getAuthorizations().iterator();
                RoleAssignment auth = null;
                while (j.hasNext()) {
                    auth = (RoleAssignment)j.next();
                    if (auth.getRole() != role) continue;
                    found = true;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "found role " + role.getRoleName() + " in auth table " + role);
                    break;
                }
                if (found) continue;
                auth = ApplicationbndFactoryImpl.getActiveFactory().createRoleAssignment();
                auth.setRole(role);
                table.getAuthorizations().add(auth);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding new role to auth table " + role.getRoleName());
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding new role to auth table " + role);
            }
            catch (Exception ex) {
                RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "resyncAuthTable", "335", this);
            }
        }
        Vector<RoleAssignment> deletedAuths = new Vector<RoleAssignment>();
        for (RoleAssignment auth : table.getAuthorizations()) {
            j = roles.iterator();
            boolean found = false;
            while (j.hasNext() && !found) {
                SecurityRole role = (SecurityRole)j.next();
                if (auth.getRole() != role) continue;
                found = true;
            }
            if (found) continue;
            deletedAuths.addElement(auth);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "adding auth " + auth.getRole().getRoleName() + " to be deleted: " + auth.getRole());
        }
        i = deletedAuths.iterator();
        while (i.hasNext()) {
            table.getAuthorizations().remove(i.next());
        }
        if (data != null) {
            for (RoleAssignment auth : table.getAuthorizations()) {
                this.addTaskData(data, auth);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auth table" + table.getAuthorizations());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "security role" + roles);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resyncAuthTable");
        }
    }

    protected void addTaskData(Vector data, RoleAssignment ra) {
        String strAccessId;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTaskData");
        }
        data.addElement(ra.getRole().getRoleName());
        StringBuilder roleString = null;
        Iterator userList = ra.getSpecialSubjects().iterator();
        String everyone = "AppDeploymentOption.No";
        String allAuthUsers = "AppDeploymentOption.No";
        String allAuthRealms = "AppDeploymentOption.No";
        while (userList.hasNext()) {
            String name = ((Subject)userList.next()).getName();
            if (name.equalsIgnoreCase("EVERYONE")) {
                everyone = "AppDeploymentOption.Yes";
                continue;
            }
            if (name.equalsIgnoreCase("ALLAUTHUSERS") || name.equalsIgnoreCase("AllAuthenticatedUsers")) {
                allAuthUsers = "AppDeploymentOption.Yes";
                continue;
            }
            if (name.equalsIgnoreCase("ALLAUTHINTRUSTEDREALMS") || name.equalsIgnoreCase("AllAuthenticatedInTrustedRealms")) {
                allAuthRealms = "AppDeploymentOption.Yes";
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Unknown special subject: " + name);
        }
        data.addElement(everyone);
        data.addElement(allAuthUsers);
        roleString = null;
        userList = ra.getUsers().iterator();
        while (userList.hasNext()) {
            if (roleString == null) {
                roleString = new StringBuilder();
            } else {
                roleString.append("|");
            }
            roleString.append(((Subject)userList.next()).getName());
        }
        if (roleString == null) {
            data.addElement("");
        } else {
            data.addElement(roleString.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "USERS: ", roleString);
        }
        roleString = null;
        Iterator groupList = ra.getGroups().iterator();
        while (groupList.hasNext()) {
            if (roleString == null) {
                roleString = new StringBuilder();
            } else {
                roleString.append("|");
            }
            roleString.append(((Subject)groupList.next()).getName());
        }
        if (roleString == null) {
            data.addElement("");
        } else {
            data.addElement(roleString.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "GROUPS: ", roleString);
        }
        data.addElement(allAuthRealms);
        userList = ra.getUsers().iterator();
        roleString = null;
        while (userList.hasNext()) {
            if (roleString == null) {
                roleString = new StringBuilder();
            } else {
                roleString.append("|");
            }
            strAccessId = ((Subject)userList.next()).getAccessId();
            if (strAccessId == null) {
                strAccessId = " ";
            }
            roleString.append(strAccessId);
        }
        if (roleString == null) {
            data.addElement("");
        } else {
            data.addElement(roleString.toString());
        }
        groupList = ra.getGroups().iterator();
        roleString = null;
        while (groupList.hasNext()) {
            if (roleString == null) {
                roleString = new StringBuilder();
            } else {
                roleString.append("|");
            }
            strAccessId = ((Subject)groupList.next()).getAccessId();
            if (strAccessId == null) {
                strAccessId = " ";
            }
            roleString.append(strAccessId);
        }
        if (roleString == null) {
            data.addElement("");
        } else {
            data.addElement(roleString.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTaskData");
        }
    }

    private void updateAuthTable(RoleAssignment ra, String everyone, String allAuthUser, String user, String group, String allAuthRealms, String userAccessId, String groupAccessId) throws AppDeploymentException {
        SpecialSubject ss;
        String name;
        StringTokenizer stok;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAuthTable", new Object[]{ra, everyone, allAuthUser, user, group, allAuthRealms, userAccessId, groupAccessId});
        }
        EList users = ra.getUsers();
        Hashtable userT = new Hashtable();
        for (int i = 0; i < users.size(); ++i) {
            userT.put(((Subject)users.get(i)).getName(), users.get(i));
        }
        users.clear();
        EList groups = ra.getGroups();
        Hashtable groupT = new Hashtable();
        for (int i = 0; i < groups.size(); ++i) {
            groupT.put(((Subject)groups.get(i)).getName(), groups.get(i));
        }
        groups.clear();
        EList special = ra.getSpecialSubjects();
        Iterator specialList = special.iterator();
        Vector<Subject> deleteSpecial = new Vector<Subject>();
        while (specialList.hasNext()) {
            Subject aSpecial = (Subject)specialList.next();
            if (aSpecial.getName().equalsIgnoreCase("Server")) continue;
            deleteSpecial.addElement(aSpecial);
        }
        Iterator iter = deleteSpecial.iterator();
        while (iter.hasNext()) {
            special.remove((Subject)iter.next());
        }
        ApplicationbndFactory factory = ApplicationbndFactoryImpl.getActiveFactory();
        if (user != null && !user.trim().equals("")) {
            stok = new StringTokenizer(user, "|");
            while (stok.hasMoreTokens()) {
                name = stok.nextToken();
                if (userT.get(name) != null) {
                    users.add(userT.get(name));
                    continue;
                }
                User aUser = factory.createUser();
                aUser.setName(name.trim());
                users.add(aUser);
            }
        }
        if (group != null && !group.trim().equals("")) {
            stok = new StringTokenizer(group, "|");
            while (stok.hasMoreTokens()) {
                name = stok.nextToken();
                if (groupT.get(name) != null) {
                    groups.add(groupT.get(name));
                    continue;
                }
                Group aGroup = factory.createGroup();
                aGroup.setName(name.trim());
                groups.add(aGroup);
            }
        }
        if (everyone != null && !everyone.trim().equals("") && everyone.equals("AppDeploymentOption.Yes")) {
            ss = factory.createEveryone();
            ss.setName("Everyone");
            special.add(ss);
        }
        if (allAuthUser != null && !allAuthUser.trim().equals("") && allAuthUser.equals("AppDeploymentOption.Yes")) {
            ss = factory.createAllAuthenticatedUsers();
            ss.setName("AllAuthenticatedUsers");
            special.add(ss);
        }
        if (allAuthRealms != null && !allAuthRealms.trim().equals("")) {
            if (allAuthRealms.equals("AppDeploymentOption.Yes")) {
                ss = factory.createAllAuthenticatedInTrustedRealms();
                ss.setName("AllAuthenticatedInTrustedRealms");
                special.add(ss);
                EList spec = ra.getSpecialSubjects();
                for (SpecialSubject aa : spec) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "NAME:  ", aa.getName());
                }
            } else if (allAuthRealms.equals("AppDeploymentOption.No")) {
                ss = factory.createAllAuthenticatedInTrustedRealms();
                ss.setName("AllAuthenticatedInTrustedRealms");
                if (special.contains(ss)) {
                    special.remove(ss);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no auth in trusted realms to remove!!");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAuthTable");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        if (allTypes.contains(ModuleType.EAR)) {
            tbl.put(ModuleType.EAR.toString(), "/application/security-role/role-name");
        } else if (allTypes.contains(ModuleType.EJB)) {
            tbl.put(ModuleType.EJB.toString(), "/ejb-jar/assembly-descriptor/security-role/role-name");
        } else if (allTypes.contains(ModuleType.WAR)) {
            tbl.put(ModuleType.WAR.toString(), "/web-app/security-role/role-name");
        }
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.task2DC(task, dcImpl, new String[]{dcImpl.getDDBean().getText()}, new int[]{0}, false);
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/MapRolesToUsersHelper.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.29");
        }
        CLASS_NAME = MapRolesToUsersHelper.class.getName();
    }
}

