/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndPackage;
import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskValidate;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.BindJndiForEJBMessageBinding;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.common.MessageDestination;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MapMessageDestinationRefToEJBHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper,
AppDeploymentTaskValidate {
    private static TraceComponent tc = Tr.register(MapMessageDestinationRefToEJBHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] cols = new String[]{"AppVersion", "ModuleVersion", "module", "EJB", "uri", "messageDestinationObject", "isMD", "messageDestinationRefName", "JNDI", "jndi.dest"};
    public static final int AppVersionColumn = 0;
    public static final int ModuleVersionColumn = 1;
    public static final int moduleColumn = 2;
    public static final int ejbColumn = 3;
    public static final int uriColumn = 4;
    public static final int messageDestinationObjectColumn = 5;
    public static final int isMD = 6;
    public static final int messageDestinationRefNameColumn = 7;
    public static final int jndiColumn = 8;
    public static final int destJndiColumn = 9;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            return new WASDeploymentTask(appController, "MapMessageDestinationRefToEJB", cols, new boolean[]{false, false, false, false, false, false, false, false, false, false}, new boolean[]{false, false, false, false, false, false, false, false, true, false}, new boolean[]{true, true, false, false, false, false, true, true, false, true}, true);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        BindJndiForEJBMessageBinding mdbTask;
        int appVersion;
        String[] colNames;
        Vector<String> data;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "prepareTask");
            }
            if (t.getTaskData() != null) {
                return;
            }
            data = new Vector<String>();
            colNames = t.getColumnNames();
            for (int i = 0; i < colNames.length; ++i) {
                data.addElement(colNames[i]);
            }
            appVersion = ((XMLResource)appInstallInfo.getApplication().eResource()).getVersionID();
            AppDeploymentController controller = t.getAppDeploymentController();
            mdbTask = null;
            try {
                mdbTask = (BindJndiForEJBMessageBinding)controller.getTaskByName("BindJndiForEJBMessageBinding", false);
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception when calling getTaskByName: " + ex);
            }
        }
        this.prepareTaskForEJB(appInstallInfo, t, data, appVersion, mdbTask);
        this.prepareTaskForWAR(appInstallInfo, t, data, appVersion, mdbTask);
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private void prepareTaskForEJB(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, Vector data, int appVersion, BindJndiForEJBMessageBinding mdbTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForEJB");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            int jarVersion = ((XMLResource)jar.eResource()).getVersionID();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jar version: " + jarVersion);
            }
            AssemblyDescriptor ad = jar.getAssemblyDescriptor();
            EList msgDestinations = ad.getMessageDestinations();
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                this.addTaskData(appInstallInfo, jar, mdbTask, ejb.getName(), ejb.getMessageDestinationRefs(), ejbBindings.getMessageDestinationRefBindings(), msgDestinations, data, appVersion, jarVersion, ejbJars);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForEJB");
        }
    }

    private void prepareTaskForWAR(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, Vector data, int appVersion, BindJndiForEJBMessageBinding mdbTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTaskForWAR");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
        Vector warBindings = appInstallInfo.getModuleConfig("WAR_BND");
        for (int i = 0; i < warBindings.size(); ++i) {
            WebAppBinding warBinding = (WebAppBinding)warBindings.elementAt(i);
            WebApp war = (WebApp)wars.elementAt(i);
            int warVersion = ((XMLResource)war.eResource()).getVersionID();
            EList msgDestinations = war.getMessageDestinations();
            this.addTaskData(appInstallInfo, war, mdbTask, "", war.getMessageDestinationRefs(), warBinding.getMessageDestinationRefBindings(), war.getMessageDestinations(), data, appVersion, warVersion, ejbJars);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTaskForWAR");
        }
    }

    private void addTaskData(AppDeploymentInfo appInstallInfo, EObject refObject, AppDeploymentTask t, String ejbName, List msgDestinationRefs, List msgDestinationRefBnds, List msgDestinations, Vector data, int appVersion, int moduleVersion, Vector ejbJars) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTaskData ejbName=" + ejbName + " refObject =" + refObject);
        }
        BindJndiForEJBMessageBinding mdbTask = null;
        if (t != null) {
            mdbTask = (BindJndiForEJBMessageBinding)t;
        }
        String[][] mdbTaskData = null;
        if (mdbTask != null) {
            mdbTaskData = mdbTask.getTaskData();
        }
        Iterator i = msgDestinationRefs.iterator();
        Hashtable mdTable = new Hashtable();
        Vector<String> refVector = null;
        Vector<String> refNames = null;
        Vector newRefNames = null;
        Object mdbRefNames = null;
        Object newmdbRefNames = null;
        Vector mdrNames = null;
        String isMD = null;
        while (i.hasNext()) {
            boolean validLink = false;
            MessageDestinationRef ref = (MessageDestinationRef)i.next();
            String refName = ref.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ref name " + refName);
            }
            Iterator j = msgDestinationRefBnds.iterator();
            boolean found = false;
            MessageDestinationRefBinding mdrb = null;
            while (j.hasNext() && !found) {
                mdrb = (MessageDestinationRefBinding)j.next();
                if (mdrb.getBindingMessageDestinationRef() == null || !mdrb.getBindingMessageDestinationRef().equals(ref)) continue;
                found = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found message destination ref binding: " + found);
            }
            if (!found) {
                mdrb = ((CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi")).getCommonbndFactory().createMessageDestinationRefBinding();
                mdrb.setBindingMessageDestinationRef(ref);
                if (moduleVersion < 50) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adding message destination ref binding");
                    }
                    msgDestinationRefBnds.add(mdrb);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not adding message destination ref binding for ee5");
                }
            }
            if (ref.getLink() == null) {
                isMD = "AppDeploymentOption.No";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No message destination link ");
                }
                if (mdTable.get(refName) != null) continue;
                validLink = true;
                refVector = new Vector<String>();
                refVector.add(0, mdrb.getJndiName());
                refVector.addElement(isMD);
                refVector.addElement(refName);
                mdTable.put(refName, refVector);
                continue;
            }
            isMD = "AppDeploymentOption.Yes";
            String mdlink = ref.getLink();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mdlink=" + mdlink);
            }
            String reflink = mdlink;
            int indx = mdlink.indexOf(35);
            EObject refObjectLocal = null;
            List msgDestinationsLocal = msgDestinations;
            String jarName = null;
            if (indx != -1) {
                jarName = mdlink.substring(0, indx);
                reflink = mdlink.substring(indx + 1);
                refObjectLocal = this.getJar(jarName, ejbJars, appInstallInfo);
                if (refObjectLocal != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Different jar in same ear - jarName: " + jarName + " EJBJar " + refObjectLocal);
                    }
                    msgDestinationsLocal = ((EJBJar)refObjectLocal).getAssemblyDescriptor().getMessageDestinations();
                } else {
                    refObjectLocal = refObject;
                }
            } else {
                refObjectLocal = refObject;
            }
            Iterator l = msgDestinationsLocal.iterator();
            while (l.hasNext()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "there is MD link ");
                }
                MessageDestination md2 = (MessageDestination)l.next();
                String mdName = md2.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "md name " + mdName + " refName=" + refName + " reflink=" + reflink);
                }
                boolean isMDBLink = false;
                if (!mdName.equals(reflink)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "there is link in MDB");
                }
                if (refObjectLocal instanceof EJBJar) {
                    EJBJar jar = (EJBJar)refObjectLocal;
                    for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                        if (!ejb.isMessageDriven()) continue;
                        MessageDriven mdb = (MessageDriven)ejb;
                        String mdblink = mdb.getLink();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "mdb link " + mdblink);
                        }
                        String destJndi = null;
                        if (mdblink == null || !mdblink.equals(reflink)) continue;
                        isMDBLink = true;
                        validLink = true;
                        for (int k = 0; k < mdbTaskData.length; ++k) {
                            if (!mdbTaskData[k][1].equals(ejb.getName())) continue;
                            destJndi = mdbTaskData[k][7];
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "destination jndi name " + destJndi);
                        }
                        if (mdTable.get(mdName) == null) {
                            refNames = new Vector<String>();
                            if (destJndi != null) {
                                refNames.add(0, destJndi);
                            } else {
                                refNames.add(0, mdrb.getJndiName());
                            }
                            refNames.addElement(isMD);
                            refNames.addElement(refName);
                            mdTable.put(mdName, refNames);
                            continue;
                        }
                        newRefNames = (Vector)mdTable.get(mdName);
                        newRefNames.addElement(refName);
                    }
                }
                if (isMDBLink) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No valid mdb link ");
                }
                validLink = true;
                if (mdTable.get(mdName) != null) continue;
                refVector = new Vector();
                refVector.add(0, mdrb.getJndiName());
                refVector.addElement(isMD);
                refVector.addElement(refName);
                mdTable.put(mdName, refVector);
            }
            if (validLink) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No valid message destination related to the link " + reflink);
            }
            validLink = true;
            if (mdTable.get(refName) != null) continue;
            refVector = new Vector();
            refVector.add(0, mdrb.getJndiName());
            refVector.addElement(isMD);
            refVector.addElement(refName);
            mdTable.put(refName, refVector);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mdTable " + mdTable);
        }
        if (mdTable != null) {
            Enumeration tb = mdTable.keys();
            while (tb.hasMoreElements()) {
                String mdKey = (String)tb.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mdKey " + mdKey);
                }
                data.addElement(Integer.toString(appVersion));
                data.addElement(Integer.toString(moduleVersion));
                data.addElement(util.getModuleName(appInstallInfo, refObject));
                data.addElement(ejbName);
                data.addElement(util.formUriString(appInstallInfo, refObject));
                data.addElement(mdKey);
                mdrNames = (Vector)mdTable.get(mdKey);
                StringBuffer refbuf = new StringBuffer();
                isMD = (String)mdrNames.elementAt(1);
                for (int k = 2; k < mdrNames.size(); ++k) {
                    String refN = (String)mdrNames.get(k);
                    if (k != 2) {
                        refbuf.append(" + ");
                    }
                    refbuf.append(refN);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "refbuf " + refbuf.toString());
                }
                data.addElement(isMD);
                data.addElement(refbuf.toString());
                data.addElement(mdrNames.firstElement());
                data.addElement(mdrNames.firstElement());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTaskData");
        }
    }

    private EObject getJar(String jarName, Vector moduleDDs, AppDeploymentInfo appInstallInfo) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJar jarName= " + jarName + " moduleDD objs= " + moduleDDs + " appInstallInfo= " + appInstallInfo);
        }
        EJBJar ejbModuleDD = null;
        for (int i = 0; i < moduleDDs.size(); ++i) {
            EObject moduleDD = (EObject)moduleDDs.elementAt(i);
            if (!(moduleDD instanceof EJBJar)) continue;
            ejbModuleDD = (EJBJar)moduleDD;
            ModuleFile ejbJarFile = (ModuleFile)appInstallInfo.getModuleFileForDD(ejbModuleDD);
            String ejbJarFileName = ejbJarFile.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ejbJarFileName " + ejbJarFileName);
            }
            if (jarName.equals(ejbJarFileName)) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJar returns: " + ejbModuleDD);
        }
        return ejbModuleDD;
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            this.completeTaskForEJB(appInstallInfo, t);
            this.completeTaskForWAR(appInstallInfo, t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void completeTaskForEJB(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTaskForEJB");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                for (MessageDestinationRef ref : ejb.getMessageDestinationRefs()) {
                    this.updateMessageDestinationRefBinding(t, ref, ejbBindings.getMessageDestinationRefBindings(), util.formUriString(appInstallInfo, jar), ejb.getName(), util.getModuleName(appInstallInfo, jar));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTaskForEJB");
        }
    }

    private void completeTaskForWAR(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTaskForWAR");
        }
        Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
        Vector warBindings = appInstallInfo.getModuleConfig("WAR_BND");
        for (int i = 0; i < warBindings.size(); ++i) {
            WebAppBinding warBinding = (WebAppBinding)warBindings.elementAt(i);
            WebApp war = (WebApp)wars.elementAt(i);
            for (MessageDestinationRef ref : war.getMessageDestinationRefs()) {
                this.updateMessageDestinationRefBinding(t, ref, warBinding.getMessageDestinationRefBindings(), util.formUriString(appInstallInfo, war), "", util.getModuleName(appInstallInfo, war));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTaskForWAR");
        }
    }

    private void updateMessageDestinationRefBinding(AppDeploymentTask t, MessageDestinationRef ref, List messageDestinationRefBnds, String uri, String ejbName, String moduleName) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMessageDestinationRefBinding( task: " + t + " ref: " + ref.getName() + " binding: " + messageDestinationRefBnds + " uri: " + uri + " ejbName: " + ejbName + " module: " + moduleName + " ) ");
        }
        String refName = ref.getName();
        String[] matchingTaskData = null;
        String[][] taskData = t.getTaskData();
        for (int j = 0; j < taskData.length; ++j) {
            if (taskData[j].length <= 4 || (ejbName == null || !ejbName.equals(taskData[j][3])) && (ejbName != null || taskData[j][3] != null && !taskData[j][3].trim().equals("")) || !moduleName.equals(taskData[j][2])) continue;
            String allMdrNames = " + " + taskData[j][7] + " + ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "allMdrNames " + allMdrNames);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ref name " + refName);
            }
            if (allMdrNames.indexOf(" + " + refName + " + ") == -1) continue;
            matchingTaskData = taskData[j];
            break;
        }
        if (matchingTaskData == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No matching task data for message destination reference binding " + ref.getName() + " for module " + moduleName);
            }
            return;
        }
        Iterator l = messageDestinationRefBnds.iterator();
        boolean found = false;
        MessageDestinationRefBinding mdrb = null;
        while (l.hasNext()) {
            mdrb = (MessageDestinationRefBinding)l.next();
            if (mdrb.getBindingMessageDestinationRef() == null || !mdrb.getBindingMessageDestinationRef().equals(ref)) continue;
            found = true;
            break;
        }
        String newJndi = null;
        if (matchingTaskData.length > 8) {
            newJndi = matchingTaskData[8];
        }
        if (!found && !AppUtils.isEmpty(newJndi)) {
            int moduleVersion = Integer.valueOf((String)matchingTaskData[1]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module version: " + moduleVersion);
            }
            if (moduleVersion >= 50) {
                mdrb = ((CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi")).getCommonbndFactory().createMessageDestinationRefBinding();
                mdrb.setBindingMessageDestinationRef(ref);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding message destination ref binding");
                }
                messageDestinationRefBnds.add(mdrb);
                found = true;
            }
        }
        if (found && matchingTaskData.length > 8) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set the jndi name to " + newJndi + " while MDB is set to " + (String)matchingTaskData[9]);
            }
            if (!AppUtils.isEmpty(newJndi)) {
                if (!newJndi.equals(matchingTaskData[9])) {
                    Tr.warning(tc, "ADMA0182I", new Object[]{newJndi, refName, matchingTaskData[9]});
                }
                if (!newJndi.equals(mdrb.getJndiName())) {
                    mdrb.setJndiName(newJndi);
                }
            } else if (mdrb.getJndiName() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jndi is reset to null ... removing the message destination ref binding");
                }
                messageDestinationRefBnds.remove(mdrb);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No matching message destination reference binding " + ref.getName() + " for module " + moduleName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMessageDestinationRefBinding");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        if (!allTypes.contains(ModuleType.EJB) && !allTypes.contains(ModuleType.WAR)) {
            return null;
        }
        Hashtable<String, Object> tbl = new Hashtable<String, Object>();
        tbl.put(ModuleType.WAR.toString(), "/web-app/message-destination-ref/message-destination-ref-name");
        Vector<String> v = new Vector<String>();
        v.addElement("/ejb-jar/enterprise-beans/entity");
        v.addElement("/ejb-jar/enterprise-beans/session");
        v.addElement("/ejb-jar/enterprise-beans/message-driven");
        tbl.put(ModuleType.EJB.toString(), v);
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        ModuleType type = dcImpl.getDDBean().getRoot().getDeployableObject().getType();
        if (type.equals(ModuleType.WAR)) {
            J2EEDeployUtil.task2DC(task, dcImpl, new String[]{uri, dcImpl.getDDBean().getText()}, new int[]{4, 5});
        } else if (type.equals(ModuleType.EJB)) {
            String child = "message-destination-ref/message-destination-ref-name";
            if (dcImpl.getDDBean().getChildBean("message-destination-ref/message-destination-link").length > 0) {
                child = "message-destination-ref/message-destination-link";
            }
            J2EEDeployUtil.ejbTask2DC(task, dcImpl, uri, child, new int[]{4, 3, 5});
        }
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }

    public String[] validate(AppDeploymentTask task, AppDeploymentInfo taskInfo) {
        String[][] taskData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{task, taskInfo});
        }
        String[] taskValidateErrorMessages = null;
        if ("MapMessageDestinationRefToEJB".equals(task.getName()) && (taskData = task.getTaskData()) != null) {
            int i;
            Vector<String> errorMessages = new Vector<String>();
            for (i = 1; i < taskData.length; ++i) {
                if (!AppUtils.isEmpty(taskData[i][8])) continue;
                int moduleVersion = Integer.valueOf(taskData[i][1]);
                String isMsgDestLink = taskData[i][6];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module version: " + moduleVersion);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "is msg destination link: " + isMsgDestLink);
                }
                if (moduleVersion >= 50 && !"AppDeploymentOption.No".equals(isMsgDestLink)) continue;
                String error = MessageFormat.format(util.getMessage(task, "ADMA4011E"), util.getGoalTitle(task, task.getName()), taskData[i][5], taskData[i][2]);
                errorMessages.addElement(error);
            }
            if (errorMessages != null && errorMessages.size() > 0) {
                taskValidateErrorMessages = new String[errorMessages.size()];
                for (i = 0; i < errorMessages.size(); ++i) {
                    taskValidateErrorMessages[i] = (String)errorMessages.elementAt(i);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", new Object[]{taskValidateErrorMessages});
        }
        return taskValidateErrorMessages;
    }
}

