/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.extensions.webappext.JSPAttribute;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebappextFactory;
import com.ibm.ejs.models.base.extensions.webappext.WebappextPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class JSPReloadForWebModHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(JSPReloadForWebModHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] cols = new String[]{"webModule", "uri", "jspReloadEnabled", "jspReloadInterval"};
    static final int webModuleColumn = 0;
    static final int uriColumn = 1;
    static final int jspReloadColumn = 2;
    static final int jspReloadIntColumn = 3;
    private String[] taskValidateErrorMessages;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            return new WASDeploymentTask(appController, "JSPReloadForWebMod", cols, new boolean[]{false, false, false, false}, new boolean[]{false, false, true, true}, new boolean[]{false, false, false, false}, true);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask: task data already set.");
            }
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        Vector webApps = appInstallInfo.getModuleConfig("WAR_DD");
        Vector webAppExtensions = appInstallInfo.getModuleConfig("WAR_EXT");
        for (int i = 0; i < webAppExtensions.size(); ++i) {
            WebApp webApp = (WebApp)webApps.get(i);
            WebAppExtension webAppExt = (WebAppExtension)webAppExtensions.get(i);
            String moduleName = util.getModuleName(appInstallInfo, webApp);
            data.addElement(moduleName);
            String uri = util.formUriString(appInstallInfo, webApp, webAppExt);
            data.addElement(uri);
            EList jspAlist = webAppExt.getJspAttributes();
            boolean foundFlag = false;
            boolean foundInt = false;
            String svalue = null;
            JSPAttribute jspattr = null;
            int j = 0;
            while (!(j >= jspAlist.size() || foundFlag && foundInt)) {
                jspattr = (JSPAttribute)jspAlist.get(j);
                ++j;
                if (jspattr.getName().equals("reloadEnabled")) {
                    svalue = "AppDeploymentOption.Yes";
                    if (jspattr.getValue().equals(Boolean.FALSE.toString())) {
                        svalue = "AppDeploymentOption.No";
                    }
                    data.addElement(svalue);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found the enrty of reloadEnabled value= " + svalue);
                    }
                    foundFlag = true;
                    continue;
                }
                if (!jspattr.getName().equals("reloadInterval")) continue;
                data.addElement(jspattr.getValue());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found the enrty of reloadInterval value= " + jspattr.getValue());
                }
                foundInt = true;
                break;
            }
            if (!foundFlag) {
                svalue = "AppDeploymentOption.Yes";
                String reloadEnabledCustProp = System.getProperty("com.ibm.websphere.management.application.client.jspReloadEnabled");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reloadEnabledCustProp: " + reloadEnabledCustProp);
                }
                boolean runDefaultScenario = false;
                if (reloadEnabledCustProp != null) {
                    if (reloadEnabledCustProp.equalsIgnoreCase(Boolean.FALSE.toString())) {
                        svalue = "AppDeploymentOption.No";
                    } else if (!reloadEnabledCustProp.equalsIgnoreCase(Boolean.TRUE.toString())) {
                        Tr.warning(tc, "ADMA0075W");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "svalue: " + svalue);
                }
                data.addElement(svalue);
            }
            if (foundInt) continue;
            data.addElement(Integer.toString(10));
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            String[][] data = t.getTaskData();
            int indx = 1;
            Vector webApps = appInstallInfo.getModuleConfig("WAR_DD");
            Vector webAppExtensions = appInstallInfo.getModuleConfig("WAR_EXT");
            boolean flag = false;
            for (int j = 0; j < webAppExtensions.size(); ++j) {
                WebAppExtension webAppExt = (WebAppExtension)webAppExtensions.get(j);
                EList jspAlist = webAppExt.getJspAttributes();
                JSPAttribute jspattr = null;
                WebappextPackage wpkg = (WebappextPackage)EPackage.Registry.INSTANCE.getEPackage("webappext.xmi");
                WebappextFactory wfact = wpkg.getWebappextFactory();
                boolean foundFlag = false;
                boolean foundInt = false;
                String svalue = null;
                int k = 0;
                while (!(k >= jspAlist.size() || foundFlag && foundInt)) {
                    jspattr = (JSPAttribute)jspAlist.get(k);
                    ++k;
                    if (jspattr.getName().equals("reloadEnabled")) {
                        svalue = Boolean.FALSE.toString();
                        if (data[indx][2].equals("AppDeploymentOption.Yes")) {
                            svalue = Boolean.TRUE.toString();
                        }
                        jspattr.setValue(svalue);
                        foundFlag = true;
                        continue;
                    }
                    if (!jspattr.getName().equals("reloadInterval")) continue;
                    jspattr.setValue(data[indx][3]);
                    foundInt = true;
                }
                if (!foundFlag) {
                    jspattr = wfact.createJSPAttribute();
                    jspattr.setName("reloadEnabled");
                    svalue = Boolean.FALSE.toString();
                    if (data[indx][2].equals("AppDeploymentOption.Yes")) {
                        svalue = Boolean.TRUE.toString();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "svalue: " + svalue);
                    }
                    jspattr.setValue(svalue);
                    jspAlist.add(jspattr);
                }
                if (!foundInt) {
                    jspattr = wfact.createJSPAttribute();
                    jspattr.setName("reloadInterval");
                    jspattr.setValue(data[indx][3]);
                    jspAlist.add(jspattr);
                }
                ++indx;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

