/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.extensions.webappext.JSPAttribute;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebappextFactory;
import com.ibm.ejs.models.base.extensions.webappext.WebappextPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class JSPCompileOptionsHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(JSPCompileOptionsHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] cols = new String[]{"webModule", "uri", "jsp.classpath", "useFullPackageNames", "jdkSourceLevel", "disableJspRuntimeCompilation"};
    public static final int moduleColumn = 0;
    public static final int uriColumn = 1;
    public static final int classpathColumn = 2;
    public static final int packageColumn = 3;
    public static final int sourceLevelColumn = 4;
    public static final int rtdisableColumn = 5;
    private String[] taskValidateErrorMessages;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            return new WASDeploymentTask(appController, "JSPCompileOptions", cols, new boolean[]{false, false, false, false, false, false}, new boolean[]{false, false, true, true, true, true}, new boolean[]{false, false, false, false, false, false}, true);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        Hashtable deployJSPOptions = (Hashtable)appInstallInfo.getAppOptions().get("preCompileJSPs.options");
        Vector webApps = appInstallInfo.getModuleConfig("WAR_DD");
        Vector webAppExtensions = appInstallInfo.getModuleConfig("WAR_EXT");
        String bool = "AppDeploymentOption.Yes";
        for (int i = 0; i < webAppExtensions.size(); ++i) {
            WebApp webApp = (WebApp)webApps.get(i);
            WebAppExtension webAppExt = (WebAppExtension)webAppExtensions.get(i);
            String moduleName = util.getModuleName(appInstallInfo, webApp);
            data.addElement(moduleName);
            String uri = util.formUriString(appInstallInfo, webApp);
            data.addElement(uri);
            data.addElement("");
            EList jspAlist = webAppExt.getJspAttributes();
            JSPAttribute jspattr = null;
            boolean foundUP = false;
            boolean foundSL = false;
            boolean foundDRT = false;
            String valueUP = null;
            String valueSL = null;
            String valueDRT = null;
            int j = 0;
            while (!(j >= jspAlist.size() || foundUP && foundSL && foundDRT)) {
                jspattr = (JSPAttribute)jspAlist.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attr name: " + jspattr.getName());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "value: " + jspattr.getValue());
                }
                ++j;
                if (jspattr.getName().equals("useFullPackageNames")) {
                    valueUP = "AppDeploymentOption.Yes";
                    if (jspattr.getValue().equals(Boolean.FALSE.toString())) {
                        valueUP = "AppDeploymentOption.No";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "package: " + valueUP);
                    }
                    foundUP = true;
                    continue;
                }
                if (jspattr.getName().equals("jdkSourceLevel")) {
                    valueSL = jspattr.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "jspsourcelevel: " + valueSL);
                    }
                    foundSL = true;
                    continue;
                }
                if (!jspattr.getName().equals("disableJspRuntimeCompilation")) continue;
                valueDRT = "AppDeploymentOption.No";
                if (jspattr.getValue().equals(Boolean.TRUE.toString())) {
                    valueDRT = "AppDeploymentOption.Yes";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "disableRTCompile: " + valueDRT);
                }
                foundDRT = true;
            }
            if (!foundUP) {
                Tr.debug(tc, "not found UseFullPackageNames");
                valueUP = "AppDeploymentOption.Yes";
                if (AppConstants.APPDEPL_PRECMPJSP_USEFULLPACKAGENAMES_DEFAULT.equals(Boolean.FALSE.toString())) {
                    valueUP = "AppDeploymentOption.No";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "package default: " + valueUP);
                }
            }
            if (!foundSL) {
                Tr.debug(tc, "not found JspSourceLevel");
                valueSL = "13";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jspsourcelevel default: " + valueSL);
                }
            }
            if (!foundDRT) {
                Tr.debug(tc, "not found DisableRuntimeCompile");
                valueDRT = "AppDeploymentOption.No";
                if (AppConstants.APPDEPL_PRECMPJSP_DISABLERTCOMPILE_DEFAULT.equals(Boolean.TRUE.toString())) {
                    valueDRT = "AppDeploymentOption.Yes";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "disableRTCompile default: " + valueDRT);
                }
            }
            data.addElement(valueUP);
            data.addElement(valueSL);
            data.addElement(valueDRT);
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty() && !t.isTaskDisabled()) {
            Hashtable appOptions = appInstallInfo.getAppOptions();
            int indx = 1;
            String[][] data = t.getTaskData();
            Vector webApps = appInstallInfo.getModuleConfig("WAR_DD");
            Vector webAppExtensions = appInstallInfo.getModuleConfig("WAR_EXT");
            Hashtable<String, String> deployJSPOptions = new Hashtable<String, String>();
            WebappextPackage wpkg = (WebappextPackage)EPackage.Registry.INSTANCE.getEPackage("webappext.xmi");
            WebappextFactory wfact = wpkg.getWebappextFactory();
            boolean foundUP = false;
            boolean foundSL = false;
            boolean foundDRT = false;
            String valueUP = null;
            String valueSL = null;
            String valueDRT = null;
            String svalue = null;
            String name = null;
            for (int j = 0; j < webAppExtensions.size(); ++j) {
                WebApp webApp = (WebApp)webApps.get(j);
                WebAppExtension webAppExt = (WebAppExtension)webAppExtensions.get(j);
                String uri = appInstallInfo.getModuleFileForDD(webApp).getURI();
                svalue = data[indx][2];
                if (svalue != null) {
                    deployJSPOptions.put(uri, svalue);
                }
                EList jspAlist = webAppExt.getJspAttributes();
                JSPAttribute jspattr = null;
                valueUP = data[indx][3];
                valueSL = data[indx][4];
                valueDRT = data[indx][5];
                foundUP = false;
                foundSL = false;
                foundDRT = false;
                int k = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "value package: " + valueUP);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "value sourceLevel: " + valueSL);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "value disableRTCompile: " + valueDRT);
                }
                while (!(k >= jspAlist.size() || foundUP && foundSL && foundDRT)) {
                    jspattr = (JSPAttribute)jspAlist.get(k);
                    ++k;
                    name = jspattr.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attr name: " + name);
                    }
                    if (name != null && name.equals("useFullPackageNames")) {
                        svalue = Boolean.FALSE.toString();
                        if (valueUP.equals("AppDeploymentOption.Yes")) {
                            svalue = Boolean.TRUE.toString();
                        }
                        jspattr.setValue(svalue);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "package: " + svalue);
                        }
                        foundUP = true;
                        continue;
                    }
                    if (name != null && name.equals("jdkSourceLevel")) {
                        Tr.debug(tc, "jspsourcelevel " + valueSL);
                        jspattr.setValue(valueSL);
                        foundSL = true;
                        continue;
                    }
                    if (name == null || !name.equals("disableJspRuntimeCompilation")) continue;
                    svalue = Boolean.FALSE.toString();
                    if (valueDRT.equals("AppDeploymentOption.Yes")) {
                        svalue = Boolean.TRUE.toString();
                    }
                    jspattr.setValue(svalue);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "disableRTCompile: " + svalue);
                    }
                    foundDRT = true;
                }
                if (!foundUP) {
                    Tr.debug(tc, "not found UseFullPackageNames");
                    jspattr = wfact.createJSPAttribute();
                    jspAlist.add(jspattr);
                    jspattr.setName("useFullPackageNames");
                    svalue = Boolean.FALSE.toString();
                    if (valueUP.equals("AppDeploymentOption.Yes")) {
                        svalue = Boolean.TRUE.toString();
                    }
                    jspattr.setValue(svalue);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "package default: " + svalue);
                    }
                }
                if (!foundSL) {
                    Tr.debug(tc, "not found JspSourceLevel");
                    jspattr = wfact.createJSPAttribute();
                    jspAlist.add(jspattr);
                    jspattr.setName("jdkSourceLevel");
                    jspattr.setValue(valueSL);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "jspsourcelevel default: " + valueSL);
                    }
                }
                if (!foundDRT) {
                    Tr.debug(tc, "not found DisableRuntimeCompile");
                    jspattr = wfact.createJSPAttribute();
                    jspattr.setName("disableJspRuntimeCompilation");
                    jspAlist.add(jspattr);
                    svalue = Boolean.FALSE.toString();
                    if (valueDRT.equals("AppDeploymentOption.Yes")) {
                        svalue = Boolean.TRUE.toString();
                    }
                    jspattr.setValue(svalue);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "disableRTCompile default: " + svalue);
                    }
                }
                ++indx;
            }
            appOptions.put("preCompileJSPs.options", deployJSPOptions);
            appInstallInfo.setAppOptions(appOptions);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

